/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.PackageNamesProvider;
import com.android.tools.idea.logcat.filters.LogcatFilter;
import com.android.tools.idea.logcat.filters.LogcatMessageWrapper;
import com.android.tools.idea.logcat.filters.ProjectAppFilter;
import com.android.tools.idea.logcat.message.LogLevel;
import com.android.tools.idea.logcat.message.LogcatHeader;
import com.intellij.openapi.util.TextRange;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/logcat/filters/ProjectAppFilter;", "Lcom/android/tools/idea/logcat/filters/LogcatFilter;", "packageNamesProvider", "Lcom/android/tools/idea/logcat/PackageNamesProvider;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/android/tools/idea/logcat/PackageNamesProvider;Lcom/intellij/openapi/util/TextRange;)V", "displayText", "", "getDisplayText", "()Ljava/lang/String;", "packageNames", "", "packageNamesRegex", "Lkotlin/text/Regex;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "equals", "", "other", "", "hashCode", "", "matches", "message", "Lcom/android/tools/idea/logcat/filters/LogcatMessageWrapper;", "prepare", "", "intellij.android.logcat"})
public final class ProjectAppFilter
extends LogcatFilter {
    @NotNull
    private final PackageNamesProvider packageNamesProvider;
    @NotNull
    private final TextRange textRange;
    @NotNull
    private Set<String> packageNames;
    @Nullable
    private Regex packageNamesRegex;

    public ProjectAppFilter(@NotNull PackageNamesProvider packageNamesProvider, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)packageNamesProvider, (String)"packageNamesProvider");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        super(textRange);
        this.packageNamesProvider = packageNamesProvider;
        this.textRange = textRange;
        this.packageNames = SetsKt.emptySet();
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        return this.textRange;
    }

    @Override
    @NotNull
    public String getDisplayText() {
        String string;
        if (this.packageNamesProvider.getPackageNames().size() == 0) {
            string = LogcatBundle.message("logcat.filter.completion.hint.package.mine.empty", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)this.packageNamesProvider.getPackageNames(), (CharSequence)"<br/>&nbsp;&nbsp;", null, null, (int)0, null, null, (int)62, null)};
            string = LogcatBundle.message("logcat.filter.completion.hint.package.mine.items", objectArray);
        }
        return string;
    }

    @Override
    public void prepare() {
        this.packageNames = this.packageNamesProvider.getPackageNames();
        this.packageNamesRegex = !((Collection)this.packageNames).isEmpty() ? new Regex(CollectionsKt.joinToString$default((Iterable)this.packageNames, (CharSequence)"|", null, null, (int)0, null, (Function1)prepare.1.INSTANCE, (int)30, null)) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(@NotNull LogcatMessageWrapper message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        LogcatHeader header = message2.getLogcatMessage().getHeader();
        if (this.packageNames.contains(header.getAppName())) return true;
        if (header.getLogLevel().compareTo((Enum)LogLevel.ERROR) < 0) return false;
        Regex regex = this.packageNamesRegex;
        if (regex == null) return false;
        if (!regex.containsMatchIn((CharSequence)message2.getLogcatMessage().getMessage())) return false;
        return true;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ProjectAppFilter && Intrinsics.areEqual((Object)this.packageNamesProvider, (Object)((ProjectAppFilter)other).packageNamesProvider);
    }

    public int hashCode() {
        return this.packageNamesProvider.hashCode();
    }
}

