/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.ConstantsKt;
import com.android.tools.idea.logcat.filters.LogcatFilter;
import com.android.tools.idea.logcat.filters.LogcatMessageWrapper;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.settings.AndroidLogcatSettings;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0011\u001a\u00020\u0006*\u00020\rH\u0002R\u0018\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/logcat/filters/LogcatMasterFilter;", "", "logcatFilter", "Lcom/android/tools/idea/logcat/filters/LogcatFilter;", "(Lcom/android/tools/idea/logcat/filters/LogcatFilter;)V", "ignoreSpam", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "settings", "Lcom/android/tools/idea/logcat/settings/AndroidLogcatSettings;", "filter", "", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "messages", "zoneId", "Ljava/time/ZoneId;", "isSpam", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nLogcatFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogcatFilter.kt\ncom/android/tools/idea/logcat/filters/LogcatMasterFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,349:1\n766#2:350\n857#2,2:351\n766#2:353\n857#2,2:354\n*S KotlinDebug\n*F\n+ 1 LogcatFilter.kt\ncom/android/tools/idea/logcat/filters/LogcatMasterFilter\n*L\n51#1:350\n51#1:351,2\n54#1:353\n54#1:354,2\n*E\n"})
public final class LogcatMasterFilter {
    @Nullable
    private final LogcatFilter logcatFilter;
    @NotNull
    private final AndroidLogcatSettings settings;
    private final Boolean ignoreSpam;

    public LogcatMasterFilter(@Nullable LogcatFilter logcatFilter) {
        this.logcatFilter = logcatFilter;
        this.settings = AndroidLogcatSettings.Companion.getInstance();
        this.ignoreSpam = (Boolean)StudioFlags.LOGCAT_IGNORE_STUDIO_SPAM_TAGS.get();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LogcatMessage> filter(@NotNull List<LogcatMessage> messages, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        if (this.logcatFilter == null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = messages;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LogcatMessage it = (LogcatMessage)element$iv$iv;
                boolean bl = false;
                if (!(!this.isSpam(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        this.logcatFilter.prepare();
        Iterable $this$filter$iv = messages;
        boolean $i$f$filter = false;
        Iterable $this$filterTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LogcatMessage it = (LogcatMessage)element$iv$iv;
            boolean bl = false;
            if (!(it.getHeader() == ConstantsKt.SYSTEM_HEADER || this.logcatFilter.matches(new LogcatMessageWrapper(it, zoneId)) && !this.isSpam(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List filter$default(LogcatMasterFilter logcatMasterFilter, List list2, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"systemDefault()");
            zoneId = zoneId2;
        }
        return logcatMasterFilter.filter(list2, zoneId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSpam(LogcatMessage $this$isSpam) {
        if (this.settings.getIgnoredTags().contains($this$isSpam.getHeader().getTag())) return true;
        Boolean bl = this.ignoreSpam;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"ignoreSpam");
        if (bl == false) return false;
        if (!StringsKt.startsWith$default((String)$this$isSpam.getHeader().getTag(), (String)"studio.", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

