/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.PackageNamesProvider;
import com.android.tools.idea.logcat.filters.AgeFilter;
import com.android.tools.idea.logcat.filters.CrashFilter;
import com.android.tools.idea.logcat.filters.ExactStringFilter;
import com.android.tools.idea.logcat.filters.FilterType;
import com.android.tools.idea.logcat.filters.LevelFilter;
import com.android.tools.idea.logcat.filters.LogcatFilter;
import com.android.tools.idea.logcat.filters.LogcatFilterField;
import com.android.tools.idea.logcat.filters.LogcatFilterParseException;
import com.android.tools.idea.logcat.filters.NameFilter;
import com.android.tools.idea.logcat.filters.NegatedExactStringFilter;
import com.android.tools.idea.logcat.filters.NegatedRegexFilter;
import com.android.tools.idea.logcat.filters.NegatedStringFilter;
import com.android.tools.idea.logcat.filters.ProjectAppFilter;
import com.android.tools.idea.logcat.filters.RegexFilter;
import com.android.tools.idea.logcat.filters.StackTraceFilter;
import com.android.tools.idea.logcat.filters.StringFilter;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterAndExpression;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterExpression;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterLiteralExpression;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterOrExpression;
import com.android.tools.idea.logcat.filters.parser.PsiExtensionsKt;
import com.android.tools.idea.logcat.message.LogLevel;
import com.android.tools.idea.logcat.util.AndroidProjectDetector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.impl.source.tree.PsiErrorElementImpl;
import com.intellij.refactoring.suggested.UtilsKt;
import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002\u001a\u001c\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0003H\u0000\u001a\f\u0010\u001b\u001a\u00020\u001a*\u00020\u0003H\u0000\u001a\f\u0010\u001c\u001a\u00020\u001a*\u00020\u0003H\u0000\u001a$\u0010\u001d\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"durationRegex", "Lkotlin/text/Regex;", "firebaseRegex", "", "firebaseTags", "", "flattenAndExpression", "Lcom/android/tools/idea/logcat/filters/parser/LogcatFilterExpression;", "expression", "flattenOrExpression", "asLogLevel", "Lcom/android/tools/idea/logcat/message/LogLevel;", "Lcom/intellij/psi/PsiElement;", "createAgeFilter", "Lcom/android/tools/idea/logcat/filters/LogcatFilter;", "Lcom/android/tools/idea/logcat/filters/parser/LogcatFilterLiteralExpression;", "text", "clock", "Ljava/time/Clock;", "createIsFilter", "createNameFilter", "getFieldForImplicitOr", "Lcom/android/tools/idea/logcat/filters/FilterType;", "index", "", "isValidIsFilter", "", "isValidLogAge", "isValidLogLevel", "toKeyFilter", "packageNamesProvider", "Lcom/android/tools/idea/logcat/PackageNamesProvider;", "androidProjectDetector", "Lcom/android/tools/idea/logcat/util/AndroidProjectDetector;", "intellij.android.logcat"})
public final class LogcatFilterParserKt {
    @NotNull
    private static final Regex durationRegex = new Regex("\\d+[smhd]");
    @NotNull
    private static final List<String> firebaseTags;
    @NotNull
    private static final String firebaseRegex;

    private static final LogcatFilter toKeyFilter(LogcatFilterLiteralExpression $this$toKeyFilter, Clock clock, PackageNamesProvider packageNamesProvider, AndroidProjectDetector androidProjectDetector) {
        TextRange textRange = new TextRange(UtilsKt.getStartOffset((PsiElement)$this$toKeyFilter), UtilsKt.getEndOffset((PsiElement)$this$toKeyFilter));
        String string = $this$toKeyFilter.getFirstChild().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"firstChild.text");
        char[] cArray = new char[]{':', '-', '~', '='};
        return switch (StringsKt.trim((String)string, (char[])cArray)) {
            case "level" -> {
                PsiElement v1 = $this$toKeyFilter.getLastChild();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"lastChild");
                yield new LevelFilter(LogcatFilterParserKt.asLogLevel(v1), textRange);
            }
            case "age" -> {
                String v3 = $this$toKeyFilter.getLastChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"lastChild.text");
                yield LogcatFilterParserKt.createAgeFilter($this$toKeyFilter, v3, clock);
            }
            case "is" -> {
                String v4 = $this$toKeyFilter.getLastChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"lastChild.text");
                yield LogcatFilterParserKt.createIsFilter($this$toKeyFilter, v4);
            }
            case "name" -> {
                PsiElement v5 = $this$toKeyFilter.getLastChild();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"lastChild");
                yield LogcatFilterParserKt.createNameFilter($this$toKeyFilter, PsiExtensionsKt.toText(v5));
            }
            default -> {
                String key;
                PsiElement v6 = $this$toKeyFilter.getLastChild();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"lastChild");
                String value = PsiExtensionsKt.toText(v6);
                String v7 = $this$toKeyFilter.getFirstChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"firstChild.text");
                boolean isNegated = StringsKt.startsWith$default((CharSequence)v7, (char)'-', (boolean)false, (int)2, null);
                String v8 = $this$toKeyFilter.getFirstChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"firstChild.text");
                boolean isRegex = StringsKt.endsWith$default((String)v8, (String)"~:", (boolean)false, (int)2, null);
                String v9 = $this$toKeyFilter.getFirstChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"firstChild.text");
                boolean isExact = StringsKt.endsWith$default((String)v9, (String)"=:", (boolean)false, (int)2, null);
                LogcatFilterField v10 = switch (key) {
                    case "tag" -> LogcatFilterField.TAG;
                    case "package" -> LogcatFilterField.APP;
                    case "process" -> LogcatFilterField.PROCESS;
                    case "message" -> LogcatFilterField.MESSAGE;
                    case "line" -> LogcatFilterField.LINE;
                    default -> throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid key: " + key));
                };
                LogcatFilterField field = v10;
                yield isNegated && isRegex ? (LogcatFilter)new NegatedRegexFilter(value, field, textRange) : (isNegated && isExact ? (LogcatFilter)new NegatedExactStringFilter(value, field, textRange) : (isNegated ? (LogcatFilter)new NegatedStringFilter(value, field, textRange) : (isRegex ? (LogcatFilter)new RegexFilter(value, field, textRange) : (isExact ? (LogcatFilter)new ExactStringFilter(value, field, textRange) : (Intrinsics.areEqual((Object)key, (Object)"package") && Intrinsics.areEqual((Object)value, (Object)"mine") && LogcatFilterParserKt.toKeyFilter$isAndroidProject(androidProjectDetector, $this$toKeyFilter) ? (LogcatFilter)new ProjectAppFilter(packageNamesProvider, textRange) : (LogcatFilter)new StringFilter(value, field, textRange))))));
            }
        };
    }

    private static final LogcatFilter createAgeFilter(LogcatFilterLiteralExpression $this$createAgeFilter, String text2, Clock clock) {
        LogcatFilter logcatFilter;
        try {
            logcatFilter = new AgeFilter(text2, clock, new TextRange(UtilsKt.getStartOffset((PsiElement)$this$createAgeFilter), UtilsKt.getEndOffset((PsiElement)$this$createAgeFilter)));
        }
        catch (IllegalArgumentException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Parse error";
            }
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl(string));
        }
        return logcatFilter;
    }

    private static final LogcatFilter createIsFilter(LogcatFilterLiteralExpression $this$createIsFilter, String text2) {
        LogcatFilter logcatFilter;
        if (!((Boolean)StudioFlags.LOGCAT_IS_FILTER.get()).booleanValue()) {
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid key: is"));
        }
        if (Intrinsics.areEqual((Object)text2, (Object)"crash")) {
            logcatFilter = new CrashFilter(new TextRange(UtilsKt.getStartOffset((PsiElement)$this$createIsFilter), UtilsKt.getEndOffset((PsiElement)$this$createIsFilter)));
        } else if (Intrinsics.areEqual((Object)text2, (Object)"firebase")) {
            logcatFilter = new RegexFilter(firebaseRegex, LogcatFilterField.TAG, new TextRange(UtilsKt.getStartOffset((PsiElement)$this$createIsFilter), UtilsKt.getEndOffset((PsiElement)$this$createIsFilter)));
        } else if (Intrinsics.areEqual((Object)text2, (Object)"stacktrace")) {
            logcatFilter = new StackTraceFilter(new TextRange(UtilsKt.getStartOffset((PsiElement)$this$createIsFilter), UtilsKt.getEndOffset((PsiElement)$this$createIsFilter)));
        } else {
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid filter: is:" + text2));
        }
        return logcatFilter;
    }

    private static final LogcatFilter createNameFilter(LogcatFilterLiteralExpression $this$createNameFilter, String text2) {
        return new NameFilter(text2, new TextRange(UtilsKt.getStartOffset((PsiElement)$this$createNameFilter), UtilsKt.getEndOffset((PsiElement)$this$createNameFilter)));
    }

    private static final LogLevel asLogLevel(PsiElement $this$asLogLevel) {
        String string = $this$asLogLevel.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        LogLevel logLevel = LogLevel.Companion.getByString(string2);
        if (logLevel == null) {
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid Log Level: " + $this$asLogLevel.getText()));
        }
        return logLevel;
    }

    public static final boolean isValidLogLevel(@NotNull String $this$isValidLogLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidLogLevel, (String)"<this>");
        String string = $this$isValidLogLevel.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return LogLevel.Companion.getByString(string) != null;
    }

    public static final boolean isValidIsFilter(@NotNull String $this$isValidIsFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidIsFilter, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isValidIsFilter, (Object)"crash") || Intrinsics.areEqual((Object)$this$isValidIsFilter, (Object)"firebase") || Intrinsics.areEqual((Object)$this$isValidIsFilter, (Object)"stacktrace");
    }

    public static final boolean isValidLogAge(@NotNull String $this$isValidLogAge) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidLogAge, (String)"<this>");
        if (durationRegex.matchEntire((CharSequence)$this$isValidLogAge) == null) {
            return false;
        }
        try {
            String string = $this$isValidLogAge.substring(0, $this$isValidLogAge.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static final List<LogcatFilterExpression> flattenOrExpression(LogcatFilterExpression expression2) {
        List list2;
        if (expression2 instanceof LogcatFilterOrExpression) {
            LogcatFilterExpression logcatFilterExpression = ((LogcatFilterOrExpression)expression2).getExpressionList().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)logcatFilterExpression, (String)"expression.expressionList[0]");
            Collection collection2 = LogcatFilterParserKt.flattenOrExpression(logcatFilterExpression);
            LogcatFilterExpression logcatFilterExpression2 = ((LogcatFilterOrExpression)expression2).getExpressionList().get(1);
            Intrinsics.checkNotNullExpressionValue((Object)logcatFilterExpression2, (String)"expression.expressionList[1]");
            list2 = CollectionsKt.plus((Collection)collection2, (Iterable)LogcatFilterParserKt.flattenOrExpression(logcatFilterExpression2));
        } else {
            list2 = CollectionsKt.listOf((Object)expression2);
        }
        return list2;
    }

    private static final List<LogcatFilterExpression> flattenAndExpression(LogcatFilterExpression expression2) {
        List list2;
        if (expression2 instanceof LogcatFilterAndExpression) {
            LogcatFilterExpression logcatFilterExpression = ((LogcatFilterAndExpression)expression2).getExpressionList().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)logcatFilterExpression, (String)"expression.expressionList[0]");
            Collection collection2 = LogcatFilterParserKt.flattenAndExpression(logcatFilterExpression);
            LogcatFilterExpression logcatFilterExpression2 = ((LogcatFilterAndExpression)expression2).getExpressionList().get(1);
            Intrinsics.checkNotNullExpressionValue((Object)logcatFilterExpression2, (String)"expression.expressionList[1]");
            list2 = CollectionsKt.plus((Collection)collection2, (Iterable)LogcatFilterParserKt.flattenAndExpression(logcatFilterExpression2));
        } else {
            list2 = CollectionsKt.listOf((Object)expression2);
        }
        return list2;
    }

    private static final FilterType getFieldForImplicitOr(LogcatFilter $this$getFieldForImplicitOr, int index2) {
        return $this$getFieldForImplicitOr instanceof StringFilter && ((StringFilter)$this$getFieldForImplicitOr).getField() != LogcatFilterField.IMPLICIT_LINE ? new FilterType((Object)((StringFilter)$this$getFieldForImplicitOr).getField()) : ($this$getFieldForImplicitOr instanceof RegexFilter ? new FilterType((Object)((RegexFilter)$this$getFieldForImplicitOr).getField()) : ($this$getFieldForImplicitOr instanceof ExactStringFilter ? new FilterType((Object)((ExactStringFilter)$this$getFieldForImplicitOr).getField()) : ($this$getFieldForImplicitOr instanceof LevelFilter ? new FilterType("level") : ($this$getFieldForImplicitOr instanceof AgeFilter ? new FilterType("age") : ($this$getFieldForImplicitOr instanceof CrashFilter ? new FilterType("is") : ($this$getFieldForImplicitOr instanceof StackTraceFilter ? new FilterType("is") : new FilterType(index2)))))));
    }

    private static final boolean toKeyFilter$isAndroidProject(AndroidProjectDetector $androidProjectDetector, LogcatFilterLiteralExpression $this_toKeyFilter) {
        Project project = $this_toKeyFilter.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return $androidProjectDetector.isAndroidProject(project);
    }

    public static final /* synthetic */ List access$flattenAndExpression(LogcatFilterExpression expression2) {
        return LogcatFilterParserKt.flattenAndExpression(expression2);
    }

    public static final /* synthetic */ List access$flattenOrExpression(LogcatFilterExpression expression2) {
        return LogcatFilterParserKt.flattenOrExpression(expression2);
    }

    public static final /* synthetic */ LogcatFilter access$toKeyFilter(LogcatFilterLiteralExpression $receiver, Clock clock, PackageNamesProvider packageNamesProvider, AndroidProjectDetector androidProjectDetector) {
        return LogcatFilterParserKt.toKeyFilter($receiver, clock, packageNamesProvider, androidProjectDetector);
    }

    public static final /* synthetic */ FilterType access$getFieldForImplicitOr(LogcatFilter $receiver, int index2) {
        return LogcatFilterParserKt.getFieldForImplicitOr($receiver, index2);
    }

    static {
        Object[] objectArray = new String[]{"AppInstallOperation", "AppInviteActivity", "AppInviteAgent", "AppInviteAnalytics", "AppInviteLogger", "BackgroundTask", "ClassMapper", "Connection", "DataOperation", "EventRaiser", "FA", "FirebaseAppIndex", "FirebaseDatabase", "FirebaseInstanceId", "FirebaseMessaging", "FirebaseRemoteConfig", "NetworkRequest", "Persistence", "PersistentConnection", "RepoOperation", "RunLoop", "StorageTask", "SyncTree", "Transaction", "WebSocket"};
        firebaseTags = CollectionsKt.listOf((Object[])objectArray);
        firebaseRegex = "^(" + CollectionsKt.joinToString$default((Iterable)firebaseTags, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")$";
    }
}

