/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.filters.LogcatFilter;
import com.android.tools.idea.logcat.filters.LogcatMessageWrapper;
import com.android.tools.idea.logcat.message.LogLevel;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\bH\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/logcat/filters/LevelFilter;", "Lcom/android/tools/idea/logcat/filters/LogcatFilter;", "level", "Lcom/android/tools/idea/logcat/message/LogLevel;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/android/tools/idea/logcat/message/LogLevel;Lcom/intellij/openapi/util/TextRange;)V", "displayText", "", "getDisplayText", "()Ljava/lang/String;", "getLevel", "()Lcom/android/tools/idea/logcat/message/LogLevel;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "matches", "message", "Lcom/android/tools/idea/logcat/filters/LogcatMessageWrapper;", "toString", "intellij.android.logcat"})
public final class LevelFilter
extends LogcatFilter {
    @NotNull
    private final LogLevel level;
    @NotNull
    private final TextRange textRange;
    @NotNull
    private final String displayText;

    public LevelFilter(@NotNull LogLevel level, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        super(textRange);
        this.level = level;
        this.textRange = textRange;
        Object[] objectArray = new Object[]{this.level.name()};
        this.displayText = LogcatBundle.message("logcat.filter.completion.hint.level.value", objectArray);
    }

    @NotNull
    public final LogLevel getLevel() {
        return this.level;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        return this.textRange;
    }

    @Override
    @NotNull
    public String getDisplayText() {
        return this.displayText;
    }

    @Override
    public boolean matches(@NotNull LogcatMessageWrapper message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        return message2.getLogcatMessage().getHeader().getLogLevel().compareTo((Enum)this.level) >= 0;
    }

    @NotNull
    public final LogLevel component1() {
        return this.level;
    }

    @NotNull
    public final TextRange component2() {
        return this.textRange;
    }

    @NotNull
    public final LevelFilter copy(@NotNull LogLevel level, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        return new LevelFilter(level, textRange);
    }

    public static /* synthetic */ LevelFilter copy$default(LevelFilter levelFilter, LogLevel logLevel, TextRange textRange, int n, Object object) {
        if ((n & 1) != 0) {
            logLevel = levelFilter.level;
        }
        if ((n & 2) != 0) {
            textRange = levelFilter.textRange;
        }
        return levelFilter.copy(logLevel, textRange);
    }

    @NotNull
    public String toString() {
        return "LevelFilter(level=" + this.level + ", textRange=" + this.textRange + ")";
    }

    public int hashCode() {
        int result2 = this.level.hashCode();
        result2 = result2 * 31 + this.textRange.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LevelFilter)) {
            return false;
        }
        LevelFilter levelFilter = (LevelFilter)other;
        if (this.level != levelFilter.level) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.textRange, (Object)levelFilter.textRange);
    }
}

