/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.logcat.ConstantsKt;
import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.LogcatPresenter;
import com.android.tools.idea.logcat.filters.AndroidLogcatFilterHistory;
import com.android.tools.idea.logcat.filters.FilterTextFieldKt;
import com.android.tools.idea.logcat.filters.LogcatFilter;
import com.android.tools.idea.logcat.filters.LogcatFilterParser;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterFileType;
import com.android.tools.idea.logcat.util.AndroidProjectDetector;
import com.android.tools.idea.logcat.util.AndroidProjectDetectorImpl;
import com.android.tools.idea.logcat.util.LogcatUsageTracker;
import com.android.tools.idea.logcat.util.ReschedulableTask;
import com.google.wireless.android.sdk.stats.LogcatUsageEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u00071234567B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0011H\u0007J\b\u0010,\u001a\u00020*H\u0002J\r\u0010-\u001a\u00020.H\u0001\u00a2\u0006\u0002\b/J\b\u00100\u001a\u00020*H\u0003R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0018R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\u00020\u001f8\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R$\u0010\"\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0012\u0010'\u001a\u00060(R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "project", "Lcom/intellij/openapi/project/Project;", "logcatPresenter", "Lcom/android/tools/idea/logcat/LogcatPresenter;", "filterParser", "Lcom/android/tools/idea/logcat/filters/LogcatFilterParser;", "initialText", "", "androidProjectDetector", "Lcom/android/tools/idea/logcat/util/AndroidProjectDetector;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/logcat/LogcatPresenter;Lcom/android/tools/idea/logcat/filters/LogcatFilterParser;Ljava/lang/String;Lcom/android/tools/idea/logcat/util/AndroidProjectDetector;)V", "clearButton", "Ljavax/swing/JLabel;", "documentChangedListeners", "", "Lcom/intellij/openapi/editor/event/DocumentListener;", "favoriteButton", "filter", "Lcom/android/tools/idea/logcat/filters/LogcatFilter;", "filterHistory", "Lcom/android/tools/idea/logcat/filters/AndroidLogcatFilterHistory;", "historyButton", "Lcom/android/tools/idea/logcat/filters/FilterTextField$InlineButton;", "value", "", "isFavorite", "setFavorite", "(Z)V", "notifyFilterChangedTask", "Lcom/android/tools/idea/logcat/util/ReschedulableTask;", "getNotifyFilterChangedTask$intellij_android_logcat", "()Lcom/android/tools/idea/logcat/util/ReschedulableTask;", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "textField", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterEditorTextField;", "addDocumentListener", "", "listener", "addToHistory", "getEditorEx", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getEditorEx$intellij_android_logcat", "showPopup", "FilterEditorTextField", "FilterHistoryItem", "FilterTextFieldBorder", "HistoryList", "HistoryListCellRenderer", "InlineButton", "InlinePanel", "intellij.android.logcat"})
public final class FilterTextField
extends BorderLayoutPanel {
    @NotNull
    private final LogcatPresenter logcatPresenter;
    @NotNull
    private final LogcatFilterParser filterParser;
    @NotNull
    private final AndroidLogcatFilterHistory filterHistory;
    @TestOnly
    @NotNull
    private final ReschedulableTask notifyFilterChangedTask;
    @NotNull
    private final List<DocumentListener> documentChangedListeners;
    @NotNull
    private final FilterEditorTextField textField;
    @NotNull
    private final InlineButton historyButton;
    @NotNull
    private final JLabel clearButton;
    @NotNull
    private final JLabel favoriteButton;
    @Nullable
    private LogcatFilter filter;
    private boolean isFavorite;

    public FilterTextField(@NotNull Project project, @NotNull LogcatPresenter logcatPresenter, @NotNull LogcatFilterParser filterParser, @NotNull String initialText, @NotNull AndroidProjectDetector androidProjectDetector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)logcatPresenter, (String)"logcatPresenter");
        Intrinsics.checkNotNullParameter((Object)filterParser, (String)"filterParser");
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        Intrinsics.checkNotNullParameter((Object)androidProjectDetector, (String)"androidProjectDetector");
        this.logcatPresenter = logcatPresenter;
        this.filterParser = filterParser;
        this.filterHistory = AndroidLogcatFilterHistory.Companion.getInstance();
        this.notifyFilterChangedTask = new ReschedulableTask(CoroutinesUtilsKt.AndroidCoroutineScope((Disposable)this.logcatPresenter, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread())));
        this.documentChangedListeners = new ArrayList();
        this.textField = new FilterEditorTextField(project, this.logcatPresenter, androidProjectDetector);
        Icon icon2 = StudioIcons.Logcat.Input.FILTER_HISTORY;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FILTER_HISTORY");
        this.historyButton = new InlineButton(icon2);
        this.clearButton = new JLabel(AllIcons.Actions.Close);
        this.favoriteButton = new JLabel(StudioIcons.Logcat.Input.FAVORITE_OUTLINE);
        this.filter = this.filterParser.parse(initialText);
        this.setText(initialText);
        this.setFavorite(this.filterHistory.getFavorites().contains(this.getText()));
        this.addToLeft(this.historyButton);
        this.addToCenter((Component)((Object)this.textField));
        Object object = new JComponent[]{this.clearButton, new JSeparator(1), this.favoriteButton};
        InlinePanel buttonPanel = new InlinePanel((JComponent[])object);
        this.addToRight(buttonPanel);
        if (((CharSequence)initialText).length() == 0) {
            buttonPanel.setVisible(false);
        }
        this.setBorder(BorderFactory.createCompoundBorder((Border)((Object)new FilterTextFieldBorder()), JBUI.Borders.empty((int)1)));
        Object $this$_init__u24lambda_u240 = object = this.historyButton;
        boolean bl = false;
        ((Component)$this$_init__u24lambda_u240).addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FilterTextField this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FilterTextField.access$showPopup(this.this$0);
            }
        });
        ((JComponent)$this$_init__u24lambda_u240).setBorder((Border)FilterTextFieldKt.access$getHistoryIconBorder$p());
        ((JComponent)$this$_init__u24lambda_u240).setToolTipText(LogcatBundle.message("logcat.filter.history.tooltip", new Object[0]));
        object = this.textField;
        Object $this$_init__u24lambda_u241 = object;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.addDocumentListener(new DocumentListener(this, (FilterEditorTextField)((Object)$this$_init__u24lambda_u241), buttonPanel){
            final /* synthetic */ FilterTextField this$0;
            final /* synthetic */ FilterEditorTextField $this_apply;
            final /* synthetic */ InlinePanel $buttonPanel;
            {
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
                this.$buttonPanel = $buttonPanel;
            }

            public void documentChanged(@NotNull DocumentEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                LogcatFilterParser logcatFilterParser = FilterTextField.access$getFilterParser$p(this.this$0);
                String string = this.$this_apply.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                FilterTextField.access$setFilter$p(this.this$0, logcatFilterParser.parse(string));
                FilterTextField.access$setFavorite(this.this$0, FilterTextField.access$getFilterHistory$p(this.this$0).getFavorites().contains(this.$this_apply.getText()));
                AndroidLogcatFilterHistory androidLogcatFilterHistory = FilterTextField.access$getFilterHistory$p(this.this$0);
                String string2 = FilterTextField.access$getTextField$p(this.this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"textField.text");
                androidLogcatFilterHistory.setMostRecentlyUsed(string2);
                this.this$0.getNotifyFilterChangedTask$intellij_android_logcat().reschedule(100L, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, event2){
                    final /* synthetic */ FilterTextField this$0;
                    final /* synthetic */ DocumentEvent $event;
                    {
                        this.this$0 = $receiver;
                        this.$event = $event;
                        super(0);
                    }

                    public final void invoke() {
                        for (DocumentListener listener2 : FilterTextField.access$getDocumentChangedListeners$p(this.this$0)) {
                            listener2.documentChanged(this.$event);
                        }
                    }
                }));
                String string3 = FilterTextField.access$getTextField$p(this.this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"textField.text");
                this.$buttonPanel.setVisible(((CharSequence)string3).length() > 0);
            }
        });
        $this$_init__u24lambda_u241.addFocusListener((FocusListener)new FocusAdapter(this){
            final /* synthetic */ FilterTextField this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusGained(@Nullable FocusEvent e) {
                String hintText = FilterTextFieldKt.access$getFilterHintText();
                new GotItTooltip("filter.tip", hintText, (Disposable)FilterTextField.access$getLogcatPresenter$p(this.this$0)).withBrowserLink(LogcatBundle.message("logcat.filter.got.it.link.text", new Object[0]), FilterTextFieldKt.access$getLogcatFilterHelpUrl$p()).show((JComponent)((Object)FilterTextField.access$getTextField$p(this.this$0)), GotItTooltip.BOTTOM_LEFT);
            }

            public void focusLost(@Nullable FocusEvent e) {
                FilterTextField.access$addToHistory(this.this$0);
            }
        });
        $this$_init__u24lambda_u241.setBorder(JBUI.Borders.customLine((Color)$this$_init__u24lambda_u241.getBackground(), (int)1, (int)0, (int)0, (int)0));
        $this$_init__u24lambda_u241.setShowPlaceholderWhenFocused(true);
        $this$_init__u24lambda_u241.setPlaceholder((CharSequence)FilterTextFieldKt.access$getFilterHintText());
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.logcatPresenter);
        Topic topic = KeymapManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new KeymapManagerListener((FilterEditorTextField)((Object)$this$_init__u24lambda_u241)){
            final /* synthetic */ FilterEditorTextField $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public void activeKeymapChanged(@Nullable Keymap keymap) {
                this.$this_apply.setPlaceholder(FilterTextFieldKt.access$getFilterHintText());
            }
        });
        Object $this$_init__u24lambda_u242 = object = this.clearButton;
        boolean bl3 = false;
        ((JComponent)$this$_init__u24lambda_u242).setToolTipText(LogcatBundle.message("logcat.filter.clear.tooltip", new Object[0]));
        ((Component)$this$_init__u24lambda_u242).addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FilterTextField this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FilterTextField.access$getClearButton$p(this.this$0).setIcon(AllIcons.Actions.CloseHovered);
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FilterTextField.access$getClearButton$p(this.this$0).setIcon(AllIcons.Actions.Close);
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FilterTextField.access$getTextField$p(this.this$0).setText("");
            }
        });
        Object $this$_init__u24lambda_u243 = object = this.favoriteButton;
        boolean bl4 = false;
        ((JComponent)$this$_init__u24lambda_u243).setToolTipText(LogcatBundle.message("logcat.filter.tag.favorite.tooltip", new Object[0]));
        ((Component)$this$_init__u24lambda_u243).addMouseListener(new MouseAdapter(this, (JLabel)$this$_init__u24lambda_u243){
            final /* synthetic */ FilterTextField this$0;
            final /* synthetic */ JLabel $this_apply;
            {
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FilterTextField.access$setFavorite(this.this$0, !FilterTextField.access$isFavorite$p(this.this$0));
                this.$this_apply.setToolTipText(FilterTextField.access$isFavorite$p(this.this$0) ? LogcatBundle.message("logcat.filter.untag.favorite.tooltip", new Object[0]) : LogcatBundle.message("logcat.filter.tag.favorite.tooltip", new Object[0]));
                FilterTextField.access$addToHistory(this.this$0);
                this.mouseEntered(e);
            }

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$this_apply.setIcon(FilterTextField.access$isFavorite$p(this.this$0) ? StudioIcons.Logcat.Input.FAVORITE_FILLED_HOVER : StudioIcons.Logcat.Input.FAVORITE_OUTLINE_HOVER);
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$this_apply.setIcon(FilterTextField.access$isFavorite$p(this.this$0) ? StudioIcons.Logcat.Input.FAVORITE_FILLED : StudioIcons.Logcat.Input.FAVORITE_OUTLINE);
            }
        });
    }

    public /* synthetic */ FilterTextField(Project project, LogcatPresenter logcatPresenter, LogcatFilterParser logcatFilterParser, String string, AndroidProjectDetector androidProjectDetector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            androidProjectDetector = new AndroidProjectDetectorImpl();
        }
        this(project, logcatPresenter, logcatFilterParser, string, androidProjectDetector);
    }

    @NotNull
    public final ReschedulableTask getNotifyFilterChangedTask$intellij_android_logcat() {
        return this.notifyFilterChangedTask;
    }

    private final void setFavorite(boolean value2) {
        this.isFavorite = value2;
        this.favoriteButton.setIcon(this.isFavorite ? StudioIcons.Logcat.Input.FAVORITE_FILLED : StudioIcons.Logcat.Input.FAVORITE_OUTLINE);
    }

    @NotNull
    public final String getText() {
        String string = this.textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textField.text");
        return string;
    }

    public final void setText(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.textField.setText(value2);
    }

    @UiThread
    public final void addDocumentListener(@NotNull DocumentListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.documentChangedListeners.add(listener2);
    }

    @TestOnly
    @NotNull
    public final EditorEx getEditorEx$intellij_android_logcat() {
        Editor editor = this.textField.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        return (EditorEx)editor;
    }

    @UiThread
    private final void showPopup() {
        Disposable disposable2 = Disposer.newDisposable((String)"popupDisposable");
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(\"popupDisposable\")");
        Disposable popupDisposable = disposable2;
        this.addToHistory();
        JList list2 = (JList)((Object)new HistoryList(this, popupDisposable, null, 2, null));
        Object[] objectArray = new String[]{"foo", "bar"};
        JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.listOf((Object[])objectArray));
        JBPopup jBPopup = new PopupChooserBuilder(list2).setMovable(false).setRequestFocus(true).setItemChosenCallback(new Consumer(this){
            final /* synthetic */ FilterTextField this$0;
            {
                this.this$0 = $receiver;
            }

            public final void consume(FilterHistoryItem it) {
                block0: {
                    FilterHistoryItem.Item item2 = it instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)it : null;
                    if (item2 == null) break block0;
                    FilterHistoryItem.Item item3 = item2;
                    FilterTextField filterTextField = this.this$0;
                    FilterHistoryItem.Item item4 = item3;
                    boolean bl = false;
                    filterTextField.setText(item4.getFilter());
                    FilterTextField.access$setFavorite(filterTextField, item4.isFavorite());
                }
            }
        }).setSelectedValue((Object)new FilterHistoryItem.Item(this.getText(), this.isFavorite, null, this.filterParser), true).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"@UiThread\n  private fun \u2026howUnderneathOf(this)\n  }");
        JBPopup popup2 = jBPopup;
        Disposer.register((Disposable)((Disposable)popup2), (Disposable)popupDisposable);
        popup2.showUnderneathOf((Component)((Object)this));
    }

    private final void addToHistory() {
        String string = this.textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textField.text");
        String text2 = string;
        if (((CharSequence)text2).length() == 0) {
            return;
        }
        this.filterHistory.add(this.filterParser, text2, this.isFavorite);
        LogcatUsageEvent.LogcatFilterEvent.Builder builder2 = this.filterParser.getUsageTrackingEvent(text2);
        LogcatUsageEvent.Builder builder3 = LogcatUsageEvent.newBuilder().setType(LogcatUsageEvent.Type.FILTER_ADDED_TO_HISTORY).setLogcatFilter(builder2 != null ? builder2.setIsFavorite(this.isFavorite) : null);
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"newBuilder()\n        .se\u2026etIsFavorite(isFavorite))");
        LogcatUsageTracker.INSTANCE.log(builder3);
    }

    public static final /* synthetic */ void access$addToHistory(FilterTextField $this) {
        $this.addToHistory();
    }

    public static final /* synthetic */ LogcatFilter access$getFilter$p(FilterTextField $this) {
        return $this.filter;
    }

    public static final /* synthetic */ LogcatPresenter access$getLogcatPresenter$p(FilterTextField $this) {
        return $this.logcatPresenter;
    }

    public static final /* synthetic */ void access$showPopup(FilterTextField $this) {
        $this.showPopup();
    }

    public static final /* synthetic */ void access$setFilter$p(FilterTextField $this, LogcatFilter logcatFilter) {
        $this.filter = logcatFilter;
    }

    public static final /* synthetic */ List access$getDocumentChangedListeners$p(FilterTextField $this) {
        return $this.documentChangedListeners;
    }

    public static final /* synthetic */ JLabel access$getClearButton$p(FilterTextField $this) {
        return $this.clearButton;
    }

    public static final /* synthetic */ boolean access$isFavorite$p(FilterTextField $this) {
        return $this.isFavorite;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterEditorTextField;", "Lcom/intellij/ui/EditorTextField;", "project", "Lcom/intellij/openapi/project/Project;", "logcatPresenter", "Lcom/android/tools/idea/logcat/LogcatPresenter;", "androidProjectDetector", "Lcom/android/tools/idea/logcat/util/AndroidProjectDetector;", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/logcat/LogcatPresenter;Lcom/android/tools/idea/logcat/util/AndroidProjectDetector;)V", "createEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "updateUI", "", "intellij.android.logcat"})
    private final class FilterEditorTextField
    extends EditorTextField {
        @NotNull
        private final LogcatPresenter logcatPresenter;
        @NotNull
        private final AndroidProjectDetector androidProjectDetector;

        public FilterEditorTextField(@NotNull Project project, @NotNull LogcatPresenter logcatPresenter, AndroidProjectDetector androidProjectDetector) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)logcatPresenter, (String)"logcatPresenter");
            Intrinsics.checkNotNullParameter((Object)androidProjectDetector, (String)"androidProjectDetector");
            super(project, (FileType)LogcatFilterFileType.INSTANCE);
            this.logcatPresenter = logcatPresenter;
            this.androidProjectDetector = androidProjectDetector;
        }

        @NotNull
        public EditorEx createEditor() {
            EditorEx editorEx = super.createEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"super.createEditor()");
            EditorEx editorEx2 = editorEx;
            FilterTextField filterTextField = FilterTextField.this;
            EditorEx $this$createEditor_u24lambda_u240 = editorEx2;
            boolean bl = false;
            $this$createEditor_u24lambda_u240.putUserData(ConstantsKt.getTAGS_PROVIDER_KEY(), (Object)this.logcatPresenter);
            $this$createEditor_u24lambda_u240.putUserData(ConstantsKt.getPACKAGE_NAMES_PROVIDER_KEY(), (Object)this.logcatPresenter);
            $this$createEditor_u24lambda_u240.putUserData(ConstantsKt.getPROCESS_NAMES_PROVIDER_KEY(), (Object)this.logcatPresenter);
            $this$createEditor_u24lambda_u240.putUserData(AndroidProjectDetector.Companion.getKEY(), (Object)this.androidProjectDetector);
            $this$createEditor_u24lambda_u240.setBorder(FilterTextFieldKt.access$getEditorBorder$p());
            $this$createEditor_u24lambda_u240.getContentComponent().addKeyListener(new KeyAdapter(filterTextField){
                final /* synthetic */ FilterTextField this$0;
                {
                    this.this$0 = $receiver;
                }

                public void keyPressed(@NotNull KeyEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getKeyCode() == 10) {
                        e.consume();
                        FilterTextField.access$addToHistory(this.this$0);
                    }
                }
            });
            $this$createEditor_u24lambda_u240.getContentComponent().addMouseMotionListener(new MouseAdapter($this$createEditor_u24lambda_u240, this, filterTextField){
                final /* synthetic */ EditorEx $this_apply;
                final /* synthetic */ FilterEditorTextField this$0;
                final /* synthetic */ FilterTextField this$1;
                {
                    this.$this_apply = $receiver;
                    this.this$0 = $receiver2;
                    this.this$1 = $receiver3;
                }

                /*
                 * WARNING - void declaration
                 */
                public void mouseMoved(@NotNull MouseEvent e) {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    JComponent jComponent = this.$this_apply.getContentComponent();
                    Editor editor = this.this$0.getEditor();
                    if (editor != null) {
                        void editor2;
                        Editor editor3 = editor;
                        FilterTextField filterTextField = this.this$1;
                        Editor editor4 = editor3;
                        JComponent jComponent2 = jComponent;
                        boolean bl = false;
                        LogicalPosition logicalPosition = editor2.xyToLogicalPosition(e.getPoint());
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"editor.xyToLogicalPosition(e.point)");
                        LogicalPosition position = logicalPosition;
                        LogcatFilter logcatFilter = FilterTextField.access$getFilter$p(filterTextField);
                        string = logcatFilter != null && (logcatFilter = logcatFilter.findFilterForOffset(position.column)) != null ? logcatFilter.getDisplayText() : null;
                        jComponent = jComponent2;
                    } else {
                        string = null;
                    }
                    jComponent.setToolTipText(string);
                }
            });
            return editorEx2;
        }

        public void updateUI() {
            this.setBorder(JBUI.Borders.customLine((Color)this.getBackground(), (int)1, (int)0, (int)0, (int)0));
            super.updateUI();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b1\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\bH&\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem;", "", "()V", "getComponent", "Ljavax/swing/JComponent;", "isSelected", "", "list", "Ljavax/swing/JList;", "Item", "Separator", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Item;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Separator;", "intellij.android.logcat"})
    @VisibleForTesting
    public static abstract class FilterHistoryItem {
        private FilterHistoryItem() {
        }

        @NotNull
        public abstract JComponent getComponent(boolean var1, @NotNull JList<? extends FilterHistoryItem> var2);

        public /* synthetic */ FilterHistoryItem(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00052\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010&H\u0016J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\b\u0010,\u001a\u00020\u0007H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015\u00a8\u00060"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Item;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem;", "filter", "", "isFavorite", "", "count", "", "filterParser", "Lcom/android/tools/idea/logcat/filters/LogcatFilterParser;", "(Ljava/lang/String;ZLjava/lang/Integer;Lcom/android/tools/idea/logcat/filters/LogcatFilterParser;)V", "component", "Ljavax/swing/JPanel;", "getCount", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "countLabel", "Ljavax/swing/JLabel;", "deleteLabel", "favoriteLabel", "getFilter", "()Ljava/lang/String;", "filterLabel", "Lcom/intellij/ui/SimpleColoredComponent;", "()Z", "setFavorite", "(Z)V", "isFavoriteHovered", "setFavoriteHovered", "tooltip", "getTooltip", "equals", "other", "", "getComponent", "Ljavax/swing/JComponent;", "isSelected", "list", "Ljavax/swing/JList;", "getDeleteIconBounds", "Ljava/awt/Rectangle;", "offset", "Ljava/awt/Point;", "getFavoriteIconBounds", "hashCode", "whiteIconForOldUI", "Ljavax/swing/Icon;", "icon", "intellij.android.logcat"})
        @SourceDebugExtension(value={"SMAP\nFilterTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Item\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,742:1\n1770#2,4:743\n*S KotlinDebug\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Item\n*L\n644#1:743,4\n*E\n"})
        public static final class Item
        extends FilterHistoryItem {
            @NotNull
            private final String filter;
            private boolean isFavorite;
            @Nullable
            private final Integer count;
            @NotNull
            private final LogcatFilterParser filterParser;
            private boolean isFavoriteHovered;
            @Nullable
            private final String tooltip;
            @NotNull
            private final JLabel favoriteLabel;
            @NotNull
            private final SimpleColoredComponent filterLabel;
            @NotNull
            private final JLabel countLabel;
            @NotNull
            private final JLabel deleteLabel;
            @NotNull
            private final JPanel component;

            /*
             * WARNING - void declaration
             */
            public Item(@NotNull String filter2, boolean isFavorite, @Nullable Integer count2, @NotNull LogcatFilterParser filterParser) {
                String filterName;
                void $this$component_u24lambda_u243_u24lambda_u242;
                void $this$component_u24lambda_u243;
                GroupLayout groupLayout;
                Object $this$countLabel_u24lambda_u241;
                Object $this$filterLabel_u24lambda_u240;
                Object object;
                Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
                Intrinsics.checkNotNullParameter((Object)filterParser, (String)"filterParser");
                super(null);
                this.filter = filter2;
                this.isFavorite = isFavorite;
                this.count = count2;
                this.filterParser = filterParser;
                this.favoriteLabel = new JLabel();
                SimpleColoredComponent simpleColoredComponent = object = new SimpleColoredComponent();
                Item item2 = this;
                boolean bl = false;
                $this$filterLabel_u24lambda_u240.setBorder((Border)FilterTextFieldKt.access$getHistoryItemLabelBorder$p());
                item2.filterLabel = object;
                $this$filterLabel_u24lambda_u240 = object = new JLabel();
                item2 = this;
                boolean bl2 = false;
                $this$countLabel_u24lambda_u241.setFont(new Font("Monospaced", 0, $this$countLabel_u24lambda_u241.getFont().getSize()));
                $this$countLabel_u24lambda_u241.setBorder((Border)FilterTextFieldKt.access$getHistoryItemLabelBorder$p());
                item2.countLabel = object;
                this.deleteLabel = new JLabel();
                $this$countLabel_u24lambda_u241 = object = new JPanel(null);
                item2 = this;
                boolean bl3 = false;
                GroupLayout groupLayout2 = groupLayout = new GroupLayout((Container)$this$component_u24lambda_u243);
                void var10_12 = $this$component_u24lambda_u243;
                boolean bl4 = false;
                $this$component_u24lambda_u243_u24lambda_u242.setHorizontalGroup($this$component_u24lambda_u243_u24lambda_u242.createSequentialGroup().addComponent(this.favoriteLabel).addComponent((Component)this.filterLabel).addComponent(this.countLabel).addComponent(this.deleteLabel));
                $this$component_u24lambda_u243_u24lambda_u242.setVerticalGroup($this$component_u24lambda_u243_u24lambda_u242.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.favoriteLabel).addComponent((Component)this.filterLabel).addComponent(this.countLabel).addComponent(this.deleteLabel));
                $this$component_u24lambda_u243.setBorder((Border)FilterTextFieldKt.access$getFilterHistoryItemBorder$p());
                var10_12.setLayout(groupLayout);
                item2.component = object;
                LogcatFilter logcatFilter = this.filterParser.parse(this.filter);
                String string = filterName = logcatFilter != null ? logcatFilter.getFilterName() : null;
                if (filterName != null) {
                    String string2;
                    int n;
                    List<String> history = AndroidLogcatFilterHistory.Companion.getInstance().getItems();
                    Iterable $this$count$iv = history;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            String it = (String)element$iv;
                            boolean bl5 = false;
                            LogcatFilter logcatFilter2 = this.filterParser.parse(it);
                            if (!Intrinsics.areEqual((Object)(logcatFilter2 != null ? logcatFilter2.getFilterName() : null), (Object)filterName) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    int sameName = n;
                    this.filterLabel.append(filterName, FilterTextFieldKt.access$getNamedFilterHistoryItemColor$p());
                    String filterWithoutName = this.filterParser.removeFilterNames(this.filter);
                    if (sameName > 1) {
                        this.filterLabel.append(": " + filterWithoutName);
                        string2 = null;
                    } else {
                        string2 = filterWithoutName;
                    }
                    this.tooltip = string2;
                } else {
                    this.tooltip = null;
                    this.filterLabel.append(this.filter);
                }
            }

            @NotNull
            public final String getFilter() {
                return this.filter;
            }

            public final boolean isFavorite() {
                return this.isFavorite;
            }

            public final void setFavorite(boolean bl) {
                this.isFavorite = bl;
            }

            @Nullable
            public final Integer getCount() {
                return this.count;
            }

            public final boolean isFavoriteHovered() {
                return this.isFavoriteHovered;
            }

            public final void setFavoriteHovered(boolean bl) {
                this.isFavoriteHovered = bl;
            }

            @Nullable
            public final String getTooltip() {
                return this.tooltip;
            }

            @NotNull
            public final Rectangle getFavoriteIconBounds(@NotNull Point offset) {
                Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
                Rectangle rectangle = this.favoriteLabel.getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"favoriteLabel.bounds");
                return FilterTextFieldKt.access$plus(rectangle, offset);
            }

            @NotNull
            public final Rectangle getDeleteIconBounds(@NotNull Point offset) {
                Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
                Rectangle rectangle = this.deleteLabel.getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"deleteLabel.bounds");
                return FilterTextFieldKt.access$plus(rectangle, offset);
            }

            @Override
            @NotNull
            public JComponent getComponent(boolean isSelected, @NotNull JList<? extends FilterHistoryItem> list2) {
                String string;
                Icon icon2;
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                if (this.isFavoriteHovered && this.isFavorite) {
                    Icon icon3 = StudioIcons.Logcat.Input.FAVORITE_FILLED;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"FAVORITE_FILLED");
                    icon2 = this.whiteIconForOldUI(icon3);
                } else if (this.isFavoriteHovered && !this.isFavorite) {
                    Icon icon4 = StudioIcons.Logcat.Input.FAVORITE_OUTLINE;
                    Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"FAVORITE_OUTLINE");
                    icon2 = this.whiteIconForOldUI(icon4);
                } else {
                    icon2 = !this.isFavoriteHovered && this.isFavorite ? StudioIcons.Logcat.Input.FAVORITE_FILLED : FilterTextFieldKt.access$getBlankIcon$p();
                }
                this.favoriteLabel.setIcon(icon2);
                this.deleteLabel.setIcon(isSelected ? StudioIcons.Logcat.Input.FILTER_HISTORY_DELETE : FilterTextFieldKt.access$getBlankIcon$p());
                Integer n = this.count;
                if (n == null) {
                    string = StringsKt.repeat((CharSequence)" ", (int)3);
                } else if (new IntRange(0, 99).contains(n.intValue())) {
                    String string2 = "% 2d ";
                    Object[] objectArray = new Object[]{this.count};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
                } else {
                    string = "99+";
                }
                this.countLabel.setText(string);
                n = isSelected ? new Pair((Object)list2.getSelectionForeground(), (Object)list2.getSelectionBackground()) : new Pair((Object)list2.getForeground(), (Object)list2.getBackground());
                Color foreground = (Color)n.component1();
                Color background = (Color)n.component2();
                this.filterLabel.setForeground(foreground);
                this.deleteLabel.setForeground(foreground);
                this.component.setBackground(background);
                this.countLabel.setForeground(isSelected ? foreground : SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor());
                return this.component;
            }

            private final Icon whiteIconForOldUI(Icon icon2) {
                return ExperimentalUI.isNewUI() ? icon2 : ColoredIconGenerator.generateWhiteIcon((Icon)icon2);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                Object object = other;
                if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                    return false;
                }
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.android.tools.idea.logcat.filters.FilterTextField.FilterHistoryItem.Item");
                Item cfr_ignored_0 = (Item)other;
                return Intrinsics.areEqual((Object)this.filter, (Object)((Item)other).filter);
            }

            public int hashCode() {
                return this.filter.hashCode();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Separator;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem;", "()V", "component", "Ljavax/swing/JPanel;", "getComponent", "Ljavax/swing/JComponent;", "isSelected", "", "list", "Ljavax/swing/JList;", "intellij.android.logcat"})
        public static final class Separator
        extends FilterHistoryItem {
            @NotNull
            public static final Separator INSTANCE;
            @NotNull
            private static final JPanel component;

            private Separator() {
                super(null);
            }

            @Override
            @NotNull
            public JComponent getComponent(boolean isSelected, @NotNull JList<? extends FilterHistoryItem> list2) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                component.setBackground(list2.getBackground());
                return component;
            }

            static {
                JPanel jPanel;
                INSTANCE = new Separator();
                JPanel $this$component_u24lambda_u240 = jPanel = new JPanel(null);
                boolean bl = false;
                $this$component_u24lambda_u240.setLayout(new BoxLayout($this$component_u24lambda_u240, 3));
                $this$component_u24lambda_u240.setBorder(FilterTextFieldKt.access$getHistoryListSeparatorBorder$p());
                $this$component_u24lambda_u240.add(new JSeparator(0));
                component = jPanel;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterTextFieldBorder;", "Lcom/intellij/ide/ui/laf/darcula/ui/DarculaTextBorder;", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;)V", "isFocused", "", "c", "Ljava/awt/Component;", "intellij.android.logcat"})
    private final class FilterTextFieldBorder
    extends DarculaTextBorder {
        protected boolean isFocused(@Nullable Component c) {
            Object object = FilterTextField.this.textField.getEditor();
            return object != null && (object = object.getContentComponent()) != null ? ((Component)object).hasFocus() : false;
        }
    }

    @UiThread
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$HistoryList;", "Lcom/intellij/ui/components/JBList;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "parentContext", "Lkotlin/coroutines/CoroutineContext;", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;Lcom/intellij/openapi/Disposable;Lkotlin/coroutines/CoroutineContext;)V", "inactiveColor", "", "listModel", "Lcom/intellij/ui/CollectionListModel;", "deleteItem", "", "index", "", "getFavoriteTooltip", "item", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Item;", "getToolTipText", "event", "Ljava/awt/event/MouseEvent;", "toggleFavoriteItem", "bounds", "Ljava/awt/Rectangle;", "MouseListener", "intellij.android.logcat"})
    @VisibleForTesting
    @SourceDebugExtension(value={"SMAP\nFilterTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$HistoryList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,742:1\n1549#2:743\n1620#2,3:744\n1549#2:747\n1620#2,3:748\n1549#2:751\n1620#2,3:752\n1549#2:755\n1620#2,3:756\n*S KotlinDebug\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$HistoryList\n*L\n407#1:743\n407#1:744,3\n411#1:747\n411#1:748,3\n412#1:751\n412#1:752,3\n415#1:755\n415#1:756,3\n*E\n"})
    public final class HistoryList
    extends JBList<FilterHistoryItem> {
        @NotNull
        private final CollectionListModel<FilterHistoryItem> listModel;
        @NotNull
        private final String inactiveColor;
        final /* synthetic */ FilterTextField this$0;

        /*
         * WARNING - void declaration
         */
        public HistoryList(@NotNull FilterTextField this$0, @NotNull Disposable parentDisposable, CoroutineContext parentContext) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter((Object)parentContext, (String)"parentContext");
            this.this$0 = this$0;
            this.listModel = new CollectionListModel((Object[])new FilterHistoryItem[0]);
            Object object = "%06x";
            Object object2 = new Object[]{NamedColorUtil.getInactiveTextColor().getRGB() & 0xFFFFFF};
            String string = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
            this.inactiveColor = string;
            object = new ArrayList();
            object2 = this.this$0;
            Object $this$_init__u24lambda_u243 = object;
            boolean bl = false;
            Iterable iterable = ((FilterTextField)((Object)object2)).filterHistory.getFavorites();
            Object object3 = $this$_init__u24lambda_u243;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                String string2 = (String)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(new FilterHistoryItem.Item(it, true, null, ((FilterTextField)((Object)object2)).filterParser));
            }
            object3.addAll((List)destination$iv$iv);
            if (!((Collection)((FilterTextField)((Object)object2)).filterHistory.getFavorites()).isEmpty() && !((Collection)((FilterTextField)((Object)object2)).filterHistory.getNonFavorites()).isEmpty()) {
                $this$_init__u24lambda_u243.add(FilterHistoryItem.Separator.INSTANCE);
            }
            $this$map$iv2 = ((FilterTextField)((Object)object2)).filterHistory.getNamed();
            object3 = $this$_init__u24lambda_u243;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (String)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(new FilterHistoryItem.Item(it, false, null, ((FilterTextField)((Object)object2)).filterParser));
            }
            object3.addAll((List)destination$iv$iv);
            $this$map$iv2 = ((FilterTextField)((Object)object2)).filterHistory.getNonFavorites();
            object3 = $this$_init__u24lambda_u243;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (String)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl4 = false;
                collection2.add(new FilterHistoryItem.Item(it, false, null, ((FilterTextField)((Object)object2)).filterParser));
            }
            object3.addAll((List)destination$iv$iv);
            Object items2 = object;
            object2 = (Iterable)items2;
            FilterTextField filterTextField = this.this$0;
            boolean $i$f$map2 = false;
            $this$map$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FilterHistoryItem $i$f$mapTo3 = (FilterHistoryItem)item$iv$iv;
                Collection collection3 = destination$iv$iv2;
                boolean bl5 = false;
                collection3.add(it2 instanceof FilterHistoryItem.Item ? filterTextField.filterParser.parse(((FilterHistoryItem.Item)it2).getFilter()) : null);
            }
            List filters = (List)destination$iv$iv2;
            this.setModel((ListModel)this.listModel);
            this.listModel.addAll(0, (List)items2);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(@NotNull KeyEvent e) {
                    FilterHistoryItem.Item item2;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Object object = this.getSelectedValue();
                    FilterHistoryItem.Item item3 = item2 = object instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)object : null;
                    if (item2 != null && ArraysKt.contains((Object[])FilterTextFieldKt.access$getDeleteKeyCodes$p(), (Object)e.getKeyCode())) {
                        this.deleteItem(this.getSelectedIndex());
                    }
                }
            });
            this.setCellRenderer(new HistoryListCellRenderer());
            BuildersKt.launch$default((CoroutineScope)CoroutinesUtilsKt.AndroidCoroutineScope((Disposable)parentDisposable, (CoroutineContext)parentContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, parentContext, this.this$0, (List<? extends LogcatFilter>)filters, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ HistoryList this$0;
                final /* synthetic */ CoroutineContext $parentContext;
                final /* synthetic */ FilterTextField this$1;
                final /* synthetic */ List<LogcatFilter> $filters;
                {
                    this.this$0 = $receiver;
                    this.$parentContext = $parentContext;
                    this.this$1 = $receiver2;
                    this.$filters = $filters;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$forEachIndexed$iv;
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            Application application = ApplicationManager.getApplication();
                            List list2 = this.this$0.listModel.getItems();
                            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"listModel.items");
                            Iterable iterable = list2;
                            CoroutineContext coroutineContext = this.$parentContext;
                            FilterTextField filterTextField = this.this$1;
                            List<LogcatFilter> list3 = this.$filters;
                            HistoryList historyList = this.this$0;
                            boolean $i$f$forEachIndexed = false;
                            int index$iv = 0;
                            for (Object item$iv : $this$forEachIndexed$iv) {
                                void item2;
                                int n;
                                if ((n = index$iv++) < 0) {
                                    CollectionsKt.throwIndexOverflow();
                                }
                                FilterHistoryItem filterHistoryItem = (FilterHistoryItem)item$iv;
                                int index2 = n;
                                boolean bl = false;
                                if (!(item2 instanceof FilterHistoryItem.Item)) continue;
                                BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(application, coroutineContext, filterTextField, list3, index2, historyList, (FilterHistoryItem)item2, null){
                                    int label;
                                    final /* synthetic */ Application $application;
                                    final /* synthetic */ CoroutineContext $parentContext;
                                    final /* synthetic */ FilterTextField this$0;
                                    final /* synthetic */ List<LogcatFilter> $filters;
                                    final /* synthetic */ int $index;
                                    final /* synthetic */ HistoryList this$1;
                                    final /* synthetic */ FilterHistoryItem $item;
                                    {
                                        this.$application = $application;
                                        this.$parentContext = $parentContext;
                                        this.this$0 = $receiver;
                                        this.$filters = $filters;
                                        this.$index = $index;
                                        this.this$1 = $receiver2;
                                        this.$item = $item;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                Integer count2 = (Integer)this.$application.runReadAction(new Computable(this.this$0, this.$filters, this.$index){
                                                    final /* synthetic */ FilterTextField this$0;
                                                    final /* synthetic */ List<LogcatFilter> $filters;
                                                    final /* synthetic */ int $index;
                                                    {
                                                        this.this$0 = $receiver;
                                                        this.$filters = $filters;
                                                        this.$index = $index;
                                                    }

                                                    public final Integer compute() {
                                                        return FilterTextField.access$getLogcatPresenter$p(this.this$0).countFilterMatches(this.$filters.get(this.$index));
                                                    }
                                                });
                                                this.label = 1;
                                                Object object3 = BuildersKt.withContext((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread().plus(this.$parentContext), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.$item, count2, this.this$0, this.$index, null){
                                                    int label;
                                                    final /* synthetic */ HistoryList this$0;
                                                    final /* synthetic */ FilterHistoryItem $item;
                                                    final /* synthetic */ Integer $count;
                                                    final /* synthetic */ FilterTextField this$1;
                                                    final /* synthetic */ int $index;
                                                    {
                                                        this.this$0 = $receiver;
                                                        this.$item = $item;
                                                        this.$count = $count;
                                                        this.this$1 = $receiver2;
                                                        this.$index = $index;
                                                        super(2, $completion);
                                                    }

                                                    @Nullable
                                                    public final Object invokeSuspend(@NotNull Object object) {
                                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)object);
                                                                int selected = this.this$0.getSelectedIndex();
                                                                HistoryList.access$getListModel$p(this.this$0).setElementAt((Object)new FilterHistoryItem.Item(((FilterHistoryItem.Item)this.$item).getFilter(), ((FilterHistoryItem.Item)this.$item).isFavorite(), this.$count, FilterTextField.access$getFilterParser$p(this.this$1)), this.$index);
                                                                if (selected >= 0) {
                                                                    this.this$0.setSelectedIndex(selected);
                                                                }
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    @NotNull
                                                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    @Nullable
                                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                }), (Continuation)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            MouseListener listener2 = new MouseListener();
            this.addMouseListener(listener2);
            this.addMouseMotionListener(listener2);
        }

        public /* synthetic */ HistoryList(FilterTextField filterTextField, Disposable disposable2, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                coroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
            }
            this(filterTextField, disposable2, coroutineContext);
        }

        @Nullable
        public String getToolTipText(@NotNull MouseEvent event2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            int index2 = this.getSelectedIndex();
            if (index2 < 0) {
                return null;
            }
            Object e = this.getModel().getElementAt(index2);
            FilterHistoryItem.Item item2 = e instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)e : null;
            if (item2 == null) {
                return null;
            }
            FilterHistoryItem.Item item3 = item2;
            Point cellLocation = this.getCellBounds(index2, index2).getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)cellLocation, (String)"cellLocation");
            Rectangle favoriteIconBounds = item3.getFavoriteIconBounds(cellLocation);
            Rectangle deleteIconBounds = item3.getDeleteIconBounds(cellLocation);
            if (favoriteIconBounds.contains(event2.getPoint())) {
                string = this.getFavoriteTooltip(item3);
            } else if (deleteIconBounds.contains(event2.getPoint())) {
                Object[] objectArray = new Object[]{this.inactiveColor};
                string = LogcatBundle.message("logcat.filter.history.delete.tooltip", objectArray);
            } else {
                string = item3.getTooltip();
            }
            return string;
        }

        private final String getFavoriteTooltip(FilterHistoryItem.Item item2) {
            String string;
            boolean bl = item2.isFavorite();
            if (bl) {
                string = LogcatBundle.message("logcat.filter.untag.favorite.tooltip", new Object[0]);
            } else if (!bl) {
                string = LogcatBundle.message("logcat.filter.tag.favorite.tooltip", new Object[0]);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        private final void toggleFavoriteItem(int index2, Rectangle bounds) {
            Object e = this.getModel().getElementAt(index2);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.android.tools.idea.logcat.filters.FilterTextField.FilterHistoryItem.Item");
            FilterHistoryItem.Item item2 = (FilterHistoryItem.Item)e;
            if (item2.isFavorite()) {
                item2.setFavorite(false);
                this.this$0.filterHistory.getFavorites().remove(item2.getFilter());
                this.this$0.filterHistory.getNonFavorites().add(item2.getFilter());
            } else {
                item2.setFavorite(true);
                this.this$0.filterHistory.getFavorites().add(item2.getFilter());
                this.this$0.filterHistory.getNonFavorites().remove(item2.getFilter());
            }
            if (Intrinsics.areEqual((Object)item2.getFilter(), (Object)this.this$0.getText())) {
                this.this$0.setFavorite(item2.isFavorite());
            }
            this.paintImmediately(bounds);
        }

        public final void deleteItem(int index2) {
            Object object = this.listModel.getElementAt(index2);
            FilterHistoryItem.Item item2 = object instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)object : null;
            if (item2 == null) {
                return;
            }
            FilterHistoryItem.Item item3 = item2;
            this.this$0.filterHistory.remove(item3.getFilter());
            if (Intrinsics.areEqual((Object)this.this$0.getText(), (Object)item3.getFilter())) {
                this.this$0.setText("");
            }
            this.listModel.remove(index2);
            this.setSelectedIndex(Math.min(index2, this.getModel().getSize() - 1));
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0014\u0010\u0010\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$HistoryList$MouseListener;", "Ljava/awt/event/MouseAdapter;", "(Lcom/android/tools/idea/logcat/filters/FilterTextField$HistoryList;)V", "hoveredFavoriteIndex", "", "Ljava/lang/Integer;", "mouseMoved", "", "event", "Ljava/awt/event/MouseEvent;", "mouseReleased", "getItemAt", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem$Item;", "Ljavax/swing/ListModel;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem;", "index", "setIsHoveredFavorite", "value", "", "intellij.android.logcat"})
        @SourceDebugExtension(value={"SMAP\nFilterTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$HistoryList$MouseListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,742:1\n1#2:743\n*E\n"})
        public final class MouseListener
        extends MouseAdapter {
            @Nullable
            private Integer hoveredFavoriteIndex;

            @Override
            public void mouseReleased(@NotNull MouseEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                if (event2.getButton() == 1 && event2.getModifiersEx() == 0) {
                    int index2 = HistoryList.this.getSelectedIndex();
                    Object e = HistoryList.this.getModel().getElementAt(index2);
                    FilterHistoryItem.Item item2 = e instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)e : null;
                    if (item2 == null) {
                        return;
                    }
                    FilterHistoryItem.Item item3 = item2;
                    Point cellLocation = HistoryList.this.getCellBounds(index2, index2).getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)cellLocation, (String)"cellLocation");
                    Rectangle favoriteIconBounds = item3.getFavoriteIconBounds(cellLocation);
                    Rectangle deleteIconBounds = item3.getDeleteIconBounds(cellLocation);
                    boolean consume2 = true;
                    if (favoriteIconBounds.contains(event2.getPoint())) {
                        HistoryList.this.toggleFavoriteItem(index2, favoriteIconBounds);
                    } else if (deleteIconBounds.contains(event2.getPoint())) {
                        HistoryList.this.deleteItem(index2);
                    } else {
                        consume2 = false;
                    }
                    if (consume2) {
                        event2.consume();
                    }
                }
            }

            @Override
            public void mouseMoved(@NotNull MouseEvent event2) {
                Integer hoveredIndex;
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                int index2 = HistoryList.this.getSelectedIndex();
                ListModel listModel = HistoryList.this.getModel();
                Intrinsics.checkNotNullExpressionValue((Object)listModel, (String)"model");
                FilterHistoryItem.Item item2 = this.getItemAt(listModel, index2);
                if (item2 == null) {
                    Integer n = this.hoveredFavoriteIndex;
                    if (n != null) {
                        this.setIsHoveredFavorite(n, false);
                    }
                    return;
                }
                Point cellLocation = HistoryList.this.getCellBounds(index2, index2).getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)cellLocation, (String)"cellLocation");
                Rectangle favoriteIconBounds = item2.getFavoriteIconBounds(cellLocation);
                Integer n = hoveredIndex = favoriteIconBounds.contains(event2.getPoint()) ? Integer.valueOf(index2) : null;
                if (!Intrinsics.areEqual((Object)hoveredIndex, (Object)this.hoveredFavoriteIndex)) {
                    Integer n2 = this.hoveredFavoriteIndex;
                    if (n2 != null) {
                        this.setIsHoveredFavorite(n2, false);
                    }
                    Integer n3 = hoveredIndex;
                    if (n3 != null) {
                        this.setIsHoveredFavorite(n3, true);
                    }
                    this.hoveredFavoriteIndex = hoveredIndex;
                    HistoryList.this.paintImmediately(favoriteIconBounds);
                }
            }

            private final void setIsHoveredFavorite(int $this$setIsHoveredFavorite, boolean value2) {
                Object e = HistoryList.this.getModel().getElementAt($this$setIsHoveredFavorite);
                FilterHistoryItem.Item item2 = e instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)e : null;
                if (item2 == null) {
                    return;
                }
                FilterHistoryItem.Item item3 = item2;
                item3.setFavoriteHovered(value2);
            }

            private final FilterHistoryItem.Item getItemAt(ListModel<FilterHistoryItem> $this$getItemAt, int index2) {
                Object object;
                Object object2 = $this$getItemAt;
                HistoryList historyList = HistoryList.this;
                try {
                    ListModel<FilterHistoryItem> $this$getItemAt_u24lambda_u240 = object2;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)((FilterHistoryItem)historyList.getModel().getElementAt(index2)));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                Object object3 = Result.isFailure-impl((Object)object2) ? null : object2;
                return object3 instanceof FilterHistoryItem.Item ? (FilterHistoryItem.Item)object3 : null;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$HistoryListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/android/tools/idea/logcat/filters/FilterTextField$FilterHistoryItem;", "()V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.android.logcat"})
    private static final class HistoryListCellRenderer
    implements ListCellRenderer<FilterHistoryItem> {
        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends FilterHistoryItem> list2, @NotNull FilterHistoryItem value2, int index2, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return value2.getComponent(isSelected, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$InlineButton;", "Ljavax/swing/JLabel;", "icon", "Ljavax/swing/Icon;", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;Ljavax/swing/Icon;)V", "updateUI", "", "intellij.android.logcat"})
    private final class InlineButton
    extends JLabel {
        public InlineButton(Icon icon2) {
            Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
            super(icon2);
            this.setOpaque(true);
        }

        @Override
        public void updateUI() {
            this.setBackground(FilterTextField.this.textField.getBackground());
            super.updateUI();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/logcat/filters/FilterTextField$InlinePanel;", "Ljavax/swing/JPanel;", "children", "", "Ljavax/swing/JComponent;", "(Lcom/android/tools/idea/logcat/filters/FilterTextField;[Ljavax/swing/JComponent;)V", "updateUI", "", "intellij.android.logcat"})
    @SourceDebugExtension(value={"SMAP\nFilterTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$InlinePanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,742:1\n13543#2,2:743\n*S KotlinDebug\n*F\n+ 1 FilterTextField.kt\ncom/android/tools/idea/logcat/filters/FilterTextField$InlinePanel\n*L\n381#1:743,2\n*E\n"})
    private final class InlinePanel
    extends JPanel {
        public InlinePanel(JComponent ... children2) {
            Intrinsics.checkNotNullParameter((Object)children2, (String)"children");
            super(null);
            this.setLayout(new BoxLayout(this, 2));
            this.setOpaque(true);
            this.setBorder(FilterTextFieldKt.access$getVerticalSeparatorBorder$p());
            JComponent[] $this$forEach$iv = children2;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                JComponent element$iv;
                JComponent it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                this.add(it);
            }
        }

        @Override
        public void updateUI() {
            this.setBackground(FilterTextField.this.textField.getBackground());
            super.updateUI();
        }
    }
}

