/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.filters.LogcatFilter;
import com.android.tools.idea.logcat.filters.LogcatFilterParseException;
import com.android.tools.idea.logcat.filters.LogcatFilterParserKt;
import com.android.tools.idea.logcat.filters.LogcatMessageWrapper;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.impl.source.tree.PsiErrorElementImpl;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/logcat/filters/AgeFilter;", "Lcom/android/tools/idea/logcat/filters/LogcatFilter;", "text", "", "clock", "Ljava/time/Clock;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "(Ljava/lang/String;Ljava/time/Clock;Lcom/intellij/openapi/util/TextRange;)V", "age", "Ljava/time/Duration;", "getAge", "()Ljava/time/Duration;", "displayText", "getDisplayText", "()Ljava/lang/String;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "matches", "message", "Lcom/android/tools/idea/logcat/filters/LogcatMessageWrapper;", "toString", "intellij.android.logcat"})
public final class AgeFilter
extends LogcatFilter {
    @NotNull
    private final String text;
    @NotNull
    private final Clock clock;
    @NotNull
    private final TextRange textRange;
    @VisibleForTesting
    @NotNull
    private final Duration age;
    @NotNull
    private final String displayText;

    public AgeFilter(@NotNull String text2, @NotNull Clock clock, @NotNull TextRange textRange) {
        Pair pair;
        long l;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        super(textRange);
        this.text = text2;
        this.clock = clock;
        this.textRange = textRange;
        if (!LogcatFilterParserKt.isValidLogAge(this.text)) {
            throw new IllegalArgumentException("Invalid age: " + this.text);
        }
        try {
            String string = this.text.substring(0, this.text.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            l = Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid duration: " + this.text));
        }
        long count2 = l;
        char c = StringsKt.last((CharSequence)this.text);
        if (c == 's') {
            pair = new Pair((Object)count2, (Object)AgeFilter._init_$pluralize(LogcatBundle.message("logcat.filter.completion.hint.age.second", new Object[0]), count2));
        } else if (c == 'm') {
            pair = new Pair((Object)TimeUnit.MINUTES.toSeconds(count2), (Object)AgeFilter._init_$pluralize(LogcatBundle.message("logcat.filter.completion.hint.age.minute", new Object[0]), count2));
        } else if (c == 'h') {
            pair = new Pair((Object)TimeUnit.HOURS.toSeconds(count2), (Object)AgeFilter._init_$pluralize(LogcatBundle.message("logcat.filter.completion.hint.age.hour", new Object[0]), count2));
        } else if (c == 'd') {
            pair = new Pair((Object)TimeUnit.DAYS.toSeconds(count2), (Object)AgeFilter._init_$pluralize(LogcatBundle.message("logcat.filter.completion.hint.age.day", new Object[0]), count2));
        } else {
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid duration: " + this.text));
        }
        Pair pair2 = pair;
        long seconds = ((Number)pair2.component1()).longValue();
        String display2 = (String)pair2.component2();
        Duration duration2 = Duration.ofSeconds(seconds);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(seconds)");
        this.age = duration2;
        Object[] objectArray = new Object[]{count2, display2};
        this.displayText = LogcatBundle.message("logcat.filter.completion.hint.age.value", objectArray);
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        return this.textRange;
    }

    @NotNull
    public final Duration getAge() {
        return this.age;
    }

    @Override
    @NotNull
    public String getDisplayText() {
        return this.displayText;
    }

    @Override
    public boolean matches(@NotNull LogcatMessageWrapper message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        return this.clock.millis() - message2.getLogcatMessage().getHeader().getTimestamp().toEpochMilli() <= this.age.toMillis();
    }

    private final String component1() {
        return this.text;
    }

    private final Clock component2() {
        return this.clock;
    }

    @NotNull
    public final TextRange component3() {
        return this.textRange;
    }

    @NotNull
    public final AgeFilter copy(@NotNull String text2, @NotNull Clock clock, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        return new AgeFilter(text2, clock, textRange);
    }

    public static /* synthetic */ AgeFilter copy$default(AgeFilter ageFilter, String string, Clock clock, TextRange textRange, int n, Object object) {
        if ((n & 1) != 0) {
            string = ageFilter.text;
        }
        if ((n & 2) != 0) {
            clock = ageFilter.clock;
        }
        if ((n & 4) != 0) {
            textRange = ageFilter.textRange;
        }
        return ageFilter.copy(string, clock, textRange);
    }

    @NotNull
    public String toString() {
        return "AgeFilter(text=" + this.text + ", clock=" + this.clock + ", textRange=" + this.textRange + ")";
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = result2 * 31 + this.clock.hashCode();
        result2 = result2 * 31 + this.textRange.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AgeFilter)) {
            return false;
        }
        AgeFilter ageFilter = (AgeFilter)other;
        if (!Intrinsics.areEqual((Object)this.text, (Object)ageFilter.text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clock, (Object)ageFilter.clock)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.textRange, (Object)ageFilter.textRange);
    }

    private static final String _init_$pluralize(String word, long count2) {
        String string;
        if (count2 == 1L) {
            string = word;
        } else {
            String string2 = Strings.pluralize((String)word);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pluralize(word)");
        }
        return string;
    }
}

