/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.devices;

import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.devices.Device;
import com.android.tools.idea.logcat.devices.DeviceComboBoxDeviceTrackerFactory;
import com.android.tools.idea.logcat.devices.DeviceEvent;
import com.android.tools.idea.logcat.devices.IDeviceComboBoxDeviceTracker;
import com.android.tools.idea.logcat.util.LogcatLoggerKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/logcat/devices/DeviceComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/android/tools/idea/logcat/devices/Device;", "project", "Lcom/intellij/openapi/project/Project;", "initialDevice", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/logcat/devices/Device;)V", "deviceModel", "Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceModel;", "getDeviceModel", "()Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceModel;", "deviceTracker", "Lcom/android/tools/idea/logcat/devices/IDeviceComboBoxDeviceTracker;", "selectedDevice", "getSelectedDevice", "()Lcom/android/tools/idea/logcat/devices/Device;", "deviceAdded", "", "device", "deviceStateChanged", "selectDevice", "trackSelectedDevice", "Lkotlinx/coroutines/flow/Flow;", "DeviceComboBoxRenderer", "DeviceModel", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nDeviceComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceComboBox.kt\ncom/android/tools/idea/logcat/devices/DeviceComboBox\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,165:1\n29#2,3:166\n*S KotlinDebug\n*F\n+ 1 DeviceComboBox.kt\ncom/android/tools/idea/logcat/devices/DeviceComboBox\n*L\n56#1:166,3\n*E\n"})
public final class DeviceComboBox
extends ComboBox<Device> {
    @Nullable
    private final Device initialDevice;
    @NotNull
    private final IDeviceComboBoxDeviceTracker deviceTracker;

    public DeviceComboBox(@NotNull Project project, @Nullable Device initialDevice) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.initialDevice = initialDevice;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<DeviceComboBoxDeviceTrackerFactory> serviceClass$iv = DeviceComboBoxDeviceTrackerFactory.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        this.deviceTracker = ((DeviceComboBoxDeviceTrackerFactory)object).createDeviceComboBoxDeviceTracker(this.initialDevice);
        AccessibleContextUtil.setName((Component)((Component)((Object)this)), (String)LogcatBundle.message("logcat.device.combo.accessible.name", new Object[0]));
        this.renderer = (ListCellRenderer)((Object)new DeviceComboBoxRenderer());
        this.setModel((ComboBoxModel)((Object)new DeviceModel()));
    }

    private final DeviceModel getDeviceModel() {
        ComboBoxModel comboBoxModel = this.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.android.tools.idea.logcat.devices.DeviceComboBox.DeviceModel");
        return (DeviceModel)((Object)comboBoxModel);
    }

    private final Device getSelectedDevice() {
        Object object = this.getSelectedItem();
        return object instanceof Device ? (Device)object : null;
    }

    @NotNull
    public final Flow<Device> trackSelectedDevice() {
        return FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super Device>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DeviceComboBox this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                        ActionListener listener2 = new ActionListener(this.this$0, (ProducerScope<? super Device>)$this$callbackFlow){
                            final /* synthetic */ DeviceComboBox this$0;
                            final /* synthetic */ ProducerScope<Device> $$this$callbackFlow;
                            {
                                this.this$0 = $receiver;
                                this.$$this$callbackFlow = $$this$callbackFlow;
                            }

                            public final void actionPerformed(ActionEvent it) {
                                block0: {
                                    Device device2 = DeviceComboBox.access$getSelectedDevice(this.this$0);
                                    if (device2 == null) break block0;
                                    Device device3 = device2;
                                    ProducerScope<Device> producerScope = this.$$this$callbackFlow;
                                    Device it2 = device3;
                                    boolean bl = false;
                                    ChannelsKt.trySendBlocking((SendChannel)((SendChannel)producerScope), (Object)it2);
                                }
                            }
                        };
                        this.this$0.addActionListener(listener2);
                        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)$this$callbackFlow), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (ProducerScope<? super Device>)$this$callbackFlow, null){
                            int label;
                            final /* synthetic */ DeviceComboBox this$0;
                            final /* synthetic */ ProducerScope<Device> $$this$callbackFlow;
                            {
                                this.this$0 = $receiver;
                                this.$$this$callbackFlow = $$this$callbackFlow;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.label = 1;
                                        v0 = DeviceComboBox.access$getDeviceTracker$p(this.this$0).trackDevices((Continuation<? super Flow<? extends DeviceEvent>>)((Continuation)this));
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        this.label = 2;
                                        v1 = ((Flow)v0).collect(new FlowCollector(this.this$0){
                                            final /* synthetic */ DeviceComboBox this$0;
                                            {
                                                this.this$0 = $receiver;
                                            }

                                            @Nullable
                                            public final Object emit(@NotNull DeviceEvent it, @NotNull Continuation<? super Unit> $completion) {
                                                LogcatLoggerKt.getLOGGER().debug("trackDevices: " + it);
                                                DeviceEvent deviceEvent = it;
                                                if (deviceEvent instanceof DeviceEvent.Added) {
                                                    DeviceComboBox.access$deviceAdded(this.this$0, ((DeviceEvent.Added)it).getDevice());
                                                } else if (deviceEvent instanceof DeviceEvent.StateChanged) {
                                                    DeviceComboBox.access$deviceStateChanged(this.this$0, ((DeviceEvent.StateChanged)it).getDevice());
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }, (Continuation)this);
                                        if (v1 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl21
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl21:
                                        // 2 sources

                                        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.$$this$callbackFlow), null, (int)1, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        this.label = 1;
                        Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(this.this$0, listener2){
                            final /* synthetic */ DeviceComboBox this$0;
                            final /* synthetic */ ActionListener $listener;
                            {
                                this.this$0 = $receiver;
                                this.$listener = $listener;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.removeActionListener(this.$listener);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super Device> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void deviceAdded(Device device2) {
        if (this.getDeviceModel().containsDevice(device2)) {
            this.deviceStateChanged(device2);
        } else {
            this.getDeviceModel().add(device2);
            if (this.getSelectedItem() != null) {
                return;
            }
            if (this.initialDevice == null) {
                this.selectDevice(device2);
            } else if (Intrinsics.areEqual((Object)device2.getDeviceId(), (Object)this.initialDevice.getDeviceId())) {
                this.selectDevice(device2);
            }
        }
    }

    private final void selectDevice(Device device2) {
        this.setSelectedItem(device2);
    }

    private final void deviceStateChanged(Device device2) {
        ComboBoxModel comboBoxModel = this.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.android.tools.idea.logcat.devices.DeviceComboBox.DeviceModel");
        Device device3 = this.getSelectedDevice();
        ((DeviceModel)((Object)comboBoxModel)).replaceItem(device2, Intrinsics.areEqual((Object)device2.getDeviceId(), (Object)(device3 != null ? device3.getDeviceId() : null)));
    }

    public static final /* synthetic */ Device access$getSelectedDevice(DeviceComboBox $this) {
        return $this.getSelectedDevice();
    }

    public static final /* synthetic */ IDeviceComboBoxDeviceTracker access$getDeviceTracker$p(DeviceComboBox $this) {
        return $this.deviceTracker;
    }

    public static final /* synthetic */ void access$deviceAdded(DeviceComboBox $this, Device device2) {
        $this.deviceAdded(device2);
    }

    public static final /* synthetic */ void access$deviceStateChanged(DeviceComboBox $this, Device device2) {
        $this.deviceStateChanged(device2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceComboBoxRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/android/tools/idea/logcat/devices/Device;", "()V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "device", "index", "", "selected", "", "hasFocus", "intellij.android.logcat"})
    private static final class DeviceComboBoxRenderer
    extends ColoredListCellRenderer<Device> {
        protected void customizeCellRenderer(@NotNull JList<? extends Device> list2, @Nullable Device device2, int index2, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            if (device2 == null) {
                this.append(LogcatBundle.message("logcat.device.combo.no.connected.devices", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            this.setIcon(device2.isEmulator() ? StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_PHONE : StudioIcons.DeviceExplorer.PHYSICAL_DEVICE_PHONE);
            this.append(device2.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (device2.isOnline()) {
                this.append(" (" + device2.getSerialNumber() + ")", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            Object[] objectArray = new Object[]{device2.getRelease(), String.valueOf(device2.getSdk())};
            this.append(LogcatBundle.message("logcat.device.combo.version", objectArray), SimpleTextAttributes.GRAY_ATTRIBUTES);
            if (!device2.isOnline()) {
                this.append(LogcatBundle.message("logcat.device.combo.offline", new Object[0]), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002J\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/logcat/devices/DeviceComboBox$DeviceModel;", "Lcom/intellij/ui/CollectionComboBoxModel;", "Lcom/android/tools/idea/logcat/devices/Device;", "()V", "idToIndexMap", "", "", "", "add", "", "device", "containsDevice", "", "replaceItem", "setSelected", "intellij.android.logcat"})
    private static final class DeviceModel
    extends CollectionComboBoxModel<Device> {
        @NotNull
        private final Map<String, Integer> idToIndexMap = new LinkedHashMap();

        public void add(@NotNull Device device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            super.add((Object)device2);
            this.idToIndexMap.put(device2.getDeviceId(), this.idToIndexMap.size());
        }

        public final void replaceItem(@NotNull Device device2, boolean setSelected2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            Integer index2 = this.idToIndexMap.get(device2.getDeviceId());
            if (index2 == null) {
                LogcatLoggerKt.getLOGGER().warn("Device " + device2.getDeviceId() + " expected to exist but was not found");
                return;
            }
            this.setElementAt(device2, index2);
            if (setSelected2) {
                this.setSelectedItem(device2);
            }
        }

        public final boolean containsDevice(@NotNull Device device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            return this.idToIndexMap.containsKey(device2.getDeviceId());
        }
    }
}

