/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.Processor;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0004*+,-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001eH\u0002J\u0006\u0010\"\u001a\u00020\u0017J\u001a\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u001eH\u0002J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/idea/logcat/UserInputHandlers;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "caretModel", "Lcom/intellij/openapi/editor/CaretModel;", "Lorg/jetbrains/annotations/NotNull;", "copyPasteManager", "Lcom/intellij/openapi/ide/CopyPasteManager;", "kotlin.jvm.PlatformType", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/Nullable;", "scrollingModel", "Lcom/intellij/openapi/editor/ex/ScrollingModelEx;", "selectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "append", "", "text", "", "deleteSelection", "findUserInputRange", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "start", "", "end", "insert", "offset", "install", "isInUserInputRange", "", "registerActionHandler", "actionId", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "type", "DeleteBackspaceHandler", "PasteHandler", "SpecialCharHandler", "UserInputKeyListener", "intellij.android.logcat"})
public final class UserInputHandlers {
    @NotNull
    private final EditorEx editor;
    @Nullable
    private final Project project;
    @NotNull
    private final DocumentEx document;
    @NotNull
    private final SelectionModel selectionModel;
    @NotNull
    private final CaretModel caretModel;
    @NotNull
    private final ScrollingModelEx scrollingModel;
    @NotNull
    private final MarkupModelEx markupModel;
    private final CopyPasteManager copyPasteManager;

    public UserInputHandlers(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.project = this.editor.getProject();
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        this.document = documentEx;
        SelectionModel selectionModel = this.editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
        this.selectionModel = selectionModel;
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        this.caretModel = caretModel;
        ScrollingModelEx scrollingModelEx = this.editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModelEx, (String)"editor.scrollingModel");
        this.scrollingModel = scrollingModelEx;
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)((Document)this.document), (Project)this.project, (boolean)true);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        this.markupModel = (MarkupModelEx)markupModel;
        this.copyPasteManager = CopyPasteManager.getInstance();
    }

    public final void install() {
        this.editor.getContentComponent().addKeyListener(new UserInputKeyListener());
        new SpecialCharHandler("\n").registerCustomShortcutSet(CommonShortcuts.ENTER, this.editor.getContentComponent());
        this.registerActionHandler("EditorTab", (AnAction)new SpecialCharHandler("\t"));
        this.registerActionHandler("EditorBackSpace", (AnAction)new DeleteBackspaceHandler(-1));
        this.registerActionHandler("EditorDelete", (AnAction)new DeleteBackspaceHandler(0));
        this.registerActionHandler("EditorPaste", (AnAction)new PasteHandler());
    }

    private final void registerActionHandler(String actionId, AnAction action2) {
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId);
        action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(Arrays.copyOf(shortcuts, shortcuts.length)), this.editor.getContentComponent());
    }

    private final boolean isInUserInputRange(int start2, int end) {
        return this.findUserInputRange(start2, end) != null;
    }

    static /* synthetic */ boolean isInUserInputRange$default(UserInputHandlers userInputHandlers, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        return userInputHandlers.isInUserInputRange(n, n2);
    }

    private final RangeHighlighterEx findUserInputRange(int start2, int end) {
        AtomicReference<Object> range = new AtomicReference<Object>(null);
        this.markupModel.processRangeHighlightersOverlappingWith(start2, end, new Processor(start2, end, range){
            final /* synthetic */ int $start;
            final /* synthetic */ int $end;
            final /* synthetic */ AtomicReference<RangeHighlighterEx> $range;
            {
                this.$start = $start;
                this.$end = $end;
                this.$range = $range;
            }

            public final boolean process(RangeHighlighterEx it) {
                boolean bl;
                if (Intrinsics.areEqual((Object)it.getTextAttributesKey(), (Object)ConsoleViewContentType.USER_INPUT.getAttributesKey()) && it.getStartOffset() <= this.$start && it.getEndOffset() >= this.$end) {
                    this.$range.set(it);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        });
        return range.get();
    }

    private final void type(String text2) {
        int lastOffset;
        int n = lastOffset = this.selectionModel.hasSelection() ? this.selectionModel.getSelectionStart() : this.caretModel.getOffset() + 1;
        if (!UserInputHandlers.isInUserInputRange$default(this, lastOffset, 0, 2, null)) {
            this.append(text2);
        } else {
            int n2;
            if (this.selectionModel.hasSelection()) {
                int start2 = this.selectionModel.getSelectionStart();
                this.deleteSelection();
                n2 = start2;
            } else {
                n2 = this.editor.getCaretModel().getOffset();
            }
            int typeOffset = n2;
            this.insert(text2, typeOffset);
        }
    }

    private final void deleteSelection() {
        this.document.deleteString(this.selectionModel.getSelectionStart(), this.selectionModel.getSelectionEnd());
        this.selectionModel.removeSelection();
    }

    private final void append(String text2) {
        RangeHighlighterEx prevMarker;
        int start2 = this.document.getTextLength();
        int end = start2 + text2.length();
        this.document.insertString(start2, (CharSequence)text2);
        this.selectionModel.removeSelection();
        this.caretModel.moveToOffset(this.document.getTextLength());
        this.scrollingModel.scrollToCaret(ScrollType.RELATIVE);
        if (start2 > 0 && (prevMarker = this.findUserInputRange(start2 - 1, start2)) != null) {
            start2 = prevMarker.getStartOffset();
            prevMarker.dispose();
        }
        this.markupModel.addRangeHighlighter(ConsoleViewContentType.USER_INPUT.getAttributesKey(), start2, end, 1000, HighlighterTargetArea.EXACT_RANGE);
    }

    private final void insert(String text2, int offset) {
        this.document.insertString(offset, (CharSequence)text2);
        this.caretModel.moveToOffset(offset + text2.length());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/logcat/UserInputHandlers$DeleteBackspaceHandler;", "Lcom/intellij/openapi/project/DumbAwareAction;", "relativeOffset", "", "(Lcom/android/tools/idea/logcat/UserInputHandlers;I)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.android.logcat"})
    private final class DeleteBackspaceHandler
    extends DumbAwareAction {
        private final int relativeOffset;

        public DeleteBackspaceHandler(int relativeOffset) {
            this.relativeOffset = relativeOffset;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (UserInputHandlers.this.document.getTextLength() == 0) {
                return;
            }
            if (UserInputHandlers.this.selectionModel.hasSelection()) {
                if (UserInputHandlers.this.isInUserInputRange(UserInputHandlers.this.selectionModel.getSelectionStart(), UserInputHandlers.this.selectionModel.getSelectionEnd())) {
                    UserInputHandlers.this.deleteSelection();
                    UserInputHandlers.this.insert("", UserInputHandlers.this.selectionModel.getSelectionStart());
                }
            } else {
                int offset = UserInputHandlers.this.caretModel.getOffset() + this.relativeOffset;
                if (offset >= 0 && offset < UserInputHandlers.this.document.getTextLength() && UserInputHandlers.isInUserInputRange$default(UserInputHandlers.this, offset, 0, 2, null)) {
                    UserInputHandlers.this.document.deleteString(offset, offset + 1);
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/logcat/UserInputHandlers$PasteHandler;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/android/tools/idea/logcat/UserInputHandlers;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.android.logcat"})
    private final class PasteHandler
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String text2 = (String)UserInputHandlers.this.copyPasteManager.getContents(DataFlavor.stringFlavor);
            if (text2 != null) {
                UserInputHandlers.this.type(text2);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/logcat/UserInputHandlers$SpecialCharHandler;", "Lcom/intellij/openapi/project/DumbAwareAction;", "text", "", "(Lcom/android/tools/idea/logcat/UserInputHandlers;Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.android.logcat"})
    private final class SpecialCharHandler
    extends DumbAwareAction {
        @NotNull
        private final String text;

        public SpecialCharHandler(String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            UserInputHandlers.this.type(this.text);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/logcat/UserInputHandlers$UserInputKeyListener;", "Ljava/awt/event/KeyAdapter;", "(Lcom/android/tools/idea/logcat/UserInputHandlers;)V", "keyTyped", "", "e", "Ljava/awt/event/KeyEvent;", "intellij.android.logcat"})
    private final class UserInputKeyListener
    extends KeyAdapter {
        @Override
        public void keyTyped(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            UserInputHandlers.this.type(String.valueOf(e.getKeyChar()));
        }
    }
}

