/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.tools.idea.logcat.ProjectApplicationIdsProvider;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.AndroidPluginDisposable;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/logcat/ProjectApplicationIdsProviderImpl;", "Lcom/android/tools/idea/logcat/ProjectApplicationIdsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "applicationIds", "", "", "getPackageNames", "loadApplicationIds", "RefreshApplicationIds", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nProjectApplicationIdsProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectApplicationIdsProviderImpl.kt\ncom/android/tools/idea/logcat/ProjectApplicationIdsProviderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1446#2,5:53\n*S KotlinDebug\n*F\n+ 1 ProjectApplicationIdsProviderImpl.kt\ncom/android/tools/idea/logcat/ProjectApplicationIdsProviderImpl\n*L\n41#1:53,5\n*E\n"})
public final class ProjectApplicationIdsProviderImpl
implements ProjectApplicationIdsProvider {
    @NotNull
    private final Project project;
    @NotNull
    private Set<String> applicationIds;

    public ProjectApplicationIdsProviderImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.applicationIds = this.loadApplicationIds();
        this.project.getMessageBus().connect((Disposable)AndroidPluginDisposable.Companion.getProjectInstance(this.project)).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, (Object)new RefreshApplicationIds());
    }

    @Override
    @NotNull
    public Set<String> getPackageNames() {
        return this.applicationIds;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> loadApplicationIds() {
        void var2_2;
        void $this$flatMapTo$iv;
        Iterable iterable = ProjectSystemUtil.getAndroidFacets(this.project);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Collection collection2;
            Set<String> set;
            AndroidFacet it = (AndroidFacet)element$iv;
            boolean bl = false;
            AndroidModel androidModel = AndroidModel.get(it);
            Set<String> set2 = set = androidModel != null ? androidModel.getAllApplicationIds() : null;
            if (set2 == null) {
                collection2 = CollectionsKt.emptyList();
            } else {
                Intrinsics.checkNotNullExpressionValue(set2, (String)"AndroidModel.get(it)?.al\u2026icationIds ?: emptyList()");
                collection2 = set;
            }
            Iterable list$iv = collection2;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var2_2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/logcat/ProjectApplicationIdsProviderImpl$RefreshApplicationIds;", "Lcom/android/tools/idea/projectsystem/ProjectSystemSyncManager$SyncResultListener;", "(Lcom/android/tools/idea/logcat/ProjectApplicationIdsProviderImpl;)V", "syncEnded", "", "result", "Lcom/android/tools/idea/projectsystem/ProjectSystemSyncManager$SyncResult;", "intellij.android.logcat"})
    private final class RefreshApplicationIds
    implements ProjectSystemSyncManager.SyncResultListener {
        @Override
        public void syncEnded(@NotNull ProjectSystemSyncManager.SyncResult result2) {
            Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
            Set newIds = ProjectApplicationIdsProviderImpl.this.loadApplicationIds();
            if (!Intrinsics.areEqual((Object)newIds, (Object)ProjectApplicationIdsProviderImpl.this.applicationIds)) {
                ProjectApplicationIdsProviderImpl.this.applicationIds = newIds;
                ((ProjectApplicationIdsProvider.ProjectApplicationIdsListener)ProjectApplicationIdsProviderImpl.this.project.getMessageBus().syncPublisher(ProjectApplicationIdsProvider.Companion.getPROJECT_APPLICATION_IDS_CHANGED_TOPIC())).applicationIdsChanged(newIds);
            }
        }
    }
}

