/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.log;

import com.android.tools.idea.rendering.RenderModelModule;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogAnonymizerUtil {
    private static final String SALT = Integer.toString(new SecureRandom().nextInt());

    public static boolean isPublicClass(@Nullable String className) {
        if (className == null) {
            return false;
        }
        return (className = className.replace("/", ".")).startsWith("java.") || className.startsWith("javax.") || className.startsWith("com.android.") || className.startsWith("android.") || className.startsWith("com.google.");
    }

    @NotNull
    public static String anonymizeClassName(@Nullable String className) {
        if (className == null) {
            return "null";
        }
        return LogAnonymizerUtil.isPublicClass(className = className.replace("/", ".")) ? className : "class:" + Hashing.sha256().hashString((CharSequence)(SALT + className), StandardCharsets.UTF_8).toString();
    }

    @NotNull
    public static String anonymize(@Nullable RenderModelModule module2) {
        if (module2 == null) {
            return "null";
        }
        if (module2.isDisposed()) {
            return "<disposed>";
        }
        return "module:" + Hashing.sha256().hashString((CharSequence)(SALT + module2.getName()), StandardCharsets.UTF_8).toString();
    }
}

