/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.refactoring.UnusedResourcesHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedResourcesQuickFix
extends DefaultLintQuickFix {
    private final String myResource;

    public UnusedResourcesQuickFix(@Nullable String resource) {
        super((String)(resource != null ? "Remove Declarations for " + resource : "Remove All Unused Resources"));
        this.myResource = resource;
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
        Project project = startElement.getProject();
        UnusedResourcesHandler.invoke(project, null, this.myResource, true, true);
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

