/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class SetScrollViewSizeQuickFix
extends DefaultLintQuickFix {
    public SetScrollViewSizeQuickFix() {
        super(AndroidLintBundle.message("android.lint.fix.set.to.wrap.content", new Object[0]));
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        if (tag == null) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        if (parentTag == null) {
            return;
        }
        boolean isHorizontal = "HorizontalScrollView".equals(parentTag.getName());
        String attributeName = isHorizontal ? "layout_width" : "layout_height";
        tag.setAttribute(attributeName, "http://schemas.android.com/apk/res/android", "wrap_content");
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        if (tag == null) {
            return false;
        }
        return tag.getParentTag() != null;
    }
}

