/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002J \u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/lint/quickFixes/RemoveSdkCheckFix;", "Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;", "removeThen", "", "(Z)V", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "applyToIfExpression", "ifExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "findSdkConditional", "Lorg/jetbrains/kotlin/psi/KtExpression;", "start", "isApplicable", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "isVersionCheckConditional", "element", "intellij.android.lint"})
public final class RemoveSdkCheckFix
extends DefaultLintQuickFix {
    private boolean removeThen;

    public RemoveSdkCheckFix(boolean removeThen) {
        super("Remove obsolete SDK version check", "Remove obsolete SDK version checks");
        this.removeThen = removeThen;
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtExpression ktExpression = this.findSdkConditional(startElement);
        if (ktExpression == null) {
            return;
        }
        KtExpression condition = ktExpression;
        if (!IntentionPreviewUtils.prepareElementForWrite((PsiElement)startElement)) {
            return;
        }
        KtIfExpression ifExpression = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)condition), KtIfExpression.class, (boolean)true);
        if (ifExpression != null && Intrinsics.areEqual((Object)ifExpression.getCondition(), (Object)condition) && this.applyToIfExpression(ifExpression)) {
            return;
        }
        if (this.removeThen) {
            condition.replace((PsiElement)new KtPsiFactory((KtElement)condition, false, 2, null).createExpression("true"));
        } else {
            condition.replace((PsiElement)new KtPsiFactory((KtElement)condition, false, 2, null).createExpression("false"));
        }
    }

    private final boolean applyToIfExpression(KtIfExpression ifExpression) {
        KtExpression keep;
        KtExpression ktExpression = keep = this.removeThen ? ifExpression.getThen() : ifExpression.getElse();
        if (keep != null) {
            PsiElement psiElement = ifExpression.getParent();
            if (psiElement == null) {
                return false;
            }
            PsiElement parent2 = psiElement;
            if (keep instanceof KtBlockExpression) {
                for (PsiElement child = ((KtBlockExpression)keep).getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child instanceof TreeElement && (Intrinsics.areEqual((Object)((TreeElement)child).getElementType(), (Object)KtTokens.RBRACE) || Intrinsics.areEqual((Object)((TreeElement)child).getElementType(), (Object)KtTokens.LBRACE))) continue;
                    parent2.addBefore(child, (PsiElement)ifExpression);
                }
            } else {
                parent2.addBefore((PsiElement)keep, (PsiElement)ifExpression);
            }
        }
        ifExpression.delete();
        return true;
    }

    private final KtExpression findSdkConditional(PsiElement start2) {
        PsiElement current = start2;
        while (current != null && (KtBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)current, KtBinaryExpression.class, (boolean)false) != null) {
            KtBinaryExpression next;
            if (this.isVersionCheckConditional((PsiElement)next)) {
                return (KtExpression)next;
            }
            current = next.getParent();
        }
        return null;
    }

    private final boolean isVersionCheckConditional(PsiElement element2) {
        String string = element2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"SDK_INT", (boolean)false, (int)2, null);
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
        return true;
    }
}

