/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.gradle.model.IdeBuildType;
import com.android.tools.idea.gradle.model.IdeBuildTypeContainer;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.utils.Pair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.EditorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveToDebugManifestQuickFix
extends DefaultLintQuickFix {
    public MoveToDebugManifestQuickFix() {
        super("Move to debug-specific manifest");
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
        XmlTag parent2;
        XmlAttribute attribute2 = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class);
        if (attribute2 != null && (parent2 = attribute2.getParent()) != null && parent2.getName().equals("uses-permission")) {
            AndroidFacet facet2;
            Module module2 = MoveToDebugManifestQuickFix.getModule((PsiElement)parent2);
            assert ("android.permission.ACCESS_MOCK_LOCATION".equals(parent2.getAttributeValue("name", "http://schemas.android.com/apk/res/android")));
            parent2.delete();
            if (module2 != null && (facet2 = AndroidFacet.getInstance((Module)module2)) != null) {
                VirtualFile mainManifest = SourceProviderManager.getInstance(facet2).getMainManifestFile();
                GradleAndroidModel androidModel = GradleAndroidModel.get(facet2);
                if (androidModel != null && mainManifest != null && mainManifest.getParent() != null && mainManifest.getParent().getParent() != null && androidModel.getAndroidProject().getMultiVariantData() != null) {
                    VirtualFile src = mainManifest.getParent().getParent();
                    for (IdeBuildTypeContainer container : androidModel.getAndroidProject().getMultiVariantData().getBuildTypes()) {
                        IdeBuildType buildType = container.getBuildType();
                        if (!buildType.isDebuggable()) continue;
                        this.addManifest(module2, src, buildType.getName());
                        return;
                    }
                    Messages.showErrorDialog((Project)module2.getProject(), (String)"Did not find a debug build type", (String)"Move Permission");
                }
            }
        }
    }

    private void addManifest(@NotNull Module module2, final @NotNull VirtualFile src, final @NotNull String buildTypeName) {
        Project project = module2.getProject();
        final VirtualFile manifest = src.findFileByRelativePath(buildTypeName + "/AndroidManifest.xml");
        Pair result2 = (Pair)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Pair<String, VirtualFile>>(){

            public Pair<String, VirtualFile> compute() {
                String text2;
                int index2;
                if (manifest == null) {
                    try {
                        VirtualFile newParentFolder = src.findChild(buildTypeName);
                        if (newParentFolder == null && (newParentFolder = src.createChildDirectory((Object)this, buildTypeName)) == null) {
                            String message2 = String.format("Could not create folder %1$s in %2$s", buildTypeName, src.getPath());
                            return Pair.of((Object)message2, null);
                        }
                        VirtualFile newFile2 = newParentFolder.createChildData((Object)this, "AndroidManifest.xml");
                        String text3 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\">\n    <uses-permission android:name=\"android.permission.ACCESS_MOCK_LOCATION\" />\n</manifest>\n";
                        VfsUtil.saveText((VirtualFile)newFile2, (String)text3);
                        return Pair.of(null, (Object)newFile2);
                    }
                    catch (IOException e) {
                        String message3 = String.format("Failed to create file: %1$s", e.getMessage());
                        return Pair.of((Object)message3, null);
                    }
                }
                Document document2 = FileDocumentManager.getInstance().getDocument(manifest);
                if (document2 != null && (index2 = (text2 = document2.getText()).lastIndexOf("</manifest>")) != -1) {
                    document2.insertString(index2, (CharSequence)"    <uses-permission android:name=\"android.permission.ACCESS_MOCK_LOCATION\" />\n");
                    return Pair.of(null, (Object)manifest);
                }
                return Pair.of((Object)("Could not add to " + VfsUtilCore.virtualToIoFile((VirtualFile)manifest)), null);
            }
        });
        String error = (String)result2.getFirst();
        VirtualFile newFile2 = (VirtualFile)result2.getSecond();
        if (error != null) {
            Messages.showErrorDialog((Project)project, (String)error, (String)"Move Permission");
        } else {
            EditorUtil.openEditor(project, newFile2);
            EditorUtil.selectEditor(project, newFile2);
        }
    }

    @Nullable
    private static Module getModule(PsiElement element2) {
        ProjectFileIndex index2 = ProjectRootManager.getInstance((Project)element2.getProject()).getFileIndex();
        return index2.getModuleForFile(element2.getContainingFile().getVirtualFile());
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class) != null;
    }
}

