/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.util.ReformatUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.uipreview.EditorUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0003J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/lint/quickFixes/GenerateMotionSceneFix;", "Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;", "url", "Lcom/android/resources/ResourceUrl;", "(Lcom/android/resources/ResourceUrl;)V", "getUrl", "()Lcom/android/resources/ResourceUrl;", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "findFirstWidgetId", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "generateMotionSceneContent", "widgetId", "isApplicable", "", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "intellij.android.lint"})
@SourceDebugExtension(value={"SMAP\nGenerateMotionSceneFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateMotionSceneFix.kt\ncom/android/tools/idea/lint/quickFixes/GenerateMotionSceneFix\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n11335#2:129\n11670#2,3:130\n1#3:133\n*S KotlinDebug\n*F\n+ 1 GenerateMotionSceneFix.kt\ncom/android/tools/idea/lint/quickFixes/GenerateMotionSceneFix\n*L\n102#1:129\n102#1:130,3\n*E\n"})
public final class GenerateMotionSceneFix
extends DefaultLintQuickFix {
    @NotNull
    private final ResourceUrl url;

    public GenerateMotionSceneFix(@NotNull ResourceUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        super("Generate MotionScene file");
        this.url = url;
    }

    @NotNull
    public final ResourceUrl getUrl() {
        return this.url;
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)startElement);
        if (androidFacet == null) {
            return false;
        }
        AndroidFacet facet2 = androidFacet;
        LocalResourceRepository localResourceRepository = StudioResourceRepositoryManager.getAppResources(facet2);
        Intrinsics.checkNotNullExpressionValue((Object)localResourceRepository, (String)"getAppResources(facet)");
        LocalResourceRepository appResources = localResourceRepository;
        return !appResources.getResources(ResourceNamespace.TODO(), ResourceType.XML).keySet().contains(this.url.name);
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Project project = startElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"startElement.project");
        Project project2 = project;
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)startElement);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet facet2 = androidFacet;
        WriteCommandAction.runWriteCommandAction((Project)project2, (String)"Create MotionScene file", null, (Runnable)new Runnable(startElement, this, facet2, project2){
            final /* synthetic */ PsiElement $startElement;
            final /* synthetic */ GenerateMotionSceneFix this$0;
            final /* synthetic */ AndroidFacet $facet;
            final /* synthetic */ Project $project;
            {
                this.$startElement = $startElement;
                this.this$0 = $receiver;
                this.$facet = $facet;
                this.$project = $project;
            }

            public final void run() {
                try {
                    Class[] classArray = new Class[]{XmlTag.class};
                    XmlTag motionTag = (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.$startElement, (Class[])classArray);
                    String string = GenerateMotionSceneFix.access$findFirstWidgetId(this.this$0, motionTag);
                    if (string == null) {
                        string = "widget";
                    }
                    String widgetId = string;
                    VirtualFile virtualFile = ResourceFolderManager.Companion.getInstance(this.$facet).getPrimaryFolder();
                    if (virtualFile == null) {
                        return;
                    }
                    VirtualFile primaryResourceDir = virtualFile;
                    VirtualFile xmlDir = AndroidUtils.createChildDirectoryIfNotExist(this.$project, primaryResourceDir, "xml");
                    VirtualFile virtualFile2 = xmlDir.createChildData((Object)this.$project, this.this$0.getUrl().name + ".xml");
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"xmlDir.createChildData(p\u2026t, \"${url.name}$DOT_XML\")");
                    VirtualFile resFile = virtualFile2;
                    VfsUtil.saveText((VirtualFile)resFile, (String)GenerateMotionSceneFix.access$generateMotionSceneContent(this.this$0, widgetId));
                    ReformatUtil.reformatAndRearrange$default(this.$project, resFile, null, false, 12, null);
                    EditorUtil.openEditor(this.$project, resFile);
                    EditorUtil.selectEditor(this.$project, resFile);
                    XmlTag xmlTag = motionTag;
                    if (xmlTag != null) {
                        xmlTag.setAttribute("layoutDescription", "http://schemas.android.com/apk/res-auto", this.this$0.getUrl().toString());
                    }
                }
                catch (IOException ex) {
                    String string = "Failed to create file: %1$s";
                    Object[] objectArray = new Object[]{ex.getMessage()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                    String error = string2;
                    Messages.showErrorDialog((Project)this.$project, (String)error, (String)"Create MotionScene");
                }
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final String findFirstWidgetId(XmlTag tag) {
        Object object;
        block7: {
            block6: {
                Object v2;
                block5: {
                    void $this$mapTo$iv$iv;
                    object = tag;
                    if (tag == null || (object = object.getSubTags()) == null) break block6;
                    XmlTag[] $this$map$iv = object;
                    boolean $i$f$map = false;
                    Object object2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        collection2.add(it.getAttributeValue("id", "http://schemas.android.com/apk/res/android"));
                    }
                    object2 = (List)destination$iv$iv;
                    Iterator iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        String it = (String)t;
                        boolean bl = false;
                        CharSequence charSequence = it;
                        boolean bl2 = !(charSequence == null || charSequence.length() == 0);
                        if (!bl2) continue;
                        v2 = t;
                        break block5;
                    }
                    v2 = null;
                }
                if ((object = (String)v2) != null) break block7;
            }
            return null;
        }
        Object reference = object;
        ResourceUrl resourceUrl = ResourceUrl.parse((String)reference);
        return resourceUrl != null ? resourceUrl.name : null;
    }

    @Language(value="XML")
    private final String generateMotionSceneContent(String widgetId) {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<MotionScene\n        xmlns:android=\"http://schemas.android.com/apk/res/android\"\n        xmlns:app=\"http://schemas.android.com/apk/res-auto\">\n\n  <ConstraintSet android:id=\"@+id/start\">\n      <Constraint android:id=\"@+id/" + widgetId + "\"/>\n  </ConstraintSet>\n\n  <ConstraintSet android:id=\"@+id/end\">\n      <Constraint android:id=\"@id/" + widgetId + "\"/>\n  </ConstraintSet>\n\n  <Transition\n      app:constraintSetStart=\"@+id/start\"\n      app:constraintSetEnd=\"@id/end\" />\n</MotionScene>\n";
    }

    public static final /* synthetic */ String access$findFirstWidgetId(GenerateMotionSceneFix $this, XmlTag tag) {
        return $this.findFirstWidgetId(tag);
    }

    public static final /* synthetic */ String access$generateMotionSceneContent(GenerateMotionSceneFix $this, String widgetId) {
        return $this.generateMotionSceneContent(widgetId);
    }
}

