/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddUsesFeatureQuickFix
extends DefaultLintQuickFix {
    private final String myFeatureName;

    public AddUsesFeatureQuickFix(@NotNull String featureName) {
        super("Add uses-feature tag");
        this.myFeatureName = featureName;
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
        XmlTag parent2 = (XmlTag)PsiTreeUtil.getTopmostParentOfType((PsiElement)startElement, XmlTag.class);
        if (parent2 == null || !"manifest".equals(parent2.getName())) {
            return;
        }
        XmlTag usesFeatureTag = parent2.createChildTag("uses-feature", null, null, false);
        XmlTag ancestor = AddUsesFeatureQuickFix.findLocationForUsesFeature(parent2);
        usesFeatureTag = ancestor != null ? (XmlTag)parent2.addAfter((PsiElement)usesFeatureTag, (PsiElement)ancestor) : parent2.addSubTag(usesFeatureTag, true);
        if (usesFeatureTag != null) {
            usesFeatureTag.setAttribute("name", "http://schemas.android.com/apk/res/android", this.myFeatureName);
            usesFeatureTag.setAttribute("required", "http://schemas.android.com/apk/res/android", "false");
        }
    }

    @Nullable
    private static XmlTag findLocationForUsesFeature(XmlTag parent2) {
        String[] reverseOrderManifestElements;
        for (String elementName : reverseOrderManifestElements = new String[]{"uses-feature", "uses-configuration", "uses-sdk", "permission"}) {
            XmlTag[] existingTags = parent2.findSubTags(elementName);
            int len = existingTags.length;
            if (len <= 0) continue;
            return existingTags[len - 1];
        }
        return null;
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getTopmostParentOfType((PsiElement)startElement, XmlTag.class);
        return xmlTag != null && "manifest".equals(xmlTag.getName());
    }
}

