/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.sdklib.SdkVersionInfo;
import com.android.support.AndroidxName;
import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.AnnotateQuickFixKt;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeUtilsKt;
import com.android.tools.idea.lint.quickFixes.AddTargetVersionCheckQuickFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.ExtensionSdk;
import com.android.tools.lint.detector.api.VersionChecks;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J(\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J8\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J0\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J \u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\u0018\u0010%\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0006H\u0002J\u0018\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010*\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u0010\u0010+\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u0010\u0010,\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\bH\u0002J \u0010-\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010.\u001a\u00020/H\u0016J\f\u00100\u001a\u00020\u0006*\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/idea/lint/quickFixes/AddTargetApiQuickFix;", "Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;", "requirements", "", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "requiresApi", "", "element", "Lcom/intellij/psi/PsiElement;", "requireClass", "(Ljava/util/List;ZLcom/intellij/psi/PsiElement;Z)V", "addAnnotationJava", "", "elementFactory", "Lcom/intellij/psi/PsiElementFactory;", "container", "Lcom/intellij/psi/PsiModifierListOwner;", "fqcn", "", "annotationText", "replace", "addAnnotationKotlin", "annotationContainer", "fqn", "inner", "addAnnotationsJava", "sdkId", "", "api", "addAnnotationsKotlin", "apply", "startElement", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "getAnnotationContainer", "getName", "getSdkApiString", "fullyQualified", "getSdkId", "project", "Lcom/intellij/openapi/project/Project;", "handleJava", "handleKotlin", "handleXml", "isApplicable", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "isTargetApiAnnotationValidTarget", "intellij.android.lint"})
@SourceDebugExtension(value={"SMAP\nAddTargetApiQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddTargetApiQuickFix.kt\ncom/android/tools/idea/lint/quickFixes/AddTargetApiQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,327:1\n1743#2,3:328\n*S KotlinDebug\n*F\n+ 1 AddTargetApiQuickFix.kt\ncom/android/tools/idea/lint/quickFixes/AddTargetApiQuickFix\n*L\n91#1:328,3\n*E\n"})
public final class AddTargetApiQuickFix
extends DefaultLintQuickFix {
    @NotNull
    private final List<ApiConstraint.SdkApiConstraint> requirements;
    private final boolean requiresApi;
    @NotNull
    private final PsiElement element;
    private final boolean requireClass;

    public AddTargetApiQuickFix(@NotNull List<ApiConstraint.SdkApiConstraint> requirements, boolean requiresApi, @NotNull PsiElement element2, boolean requireClass) {
        Intrinsics.checkNotNullParameter(requirements, (String)"requirements");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        super("");
        this.requirements = requirements;
        this.requiresApi = requiresApi;
        this.element = element2;
        this.requireClass = requireClass;
    }

    public /* synthetic */ AddTargetApiQuickFix(List list2, boolean bl, PsiElement psiElement, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(list2, bl, psiElement, bl2);
    }

    private final String getSdkApiString(int api, boolean fullyQualified) {
        return AddTargetVersionCheckQuickFix.Companion.getVersionField(api, fullyQualified);
    }

    @NotNull
    public String getName() {
        String string;
        ApiConstraint.SdkApiConstraint first = (ApiConstraint.SdkApiConstraint)CollectionsKt.first(this.requirements);
        if (Intrinsics.areEqual((Object)this.element.getLanguage(), (Object)XMLLanguage.INSTANCE)) {
            string = "Suppress with tools:targetApi attribute";
        } else if (!this.requiresApi) {
            Object[] objectArray = new Object[]{this.getSdkApiString(first.min(), false)};
            string = AndroidLintBundle.Companion.message("android.lint.fix.add.target.api", objectArray);
        } else if (this.requirements.size() > 1) {
            boolean bl;
            block11: {
                Iterable $this$any$iv = this.requirements;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ApiConstraint.SdkApiConstraint it = (ApiConstraint.SdkApiConstraint)element$iv;
                        boolean bl2 = false;
                        if (!(it.getSdkId() == 0)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            string = bl ? AndroidLintBundle.Companion.message("android.lint.fix.add.both.annotations", new Object[0]) : AndroidLintBundle.Companion.message("android.lint.fix.add.sdk.annotation", new Object[0]);
        } else if (this.requiresApi && first.getSdkId() != 0) {
            Object[] objectArray = new Object[]{ExtensionSdk.Companion.getSdkExtensionField(first.getSdkId(), false), first.minString()};
            string = AndroidLintBundle.Companion.message("android.lint.fix.add.requires.sdk.extension", objectArray);
        } else {
            Object[] objectArray = new Object[]{this.getSdkApiString(first.min(), false)};
            string = AndroidLintBundle.Companion.message("android.lint.fix.add.requires.api", objectArray);
        }
        return string;
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
        return this.getAnnotationContainer(startElement) != null;
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Language language = startElement.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            this.handleJava(startElement);
        } else if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
            this.handleKotlin(startElement);
        } else if (Intrinsics.areEqual((Object)language, (Object)XMLLanguage.INSTANCE)) {
            this.handleXml(startElement);
        }
    }

    private final void handleXml(PsiElement startElement) {
        block4: {
            String string;
            XmlTag element2;
            block6: {
                int api;
                block5: {
                    PsiElement psiElement = this.getAnnotationContainer(startElement);
                    XmlTag xmlTag = psiElement instanceof XmlTag ? (XmlTag)psiElement : null;
                    if (xmlTag == null) {
                        return;
                    }
                    element2 = xmlTag;
                    XmlFile file2 = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element2), XmlFile.class, (boolean)false);
                    if (file2 == null) break block4;
                    IdeResourcesUtil.ensureNamespaceImported$default(file2, "http://schemas.android.com/tools", null, 4, null);
                    api = ((ApiConstraint.SdkApiConstraint)CollectionsKt.first(this.requirements)).min();
                    string = SdkVersionInfo.getBuildCode((int)api);
                    if (string == null) break block5;
                    String string2 = string;
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    String string3 = string2.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                    string = string3;
                    if (string3 != null) break block6;
                }
                string = String.valueOf(api);
            }
            String codeName = string;
            element2.setAttribute("targetApi", "http://schemas.android.com/tools", codeName);
        }
    }

    private final void handleJava(PsiElement startElement) {
        PsiElement psiElement = this.getAnnotationContainer(startElement);
        PsiModifierListOwner psiModifierListOwner = psiElement instanceof PsiModifierListOwner ? (PsiModifierListOwner)psiElement : null;
        if (psiModifierListOwner == null) {
            return;
        }
        PsiModifierListOwner container = psiModifierListOwner;
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList != null) {
            Project project = startElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"startElement.project");
            Project project2 = project;
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getInstance(project).elementFactory");
            PsiElementFactory factory2 = psiElementFactory;
            for (ApiConstraint.SdkApiConstraint requirement : CollectionsKt.reversed((Iterable)this.requirements)) {
                this.addAnnotationsJava(factory2, container, this.requiresApi, requirement.getSdkId(), requirement.min(), requirement.getSdkId() == 0);
            }
        }
    }

    private final void addAnnotationsJava(PsiElementFactory elementFactory, PsiModifierListOwner container, boolean requiresApi, int sdkId, int api, boolean replace2) {
        String fqcn = null;
        String annotationText = null;
        if (requiresApi && sdkId == 0) {
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)container));
            AndroidxName androidxName = VersionChecks.REQUIRES_API_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)androidxName, (String)"REQUIRES_API_ANNOTATION");
            fqcn = DependencyManagementUtil.mapAndroidxName(module2, androidxName);
            annotationText = "@" + fqcn + "(api=" + this.getSdkApiString(api, true) + ")";
        } else if (requiresApi) {
            fqcn = "androidx.annotation.RequiresExtension";
            Project project = container.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"container.project");
            annotationText = "@" + fqcn + "(extension=" + this.getSdkId(project, sdkId) + ", version=" + api + ")";
        } else {
            fqcn = "android.annotation.TargetApi";
            annotationText = "@" + fqcn + "(" + this.getSdkApiString(api, true) + ")";
        }
        this.addAnnotationJava(elementFactory, container, fqcn, annotationText, replace2);
    }

    private final void addAnnotationJava(PsiElementFactory elementFactory, PsiModifierListOwner container, String fqcn, String annotationText, boolean replace2) {
        PsiAnnotation annotation;
        String[] stringArray;
        PsiAnnotation psiAnnotation = elementFactory.createAnnotationFromText(annotationText, (PsiElement)container);
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"elementFactory.createAnn\u2026nnotationText, container)");
        PsiAnnotation newAnnotation = psiAnnotation;
        if (replace2) {
            stringArray = new String[]{fqcn};
            v1 = AnnotationUtil.findAnnotation((PsiModifierListOwner)container, (String[])stringArray);
        } else {
            v1 = annotation = null;
        }
        if (annotation != null && annotation.isPhysical()) {
            annotation.replace((PsiElement)newAnnotation);
        } else if (!replace2 && AnnotationUtil.findAnnotation((PsiModifierListOwner)container, (String[])(stringArray = new String[]{fqcn})) != null) {
            PsiModifierList owner = container.getModifierList();
            PsiAnnotation inserted = AddAnnotationPsiFix.addPhysicalAnnotationTo((String)fqcn, (PsiNameValuePair[])newAnnotation.getParameterList().getAttributes(), (PsiAnnotationOwner)((PsiAnnotationOwner)owner));
            if (inserted != null) {
                JavaCodeStyleManager.getInstance((Project)inserted.getProject()).shortenClassReferences((PsiElement)inserted);
            }
        } else {
            PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
            AddAnnotationFix fix = new AddAnnotationFix(fqcn, container, attributes, new String[0]);
            fix.invoke(container.getProject(), null, container.getContainingFile());
        }
    }

    private final void handleKotlin(PsiElement startElement) {
        PsiElement psiElement = this.getAnnotationContainer(startElement);
        if (psiElement == null) {
            return;
        }
        PsiElement annotationContainer = psiElement;
        if (!IntentionPreviewUtils.prepareElementForWrite((PsiElement)annotationContainer)) {
            return;
        }
        for (ApiConstraint.SdkApiConstraint requirement : CollectionsKt.reversed((Iterable)this.requirements)) {
            this.addAnnotationsKotlin(annotationContainer, this.requiresApi, requirement.getSdkId(), requirement.min(), requirement.getSdkId() == 0);
        }
    }

    private final void addAnnotationsKotlin(PsiElement annotationContainer, boolean requiresApi, int sdkId, int api, boolean replace2) {
        Object object;
        String fqn;
        if (requiresApi && sdkId != 0) {
            v0 = "androidx.annotation.RequiresExtension";
        } else if (requiresApi) {
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)annotationContainer);
            AndroidxName androidxName = VersionChecks.REQUIRES_API_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)androidxName, (String)"REQUIRES_API_ANNOTATION");
            v0 = DependencyManagementUtil.mapAndroidxName(module2, androidxName);
        } else {
            v0 = fqn = "android.annotation.TargetApi";
        }
        if (requiresApi && sdkId != 0) {
            Project project = annotationContainer.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"annotationContainer.project");
            object = "extension=" + this.getSdkId(project, sdkId) + ", version=" + api;
        } else {
            object = AddTargetVersionCheckQuickFix.Companion.getVersionField(api, true);
        }
        String inner = object;
        this.addAnnotationKotlin(annotationContainer, fqn, inner, replace2);
    }

    private final String getSdkId(Project project, int sdkId) {
        ApiLookup lookup = LintIdeClient.getApiLookup((Project)project);
        String string = ApiLookup.getSdkExtensionField((ApiLookup)lookup, (int)sdkId, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSdkExtensionField(lookup, sdkId, true)");
        return string;
    }

    private final void addAnnotationKotlin(PsiElement annotationContainer, String fqn, String inner, boolean replace2) {
        if (annotationContainer instanceof KtModifierListOwner) {
            String whiteSpaceText = AnnotateQuickFixKt.isNewLineNeededForAnnotation((KtElement)((KtElement)annotationContainer)) ? "\n" : " ";
            LintIdeUtilsKt.addAnnotation$default((KtModifierListOwner)((KtModifierListOwner)annotationContainer), (FqName)new FqName(fqn), (String)inner, null, (boolean)replace2, (String)whiteSpaceText, null, (int)32, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement getAnnotationContainer(PsiElement element2) {
        Object object;
        Language language = element2.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            void var3_3;
            Class[] classArray;
            PsiModifierListOwner container = null;
            if (this.requireClass) {
                classArray = new Class[]{PsiClass.class};
                v0 = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])classArray);
            } else {
                classArray = new Class[]{PsiMethod.class, PsiClass.class};
                v0 = container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])classArray);
            }
            while (container != null && container instanceof PsiAnonymousClass) {
                classArray = new Class[]{PsiClass.class};
                container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)container), PsiMethod.class, (boolean)true, (Class[])classArray);
            }
            object = (PsiElement)var3_3;
        } else {
            object = Intrinsics.areEqual((Object)language, (Object)XMLLanguage.INSTANCE) ? PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class, (boolean)false) : (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE) ? PsiTreeUtil.findFirstParent((PsiElement)element2, (Condition)new Condition(this){
                final /* synthetic */ AddTargetApiQuickFix this$0;
                {
                    this.this$0 = $receiver;
                }

                public final boolean value(PsiElement it) {
                    boolean bl;
                    if (AddTargetApiQuickFix.access$getRequiresApi$p(this.this$0)) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        bl = AnnotateQuickFixKt.isAnnotationTarget((PsiElement)it);
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        bl = AddTargetApiQuickFix.access$isTargetApiAnnotationValidTarget(this.this$0, it);
                    }
                    return bl;
                }
            }) : null);
        }
        return object;
    }

    private final boolean isTargetApiAnnotationValidTarget(PsiElement $this$isTargetApiAnnotationValidTarget) {
        return $this$isTargetApiAnnotationValidTarget instanceof KtClassOrObject || $this$isTargetApiAnnotationValidTarget instanceof KtFunction && !($this$isTargetApiAnnotationValidTarget instanceof KtFunctionLiteral) || $this$isTargetApiAnnotationValidTarget instanceof KtPropertyAccessor;
    }

    public static final /* synthetic */ boolean access$getRequiresApi$p(AddTargetApiQuickFix $this) {
        return $this.requiresApi;
    }

    public static final /* synthetic */ boolean access$isTargetApiAnnotationValidTarget(AddTargetApiQuickFix $this, PsiElement $receiver) {
        return $this.isTargetApiAnnotationValidTarget($receiver);
    }
}

