/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.intentions;

import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.intentions.AndroidAddStringResourceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAddStringResourceQuickFix
extends AndroidAddStringResourceAction {
    private final PsiElement myStartElement;

    public AndroidAddStringResourceQuickFix(@NotNull PsiElement startElement) {
        this.myStartElement = startElement;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (!this.myStartElement.isValid()) {
            return false;
        }
        XmlAttributeValue value2 = AndroidAddStringResourceQuickFix.getAttributeValue(this.myStartElement);
        return value2 != null && AndroidAddStringResourceQuickFix.getStringLiteralValue(project, (PsiElement)value2, file2, ResourceType.STRING) != null;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        String value2;
        String defaultName = null;
        PsiElement parent2 = this.myStartElement.getParent();
        if (parent2 instanceof XmlAttribute && (value2 = ((XmlAttribute)parent2).getValue()) != null) {
            defaultName = IdeResourcesUtil.buildResourceNameFromStringValue(value2);
        }
        this.invokeIntention(project, editor, file2, defaultName);
    }

    public void invokeIntention(Project project, Editor editor, PsiFile file2, @Nullable String resName) {
        XmlAttributeValue attributeValue = AndroidAddStringResourceQuickFix.getAttributeValue(this.myStartElement);
        if (attributeValue != null) {
            AndroidAddStringResourceQuickFix.doInvoke(project, editor, file2, resName, (PsiElement)attributeValue, ResourceType.STRING);
        }
    }

    @Nullable
    private static XmlAttributeValue getAttributeValue(@NotNull PsiElement element2) {
        XmlAttribute attribute2 = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlAttribute.class);
        return attribute2 != null ? attribute2.getValueElement() : null;
    }
}

