/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.lint.checks.WearStandaloneAppDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintWearStandaloneAppFlagInspection
extends AndroidLintInspectionBase {
    public AndroidLintWearStandaloneAppFlagInspection() {
        super(AndroidLintBundle.message("android.lint.inspections.wear.standalone.app.flag", new Object[0]), WearStandaloneAppDetector.WEAR_STANDALONE_APP_ISSUE);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2, @Nullable LintFix fixData) {
        boolean addMetadata = LintFix.getBoolean((LintFix)fixData, (String)"metadata", (boolean)false);
        if (addMetadata) {
            return new LintIdeQuickFix[]{new DefaultLintQuickFix("Add meta-data element for 'com.google.android.wearable.standalone'", true){

                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
                    XmlTag parent2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
                    if (parent2 == null || !"application".equals(parent2.getName())) {
                        return;
                    }
                    XmlTag nodeMetadata = parent2.createChildTag("meta-data", null, null, false);
                    XmlTag[] currentMetadataTags = parent2.findSubTags("meta-data");
                    XmlTag addAfter = currentMetadataTags.length > 0 ? currentMetadataTags[currentMetadataTags.length - 1] : null;
                    nodeMetadata = addAfter != null ? (XmlTag)parent2.addAfter((PsiElement)nodeMetadata, (PsiElement)addAfter) : parent2.addSubTag(nodeMetadata, true);
                    if (nodeMetadata != null) {
                        nodeMetadata.setAttribute("name", "http://schemas.android.com/apk/res/android", "com.google.android.wearable.standalone");
                        nodeMetadata.setAttribute("value", "http://schemas.android.com/apk/res/android", "true");
                    }
                }

                public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                    XmlTag parent2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
                    return parent2 != null && "application".equals(parent2.getName());
                }
            }};
        }
        return super.getQuickFixes(startElement, endElement, message2, fixData);
    }
}

