/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

public class AndroidLintSwitchIntDefInspection
extends AndroidLintInspectionBase {
    public AndroidLintSwitchIntDefInspection() {
        super(AndroidLintBundle.message("android.lint.inspections.switch.int.def", new Object[0]), AnnotationDetector.SWITCH_TYPE_DEF);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2, @Nullable LintFix fixData) {
        final List missingCases = LintFix.getStringList((LintFix)fixData, (String)"cases");
        if (missingCases != null && !missingCases.isEmpty()) {
            return new LintIdeQuickFix[]{new DefaultLintQuickFix("Add Missing @IntDef Constants"){

                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
                    if (!IntentionPreviewUtils.prepareElementForWrite((PsiElement)startElement)) {
                        return;
                    }
                    if (startElement.getParent() instanceof PsiSwitchStatement) {
                        PsiSwitchStatement switchStatement = (PsiSwitchStatement)startElement.getParent();
                        Project project = switchStatement.getProject();
                        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory((Project)project);
                        PsiCodeBlock body = switchStatement.getBody();
                        if (body == null) {
                            return;
                        }
                        PsiElement anchor = body.getLastChild();
                        for (String constant : missingCases) {
                            constant = TextFormat.RAW.convertTo(constant, TextFormat.TEXT);
                            PsiElement parent2 = anchor.getParent();
                            PsiStatement caseStatement = factory2.createStatementFromText("case " + constant + ":", anchor);
                            parent2.addBefore((PsiElement)caseStatement, anchor);
                            PsiStatement breakStatement = factory2.createStatementFromText("break;", anchor);
                            parent2.addBefore((PsiElement)breakStatement, anchor);
                        }
                        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)switchStatement);
                    } else {
                        KtWhenExpression when = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, KtWhenExpression.class, (boolean)false);
                        if (when != null) {
                            Project project = when.getProject();
                            KtPsiFactory factory3 = new KtPsiFactory(project);
                            PsiElement anchor = when.getCloseBrace();
                            for (String constant : missingCases) {
                                constant = TextFormat.RAW.convertTo(constant, TextFormat.TEXT);
                                KtWhenEntry caseStatement = factory3.createWhenEntry(constant + "-> { TODO() }");
                                when.addBefore((PsiElement)caseStatement, anchor);
                                ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)when);
                            }
                        }
                    }
                }

                public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                    return startElement.isValid();
                }
            }};
        }
        return super.getQuickFixes(startElement, endElement, message2, fixData);
    }
}

