/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.support.AndroidxName;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.lint.checks.ExifInterfaceDetector;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintExifInterfaceInspection
extends AndroidLintInspectionBase {
    private static final AndroidxName NEW_EXIT_INTERFACE = new AndroidxName("android.support.media.ExifInterface", "androidx.exifinterface.media.ExifInterface");

    public AndroidLintExifInterfaceInspection() {
        super(AndroidLintBundle.message("android.lint.inspections.exif.interface", new Object[0]), ExifInterfaceDetector.ISSUE);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2) {
        return new LintIdeQuickFix[]{new ReplaceExifFix()};
    }

    private static class ReplaceExifFix
    extends DefaultLintQuickFix {
        ReplaceExifFix() {
            super("Update all references in this file");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
            Module module2 = AndroidPsiUtils.getModuleSafely((PsiElement)startElement);
            if (module2 != null) {
                LocalHistoryAction action2 = LocalHistory.getInstance().startAction(this.getName());
                Project project = module2.getProject();
                PsiClass cls = JavaPsiFacade.getInstance((Project)project).findClass(NEW_EXIT_INTERFACE.newName(), GlobalSearchScope.allScope((Project)project));
                if (cls == null) {
                    cls = JavaPsiFacade.getInstance((Project)project).findClass(NEW_EXIT_INTERFACE.oldName(), GlobalSearchScope.allScope((Project)project));
                }
                if (cls != null) {
                    ReplaceExifFix.replaceReferences(this.getName(), startElement, cls, false);
                    return;
                }
                String libraryCoordinate = ReplaceExifFix.getExifLibraryCoordinate();
                boolean useAndroidx = libraryCoordinate != null && libraryCoordinate.startsWith(GoogleMavenArtifactId.ANDROIDX_EXIF_INTERFACE.getMavenGroupId());
                GradleBuildModel buildModel = GradleBuildModel.get(module2);
                try {
                    if (buildModel == null) {
                        ReplaceExifFix.replaceReferences(this.getName(), startElement, null, useAndroidx);
                    } else {
                        WriteCommandAction.writeCommandAction((Project)module2.getProject()).withName(this.getName()).run(() -> {
                            if (libraryCoordinate != null) {
                                ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
                                    GradleBuildModel buildModel2 = GradleBuildModel.get(module2);
                                    if (buildModel2 != null) {
                                        buildModel2.dependencies().addArtifact("implementation", libraryCoordinate);
                                        buildModel2.applyChanges();
                                    }
                                });
                            }
                            this.syncAndReplaceReferences(project, startElement, useAndroidx);
                        });
                    }
                }
                finally {
                    action2.finish();
                }
            }
        }

        private void syncAndReplaceReferences(final @NotNull Project project, final @NotNull PsiElement startElement, final boolean useAndroidx) {
            assert (ApplicationManager.getApplication().isDispatchThread());
            ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
            Futures.addCallback(syncResult, (FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(){

                public void onSuccess(@Nullable ProjectSystemSyncManager.SyncResult syncResult) {
                    if (syncResult != null && syncResult.isSuccessful()) {
                        DumbService.getInstance((Project)project).runWhenSmart(() -> ReplaceExifFix.replaceReferences(this.getName(), startElement, null, useAndroidx));
                    }
                }

                public void onFailure(@Nullable Throwable t) {
                    throw new RuntimeException(t);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private static String getExifLibraryCoordinate() {
            GradleVersion version2;
            RepositoryUrlManager manager = RepositoryUrlManager.get();
            Object libraryCoordinate = manager.getArtifactStringCoordinate(GoogleMavenArtifactId.ANDROIDX_EXIF_INTERFACE, true);
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
            libraryCoordinate = manager.getArtifactStringCoordinate(GoogleMavenArtifactId.EXIF_INTERFACE, true);
            if (libraryCoordinate == null) {
                return null;
            }
            GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)libraryCoordinate);
            if (coordinate != null && (version2 = GradleVersion.tryParse((String)coordinate.getRevision())) != null && !version2.isAtLeast(25, 1, 0)) {
                libraryCoordinate = coordinate.getGroupId() + ":" + coordinate.getArtifactId() + ":25.1.0";
            }
            return libraryCoordinate;
        }

        private static void replaceReferences(@NotNull String actionName, @NotNull PsiElement element2, final @Nullable PsiClass cls, final boolean useAndroidx) {
            WriteCommandAction.writeCommandAction((Project)element2.getProject()).withName(actionName).run(() -> {
                Project project = element2.getProject();
                final PsiElementFactory factory2 = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                PsiFile file2 = element2.getContainingFile();
                file2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement expression2) {
                        if ("ExifInterface".equals(expression2.getReferenceName()) && expression2.isQualified()) {
                            PsiElement context2 = expression2.getParent();
                            if (expression2 instanceof PsiReferenceExpression) {
                                if (cls != null) {
                                    PsiReferenceExpression replacement = factory2.createReferenceExpression(cls);
                                    expression2.replace((PsiElement)replacement);
                                    return;
                                }
                            } else {
                                expression2.replace((PsiElement)factory2.createReferenceFromText(useAndroidx ? NEW_EXIT_INTERFACE.newName() : NEW_EXIT_INTERFACE.oldName(), context2));
                                return;
                            }
                        }
                        super.visitReferenceElement(expression2);
                    }
                });
            });
        }
    }
}

