/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.lint.checks.ByteOrderMarkDetector;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class AndroidLintByteOrderMarkInspection
extends AndroidLintInspectionBase {
    public AndroidLintByteOrderMarkInspection() {
        super(AndroidLintBundle.message("android.lint.inspections.byte.order.mark", new Object[0]), ByteOrderMarkDetector.BOM);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2) {
        return new LintIdeQuickFix[]{new DefaultLintQuickFix("Remove byte order marks", true){

            public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
                PsiFile file2 = startElement.getContainingFile();
                Document document2 = context2.getDocument(file2);
                if (document2 != null) {
                    String text2 = document2.getText();
                    for (int i = text2.length() - 1; i >= 0; --i) {
                        char c = text2.charAt(i);
                        if (c != '\ufeff') continue;
                        document2.deleteString(i, i + 1);
                    }
                }
            }
        }};
    }
}

