/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.quickFixes.AddTargetApiQuickFix;
import com.android.tools.idea.lint.quickFixes.AddTargetVersionCheckQuickFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.VersionChecks;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.intentions.OverrideResourceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLintApiInspection
extends AndroidLintInspectionBase {
    public AndroidLintApiInspection(String displayName2, Issue issue2) {
        super(displayName2, issue2);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2, @Nullable LintFix fixData) {
        ApiConstraint requirement = LintFix.getApiConstraint((LintFix)fixData, (String)"requiresApi", (ApiConstraint)ApiConstraint.UNKNOWN);
        if (requirement != ApiConstraint.UNKNOWN) {
            int api = requirement.min();
            ArrayList<Object> list2 = new ArrayList<Object>();
            PsiFile file2 = startElement.getContainingFile();
            boolean isXml = false;
            if (file2 instanceof XmlFile) {
                FolderConfiguration config2;
                isXml = true;
                ResourceFolderType folderType = IdeResourcesUtil.getFolderType(file2);
                if (folderType != null && (config2 = IdeResourcesUtil.getFolderConfiguration(file2)) != null) {
                    config2.setVersionQualifier(new VersionQualifier(api));
                    String folder = config2.getFolderName(folderType);
                    list2.add(OverrideResourceAction.createFix(folder));
                }
            }
            boolean requireClass = LintFix.getBoolean((LintFix)fixData, (String)"requireClass", (boolean)false);
            List constraints = requirement.getConstraints();
            Project project = startElement.getProject();
            if (!requireClass && !isXml) {
                ApiConstraint minSdk = LintFix.getApiConstraint((LintFix)fixData, (String)"minSdk", (ApiConstraint)ApiConstraint.UNKNOWN);
                for (ApiConstraint constraint : constraints) {
                    int version2 = constraint.min();
                    int sdk = constraint.getSdk();
                    list2.add((Object)new AddTargetVersionCheckQuickFix(project, version2, sdk, minSdk));
                }
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            ApiConstraint.SdkApiConstraint first = (ApiConstraint.SdkApiConstraint)constraints.get(0);
            if (constraints.size() > 1) {
                if (AndroidLintApiInspection.requiresExtensionAvailable(project)) {
                    list2.add((Object)new AddTargetApiQuickFix(Collections.singletonList(first), true, startElement, requireClass));
                }
            } else {
                int sdkId = first.getSdkId();
                if (sdkId == 0) {
                    if (!isXml && AndroidLintApiInspection.requiresApiAvailable(project)) {
                        list2.add((Object)new AddTargetApiQuickFix(constraints, true, startElement, requireClass));
                    } else {
                        list2.add((Object)new AddTargetApiQuickFix(constraints, false, startElement, requireClass));
                    }
                } else if (!isXml && AndroidLintApiInspection.requiresExtensionAvailable(project)) {
                    list2.add((Object)new AddTargetApiQuickFix(constraints, true, startElement, requireClass));
                }
            }
            return list2.toArray(LintIdeQuickFix.EMPTY_ARRAY);
        }
        return super.getQuickFixes(startElement, endElement, message2, fixData);
    }

    public static boolean requiresApiAvailable(Project project) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope2 = GlobalSearchScope.allScope((Project)project);
        return facade.findClass(VersionChecks.REQUIRES_API_ANNOTATION.oldName(), scope2) != null || facade.findClass(VersionChecks.REQUIRES_API_ANNOTATION.newName(), scope2) != null;
    }

    public static boolean requiresExtensionAvailable(Project project) {
        GlobalSearchScope scope2;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        return facade.findClass("androidx.annotation.RequiresExtension", scope2 = GlobalSearchScope.allScope((Project)project)) != null;
    }
}

