/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.model.IdeAndroidProject;
import com.android.tools.idea.gradle.model.IdeAndroidProjectType;
import com.android.tools.idea.gradle.model.IdeLintOptions;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LintAction;
import com.google.wireless.android.sdk.stats.LintIssueId;
import com.google.wireless.android.sdk.stats.LintPerformance;
import com.google.wireless.android.sdk.stats.LintSession;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002JV\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2&\u0010\r\u001a\"\u0012\u0004\u0012\u00020\u000e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\b\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fJX\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2&\u0010\r\u001a\"\u0012\u0004\u0012\u00020\u000e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\b\u0018\u00010\bJ:\u0010#\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\"\u0010%\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0&j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t`'H\u0002J<\u0010(\u001a\u00020\u001c2\"\u0010%\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0&j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t`'2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+H\u0002J\f\u0010,\u001a\u00020+*\u00020-H\u0002J\f\u0010,\u001a\u00020+*\u00020.H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/tools/idea/lint/LintIdeAnalytics;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "computeApplicationId", "", "computeIssueData", "", "Lcom/google/wireless/android/sdk/stats/LintIssueId$Builder;", "warnings1", "", "Lcom/android/tools/idea/lint/common/LintProblemData;", "warnings2", "Lcom/android/tools/lint/detector/api/Issue;", "Ljava/io/File;", "severityModule", "Lcom/intellij/openapi/module/Module;", "computePerformance", "Lcom/google/wireless/android/sdk/stats/LintPerformance;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "singleFileAnalysis", "", "computeProjectId", "projectPath", "Ljava/nio/file/Path;", "logFeedback", "", "issue", "feedback", "Lcom/google/wireless/android/sdk/stats/LintAction$LintFeedback;", "logSession", "type", "Lcom/google/wireless/android/sdk/stats/LintSession$AnalysisType;", "recordIssueData", "warnings", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "recordSeverityOverride", "id", "lintSeverity", "Lcom/google/wireless/android/sdk/stats/LintIssueId$LintSeverity;", "toAnalyticsSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "", "intellij.android.lint"})
@SourceDebugExtension(value={"SMAP\nLintIdeAnalytics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintIdeAnalytics.kt\ncom/android/tools/idea/lint/LintIdeAnalytics\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n1#2:267\n*E\n"})
public final class LintIdeAnalytics {
    @NotNull
    private final Project project;

    public LintIdeAnalytics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final void logFeedback(@NotNull String issue2, @NotNull LintAction.LintFeedback feedback) {
        LintAction.Builder builder2;
        String it;
        AndroidStudioEvent.Builder builder3;
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)feedback, (String)"feedback");
        AndroidStudioEvent.Builder $this$logFeedback_u24lambda_u243 = builder3 = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $this$logFeedback_u24lambda_u243.setKind(AndroidStudioEvent.EventKind.LINT_ACTION);
        String string = this.computeProjectId(this.project);
        if (string != null) {
            it = string;
            boolean bl2 = false;
            $this$logFeedback_u24lambda_u243.setProjectId(it);
        }
        String string2 = this.computeApplicationId(this.project);
        if (string2 != null) {
            it = string2;
            boolean bl3 = false;
            $this$logFeedback_u24lambda_u243.setRawProjectId(it);
        }
        LintAction.Builder $this$logFeedback_u24lambda_u243_u24lambda_u242 = builder2 = LintAction.newBuilder();
        boolean bl4 = false;
        $this$logFeedback_u24lambda_u243_u24lambda_u242.setIssueId(issue2);
        $this$logFeedback_u24lambda_u243_u24lambda_u242.setLintFeedback(feedback);
        LintAction action2 = builder2.build();
        $this$logFeedback_u24lambda_u243.setLintAction(action2);
        AndroidStudioEvent.Builder builder4 = builder3;
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"newBuilder()\n        .ap\u2026Action = action\n        }");
        AndroidStudioEvent.Builder event2 = UsageTrackerUtils.withProjectId(builder4, this.project);
        UsageTracker.log((AndroidStudioEvent.Builder)event2);
    }

    public final void logSession(@NotNull LintSession.AnalysisType type, @NotNull LintDriver driver, @Nullable Module severityModule, @Nullable List<? extends LintProblemData> warnings1, @Nullable Map<Issue, ? extends Map<File, ? extends List<? extends LintProblemData>>> warnings2) {
        AndroidStudioEvent.Builder builder2;
        LintSession.Builder builder3;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        if (this.project.isDisposed()) {
            return;
        }
        if (!AnalyticsSettings.getOptedIn()) {
            return;
        }
        LintSession.Builder $this$logSession_u24lambda_u244 = builder3 = LintSession.newBuilder();
        boolean bl = false;
        $this$logSession_u24lambda_u244.setAnalysisType(type);
        $this$logSession_u24lambda_u244.setProjectId(this.computeProjectId(this.project));
        $this$logSession_u24lambda_u244.setLintPerformance(this.computePerformance(driver, type == LintSession.AnalysisType.IDE_FILE));
        $this$logSession_u24lambda_u244.setBaselineEnabled(driver.getBaseline() != null);
        $this$logSession_u24lambda_u244.setIncludingGeneratedSources(driver.getCheckGeneratedSources());
        $this$logSession_u24lambda_u244.setIncludingTestSources(driver.getCheckTestSources());
        $this$logSession_u24lambda_u244.setIncludingDependencies(driver.getCheckDependencies());
        for (LintIssueId.Builder issueBuilder : this.computeIssueData(warnings1, warnings2, severityModule).values()) {
            $this$logSession_u24lambda_u244.addIssueIds(issueBuilder);
        }
        LintSession session2 = builder3.build();
        AndroidStudioEvent.Builder $this$logSession_u24lambda_u245 = builder2 = AndroidStudioEvent.newBuilder();
        boolean bl2 = false;
        $this$logSession_u24lambda_u245.setKind(AndroidStudioEvent.EventKind.LINT_SESSION);
        $this$logSession_u24lambda_u245.setLintSession(session2);
        $this$logSession_u24lambda_u245.setJavaProcessStats(CommonMetricsData.getJavaProcessStats());
        $this$logSession_u24lambda_u245.setJvmDetails(CommonMetricsData.getJvmDetails());
        AndroidStudioEvent.Builder builder4 = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"newBuilder()\n        .ap\u2026Data.jvmDetails\n        }");
        AndroidStudioEvent.Builder event2 = UsageTrackerUtils.withProjectId(builder4, this.project);
        UsageTracker.log((AndroidStudioEvent.Builder)event2);
    }

    private final LintPerformance computePerformance(LintDriver driver, boolean singleFileAnalysis) {
        LintPerformance.Builder builder2;
        LintPerformance.Builder $this$computePerformance_u24lambda_u246 = builder2 = LintPerformance.newBuilder();
        boolean bl = false;
        $this$computePerformance_u24lambda_u246.setAnalysisTimeMs(System.currentTimeMillis() - driver.getAnalysisStartTime());
        $this$computePerformance_u24lambda_u246.setFileCount((long)driver.getFileCount());
        if (!singleFileAnalysis) {
            $this$computePerformance_u24lambda_u246.setModuleCount((long)driver.getModuleCount());
            $this$computePerformance_u24lambda_u246.setJavaSourceCount((long)driver.getJavaFileCount());
            $this$computePerformance_u24lambda_u246.setKotlinSourceCount((long)driver.getKotlinFileCount());
            $this$computePerformance_u24lambda_u246.setResourceFileCount((long)driver.getResourceFileCount());
            $this$computePerformance_u24lambda_u246.setTestSourceCount((long)driver.getTestSourceCount());
        }
        LintPerformance lintPerformance = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)lintPerformance, (String)"newBuilder()\n      .appl\u2026 }\n      }\n      .build()");
        return lintPerformance;
    }

    private final void recordSeverityOverride(HashMap<String, LintIssueId.Builder> map2, String id2, LintIssueId.LintSeverity lintSeverity) {
        LintIssueId.Builder builder2;
        LintIssueId.Builder builder3 = map2.get(id2);
        if (builder3 != null) {
            return;
        }
        LintIssueId.Builder $this$recordSeverityOverride_u24lambda_u247 = builder2 = LintIssueId.newBuilder();
        boolean bl = false;
        Map map3 = map2;
        Intrinsics.checkNotNullExpressionValue((Object)$this$recordSeverityOverride_u24lambda_u247, (String)"this");
        map3.put(id2, $this$recordSeverityOverride_u24lambda_u247);
        $this$recordSeverityOverride_u24lambda_u247.setIssueId(id2);
        $this$recordSeverityOverride_u24lambda_u247.setCount(0L);
        $this$recordSeverityOverride_u24lambda_u247.setSeverity(lintSeverity);
    }

    private final LintIssueId.LintSeverity toAnalyticsSeverity(Severity $this$toAnalyticsSeverity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toAnalyticsSeverity.ordinal()]) {
            case 1 -> LintIssueId.LintSeverity.FATAL_SEVERITY;
            case 2 -> LintIssueId.LintSeverity.ERROR_SEVERITY;
            case 3 -> LintIssueId.LintSeverity.WARNING_SEVERITY;
            case 4 -> LintIssueId.LintSeverity.INFORMATIONAL_SEVERITY;
            case 5 -> LintIssueId.LintSeverity.IGNORE_SEVERITY;
            default -> LintIssueId.LintSeverity.UNKNOWN_SEVERITY;
        };
    }

    private final LintIssueId.LintSeverity toAnalyticsSeverity(int $this$toAnalyticsSeverity) {
        return switch ($this$toAnalyticsSeverity) {
            case 1 -> LintIssueId.LintSeverity.FATAL_SEVERITY;
            case 2 -> LintIssueId.LintSeverity.ERROR_SEVERITY;
            case 3 -> LintIssueId.LintSeverity.WARNING_SEVERITY;
            case 4 -> LintIssueId.LintSeverity.INFORMATIONAL_SEVERITY;
            case 5 -> LintIssueId.LintSeverity.IGNORE_SEVERITY;
            default -> LintIssueId.LintSeverity.UNKNOWN_SEVERITY;
        };
    }

    private final Map<String, LintIssueId.Builder> computeIssueData(List<? extends LintProblemData> warnings1, Map<Issue, ? extends Map<File, ? extends List<? extends LintProblemData>>> warnings2, Module severityModule) {
        GradleAndroidModel model2;
        HashMap<String, LintIssueId.Builder> map2 = new HashMap<String, LintIssueId.Builder>(100);
        if (warnings1 != null) {
            this.recordIssueData(warnings1, map2);
        }
        if (warnings2 != null) {
            for (Map<File, ? extends List<? extends LintProblemData>> map3 : warnings2.values()) {
                for (List<? extends LintProblemData> list2 : map3.values()) {
                    this.recordIssueData(list2, map2);
                }
            }
        }
        if (severityModule != null && (model2 = GradleAndroidModel.Companion.get(severityModule)) != null) {
            try {
                IdeAndroidProject throwable = model2.getAndroidProject();
                IdeLintOptions lintOptions = throwable.getLintOptions();
                Map map4 = lintOptions.getSeverityOverrides();
                Map map5 = map4;
                if (!(map5 == null || map5.isEmpty())) {
                    for (Map.Entry entry : map4.entrySet()) {
                        String id2 = (String)entry.getKey();
                        int severity = ((Number)entry.getValue()).intValue();
                        this.recordSeverityOverride(map2, id2, this.toAnalyticsSeverity(severity));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return map2;
    }

    private final void recordIssueData(List<? extends LintProblemData> warnings, HashMap<String, LintIssueId.Builder> map2) {
        for (LintProblemData lintProblemData : warnings) {
            Issue issue2;
            Intrinsics.checkNotNullExpressionValue((Object)lintProblemData.getIssue(), (String)"warning.issue");
            String id2 = issue2.getId();
            LintIssueId.Builder builder2 = map2.get(id2);
            if (builder2 == null) {
                LintIssueId.Builder builder3;
                LintIdeAnalytics $this$recordIssueData_u24lambda_u249 = this;
                boolean bl = false;
                LintIssueId.Builder $this$recordIssueData_u24lambda_u249_u24lambda_u248 = builder3 = LintIssueId.newBuilder();
                boolean bl2 = false;
                Map map3 = map2;
                Intrinsics.checkNotNullExpressionValue((Object)$this$recordIssueData_u24lambda_u249_u24lambda_u248, (String)"this");
                map3.put(id2, $this$recordIssueData_u24lambda_u249_u24lambda_u248);
                $this$recordIssueData_u24lambda_u249_u24lambda_u248.setIssueId(issue2.getId());
                Severity configuredSeverity = lintProblemData.getConfiguredSeverity();
                $this$recordIssueData_u24lambda_u249_u24lambda_u248.setSeverity(configuredSeverity == null || configuredSeverity == issue2.getDefaultSeverity() ? LintIssueId.LintSeverity.DEFAULT_SEVERITY : $this$recordIssueData_u24lambda_u249.toAnalyticsSeverity(configuredSeverity));
                builder2 = builder3;
            }
            LintIssueId.Builder issueBuilder = builder2;
            issueBuilder.setCount(issueBuilder.getCount() + 1L);
        }
    }

    private final String computeApplicationId(Project project) {
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
        for (Module module2 : moduleManager.getModules()) {
            GradleAndroidModel androidModel = GradleAndroidModel.Companion.get(module2);
            if (androidModel == null || androidModel.getAndroidProject().getProjectType() != IdeAndroidProjectType.PROJECT_TYPE_APP) continue;
            return androidModel.getApplicationId();
        }
        return null;
    }

    private final String computeProjectId(Project project) {
        return this.computeProjectId(Paths.get(project.getBasePath(), new String[0]));
    }

    private final String computeProjectId(Path projectPath) {
        String string;
        if (projectPath == null) {
            return null;
        }
        try {
            string = Anonymizer.anonymizeUtf8((ILogger)((ILogger)new NullLogger()), (String)((Object)projectPath.toAbsolutePath()).toString());
        }
        catch (IOException e) {
            string = "*ANONYMIZATION_ERROR*";
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.FATAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.INFORMATIONAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.IGNORE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

