/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.support.AndroidxNameUtils;
import com.android.tools.idea.gradle.model.IdeAndroidProject;
import com.android.tools.idea.gradle.model.IdeModuleSourceSet;
import com.android.tools.idea.gradle.model.IdeModuleWellKnownSourceSet;
import com.android.tools.idea.gradle.model.IdeMultiVariantData;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeProject;
import com.android.tools.idea.lint.model.LintModelFactory;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.ProjectSyncModificationTracker;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.android.tools.idea.projectsystem.gradle.GradleSourceSetProjectPath;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.LintModelModuleAndroidLibraryProject;
import com.android.tools.lint.detector.api.LintModelModuleProject;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.LintModelAndroidLibrary;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelVariant;
import com.android.tools.sdk.AndroidPlatform;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.graph.Graph;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.KotlinModuleKind;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;

public class AndroidLintIdeProject
extends LintIdeProject {
    AndroidLintIdeProject(LintClient client2, File dir, File referenceDir) {
        super(client2, dir, referenceDir);
    }

    public static List<Project> create(LintIdeClient client2, @Nullable List<VirtualFile> files2, Module ... modules) {
        ArrayList<Project> projects = new ArrayList<Project>();
        HashMap projectMap = Maps.newHashMap();
        HashMap moduleMap = Maps.newHashMap();
        HashMap libraryMap = Maps.newHashMap();
        if (files2 != null && !files2.isEmpty()) {
            files2 = Lists.newArrayList(files2);
        }
        for (Module module2 : Arrays.stream(modules).map(AndroidLintIdeProject::getMainModule).distinct().collect(Collectors.toList())) {
            AndroidLintIdeProject.addProjects((LintClient)client2, module2, files2, moduleMap, libraryMap, projectMap, projects, false);
        }
        client2.setModuleMap((Map)projectMap);
        if (projects.size() > 1) {
            HashSet<Project> roots = new HashSet<Project>(projects);
            for (Project project : projects) {
                roots.removeAll(project.getAllLibraries());
            }
            return Lists.newArrayList(roots);
        }
        return projects;
    }

    @NotNull
    private static Module getMainModule(@NotNull Module module2) {
        GradleProjectPath path2 = GradleProjectPathKt.getGradleProjectPath(module2);
        if (path2 == null) {
            return module2;
        }
        GradleSourceSetProjectPath pathToMain = GradleProjectPathKt.toSourceSetPath(path2, (IdeModuleSourceSet)IdeModuleWellKnownSourceSet.MAIN);
        Module mainModule = GradleProjectPathKt.resolveIn(pathToMain, module2.getProject());
        return mainModule != null ? mainModule : module2;
    }

    public static Pair<Project, Project> createForSingleFile(LintIdeClient client2, @Nullable VirtualFile file2, Module module2) {
        Project project = AndroidLintIdeProject.createModuleProject((LintClient)client2, module2, true);
        Project main = null;
        HashMap projectMap = Maps.newHashMap();
        if (project != null) {
            Module androidModule;
            project.setDirectLibraries(Collections.emptyList());
            if (file2 != null) {
                project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file2));
            }
            projectMap.put(project, module2);
            if (!project.isAndroidProject() && (androidModule = AndroidLintIdeProject.findAndroidModule(module2)) != null && (main = AndroidLintIdeProject.createModuleProject((LintClient)client2, androidModule, true)) != null) {
                projectMap.put(main, androidModule);
                main.setDirectLibraries(Collections.singletonList(project));
            }
        }
        client2.setModuleMap((Map)projectMap);
        return Pair.create((Object)project, main);
    }

    @Nullable
    private static Module findAndroidModule(Module module2) {
        if (module2.isDisposed()) {
            return null;
        }
        Graph graph = (Graph)ApplicationManager.getApplication().runReadAction(() -> {
            com.intellij.openapi.project.Project project = module2.getProject();
            return ModuleManager.getInstance((com.intellij.openapi.project.Project)project).moduleGraph();
        });
        if (graph == null) {
            return null;
        }
        HashSet facets = Sets.newHashSet();
        HashSet seen = Sets.newHashSet();
        seen.add(module2);
        AndroidLintIdeProject.addAndroidModules(facets, seen, (Graph<Module>)graph, module2);
        for (AndroidFacet facet2 : facets) {
            if (!((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()) continue;
            return facet2.getMainModule();
        }
        if (!facets.isEmpty()) {
            return ((AndroidFacet)facets.iterator().next()).getMainModule();
        }
        return null;
    }

    private static void addAndroidModules(Set<AndroidFacet> androidFacets, Set<Module> seen, Graph<Module> graph, Module module2) {
        Iterator iterator2 = graph.getOut((Object)module2);
        while (iterator2.hasNext()) {
            Module dep = AndroidLintIdeProject.getMainModule((Module)iterator2.next());
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)dep);
            if (facet2 != null) {
                androidFacets.add(facet2);
            }
            if (seen.contains(dep)) continue;
            seen.add(dep);
            AndroidLintIdeProject.addAndroidModules(androidFacets, seen, graph, dep);
        }
    }

    private static void addProjects(LintClient client2, Module module2, @Nullable List<VirtualFile> files2, Map<Module, Project> moduleMap, Map<LintModelAndroidLibrary, Project> libraryMap, Map<Project, Module> projectMap, List<Project> projects, boolean shallowModel) {
        LintModelVariant variant;
        if (moduleMap.containsKey(module2)) {
            return;
        }
        Project project = AndroidLintIdeProject.createModuleProject(client2, module2, shallowModel);
        if (project == null) {
            List dependentModules = AndroidDependenciesCache.getAllAndroidDependencies(module2, false).stream().map(AndroidFacet::getMainModule).distinct().collect(Collectors.toList());
            for (Module dependentModule : dependentModules) {
                AndroidLintIdeProject.addProjects(client2, dependentModule, files2, moduleMap, libraryMap, projectMap, projects, true);
            }
            return;
        }
        project.setIdeaProject(module2.getProject());
        projects.add(project);
        moduleMap.put(module2, project);
        projectMap.put(project, module2);
        if (AndroidLintIdeProject.processFileFilter((Module)module2, files2, (Project)project)) {
            return;
        }
        ArrayList<Project> dependencies2 = new ArrayList<Project>();
        List dependentModules = AndroidDependenciesCache.getAllAndroidDependencies(module2, true).stream().map(AndroidFacet::getMainModule).distinct().collect(Collectors.toList());
        for (Module dependentModule : dependentModules) {
            Project p = moduleMap.get(dependentModule);
            if (p != null) {
                dependencies2.add(p);
                continue;
            }
            AndroidLintIdeProject.addProjects(client2, dependentModule, files2, moduleMap, libraryMap, projectMap, dependencies2, true);
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 != null && (variant = project.getBuildVariant()) != null) {
            List roots = variant.getMainArtifact().getDependencies().getCompileDependencies().getRoots();
            AndroidLintIdeProject.addGradleLibraryProjects(client2, files2, libraryMap, projects, facet2, project, projectMap, dependencies2, roots);
        }
        project.setDirectLibraries(dependencies2);
    }

    @Nullable
    private static Project createModuleProject(LintClient client2, Module module2, boolean shallowModel) {
        Object project;
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        File dir = AndroidLintIdeProject.getLintProjectDirectory(module2, facet2);
        if (dir == null) {
            return null;
        }
        if (facet2 == null) {
            KotlinFacet kotlinFacet = KotlinFacet.Companion.get(module2);
            if (kotlinFacet != null && ((KotlinFacetConfiguration)kotlinFacet.getConfiguration()).getSettings().getMppVersion() != null && ((KotlinFacetConfiguration)kotlinFacet.getConfiguration()).getSettings().getKind() != KotlinModuleKind.COMPILATION_AND_SOURCE_SET_HOLDER) {
                return null;
            }
            project = new LintIdeProject.LintModuleProject(client2, dir, dir, module2);
            AndroidFacet f = AndroidLintIdeProject.findAndroidFacetInProject(module2.getProject());
            if (f != null) {
                ((Project)project).gradleProject = AndroidModel.isRequired(f);
            }
        } else if (AndroidModel.isRequired(facet2)) {
            AndroidModel androidModel = AndroidModel.get(facet2);
            if (androidModel instanceof GradleAndroidModel) {
                GradleAndroidModel model2 = (GradleAndroidModel)androidModel;
                String variantName = model2.getSelectedVariantName();
                LintModelModule lintModel = AndroidLintIdeProject.getLintModuleModel(facet2, shallowModel);
                LintModelVariant variant = lintModel.findVariant(variantName);
                if (variant == null) {
                    variant = (LintModelVariant)lintModel.getVariants().get(0);
                }
                project = new LintGradleProject(client2, dir, dir, variant, facet2, model2);
            } else {
                project = androidModel != null ? new LintAndroidModelProject(client2, dir, dir, facet2, androidModel) : new LintAndroidProject(client2, dir, dir, facet2);
            }
        } else {
            project = new LintAndroidProject(client2, dir, dir, facet2);
        }
        project.setIdeaProject(module2.getProject());
        client2.registerProject(dir, (Project)project);
        return project;
    }

    @NotNull
    private static LintModelModule getLintModuleModel(AndroidFacet facet2, boolean shallowModel) {
        com.intellij.openapi.project.Project project = facet2.getModule().getProject();
        CachedValuesManager cacheValueManager = CachedValuesManager.getManager((com.intellij.openapi.project.Project)project);
        return (LintModelModule)cacheValueManager.getCachedValue((UserDataHolder)facet2, () -> AndroidLintIdeProject.buildModuleModel(facet2, shallowModel));
    }

    @NotNull
    private static CachedValueProvider.Result<LintModelModule> buildModuleModel(AndroidFacet facet2, boolean shallowModel) {
        GradleAndroidModel model2 = GradleAndroidModel.get(facet2);
        if (model2 == null) {
            throw new IllegalStateException("GradleAndroidModel not available for " + facet2);
        }
        IdeAndroidProject builderModelProject = model2.getAndroidProject();
        IdeMultiVariantData multiVariantData = builderModelProject.getMultiVariantData();
        if (multiVariantData == null) {
            throw new IllegalStateException("GradleAndroidModel is expected to support multi variant plugins.");
        }
        String externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)facet2.getModule());
        if (externalProjectPath == null) {
            throw new IllegalStateException("No external project path for " + facet2.getModule());
        }
        File dir = new File(externalProjectPath);
        LintModelModule module2 = new LintModelFactory().create(builderModelProject, model2.getVariants(), multiVariantData, dir, !shallowModel);
        return CachedValueProvider.Result.create((Object)module2, (Object[])new Object[]{ProjectSyncModificationTracker.getInstance(facet2.getModule().getProject())});
    }

    @Nullable
    public static File getLintProjectDirectory(Module module2, @Nullable AndroidFacet facet2) {
        File dir;
        String externalProjectPath;
        if (ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (Module)module2) && !Strings.isNullOrEmpty((String)(externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module2)))) {
            return new File(externalProjectPath);
        }
        if (facet2 != null) {
            VirtualFile mainContentRoot = AndroidRootUtil.getMainContentRoot(facet2);
            if (mainContentRoot == null) {
                return null;
            }
            dir = VfsUtilCore.virtualToIoFile((VirtualFile)mainContentRoot);
        } else {
            VirtualFile[] roots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
            if (roots.length == 0) {
                return null;
            }
            dir = VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]);
        }
        return dir;
    }

    public static boolean hasAndroidModule(com.intellij.openapi.project.Project project) {
        return ProjectFacetManager.getInstance((com.intellij.openapi.project.Project)project).hasFacets(AndroidFacet.ID);
    }

    @Nullable
    private static AndroidFacet findAndroidFacetInProject(com.intellij.openapi.project.Project project) {
        List androidFacetsInRandomOrder = ProjectFacetManager.getInstance((com.intellij.openapi.project.Project)project).getFacets(AndroidFacet.ID);
        return androidFacetsInRandomOrder.isEmpty() ? null : (AndroidFacet)androidFacetsInRandomOrder.get(0);
    }

    private static void addGradleLibraryProjects(LintClient client2, @Nullable List<VirtualFile> files2, Map<LintModelAndroidLibrary, Project> libraryMap, List<Project> projects, AndroidFacet facet2, Project project, Map<Project, Module> projectMap, List<Project> dependencies2, List<LintModelDependency> graphItems) {
        com.intellij.openapi.project.Project ideaProject = facet2.getModule().getProject();
        for (LintModelDependency dependency : graphItems) {
            LintModelLibrary l = dependency.findLibrary();
            if (!(l instanceof LintModelAndroidLibrary)) continue;
            LintModelAndroidLibrary library = (LintModelAndroidLibrary)l;
            Object p = libraryMap.get(library);
            if (p == null) {
                File dir = library.getFolder();
                p = new LintGradleLibraryProject(client2, dir, dir, dependency, library);
                p.setIdeaProject(ideaProject);
                libraryMap.put(library, (Project)p);
                projectMap.put((Project)p, facet2.getMainModule());
                projects.add((Project)p);
                if (files2 != null) {
                    VirtualFile libraryDir = LocalFileSystem.getInstance().findFileByIoFile(dir);
                    if (libraryDir != null) {
                        ListIterator<VirtualFile> iterator2 = files2.listIterator();
                        while (iterator2.hasNext()) {
                            VirtualFile file2 = iterator2.next();
                            if (!VfsUtilCore.isAncestor((VirtualFile)libraryDir, (VirtualFile)file2, (boolean)false)) continue;
                            project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file2));
                            iterator2.remove();
                        }
                    }
                    if (files2.isEmpty()) {
                        files2 = null;
                    }
                }
            }
            dependencies2.add((Project)p);
        }
    }

    protected void initialize() {
    }

    private static class LintGradleProject
    extends LintModelModuleProject {
        private final GradleAndroidModel myAndroidModuleModel;
        private final AndroidFacet myFacet;

        private LintGradleProject(LintClient client2, File dir, File referenceDir, LintModelVariant variant, AndroidFacet facet2, GradleAndroidModel androidModuleModel) {
            super(client2, dir, referenceDir, variant, null);
            this.gradleProject = true;
            this.mergeManifests = true;
            this.myFacet = facet2;
            this.myAndroidModuleModel = androidModuleModel;
        }

        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }

        public int getBuildSdk() {
            String compileTarget = this.myAndroidModuleModel.getAndroidProject().getCompileTarget();
            AndroidVersion version2 = AndroidTargetHash.getPlatformVersion((String)compileTarget);
            if (version2 != null) {
                return version2.getFeatureLevel();
            }
            AndroidPlatform platform = AndroidPlatforms.getInstance(this.myFacet.getModule());
            if (platform != null) {
                return platform.getApiVersion().getFeatureLevel();
            }
            return super.getBuildSdk();
        }

        @Nullable
        public String getBuildTargetHash() {
            return this.myAndroidModuleModel.getAndroidProject().getCompileTarget();
        }
    }

    private static class LintAndroidModelProject
    extends LintAndroidProject {
        private final AndroidModel myAndroidModel;

        private LintAndroidModelProject(LintClient client2, File dir, File referenceDir, AndroidFacet facet2, AndroidModel androidModel) {
            super(client2, dir, referenceDir, facet2);
            this.myAndroidModel = androidModel;
        }

        @Nullable
        public String getPackage() {
            String manifestPackage = super.getPackage();
            if (manifestPackage != null) {
                return manifestPackage;
            }
            return this.myAndroidModel.getApplicationId();
        }

        public AndroidVersion getMinSdkVersion() {
            AndroidVersion version2 = this.myAndroidModel.getMinSdkVersion();
            if (version2 != null) {
                return version2;
            }
            return super.getMinSdkVersion();
        }

        @NotNull
        public ApiConstraint getMinSdkVersions() {
            AndroidVersion version2 = this.myAndroidModel.getMinSdkVersion();
            if (version2 != null) {
                return ApiConstraint.get((int)version2.getFeatureLevel(), (int)0);
            }
            return super.getMinSdkVersions();
        }

        public AndroidVersion getTargetSdkVersion() {
            AndroidVersion version2 = this.myAndroidModel.getTargetSdkVersion();
            if (version2 != null) {
                return version2;
            }
            return super.getTargetSdkVersion();
        }
    }

    private static class LintAndroidProject
    extends LintIdeProject.LintModuleProject {
        protected final AndroidFacet myFacet;

        private LintAndroidProject(LintClient client2, File dir, File referenceDir, AndroidFacet facet2) {
            super(client2, dir, referenceDir, facet2.getMainModule());
            this.myFacet = facet2;
            this.gradleProject = false;
            this.library = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).isLibraryProject();
            AndroidPlatform platform = AndroidPlatforms.getInstance(this.myFacet.getMainModule());
            if (platform != null) {
                this.buildSdk = platform.getApiLevel();
            }
        }

        public boolean isAndroidProject() {
            return true;
        }

        public String getName() {
            return this.myFacet.getHolderModule().getName();
        }

        public LintModelModuleType getType() {
            return LintModelFactory.getModuleType(((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType());
        }

        public List<File> getManifestFiles() {
            if (this.manifestFiles == null) {
                VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(this.myFacet);
                this.manifestFiles = manifestFile != null ? Collections.singletonList(VfsUtilCore.virtualToIoFile((VirtualFile)manifestFile)) : Collections.emptyList();
            }
            return this.manifestFiles;
        }

        public List<File> getProguardFiles() {
            if (this.proguardFiles == null) {
                List urls;
                AndroidFacetProperties properties2 = this.myFacet.getProperties();
                if (properties2.RUN_PROGUARD && !(urls = properties2.myProGuardCfgFiles).isEmpty()) {
                    this.proguardFiles = new ArrayList();
                    for (String osPath : AndroidUtils.urlsToOsPaths(urls, null)) {
                        if (osPath.contains("%MODULE_SDK_HOME%")) continue;
                        this.proguardFiles.add(new File(osPath));
                    }
                }
                if (this.proguardFiles == null) {
                    this.proguardFiles = Collections.emptyList();
                }
            }
            return this.proguardFiles;
        }

        public List<File> getResourceFolders() {
            if (this.resourceFolders == null) {
                List<VirtualFile> folders = ResourceFolderManager.getInstance(this.myFacet).getFolders();
                ArrayList dirs2 = Lists.newArrayListWithExpectedSize((int)folders.size());
                for (VirtualFile folder : folders) {
                    dirs2.add(VfsUtilCore.virtualToIoFile((VirtualFile)folder));
                }
                this.resourceFolders = dirs2;
            }
            return this.resourceFolders;
        }

        @Nullable
        public Boolean dependsOn(String artifact) {
            GradleCoordinate queryCoordinate = GradleCoordinate.parseCoordinateString((String)(artifact + ":+"));
            if (queryCoordinate != null) {
                String newArtifact;
                GradleCoordinate foundDependency = ProjectSystemUtil.getModuleSystem(this.myFacet.getModule()).getResolvedDependency(queryCoordinate);
                if (foundDependency != null) {
                    return Boolean.TRUE;
                }
                if (artifact.startsWith("com.android.support") && !(newArtifact = AndroidxNameUtils.getCoordinateMapping((String)artifact)).equals(artifact) && (queryCoordinate = GradleCoordinate.parseCoordinateString((String)(newArtifact + ":+"))) != null && (foundDependency = ProjectSystemUtil.getModuleSystem(this.myFacet.getModule()).getResolvedDependency(queryCoordinate)) != null) {
                    return Boolean.TRUE;
                }
            }
            return super.dependsOn(artifact);
        }
    }

    private static class LintGradleLibraryProject
    extends LintModelModuleAndroidLibraryProject {
        private LintGradleLibraryProject(LintClient client2, File dir, File referenceDir, LintModelDependency dependency, LintModelAndroidLibrary library) {
            super(client2, dir, referenceDir, dependency, library);
        }

        @NotNull
        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }
    }
}

