/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.manifmerger.Actions;
import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.repository.api.RemotePackage;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.editors.manifest.ManifestUtils;
import com.android.tools.idea.gradle.repositories.IdeGoogleMavenRepository;
import com.android.tools.idea.lint.SdkManagerPlatformLookup;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintResult;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.projectsystem.gradle.IdeGooglePlaySdkIndexKt;
import com.android.tools.idea.res.FileResourceReader;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.PlatformLookup;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.res.FrameworkResourceRepositoryManager;
import com.android.tools.sdk.AndroidSdkData;
import com.android.utils.Pair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.StudioAndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;

public class AndroidLintIdeClient
extends LintIdeClient {
    protected static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.lint.AndroidLintIdeClient");
    protected com.intellij.openapi.project.Project myProject;
    private AndroidSdkHandler sdk = null;
    @Nullable
    private PlatformLookup platformLookup = null;
    private static final String MERGED_MANIFEST_INFO = "lint-merged-manifest-info";

    public AndroidLintIdeClient(com.intellij.openapi.project.Project project, @NotNull LintResult lintResult) {
        super(project, lintResult);
        this.myProject = project;
    }

    @Nullable
    public Version getHighestKnownVersion(GradleCoordinate coordinate, @Nullable Predicate<Version> filter2) {
        GradleCoordinate found;
        AndroidSdkHandler sdkHandler = this.getSdk();
        if (sdkHandler == null) {
            return null;
        }
        StudioLoggerProgressIndicator logger2 = new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass());
        RemotePackage sdkPackage = SdkMavenRepository.findLatestRemoteVersion((GradleCoordinate)coordinate, (AndroidSdkHandler)sdkHandler, filter2, (ProgressIndicator)logger2);
        if (sdkPackage != null && (found = SdkMavenRepository.getCoordinateFromSdkPath((String)sdkPackage.getPath())) != null) {
            return found.getLowerBoundVersion();
        }
        return null;
    }

    @NotNull
    public byte[] readBytes(@NotNull PathString resourcePath) throws IOException {
        ProgressManager.checkCanceled();
        return FileResourceReader.readBytes(resourcePath);
    }

    @Nullable
    public File getSdkHome() {
        File home;
        String path2;
        Sdk moduleSdk;
        Module module2 = this.getModule();
        if (module2 != null && (moduleSdk = ModuleRootManager.getInstance((Module)module2).getSdk()) != null && moduleSdk.getSdkType() instanceof AndroidSdkType && (path2 = moduleSdk.getHomePath()) != null && (home = new File(path2)).exists()) {
            return home;
        }
        File sdkHome = super.getSdkHome();
        if (sdkHome != null) {
            return sdkHome;
        }
        for (Module m : ModuleManager.getInstance((com.intellij.openapi.project.Project)this.myProject).getModules()) {
            File home2;
            String path3;
            Sdk moduleSdk2 = ModuleRootManager.getInstance((Module)m).getSdk();
            if (moduleSdk2 == null || !(moduleSdk2.getSdkType() instanceof AndroidSdkType) || (path3 = moduleSdk2.getHomePath()) == null || !(home2 = new File(path3)).exists()) continue;
            return home2;
        }
        return IdeSdks.getInstance().getAndroidSdkPath();
    }

    @Nullable
    public PlatformLookup getPlatformLookup() {
        if (this.platformLookup == null) {
            AndroidSdkHandler handler2 = this.getSdk();
            if (handler2 != null) {
                StudioLoggerProgressIndicator logger2 = new StudioLoggerProgressIndicator(AndroidLintIdeClient.class);
                this.platformLookup = new SdkManagerPlatformLookup(handler2, (ProgressIndicatorAdapter)logger2);
            } else {
                this.platformLookup = super.getPlatformLookup();
            }
        }
        return this.platformLookup;
    }

    @Nullable
    protected AndroidSdkHandler getSdk() {
        if (this.sdk == null) {
            Module module2 = this.getModule();
            AndroidSdkHandler localSdk = AndroidLintIdeClient.getLocalSdk(module2);
            if (localSdk != null) {
                this.sdk = localSdk;
            } else {
                File sdkHome;
                for (Module m : ModuleManager.getInstance((com.intellij.openapi.project.Project)this.myProject).getModules()) {
                    localSdk = AndroidLintIdeClient.getLocalSdk(m);
                    if (localSdk == null) continue;
                    this.sdk = localSdk;
                    break;
                }
                if (localSdk == null && (sdkHome = this.getSdkHome()) != null) {
                    this.sdk = AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, (Path)sdkHome.toPath());
                }
            }
        }
        return this.sdk;
    }

    @Nullable
    private static AndroidSdkHandler getLocalSdk(@Nullable Module module2) {
        AndroidSdkData sdkData;
        AndroidFacet facet2;
        if (module2 != null && (facet2 = AndroidFacet.getInstance((Module)module2)) != null && (sdkData = StudioAndroidSdkData.getSdkData(facet2)) != null) {
            return sdkData.getSdkHandler();
        }
        return null;
    }

    public boolean isGradleProject(@NotNull Project project) {
        Module module2 = this.getModule(project);
        if (module2 != null) {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
            return facet2 != null && AndroidModel.isRequired(facet2);
        }
        return ProjectSystemUtil.requiresAndroidModel(this.myProject);
    }

    @Nullable
    public File getCacheDir(@Nullable String name2, boolean create2) {
        if ("maven.google".equals(name2)) {
            Path cacheDir = IdeGoogleMavenRepository.INSTANCE.getCacheDir();
            return cacheDir == null ? null : cacheDir.toFile();
        }
        if ("sdk_index".equals(name2)) {
            Path cacheDir = IdeGooglePlaySdkIndexKt.getCacheDir();
            return cacheDir == null ? null : cacheDir.toFile();
        }
        return super.getCacheDir(name2, create2);
    }

    @Nullable
    public Document getMergedManifest(Project project) {
        MergedManifestSnapshot mergedManifest;
        Document document2;
        Module module2 = this.findModuleForLintProject(this.myProject, project);
        if (module2 != null && (document2 = (mergedManifest = MergedManifestManager.getFreshSnapshot(module2)).getDocument()) != null) {
            Element root = document2.getDocumentElement();
            if (root != null && !this.isMergeManifestNode(root)) {
                this.resolveMergeManifestSources(document2, project.getDir());
                document2.setUserData(MERGED_MANIFEST_INFO, mergedManifest, null);
            }
            return document2;
        }
        return null;
    }

    @Nullable
    public Pair<File, ? extends Node> findManifestSourceNode(Node mergedNode) {
        Map sourceNodeCache = this.getSourceNodeCache();
        Pair source = (Pair)sourceNodeCache.get(mergedNode);
        if (source != null) {
            if (source == NOT_FOUND) {
                return null;
            }
            return source;
        }
        Document doc = mergedNode.getOwnerDocument();
        if (doc == null) {
            return null;
        }
        MergedManifestSnapshot mergedManifest = (MergedManifestSnapshot)doc.getUserData(MERGED_MANIFEST_INFO);
        if (mergedManifest == null) {
            return null;
        }
        source = NOT_FOUND;
        List<? extends Actions.Record> records = ManifestUtils.getRecords(mergedManifest, mergedNode);
        for (Actions.Record record : records) {
            Node sourceNode;
            if (record.getActionType() != Actions.ActionType.ADDED && record.getActionType() != Actions.ActionType.MERGED || (sourceNode = ManifestUtils.getSourceNode(mergedManifest.getModule(), record)) == null) continue;
            File file2 = record.getActionLocation().getFile().getSourceFile();
            source = Pair.of((Object)file2, (Object)sourceNode);
            break;
        }
        if (source == NOT_FOUND && mergedNode.getNodeType() == 1) {
            for (Actions.Record record : records) {
                File file3 = record.getActionLocation().getFile().getSourceFile();
                if (file3 == null) continue;
                try {
                    Element sourceNode;
                    Document document2 = this.getXmlParser().parseXml(file3);
                    if (document2 == null || (sourceNode = Lint.matchXmlElement((Element)((Element)mergedNode), (Document)document2)) == null) continue;
                    source = Pair.of((Object)file3, (Object)sourceNode);
                    break;
                }
                catch (Throwable e) {
                    this.log(e, "Can't parse %1$s", new Object[]{file3});
                }
            }
        }
        sourceNodeCache.put(mergedNode, source);
        return source != NOT_FOUND ? source : null;
    }

    @NotNull
    public Set<Desugaring> getDesugaring(@NotNull Project project) {
        Module module2 = this.getModule(project);
        if (module2 == null) {
            return Desugaring.DEFAULT;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return Desugaring.DEFAULT;
        }
        AndroidModel model2 = AndroidModel.get(module2);
        if (model2 == null) {
            return Desugaring.DEFAULT;
        }
        return model2.getDesugaring();
    }

    public Iterable<File> findRuleJars(@NotNull Project project) {
        Iterable<File> lintRuleJars;
        AndroidModel model2;
        Module module2 = this.getModule(project);
        if (module2 != null && (model2 = AndroidModel.get(module2)) != null && (lintRuleJars = model2.getLintRuleJarsOverride()) != null) {
            return lintRuleJars;
        }
        return super.findRuleJars(project);
    }

    public List<File> getResourceFolders(Project project) {
        Module module2 = this.getModule(project);
        if (module2 == null) {
            return super.getResourceFolders(project);
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 != null) {
            return AndroidLintIdeClient.getResourceFolders(facet2);
        }
        return super.getResourceFolders(project);
    }

    @NotNull
    public static List<File> getResourceFolders(@NotNull AndroidFacet facet2) {
        ArrayList<File> resDirectories = new ArrayList<File>();
        IdeaSourceProvider sourceProvider = SourceProviderManager.getInstance(facet2).getSources();
        for (VirtualFile resDirectory : sourceProvider.getResDirectories()) {
            resDirectories.add(VfsUtilCore.virtualToIoFile((VirtualFile)resDirectory));
        }
        return resDirectories;
    }

    public ResourceRepository getResources(Project project, ResourceRepositoryScope scope2) {
        AndroidFacet facet2;
        Module module2 = this.findModuleForLintProject(this.myProject, project);
        if (module2 != null && (facet2 = AndroidFacet.getInstance((Module)module2)) != null) {
            if (scope2 == ResourceRepositoryScope.ANDROID) {
                IAndroidTarget target2 = project.getBuildTarget();
                if (target2 != null) {
                    return FrameworkResourceRepositoryManager.getInstance().getFrameworkResources(target2.getPath(11), false, Collections.emptySet());
                }
                return super.getResources(project, scope2);
            }
            if (scope2.includesLibraries()) {
                return StudioResourceRepositoryManager.getAppResources(facet2);
            }
            if (scope2.includesDependencies()) {
                return StudioResourceRepositoryManager.getProjectResources(facet2);
            }
            return StudioResourceRepositoryManager.getModuleResources(facet2);
        }
        return super.getResources(project, scope2);
    }

    public Location.ResourceItemHandle createResourceItemHandle(ResourceItem item2, boolean nameOnly, boolean valueOnly) {
        XmlTag tag = IdeResourcesUtil.getItemTag(this.myProject, item2);
        if (tag != null) {
            PathString source = item2.getSource();
            assert (source != null) : item2;
            File file2 = source.toFile();
            assert (file2 != null) : item2;
            return new LocationHandle(file2, item2, (XmlElement)tag, nameOnly, valueOnly);
        }
        return super.createResourceItemHandle(item2, nameOnly, valueOnly);
    }

    @Nullable
    public XmlPullParser createXmlPullParser(@NotNull PathString resourcePath) throws IOException {
        ProgressManager.checkCanceled();
        return FileResourceReader.createXmlPullParser(resourcePath);
    }

    private class LocationHandle
    extends Location.ResourceItemHandle
    implements Location.Handle,
    Computable<Location> {
        private final File myFile;
        private final XmlElement myNode;
        private final boolean myNameOnly;
        private final boolean myValueOnly;
        private Object myClientData;

        LocationHandle(File file2, ResourceItem item2, XmlElement node, boolean nameOnly, boolean valueOnly) {
            super((LintClient)AndroidLintIdeClient.this, item2, nameOnly, valueOnly);
            this.myNameOnly = nameOnly;
            this.myValueOnly = valueOnly;
            this.myFile = file2;
            this.myNode = node;
        }

        public Location resolve() {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (Location)ApplicationManager.getApplication().runReadAction((Computable)this);
            }
            TextRange textRange = this.myNode.getTextRange();
            if (this.myNode instanceof XmlTag) {
                XmlTag element2 = (XmlTag)this.myNode;
                if (this.myNameOnly) {
                    XmlAttribute attribute2 = element2.getAttribute("name");
                    if (attribute2 != null) {
                        textRange = attribute2.getValueTextRange();
                    }
                } else if (this.myValueOnly) {
                    XmlTagValue value2 = element2.getValue();
                    textRange = value2.getTextRange();
                } else {
                    String tag = element2.getName();
                    int index2 = this.myNode.getText().indexOf(tag);
                    if (index2 != -1) {
                        int start2 = textRange.getStartOffset() + index2;
                        textRange = new TextRange(start2, start2 + tag.length());
                    }
                }
            }
            DefaultPosition start3 = new DefaultPosition(-1, -1, textRange.getStartOffset());
            DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
            return Location.create((File)this.myFile, (Position)start3, (Position)end);
        }

        public Location compute() {
            return this.resolve();
        }

        public void setClientData(@Nullable Object clientData) {
            this.myClientData = clientData;
        }

        @Nullable
        public Object getClientData() {
            return this.myClientData;
        }
    }
}

