/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui.toolbar.actions;

import com.android.tools.idea.appinspection.api.process.ProcessesModel;
import com.android.tools.idea.appinspection.ide.ui.SelectProcessAction;
import com.android.tools.idea.appinspection.ide.ui.SelectProcessActionKt;
import com.android.tools.idea.appinspection.inspector.api.process.DeviceDescriptor;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.DeviceModel;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetection;
import com.android.tools.idea.layoutinspector.settings.LayoutInspectorSettings;
import com.android.tools.idea.layoutinspector.ui.toolbar.actions.DropDownActionWithButton;
import com.android.tools.idea.layoutinspector.ui.toolbar.actions.SelectDeviceAction;
import com.android.tools.idea.layoutinspector.ui.toolbar.actions.TargetSelectionActionFactoryKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/toolbar/actions/TargetSelectionActionFactory;", "", "()V", "deviceAttribution", "", "device", "Lcom/android/tools/idea/appinspection/inspector/api/process/DeviceDescriptor;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getAction", "Lcom/android/tools/idea/layoutinspector/ui/toolbar/actions/DropDownActionWithButton;", "layoutInspector", "Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "getDeviceSelectorAction", "Lcom/android/tools/idea/layoutinspector/ui/toolbar/actions/SelectDeviceAction;", "getProcessSelectorAction", "Lcom/android/tools/idea/appinspection/ide/ui/SelectProcessAction;", "intellij.android.layout-inspector"})
public final class TargetSelectionActionFactory {
    @NotNull
    public static final TargetSelectionActionFactory INSTANCE = new TargetSelectionActionFactory();

    private TargetSelectionActionFactory() {
    }

    @Nullable
    public final DropDownActionWithButton getAction(@NotNull LayoutInspector layoutInspector) {
        DropDownActionWithButton dropDownActionWithButton;
        Intrinsics.checkNotNullParameter((Object)layoutInspector, (String)"layoutInspector");
        if (LayoutInspectorSettings.Companion.getInstance().getAutoConnectEnabled()) {
            SelectDeviceAction selectDeviceAction = this.getDeviceSelectorAction(layoutInspector);
            if (selectDeviceAction == null) {
                return null;
            }
            SelectDeviceAction action2 = selectDeviceAction;
            dropDownActionWithButton = new DropDownActionWithButton(action2, (Function0<? extends JComponent>)((Function0)new Function0<JComponent>(action2){
                final /* synthetic */ SelectDeviceAction $action;
                {
                    this.$action = $action;
                    super(0);
                }

                @Nullable
                public final JComponent invoke() {
                    return this.$action.getButton();
                }
            }));
        } else {
            SelectProcessAction selectProcessAction = this.getProcessSelectorAction(layoutInspector);
            if (selectProcessAction == null) {
                return null;
            }
            SelectProcessAction action3 = selectProcessAction;
            dropDownActionWithButton = new DropDownActionWithButton(action3, (Function0<? extends JComponent>)((Function0)new Function0<JComponent>(action3){
                final /* synthetic */ SelectProcessAction $action;
                {
                    this.$action = $action;
                    super(0);
                }

                @Nullable
                public final JComponent invoke() {
                    return this.$action.getButton();
                }
            }));
        }
        return dropDownActionWithButton;
    }

    private final SelectProcessAction getProcessSelectorAction(LayoutInspector layoutInspector) {
        ProcessesModel processesModel = layoutInspector.getProcessModel();
        if (processesModel == null) {
            return null;
        }
        ProcessesModel model2 = processesModel;
        return new SelectProcessAction(model2, false, (Function1)new Function1<ProcessDescriptor, String>((Object)SelectProcessAction.Companion){

            @NotNull
            public final String invoke(@NotNull ProcessDescriptor p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((SelectProcessAction.Companion)this.receiver).createCompactProcessLabel(p0);
            }
        }, new SelectProcessAction.StopPresentation("Stop Inspector", "Stop running the layout inspector against the current process"), (Function1)new Function1<ProcessDescriptor, Unit>(layoutInspector){
            final /* synthetic */ LayoutInspector $layoutInspector;
            {
                this.$layoutInspector = $layoutInspector;
                super(1);
            }

            public final void invoke(@NotNull ProcessDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$layoutInspector.stopInspector();
            }
        }, (Function2)new Function2<DeviceDescriptor, AnActionEvent, Unit>((Object)INSTANCE){

            public final void invoke(@NotNull DeviceDescriptor p0, @NotNull AnActionEvent p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                TargetSelectionActionFactory.access$deviceAttribution((TargetSelectionActionFactory)this.receiver, p0, p1);
            }
        }, null, 64, null);
    }

    private final SelectDeviceAction getDeviceSelectorAction(LayoutInspector layoutInspector) {
        DeviceModel deviceModel = layoutInspector.getDeviceModel();
        if (deviceModel == null) {
            return null;
        }
        DeviceModel model2 = deviceModel;
        return new SelectDeviceAction(model2, (Function1)new Function1<DeviceDescriptor, Unit>(layoutInspector){
            final /* synthetic */ LayoutInspector $layoutInspector;
            {
                this.$layoutInspector = $layoutInspector;
                super(1);
            }

            public final void invoke(@NotNull DeviceDescriptor newDevice) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)newDevice, (String)"newDevice");
                    ForegroundProcessDetection foregroundProcessDetection = this.$layoutInspector.getForegroundProcessDetection();
                    if (foregroundProcessDetection == null) break block0;
                    foregroundProcessDetection.startPollingDevice(newDevice);
                }
            }
        }, (Function1)new Function1<ProcessDescriptor, Unit>(layoutInspector){
            final /* synthetic */ LayoutInspector $layoutInspector;
            {
                this.$layoutInspector = $layoutInspector;
                super(1);
            }

            public final void invoke(@NotNull ProcessDescriptor newProcess) {
                Intrinsics.checkNotNullParameter((Object)newProcess, (String)"newProcess");
                ProcessesModel processesModel = this.$layoutInspector.getProcessModel();
                if (processesModel != null) {
                    processesModel.setSelectedProcess(newProcess);
                }
            }
        }, null, (Function0)new Function0<Unit>(layoutInspector){
            final /* synthetic */ LayoutInspector $layoutInspector;
            {
                this.$layoutInspector = $layoutInspector;
                super(0);
            }

            public final void invoke() {
                this.$layoutInspector.stopInspector();
            }
        }, (Function2)new Function2<DeviceDescriptor, AnActionEvent, Unit>((Object)INSTANCE){

            public final void invoke(@NotNull DeviceDescriptor p0, @NotNull AnActionEvent p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                TargetSelectionActionFactory.access$deviceAttribution((TargetSelectionActionFactory)this.receiver, p0, p1);
            }
        }, 8, null);
    }

    private final void deviceAttribution(DeviceDescriptor device2, AnActionEvent event2) {
        if (device2.getApiLevel() < 23) {
            event2.getPresentation().setEnabled(false);
            event2.getPresentation().setText(SelectProcessActionKt.buildDeviceName(device2) + " (Unsupported for API < 23)");
        } else if (device2.getApiLevel() < 29) {
            event2.getPresentation().setIcon((Icon)TargetSelectionActionFactoryKt.access$toLegacyIcon(device2));
            event2.getPresentation().setText(SelectProcessActionKt.buildDeviceName(device2) + " (Live inspection disabled for API < 29)");
        }
    }

    public static final /* synthetic */ void access$deviceAttribution(TargetSelectionActionFactory $this, DeviceDescriptor device2, AnActionEvent event2) {
        $this.deviceAttribution(device2, event2);
    }
}

