/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.layoutinspector.ui.HighlightColorAction;
import com.android.tools.idea.layoutinspector.ui.RenderModel;
import com.android.tools.idea.layoutinspector.ui.RenderModelKt;
import com.android.tools.idea.layoutinspector.ui.RenderSettings;
import com.android.tools.idea.layoutinspector.ui.RenderSettingsKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import icons.StudioIcons;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/ViewMenuAction;", "Lcom/android/tools/adtui/actions/DropDownAction;", "()V", "canBePerformed", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "SettingsAction", "intellij.android.layout-inspector"})
public final class ViewMenuAction
extends DropDownAction {
    @NotNull
    public static final ViewMenuAction INSTANCE = new ViewMenuAction();

    private ViewMenuAction() {
        super(null, "View Options", StudioIcons.Common.VISIBILITY_INLINE);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        RenderModel renderModel = (RenderModel)e.getData(RenderModelKt.getDEVICE_VIEW_MODEL_KEY());
        if (renderModel == null) {
            return;
        }
        boolean enabled2 = renderModel.isActive();
        JComponent jComponent = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (jComponent != null) {
            jComponent.setEnabled(enabled2);
        }
    }

    public boolean canBePerformed(@NotNull DataContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        RenderModel renderModel = (RenderModel)context2.getData(RenderModelKt.getDEVICE_VIEW_MODEL_KEY());
        return renderModel != null ? renderModel.isActive() : false;
    }

    static {
        INSTANCE.add((AnAction)new SettingsAction("Show Borders", (KMutableProperty1<RenderSettings, Boolean>)((KMutableProperty1)1.INSTANCE)));
        INSTANCE.add((AnAction)new SettingsAction("Show Layout Bounds", (KMutableProperty1<RenderSettings, Boolean>)((KMutableProperty1)2.INSTANCE)));
        INSTANCE.add((AnAction)new SettingsAction("Show View Label", (KMutableProperty1<RenderSettings, Boolean>)((KMutableProperty1)3.INSTANCE)));
        INSTANCE.add((AnAction)new SettingsAction("Show Fold Hinge and Angle", (KMutableProperty1<RenderSettings, Boolean>)((KMutableProperty1)4.INSTANCE)));
        INSTANCE.add((AnAction)HighlightColorAction.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/ViewMenuAction$SettingsAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "name", "", "property", "Lkotlin/reflect/KMutableProperty1;", "Lcom/android/tools/idea/layoutinspector/ui/RenderSettings;", "", "(Ljava/lang/String;Lkotlin/reflect/KMutableProperty1;)V", "getProperty", "()Lkotlin/reflect/KMutableProperty1;", "isSelected", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.android.layout-inspector"})
    @SourceDebugExtension(value={"SMAP\nViewMenuAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewMenuAction.kt\ncom/android/tools/idea/layoutinspector/ui/ViewMenuAction$SettingsAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
    public static final class SettingsAction
    extends ToggleAction {
        @NotNull
        private final KMutableProperty1<RenderSettings, Boolean> property;

        public SettingsAction(@NotNull String name2, @NotNull KMutableProperty1<RenderSettings, Boolean> property2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(property2, (String)"property");
            super(name2);
            this.property = property2;
        }

        @NotNull
        public final KMutableProperty1<RenderSettings, Boolean> getProperty() {
            return this.property;
        }

        public boolean isSelected(@NotNull AnActionEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            RenderSettings renderSettings = (RenderSettings)event2.getData(RenderSettingsKt.getDEVICE_VIEW_SETTINGS_KEY());
            if (renderSettings != null) {
                RenderSettings settings = renderSettings;
                boolean bl = false;
                return (Boolean)this.property.get((Object)settings);
            }
            return false;
        }

        public void setSelected(@NotNull AnActionEvent event2, boolean state2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                RenderSettings renderSettings = (RenderSettings)event2.getData(RenderSettingsKt.getDEVICE_VIEW_SETTINGS_KEY());
                if (renderSettings == null) break block0;
                RenderSettings settings = renderSettings;
                boolean bl = false;
                this.property.set((Object)settings, (Object)state2);
            }
        }
    }
}

