/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.idea.layoutinspector.metrics.statistics.SessionStatistics;
import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.DrawViewNode;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.android.tools.idea.layoutinspector.ui.LevelListItem;
import com.android.tools.idea.layoutinspector.ui.RenderModel;
import com.android.tools.idea.layoutinspector.ui.ViewDrawInfo;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\b\u0002\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u001c\u0010J\u001a\b\u0012\u0004\u0012\u00020\f0K2\u0006\u0010L\u001a\u00020B2\u0006\u0010M\u001a\u00020BJ\u0018\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010L\u001a\u00020B2\u0006\u0010M\u001a\u00020BJ\u001c\u0010P\u001a\b\u0012\u0004\u0012\u00020O0K2\u0006\u0010L\u001a\u00020B2\u0006\u0010M\u001a\u00020BJ\u0006\u0010Q\u001a\u00020.JB\u0010R\u001a\u00020.2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020B2\u0006\u0010V\u001a\u00020B2\u0012\u0010W\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020X0\u000b0\u000b2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\f0-H\u0002J\u0006\u0010Z\u001a\u00020.J\u0006\u0010[\u001a\u00020.J\u0016\u0010\\\u001a\u00020.2\u0006\u0010]\u001a\u00020B2\u0006\u0010^\u001a\u00020BJ\u0018\u0010_\u001a\u00020\u001a2\u0006\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020aH\u0007J6\u0010c\u001a\u00020.*\u00020d2\f\u0010e\u001a\b\u0012\u0004\u0012\u00020f0K2\u0012\u0010g\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020X0-0-2\u0006\u0010h\u001a\u00020\u001dH\u0002J,\u0010i\u001a\b\u0012\u0004\u0012\u0002Hj0-\"\u0004\b\u0000\u0010j*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hj0-0-2\u0006\u0010k\u001a\u00020\u001dH\u0002J\u001e\u0010l\u001a\u00020\u001a*\u00020f2\u0006\u0010m\u001a\u00020f2\b\b\u0002\u0010n\u001a\u00020\u001aH\u0002J\u0014\u0010o\u001a\u00020\u001a*\u00020=2\u0006\u0010m\u001a\u00020=H\u0002J\u0014\u0010o\u001a\u00020\u001a*\u00020a2\u0006\u0010m\u001a\u00020=H\u0002J\u0014\u0010o\u001a\u00020\u001a*\u00020a2\u0006\u0010m\u001a\u00020aH\u0002R\u0018\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R(\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001bR$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u001d@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020\u001d8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b%\u0010\u000e\u001a\u0004\b&\u0010 R\u001a\u0010'\u001a\u00020\u001d8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b(\u0010\u000e\u001a\u0004\b)\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001d\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u00070-\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0010R(\u00101\u001a\u0004\u0018\u0001002\b\u0010\u0013\u001a\u0004\u0018\u000100@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R$\u00107\u001a\u0002062\u0006\u0010\u0013\u001a\u000206@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u000e\u0010<\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u000e\u0010@\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010A\u001a\u00020BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u001a\u0010G\u001a\u00020BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010D\"\u0004\bI\u0010F\u00a8\u0006p"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/RenderModel;", "", "model", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "treeSettings", "Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "client", "Lkotlin/Function0;", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "(Lcom/android/tools/idea/layoutinspector/model/InspectorModel;Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;Lkotlin/jvm/functions/Function0;)V", "hitRects", "", "Lcom/android/tools/idea/layoutinspector/ui/ViewDrawInfo;", "getHitRects$annotations", "()V", "getHitRects", "()Ljava/util/List;", "setHitRects", "(Ljava/util/List;)V", "value", "hoveredDrawInfo", "getHoveredDrawInfo", "()Lcom/android/tools/idea/layoutinspector/ui/ViewDrawInfo;", "setHoveredDrawInfo", "(Lcom/android/tools/idea/layoutinspector/ui/ViewDrawInfo;)V", "isActive", "", "()Z", "isRotated", "", "layerSpacing", "getLayerSpacing", "()I", "setLayerSpacing", "(I)V", "maxDepth", "maxHeight", "getMaxHeight$annotations", "getMaxHeight", "maxWidth", "getMaxWidth$annotations", "getMaxWidth", "getModel", "()Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "modificationListeners", "", "", "getModificationListeners", "Ljava/awt/Image;", "overlay", "getOverlay", "()Ljava/awt/Image;", "setOverlay", "(Ljava/awt/Image;)V", "", "overlayAlpha", "getOverlayAlpha", "()F", "setOverlayAlpha", "(F)V", "rootBounds", "Ljava/awt/Rectangle;", "getTreeSettings", "()Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "visibleBounds", "xOff", "", "getXOff", "()D", "setXOff", "(D)V", "yOff", "getYOff", "setYOff", "findDrawInfoAt", "Lkotlin/sequences/Sequence;", "x", "y", "findTopViewAt", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "findViewsAt", "fireModified", "rebuildRectsForLevel", "transform", "Ljava/awt/geom/AffineTransform;", "magnitude", "angle", "allLevels", "Lcom/android/tools/idea/layoutinspector/ui/LevelListItem;", "newHitRects", "refresh", "resetRotation", "rotate", "xRotation", "yRotation", "testOverlap", "shape1", "Ljava/awt/Shape;", "shape2", "buildLevelLists", "Lcom/android/tools/idea/layoutinspector/model/ViewNode$ReadAccess;", "nodes", "Lcom/android/tools/idea/layoutinspector/model/DrawViewNode;", "levelListCollector", "minLevel", "getOrAddSublist", "T", "index", "intersects", "other", "useTransitiveBounds", "overlap", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nRenderModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderModel.kt\ncom/android/tools/idea/layoutinspector/ui/RenderModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,376:1\n1851#2,2:377\n1851#2,2:379\n1851#2,2:382\n1851#2,2:384\n350#2,3:386\n1743#2,3:389\n353#2,4:392\n378#2,3:397\n1743#2,3:400\n381#2,4:403\n1743#2,3:407\n766#2:410\n857#2,2:411\n378#2,3:413\n1743#2,3:416\n381#2,4:419\n1620#2,3:423\n1860#2,2:426\n1851#2:428\n1852#2:436\n1862#2:437\n1851#2,2:438\n614#3:381\n1#4:396\n359#5,7:429\n*S KotlinDebug\n*F\n+ 1 RenderModel.kt\ncom/android/tools/idea/layoutinspector/ui/RenderModel\n*L\n103#1:377,2\n109#1:379,2\n166#1:382,2\n216#1:384,2\n250#1:386,3\n250#1:389,3\n250#1:392,4\n267#1:397,3\n267#1:400,3\n267#1:403,4\n270#1:407,3\n286#1:410\n286#1:411,2\n293#1:413,3\n293#1:416,3\n293#1:419,4\n294#1:423,3\n346#1:426,2\n347#1:428\n347#1:436\n346#1:437\n374#1:438,2\n149#1:381\n348#1:429,7\n*E\n"})
public final class RenderModel {
    @NotNull
    private final InspectorModel model;
    @NotNull
    private final TreeSettings treeSettings;
    @Nullable
    private final Function0<InspectorClient> client;
    @Nullable
    private ViewDrawInfo hoveredDrawInfo;
    private double xOff;
    private double yOff;
    @NotNull
    private Rectangle visibleBounds;
    private int maxDepth;
    @NotNull
    private List<ViewDrawInfo> hitRects;
    @NotNull
    private final List<Function0<Unit>> modificationListeners;
    @Nullable
    private Image overlay;
    private float overlayAlpha;
    private int layerSpacing;
    @NotNull
    private Rectangle rootBounds;

    public RenderModel(@NotNull InspectorModel model2, @NotNull TreeSettings treeSettings2, @Nullable Function0<? extends InspectorClient> client2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)treeSettings2, (String)"treeSettings");
        this.model = model2;
        this.treeSettings = treeSettings2;
        this.client = client2;
        this.visibleBounds = new Rectangle();
        this.hitRects = CollectionsKt.emptyList();
        this.modificationListeners = new ArrayList();
        this.overlayAlpha = 0.6f;
        this.layerSpacing = 150;
        this.rootBounds = new Rectangle();
        this.model.getModificationListeners().add((Object)new Function3<AndroidWindow, AndroidWindow, Boolean, Unit>(){

            public final void invoke(@Nullable AndroidWindow androidWindow, @Nullable AndroidWindow androidWindow2, boolean bl) {
                Object object;
                if (androidWindow2 == null) {
                    this.setOverlay(null);
                }
                if (!((object = client) != null && (object = (InspectorClient)object.invoke()) != null && (object = object.getCapabilities()) != null ? object.contains((Object)InspectorClient.Capability.SUPPORTS_SKP) : false)) {
                    this.resetRotation();
                }
            }
        });
        this.refresh();
    }

    public /* synthetic */ RenderModel(InspectorModel inspectorModel, TreeSettings treeSettings2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        this(inspectorModel, treeSettings2, (Function0<? extends InspectorClient>)function0);
    }

    @NotNull
    public final InspectorModel getModel() {
        return this.model;
    }

    @NotNull
    public final TreeSettings getTreeSettings() {
        return this.treeSettings;
    }

    @Nullable
    public final ViewDrawInfo getHoveredDrawInfo() {
        return this.hoveredDrawInfo;
    }

    public final void setHoveredDrawInfo(@Nullable ViewDrawInfo value2) {
        if (!Intrinsics.areEqual((Object)this.hoveredDrawInfo, (Object)value2)) {
            this.hoveredDrawInfo = value2;
            this.fireModified();
        }
    }

    public final double getXOff() {
        return this.xOff;
    }

    public final void setXOff(double d) {
        this.xOff = d;
    }

    public final double getYOff() {
        return this.yOff;
    }

    public final void setYOff(double d) {
        this.yOff = d;
    }

    public final int getMaxWidth() {
        return (int)Math.hypot(this.maxDepth * this.layerSpacing, this.visibleBounds.width);
    }

    @VisibleForTesting
    public static /* synthetic */ void getMaxWidth$annotations() {
    }

    public final int getMaxHeight() {
        return (int)Math.hypot(this.maxDepth * this.layerSpacing, this.visibleBounds.height);
    }

    @VisibleForTesting
    public static /* synthetic */ void getMaxHeight$annotations() {
    }

    public final boolean isRotated() {
        return !(this.xOff == 0.0) || !(this.yOff == 0.0);
    }

    @NotNull
    public final List<ViewDrawInfo> getHitRects() {
        return this.hitRects;
    }

    public final void setHitRects(@NotNull List<ViewDrawInfo> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.hitRects = list2;
    }

    @VisibleForTesting
    public static /* synthetic */ void getHitRects$annotations() {
    }

    @NotNull
    public final List<Function0<Unit>> getModificationListeners() {
        return this.modificationListeners;
    }

    @Nullable
    public final Image getOverlay() {
        return this.overlay;
    }

    public final void setOverlay(@Nullable Image value2) {
        if (value2 != null) {
            this.resetRotation();
        }
        this.overlay = value2;
        Iterable $this$forEach$iv = this.modificationListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public final float getOverlayAlpha() {
        return this.overlayAlpha;
    }

    public final void setOverlayAlpha(float value2) {
        this.overlayAlpha = value2;
        Iterable $this$forEach$iv = this.modificationListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public final int getLayerSpacing() {
        return this.layerSpacing;
    }

    public final void setLayerSpacing(int value2) {
        this.layerSpacing = value2;
        this.refresh();
    }

    public final boolean isActive() {
        return !this.model.isEmpty();
    }

    @NotNull
    public final Sequence<ViewNode> findViewsAt(double x, double y) {
        return SequencesKt.distinct((Sequence)SequencesKt.mapNotNull(this.findDrawInfoAt(x, y), (Function1)((Function1)new Function1<ViewDrawInfo, ViewNode>(this){
            final /* synthetic */ RenderModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ViewNode invoke(@NotNull ViewDrawInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getNode().findFilteredOwner(this.this$0.getTreeSettings());
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Sequence<ViewDrawInfo> findDrawInfoAt(double x, double y) {
        void $this$sortedByDescending$iv;
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.asReversed(this.hitRects)), (Function1)((Function1)new Function1<ViewDrawInfo, Boolean>(x, y){
            final /* synthetic */ double $x;
            final /* synthetic */ double $y;
            {
                this.$x = $x;
                this.$y = $y;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ViewDrawInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getBounds().contains(this.$x, this.$y);
            }
        }));
        boolean $i$f$sortedByDescending = false;
        return SequencesKt.distinct((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ViewDrawInfo it = (ViewDrawInfo)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getHitLevel());
                it = (ViewDrawInfo)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getHitLevel()));
            }
        }));
    }

    @Nullable
    public final ViewNode findTopViewAt(double x, double y) {
        return (ViewNode)SequencesKt.firstOrNull(this.findViewsAt(x, y));
    }

    public final void rotate(double xRotation, double yRotation) {
        this.xOff = RangesKt.coerceIn((double)(this.xOff + xRotation), (double)-1.0, (double)1.0);
        this.yOff = RangesKt.coerceIn((double)(this.yOff + yRotation), (double)-1.0, (double)1.0);
        this.refresh();
    }

    public final void refresh() {
        Object object = this.client;
        SessionStatistics sessionStatistics = object != null && (object = (InspectorClient)object.invoke()) != null ? object.getStats() : null;
        if (sessionStatistics != null) {
            sessionStatistics.setCurrentMode3D(this.isRotated());
        }
        if (this.model.isEmpty()) {
            this.visibleBounds = new Rectangle();
            this.maxDepth = 0;
            this.hitRects = CollectionsKt.emptyList();
            Iterable $this$forEach$iv = this.modificationListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
            return;
        }
        ViewNode root = this.model.getRoot();
        List levelLists = new ArrayList();
        ViewNode.Companion.readAccess((Function1)new Function1<ViewNode.ReadAccess, Unit>(root, this, (List<List<LevelListItem>>)levelLists){
            final /* synthetic */ ViewNode $root;
            final /* synthetic */ RenderModel this$0;
            final /* synthetic */ List<List<LevelListItem>> $levelLists;
            {
                this.$root = $root;
                this.this$0 = $receiver;
                this.$levelLists = $levelLists;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ViewNode.ReadAccess $this$readAccess) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)$this$readAccess, (String)"$this$readAccess");
                Iterable iterable = $this$readAccess.getDrawChildren(this.$root);
                RenderModel renderModel = this.this$0;
                List<List<LevelListItem>> list2 = this.$levelLists;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DrawViewNode it = (DrawViewNode)element$iv;
                    boolean bl = false;
                    Object[] objectArray = new DrawViewNode[]{it};
                    RenderModel.access$buildLevelLists(renderModel, $this$readAccess, SequencesKt.sequenceOf((Object[])objectArray), list2, list2.size());
                }
            }
        });
        this.maxDepth = levelLists.size();
        List newHitRects = new ArrayList();
        AffineTransform transform2 = new AffineTransform();
        double magnitude = 0.0;
        double angle = 0.0;
        if (this.maxDepth > 0) {
            ViewNode.Companion.readAccess((Function1)new Function1<ViewNode.ReadAccess, Unit>(this){
                final /* synthetic */ RenderModel this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull ViewNode.ReadAccess $this$readAccess) {
                    Rectangle rectangle;
                    Object v2;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    void $this$flatMapTo$iv$iv;
                    Iterable $this$flatMap$iv;
                    Rectangle rectangle2;
                    Rectangle rectangle3;
                    Object accumulator$iv;
                    Object v0;
                    Iterable $this$reduceOrNull$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$readAccess, (String)"$this$readAccess");
                    Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filter($this$readAccess.flatten(this.this$0.getModel().getRoot()), (Function1)((Function1)new Function1<ViewNode, Boolean>(this.this$0){
                        final /* synthetic */ RenderModel this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull ViewNode it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return this.this$0.getModel().isVisible(it);
                        }
                    })), (Function1)refresh.2.INSTANCE);
                    RenderModel renderModel = this.this$0;
                    boolean $i$f$reduceOrNull22 = false;
                    Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v0 = null;
                    } else {
                        accumulator$iv = iterator$iv.next();
                        while (iterator$iv.hasNext()) {
                            void bounds;
                            Rectangle rectangle4 = (Rectangle)iterator$iv.next();
                            Rectangle acc = (Rectangle)accumulator$iv;
                            boolean bl = false;
                            Rectangle $this$invoke_u24lambda_u241_u24lambda_u240 = rectangle3 = acc;
                            boolean bl2 = false;
                            $this$invoke_u24lambda_u241_u24lambda_u240.add((Rectangle)bounds);
                            accumulator$iv = rectangle3;
                        }
                        v0 = accumulator$iv;
                    }
                    if ((rectangle2 = (Rectangle)v0) == null) {
                        rectangle2 = new Rectangle();
                    }
                    RenderModel.access$setVisibleBounds$p(renderModel, rectangle2);
                    $this$reduceOrNull$iv = $this$readAccess.getChildren(this.this$0.getModel().getRoot());
                    RenderModel $i$f$reduceOrNull22 = this.this$0;
                    renderModel = this.this$0;
                    boolean $i$f$flatMapSequence22 = false;
                    accumulator$iv = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapSequenceTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        ViewNode it = (ViewNode)element$iv$iv;
                        boolean bl = false;
                        Sequence<ViewNode> list$iv$iv = refresh.3.invoke$lowestVisible($i$f$reduceOrNull22, $this$readAccess, it);
                        CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
                    }
                    $this$flatMap$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    void $i$f$flatMapSequence22 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Object element$iv$iv;
                        element$iv$iv = (ViewNode)item$iv$iv;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl = false;
                        collection2.add(it.getRenderBounds().getBounds());
                    }
                    $this$map$iv = (List)destination$iv$iv2;
                    boolean $i$f$reduceOrNull = false;
                    Iterator<T> iterator$iv2 = $this$reduceOrNull$iv.iterator();
                    if (!iterator$iv2.hasNext()) {
                        v2 = null;
                    } else {
                        accumulator$iv = iterator$iv2.next();
                        while (iterator$iv2.hasNext()) {
                            void bounds;
                            Rectangle $i$f$mapTo2 = (Rectangle)iterator$iv2.next();
                            Rectangle acc = (Rectangle)accumulator$iv;
                            boolean bl = false;
                            Rectangle $this$invoke_u24lambda_u245_u24lambda_u244 = rectangle3 = acc;
                            boolean bl3 = false;
                            $this$invoke_u24lambda_u245_u24lambda_u244.add((Rectangle)bounds);
                            accumulator$iv = rectangle3;
                        }
                        v2 = accumulator$iv;
                    }
                    if ((rectangle = (Rectangle)v2) == null) {
                        rectangle = new Rectangle();
                    }
                    RenderModel.access$setRootBounds$p(renderModel, rectangle);
                }

                private static final Sequence<ViewNode> invoke$lowestVisible(RenderModel this$0, ViewNode.ReadAccess $this_readAccess, ViewNode node) {
                    Sequence sequence;
                    if (this$0.getModel().isVisible(node)) {
                        Object[] objectArray = new ViewNode[]{node};
                        sequence = SequencesKt.sequenceOf((Object[])objectArray);
                    } else {
                        sequence = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)$this_readAccess.getChildren(node)), (Function1)((Function1)new Function1<ViewNode, Sequence<? extends ViewNode>>(this$0, $this_readAccess){
                            final /* synthetic */ RenderModel this$0;
                            final /* synthetic */ ViewNode.ReadAccess $this_readAccess;
                            {
                                this.this$0 = $receiver;
                                this.$this_readAccess = $this_readAccess;
                                super(1);
                            }

                            @NotNull
                            public final Sequence<ViewNode> invoke(@NotNull ViewNode it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return refresh.3.access$invoke$lowestVisible(this.this$0, this.$this_readAccess, it);
                            }
                        }));
                    }
                    return sequence;
                }

                public static final /* synthetic */ Sequence access$invoke$lowestVisible(RenderModel this$0, ViewNode.ReadAccess $this_readAccess, ViewNode node) {
                    return refresh.3.invoke$lowestVisible(this$0, $this_readAccess, node);
                }
            });
            root.getLayoutBounds().x = this.rootBounds.x;
            root.getLayoutBounds().y = this.rootBounds.y;
            root.getLayoutBounds().width = this.rootBounds.width;
            root.getLayoutBounds().height = this.rootBounds.height;
            magnitude = Math.min(0.98, Math.hypot(this.xOff, this.yOff));
            angle = Math.abs(this.xOff) < 1.0E-5 ? 1.5707963267948966 : Math.atan(this.yOff / this.xOff);
            transform2.translate(-((double)this.rootBounds.x), -((double)this.rootBounds.y));
            transform2.rotate(angle);
        } else {
            this.visibleBounds = new Rectangle();
        }
        this.rebuildRectsForLevel(transform2, magnitude, angle, levelLists, newHitRects);
        this.hitRects = CollectionsKt.toList((Iterable)newHitRects);
        Iterable $this$forEach$iv = this.modificationListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLevelLists(ViewNode.ReadAccess $this$buildLevelLists, Sequence<? extends DrawViewNode> nodes2, List<List<LevelListItem>> levelListCollector, int minLevel) {
        Object object;
        Object it;
        if (SequencesKt.none(nodes2)) {
            return;
        }
        List[] listArray = new List[]{new ArrayList()};
        List siblingGroups = CollectionsKt.mutableListOf((Object[])listArray);
        for (DrawViewNode node : nodes2) {
            int reversedIndex;
            block37: {
                int n;
                List $this$indexOfFirst$iv = CollectionsKt.reversed((Iterable)siblingGroups);
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    boolean bl;
                    block36: {
                        it = (List)item$iv;
                        boolean bl2 = false;
                        Iterable $this$any$iv = (Iterable)it;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            object = $this$any$iv.iterator();
                            while (object.hasNext()) {
                                Object element$iv = object.next();
                                DrawViewNode sibling = (DrawViewNode)element$iv;
                                boolean bl3 = false;
                                if (!this.intersects(sibling, node, true)) continue;
                                bl = true;
                                break block36;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        n = index$iv;
                        break block37;
                    }
                    ++index$iv;
                }
                n = reversedIndex = -1;
            }
            int siblingListIndex = reversedIndex == -1 ? (node.canCollapse(this.treeSettings) ? 0 : 1) : siblingGroups.size() - reversedIndex;
            this.getOrAddSublist(siblingGroups, siblingListIndex).add(node);
        }
        for (DrawViewNode node : (List)siblingGroups.get(0)) {
            int newLevelIndex;
            block46: {
                block45: {
                    block44: {
                        boolean bl;
                        block39: {
                            Object it2 = node.findFilteredOwner(this.treeSettings);
                            boolean bl4 = false;
                            boolean bl5 = it2 != null && !this.model.isVisible((ViewNode)it2);
                            if (bl5) {
                                this.buildLevelLists($this$buildLevelLists, node.children($this$buildLevelLists), levelListCollector, minLevel);
                                continue;
                            }
                            if (levelListCollector.isEmpty()) {
                                v3 = -1;
                            } else {
                                void $this$indexOfLast$iv;
                                it2 = levelListCollector.subList(minLevel, levelListCollector.size());
                                boolean $i$f$indexOfLast = false;
                                ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                                while (iterator$iv.hasPrevious()) {
                                    boolean bl6;
                                    block38: {
                                        List levelList = (List)iterator$iv.previous();
                                        boolean bl7 = false;
                                        Iterable $this$any$iv = levelList;
                                        boolean $i$f$any = false;
                                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                            bl6 = false;
                                        } else {
                                            for (Object element$iv : $this$any$iv) {
                                                object = (LevelListItem)element$iv;
                                                boolean bl8 = false;
                                                DrawViewNode existing2 = ((LevelListItem)object).component1();
                                                if (!RenderModel.intersects$default(this, existing2, node, false, 2, null)) continue;
                                                bl6 = true;
                                                break block38;
                                            }
                                            bl6 = false;
                                        }
                                    }
                                    if (!bl6) continue;
                                    v3 = iterator$iv.nextIndex();
                                    break block39;
                                }
                                v3 = newLevelIndex = -1;
                            }
                        }
                        if (newLevelIndex != 0) break block44;
                        List list2 = (List)CollectionsKt.getOrNull(levelListCollector, (int)minLevel);
                        if (list2 != null) {
                            boolean bl9;
                            block40: {
                                Iterable $this$any$iv = list2;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl9 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        it = (LevelListItem)element$iv;
                                        boolean bl10 = false;
                                        if (!Intrinsics.areEqual((Object)((LevelListItem)it).getNode().findFilteredOwner(this.treeSettings), (Object)node.findFilteredOwner(this.treeSettings))) continue;
                                        bl9 = true;
                                        break block40;
                                    }
                                    bl9 = false;
                                }
                            }
                            bl = bl9;
                        } else {
                            bl = false;
                        }
                        if (bl) break block45;
                    }
                    if (newLevelIndex != -1 || node.findFilteredOwner(this.treeSettings) != null) break block46;
                }
                if (node.getDrawWhenCollapsed()) {
                    this.getOrAddSublist(levelListCollector, minLevel).add(new LevelListItem(node, true));
                }
                this.buildLevelLists($this$buildLevelLists, node.children($this$buildLevelLists), levelListCollector, minLevel);
                continue;
            }
            this.getOrAddSublist(levelListCollector, newLevelIndex + minLevel + 1).add(new LevelListItem(node, false));
            this.buildLevelLists($this$buildLevelLists, node.children($this$buildLevelLists), levelListCollector, newLevelIndex + minLevel + 1);
        }
        for (List siblingGroup : siblingGroups.subList(1, siblingGroups.size())) {
            void $this$mapTo$iv;
            int n;
            Iterable $this$indexOfLast$iv;
            List filteredGroup;
            block43: {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = siblingGroup;
                boolean $i$f$filter22 = false;
                Iterable $i$f$any = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    DrawViewNode it3 = (DrawViewNode)element$iv$iv;
                    boolean bl = false;
                    ViewNode owner = it3.findFilteredOwner(this.treeSettings);
                    if (!(owner == null || this.model.isVisible(owner))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                filteredGroup = (List)destination$iv$iv;
                List<List<LevelListItem>> $i$f$filter22 = levelListCollector.subList(minLevel, levelListCollector.size());
                boolean $i$f$indexOfLast = false;
                ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    boolean bl;
                    block42: {
                        List levelList = (List)iterator$iv.previous();
                        boolean bl11 = false;
                        Iterable $this$any$iv = levelList;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                boolean bl12;
                                block41: {
                                    LevelListItem levelListItem = (LevelListItem)element$iv;
                                    boolean bl13 = false;
                                    DrawViewNode existing3 = levelListItem.component1();
                                    Iterable $this$any$iv2 = filteredGroup;
                                    boolean $i$f$any3 = false;
                                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                        bl12 = false;
                                    } else {
                                        for (Object element$iv2 : $this$any$iv2) {
                                            DrawViewNode it4 = (DrawViewNode)element$iv2;
                                            boolean bl14 = false;
                                            if (!RenderModel.intersects$default(this, existing3, it4, false, 2, null)) continue;
                                            bl12 = true;
                                            break block41;
                                        }
                                        bl12 = false;
                                    }
                                }
                                if (!bl12) continue;
                                bl = true;
                                break block42;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    n = iterator$iv.nextIndex();
                    break block43;
                }
                n = -1;
            }
            int newLevelIndex = n + minLevel + 1;
            $this$indexOfLast$iv = filteredGroup;
            Collection destination$iv = this.getOrAddSublist(levelListCollector, newLevelIndex);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it5;
                DrawViewNode $this$any$iv = (DrawViewNode)item$iv;
                Collection collection2 = destination$iv;
                boolean bl = false;
                collection2.add(new LevelListItem((DrawViewNode)it5, false));
            }
            for (DrawViewNode sibling : siblingGroup) {
                ViewNode owner = sibling.findFilteredOwner(this.treeSettings);
                boolean hidden = owner != null && !this.model.isVisible(owner);
                this.buildLevelLists($this$buildLevelLists, sibling.children($this$buildLevelLists), levelListCollector, hidden ? minLevel : newLevelIndex);
            }
        }
    }

    private final <T> List<T> getOrAddSublist(List<List<T>> $this$getOrAddSublist, int index2) {
        List list2;
        List<List<T>> list3 = $this$getOrAddSublist;
        if (index2 >= 0 && index2 <= CollectionsKt.getLastIndex(list3)) {
            list2 = list3.get(index2);
        } else {
            List list4;
            int it = index2;
            boolean bl = false;
            List it2 = list4 = (List)new ArrayList();
            boolean bl2 = false;
            $this$getOrAddSublist.add(it2);
            list2 = list4;
        }
        return list2;
    }

    private final boolean intersects(DrawViewNode $this$intersects, DrawViewNode other, boolean useTransitiveBounds) {
        return this.overlap(useTransitiveBounds ? (Shape)$this$intersects.getUnfilteredOwner().getTransitiveBounds() : $this$intersects.getBounds(), other.getBounds());
    }

    static /* synthetic */ boolean intersects$default(RenderModel renderModel, DrawViewNode drawViewNode, DrawViewNode drawViewNode2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return renderModel.intersects(drawViewNode, drawViewNode2, bl);
    }

    @TestOnly
    public final boolean testOverlap(@NotNull Shape shape1, @NotNull Shape shape2) {
        Intrinsics.checkNotNullParameter((Object)shape1, (String)"shape1");
        Intrinsics.checkNotNullParameter((Object)shape2, (String)"shape2");
        return this.overlap(shape1, shape2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean overlap(Shape $this$overlap, Shape other) {
        Rectangle r1 = $this$overlap instanceof Rectangle ? (Rectangle)$this$overlap : null;
        Rectangle r2 = other instanceof Rectangle ? (Rectangle)other : null;
        if (r1 != null && r2 != null) {
            v0 = this.overlap(r1, r2);
            return v0;
        } else if (r1 != null) {
            v0 = this.overlap(other, r1);
            return v0;
        } else if (r2 != null) {
            v0 = this.overlap($this$overlap, r2);
            return v0;
        } else {
            Area area;
            Rectangle rectangle = other.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"other.bounds");
            if (!this.overlap($this$overlap, rectangle)) return false;
            Area $this$overlap_u24lambda_u2418 = area = new Area($this$overlap);
            boolean bl = false;
            $this$overlap_u24lambda_u2418.intersect(new Area(other));
            if (area.isEmpty()) return false;
            return true;
        }
    }

    private final boolean overlap(Rectangle $this$overlap, Rectangle other) {
        return $this$overlap.x < other.x + other.width && other.x < $this$overlap.x + $this$overlap.width && $this$overlap.y < other.y + other.height && other.y < $this$overlap.y + $this$overlap.height;
    }

    private final boolean overlap(Shape $this$overlap, Rectangle other) {
        return $this$overlap.intersects(other.x, other.y, other.width, other.height);
    }

    /*
     * WARNING - void declaration
     */
    private final void rebuildRectsForLevel(AffineTransform transform2, double magnitude, double angle, List<? extends List<LevelListItem>> allLevels, List<ViewDrawInfo> newHitRects) {
        Map ownerToLevel = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = allLevels;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void levelList;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list2 = (List)item$iv;
            int level = n;
            boolean bl = false;
            Iterable $this$forEach$iv = (Iterable)levelList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                void $this$getOrPut$iv;
                LevelListItem levelListItem = (LevelListItem)element$iv;
                boolean bl2 = false;
                DrawViewNode view = levelListItem.component1();
                boolean isCollapsed = levelListItem.component2();
                Map map2 = ownerToLevel;
                ViewNode key$iv = view.findFilteredOwner(this.treeSettings);
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    Integer answer$iv = level;
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                int hitLevel = ((Number)object).intValue();
                AffineTransform viewTransform = new AffineTransform(transform2);
                int sign = this.xOff < 0.0 ? -1 : 1;
                viewTransform.translate(magnitude * (double)(level - this.maxDepth / 2) * (double)this.layerSpacing * (double)sign, 0.0);
                viewTransform.scale(Math.sqrt(1.0 - magnitude * magnitude), 1.0);
                viewTransform.rotate(-angle);
                viewTransform.translate((double)(-this.rootBounds.width) / 2.0, (double)(-this.rootBounds.height) / 2.0);
                Shape rect = viewTransform.createTransformedShape(view.getUnfilteredOwner().getRenderBounds());
                Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"rect");
                newHitRects.add(new ViewDrawInfo(rect, viewTransform, view, hitLevel, isCollapsed));
            }
        }
    }

    public final void resetRotation() {
        if (!(this.xOff == 0.0) || !(this.yOff == 0.0)) {
            this.xOff = 0.0;
            this.yOff = 0.0;
            this.refresh();
        }
    }

    public final void fireModified() {
        Iterable $this$forEach$iv = this.modificationListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public static final /* synthetic */ void access$buildLevelLists(RenderModel $this, ViewNode.ReadAccess $receiver, Sequence nodes2, List levelListCollector, int minLevel) {
        $this.buildLevelLists($receiver, (Sequence<? extends DrawViewNode>)nodes2, levelListCollector, minLevel);
    }

    public static final /* synthetic */ void access$setVisibleBounds$p(RenderModel $this, Rectangle rectangle) {
        $this.visibleBounds = rectangle;
    }

    public static final /* synthetic */ void access$setRootBounds$p(RenderModel $this, Rectangle rectangle) {
        $this.rootBounds = rectangle;
    }
}

