/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.adtui.TreeWalker;
import com.android.tools.idea.layoutinspector.model.StatusNotification;
import com.android.tools.idea.layoutinspector.ui.InspectorBanner;
import com.android.tools.idea.layoutinspector.ui.InspectorBannerService;
import com.android.tools.idea.layoutinspector.ui.InspectorBannerServiceKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "bannerService", "Lcom/android/tools/idea/layoutinspector/ui/InspectorBannerService;", "model", "Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner$NotificationsModel;", "notifications", "", "Lcom/android/tools/idea/layoutinspector/model/StatusNotification;", "table", "Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner$NotificationTable;", "updateNotifications", "", "NotificationTable", "NotificationsModel", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nInspectorBanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectorBanner.kt\ncom/android/tools/idea/layoutinspector/ui/InspectorBanner\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,246:1\n65#2:247\n*S KotlinDebug\n*F\n+ 1 InspectorBanner.kt\ncom/android/tools/idea/layoutinspector/ui/InspectorBanner\n*L\n76#1:247\n*E\n"})
public final class InspectorBanner
extends JPanel {
    @NotNull
    private final NotificationsModel model;
    @NotNull
    private final NotificationTable table;
    @Nullable
    private final InspectorBannerService bannerService;
    @NotNull
    private List<? extends StatusNotification> notifications;

    public InspectorBanner(@NotNull Project project) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(new BorderLayout());
            this.model = new NotificationsModel();
            this.table = new NotificationTable(this.model);
            this.bannerService = InspectorBannerService.Companion.getInstance(project);
            this.notifications = CollectionsKt.emptyList();
            this.setVisible(false);
            this.setBackground(UIUtil.TRANSPARENT_COLOR);
            this.setOpaque(false);
            JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.table)), (int)21, (int)31);
            Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(table, \u2026RIZONTAL_SCROLLBAR_NEVER)");
            JScrollPane scrollPane2 = jScrollPane;
            scrollPane2.setBorder((Border)JBUI.Borders.empty());
            this.add((Component)scrollPane2, "Center");
            Object object = this.bannerService;
            if (object == null || (object = ((InspectorBannerService)object).getNotificationListeners()) == null) break block0;
            object.add(new Function0<Unit>((Object)this){

                public final void invoke() {
                    ((InspectorBanner)this.receiver).updateNotifications();
                }
            });
        }
    }

    private final void updateNotifications() {
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ InspectorBanner this$0;
            {
                this.this$0 = inspectorBanner;
            }

            public final void run() {
                boolean bl = false;
                Object object = InspectorBanner.access$getBannerService$p(this.this$0);
                if (object == null || (object = ((InspectorBannerService)object).getNotifications()) == null) {
                    object = CollectionsKt.emptyList();
                }
                InspectorBanner.access$setNotifications$p(this.this$0, (List)object);
                this.this$0.setVisible(!((Collection)InspectorBanner.access$getNotifications$p(this.this$0)).isEmpty());
                InspectorBanner.access$getModel$p(this.this$0).fireTableDataChanged();
                this.this$0.revalidate();
            }
        });
    }

    public static final /* synthetic */ void access$setNotifications$p(InspectorBanner $this, List list2) {
        $this.notifications = list2;
    }

    public static final /* synthetic */ InspectorBannerService access$getBannerService$p(InspectorBanner $this) {
        return $this.bannerService;
    }

    public static final /* synthetic */ NotificationsModel access$getModel$p(InspectorBanner $this) {
        return $this.model;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000_\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u000f\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rH\u0016J\b\u0010!\u001a\u00020\rH\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner$NotificationTable;", "Lcom/intellij/ui/table/JBTable;", "model", "Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner$NotificationsModel;", "Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner;", "(Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner$NotificationsModel;)V", "actionLayout", "Ljava/awt/FlowLayout;", "actionPanel", "Ljavax/swing/JPanel;", "classInitialized", "", "lastActionRenderRow", "", "mouseListener", "com/android/tools/idea/layoutinspector/ui/InspectorBanner$NotificationTable$mouseListener$1", "Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner$NotificationTable$mouseListener$1;", "tableCellRenderer", "Ljavax/swing/table/TableCellRenderer;", "text", "Ljavax/swing/JLabel;", "applyUISettings", "", "doLayout", "findComponentAtMouse", "Ljava/awt/Component;", "event", "Ljava/awt/event/MouseEvent;", "forwardMouseEventToHoveredComponent", "getCellComponent", "row", "column", "getCellRenderer", "getMaxActionWidth", "handleMouseMoved", "processMouseEvent", "tableChanged", "Ljavax/swing/event/TableModelEvent;", "updateUI", "intellij.android.layout-inspector"})
    @SourceDebugExtension(value={"SMAP\nInspectorBanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectorBanner.kt\ncom/android/tools/idea/layoutinspector/ui/InspectorBanner$NotificationTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n1#2:247\n1851#3,2:248\n*S KotlinDebug\n*F\n+ 1 InspectorBanner.kt\ncom/android/tools/idea/layoutinspector/ui/InspectorBanner$NotificationTable\n*L\n227#1:248,2\n*E\n"})
    private static final class NotificationTable
    extends JBTable {
        @NotNull
        private final JLabel text;
        @NotNull
        private final FlowLayout actionLayout;
        @NotNull
        private final JPanel actionPanel;
        @NotNull
        private final TableCellRenderer tableCellRenderer;
        @NotNull
        private final mouseListener.1 mouseListener;
        private int lastActionRenderRow;
        private boolean classInitialized;

        public NotificationTable(@NotNull NotificationsModel model2) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            super((TableModel)model2);
            this.text = new JLabel();
            this.actionLayout = new FlowLayout(2, JBUI.scale((int)6), 0);
            this.actionPanel = new JPanel(this.actionLayout);
            this.tableCellRenderer = new TableCellRenderer(this){
                final /* synthetic */ NotificationTable this$0;
                {
                    this.this$0 = $receiver;
                }

                public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int row2, int column2) {
                    return NotificationTable.access$getCellComponent(this.this$0, row2, column2);
                }
            };
            this.mouseListener = new MouseAdapter(this){
                final /* synthetic */ NotificationTable this$0;
                {
                    this.this$0 = $receiver;
                }

                public void mouseMoved(@NotNull MouseEvent event2) {
                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                    NotificationTable.access$handleMouseMoved(this.this$0, event2);
                }
            };
            this.lastActionRenderRow = -1;
            this.classInitialized = true;
            this.applyUISettings();
            this.tableHeader = null;
            this.setShowGrid(false);
            this.addMouseMotionListener(this.mouseListener);
            this.putClientProperty(RenderingUtil.PAINT_HOVERED_BACKGROUND, false);
        }

        public void updateUI() {
            super.updateUI();
            if (this.classInitialized) {
                this.applyUISettings();
            }
        }

        public void tableChanged(@NotNull TableModelEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            super.tableChanged(event2);
            this.lastActionRenderRow = -1;
        }

        public void doLayout() {
            TableColumn messageColumn = this.getColumnModel().getColumn(0);
            TableColumn actionColumn = this.getColumnModel().getColumn(1);
            int maxActionWidth = this.getMaxActionWidth();
            actionColumn.setWidth(Math.min(this.getWidth(), maxActionWidth));
            messageColumn.setWidth(this.getWidth() - actionColumn.getWidth());
        }

        @NotNull
        public TableCellRenderer getCellRenderer(int row2, int column2) {
            return this.tableCellRenderer;
        }

        protected void processMouseEvent(@NotNull MouseEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            if (!this.forwardMouseEventToHoveredComponent(event2)) {
                super.processMouseEvent(event2);
            }
        }

        private final void applyUISettings() {
            JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)3, (int)6);
            Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(VERTICAL_BORDER_SI\u2026, HORIZONTAL_BORDER_SIZE)");
            JBEmptyBorder borderSpacing = jBEmptyBorder;
            Border border = JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)border, (String)"customLine(JBColor.border(), 0, 0, 1, 0)");
            Border borderSeparator = border;
            Border renderBorder = JBUI.Borders.compound((Border)borderSeparator, (Border)((Border)borderSpacing));
            this.text.setBorder(renderBorder);
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getInstance().globalScheme");
            EditorColorsScheme globalScheme = editorColorsScheme;
            this.setBackground(globalScheme.getColor(EditorColors.NOTIFICATION_BACKGROUND));
            this.actionPanel.setBorder(renderBorder);
            this.actionPanel.setBackground(this.getBackground());
            this.actionLayout.setHgap(JBUI.scale((int)3));
        }

        private final int getMaxActionWidth() {
            int width = 0;
            int n = this.getModel().getRowCount();
            for (int row2 = 0; row2 < n; ++row2) {
                int actionWidth = this.getCellComponent((int)row2, (int)1).getPreferredSize().width;
                width = Math.max(width, actionWidth);
            }
            return width;
        }

        private final void handleMouseMoved(MouseEvent event2) {
            Serializable serializable = this.findComponentAtMouse(event2);
            if (serializable == null || (serializable = serializable.getCursor()) == null) {
                serializable = Cursor.getDefaultCursor();
            }
            this.setCursor((Cursor)serializable);
        }

        private final boolean forwardMouseEventToHoveredComponent(MouseEvent event2) {
            Component component2 = this.findComponentAtMouse(event2);
            if (component2 == null) {
                return false;
            }
            Component component3 = component2;
            this.add(this.actionPanel);
            MouseEvent newEvent = SwingUtilities.convertMouseEvent((Component)((Object)this), event2, component3);
            this.remove(this.actionPanel);
            component3.dispatchEvent(newEvent);
            return true;
        }

        private final Component findComponentAtMouse(MouseEvent event2) {
            int row2 = this.rowAtPoint(event2.getPoint());
            int column2 = this.columnAtPoint(event2.getPoint());
            if (column2 != 1) {
                return null;
            }
            Component renderer2 = this.getCellComponent(row2, 1);
            Rectangle rect = this.getCellRect(row2, column2, true);
            renderer2.setBounds(rect);
            new TreeWalker(renderer2).descendantStream().forEach(findComponentAtMouse.1.INSTANCE);
            return SwingUtilities.getDeepestComponentAt(renderer2, event2.getX() - rect.x, event2.getY() - rect.y);
        }

        private final Component getCellComponent(int row2, int column2) {
            Component component2;
            StatusNotification notificationValue;
            Object object = this.getModel().getValueAt(row2, 1);
            StatusNotification statusNotification = notificationValue = object instanceof StatusNotification ? (StatusNotification)object : null;
            if (column2 == 0) {
                Object $this$getCellComponent_u24lambda_u240 = object = this.text;
                boolean bl = false;
                Object object2 = notificationValue;
                if (object2 == null || (object2 = object2.getMessage()) == null) {
                    object2 = "";
                }
                ((JLabel)$this$getCellComponent_u24lambda_u240).setText((String)object2);
                component2 = (Component)object;
            } else {
                if (this.lastActionRenderRow != row2) {
                    this.lastActionRenderRow = row2;
                    this.actionPanel.removeAll();
                    StatusNotification statusNotification2 = notificationValue;
                    if (statusNotification2 != null) {
                        StatusNotification notification = statusNotification2;
                        boolean bl = false;
                        Iterable $this$forEach$iv = notification.getActions();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            AnAction action2 = (AnAction)element$iv;
                            boolean bl2 = false;
                            HyperlinkLabel actionLabel = new HyperlinkLabel(action2.getTemplateText(), (Color)JBColor.BLUE);
                            actionLabel.setCursor(Cursor.getPredefinedCursor(12));
                            actionLabel.addHyperlinkListener(new HyperlinkListener(action2, notification){
                                final /* synthetic */ AnAction $action;
                                final /* synthetic */ StatusNotification $notification;
                                {
                                    this.$action = $action;
                                    this.$notification = $notification;
                                }

                                public final void hyperlinkUpdate(HyperlinkEvent it) {
                                    DataContext context2 = new DataContext(this.$notification){
                                        final /* synthetic */ StatusNotification $notification;
                                        {
                                            this.$notification = $notification;
                                        }

                                        @Nullable
                                        public final Object getData(@NotNull String dataId) {
                                            Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                                            return InspectorBannerServiceKt.getNOTIFICATION_KEY().is(dataId) ? this.$notification : null;
                                        }
                                    };
                                    Presentation presentation = this.$action.getTemplatePresentation().clone();
                                    Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"action.templatePresentation.clone()");
                                    Presentation presentation2 = presentation;
                                    AnActionEvent event2 = new AnActionEvent(it.getInputEvent(), context2, "Notification", presentation2, ActionManager.getInstance(), 0);
                                    this.$action.actionPerformed(event2);
                                }
                            });
                            this.actionPanel.add((Component)actionLabel);
                        }
                    }
                }
                component2 = this.actionPanel;
            }
            return component2;
        }

        public static final /* synthetic */ Component access$getCellComponent(NotificationTable $this, int row2, int column2) {
            return $this.getCellComponent(row2, column2);
        }

        public static final /* synthetic */ void access$handleMouseMoved(NotificationTable $this, MouseEvent event2) {
            $this.handleMouseMoved(event2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner$NotificationsModel;", "Ljavax/swing/table/AbstractTableModel;", "(Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner;)V", "getColumnCount", "", "getRowCount", "getValueAt", "Lcom/android/tools/idea/layoutinspector/model/StatusNotification;", "rowIndex", "columnIndex", "isCellEditable", "", "intellij.android.layout-inspector"})
    private final class NotificationsModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return InspectorBanner.this.notifications.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        @Nullable
        public StatusNotification getValueAt(int rowIndex, int columnIndex) {
            return (StatusNotification)CollectionsKt.getOrNull((List)InspectorBanner.this.notifications, (int)rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }
    }
}

