/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.adtui.Pannable;
import com.android.tools.adtui.PannableKt;
import com.android.tools.adtui.Zoomable;
import com.android.tools.adtui.ZoomableKt;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.adtui.common.AdtPrimaryPanel;
import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.appinspection.api.process.ProcessesModel;
import com.android.tools.idea.appinspection.inspector.api.process.DeviceDescriptor;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.concurrency.AndroidExecutors;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.LayoutInspectorBundle;
import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.DeviceModel;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcess;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetectionKt;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.android.tools.idea.layoutinspector.ui.DeviceViewContentPanel;
import com.android.tools.idea.layoutinspector.ui.DeviceViewPanelKt;
import com.android.tools.idea.layoutinspector.ui.InspectorBannerService;
import com.android.tools.idea.layoutinspector.ui.MyViewportLayoutManager;
import com.android.tools.idea.layoutinspector.ui.RenderLogic;
import com.android.tools.idea.layoutinspector.ui.RenderModel;
import com.android.tools.idea.layoutinspector.ui.RenderModelKt;
import com.android.tools.idea.layoutinspector.ui.RenderSettings;
import com.android.tools.idea.layoutinspector.ui.RenderSettingsKt;
import com.android.tools.idea.layoutinspector.ui.toolbar.FloatingToolbarProvider;
import com.android.tools.idea.layoutinspector.ui.toolbar.LayoutInspectorMainToolbarKt;
import com.android.tools.idea.layoutinspector.ui.toolbar.actions.DropDownActionWithButton;
import com.android.tools.idea.layoutinspector.ui.toolbar.actions.TargetSelectionActionFactory;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorErrorInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBLoadingPanelListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010<\u001a\u00020\u0013H\u0016J\b\u0010=\u001a\u00020\u0013H\u0016J\b\u0010>\u001a\u00020\u0013H\u0016J\b\u0010?\u001a\u00020\u0013H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020GH\u0002J\b\u0010H\u001a\u00020IH\u0002J\u000e\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MJ\b\u0010N\u001a\u00020KH\u0002J\b\u0010O\u001a\u00020KH\u0002J\u0010\u0010P\u001a\u00020\u00132\u0006\u0010Q\u001a\u00020RH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u00020\u00138VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0018\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020+X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010-R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00103\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u001e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanel;", "Ljavax/swing/JPanel;", "Lcom/android/tools/adtui/Zoomable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/android/tools/adtui/Pannable;", "layoutInspector", "Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "disposableParent", "Lcom/intellij/openapi/Disposable;", "backgroundExecutor", "Ljava/util/concurrent/Executor;", "(Lcom/android/tools/idea/layoutinspector/LayoutInspector;Lcom/intellij/openapi/Disposable;Ljava/util/concurrent/Executor;)V", "actionToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "contentPanel", "Lcom/android/tools/idea/layoutinspector/ui/DeviceViewContentPanel;", "floatingToolbarProvider", "Lcom/android/tools/idea/layoutinspector/ui/toolbar/FloatingToolbarProvider;", "hasForegroundProcess", "", "isCurrentForegroundProcessDebuggable", "isLoading", "isMiddleMousePressed", "isPannable", "()Z", "isPanning", "setPanning", "(Z)V", "isSpacePressed", "lastPanMouseLocation", "Ljava/awt/Point;", "layeredPane", "Ljavax/swing/JLayeredPane;", "getLayoutInspector", "()Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "loadingPane", "Lcom/intellij/ui/components/JBLoadingPanel;", "panMouseListener", "Ljava/awt/event/MouseAdapter;", "performanceWarningGiven", "renderSettings", "Lcom/android/tools/idea/layoutinspector/ui/RenderSettings;", "scale", "", "getScale", "()D", "screenScalingFactor", "getScreenScalingFactor", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "<anonymous parameter 0>", "scrollPosition", "getScrollPosition", "()Ljava/awt/Point;", "setScrollPosition", "(Ljava/awt/Point;)V", "targetSelectedAction", "Lcom/android/tools/idea/layoutinspector/ui/toolbar/actions/DropDownActionWithButton;", "viewportLayoutManager", "Lcom/android/tools/idea/layoutinspector/ui/MyViewportLayoutManager;", "canZoomIn", "canZoomOut", "canZoomToActual", "canZoomToFit", "createToolbarPanel", "Ljavax/swing/JComponent;", "getData", "", "dataId", "", "getFitZoom", "", "getScreenSize", "Ljava/awt/Dimension;", "onNewForegroundProcess", "", "foregroundProcess", "Lcom/android/tools/idea/layoutinspector/pipeline/foregroundprocessdetection/ForegroundProcess;", "showGrab", "updateLayeredPaneSize", "zoom", "type", "Lcom/android/tools/adtui/actions/ZoomType;", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nDeviceViewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceViewPanel.kt\ncom/android/tools/idea/layoutinspector/ui/DeviceViewPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,555:1\n1851#2,2:556\n1851#2,2:558\n1851#2,2:560\n1851#2,2:562\n1851#2,2:564\n1851#2,2:566\n*S KotlinDebug\n*F\n+ 1 DeviceViewPanel.kt\ncom/android/tools/idea/layoutinspector/ui/DeviceViewPanel\n*L\n233#1:556,2\n235#1:558,2\n237#1:560,2\n255#1:562,2\n256#1:564,2\n257#1:566,2\n*E\n"})
public final class DeviceViewPanel
extends JPanel
implements Zoomable,
DataProvider,
Pannable {
    @NotNull
    private final LayoutInspector layoutInspector;
    @TestOnly
    @NotNull
    private final Executor backgroundExecutor;
    @NotNull
    private final RenderSettings renderSettings;
    private final double screenScalingFactor;
    private boolean isPanning;
    private boolean isSpacePressed;
    private boolean isMiddleMousePressed;
    @Nullable
    private Point lastPanMouseLocation;
    private boolean performanceWarningGiven;
    @Nullable
    private final DropDownActionWithButton targetSelectedAction;
    @NotNull
    private final DeviceViewContentPanel contentPanel;
    @NotNull
    private final MouseAdapter panMouseListener;
    @NotNull
    private final JBScrollPane scrollPane;
    @NotNull
    private final JLayeredPane layeredPane;
    @NotNull
    private final JBLoadingPanel loadingPane;
    @NotNull
    private final FloatingToolbarProvider floatingToolbarProvider;
    @NotNull
    private final MyViewportLayoutManager viewportLayoutManager;
    @NotNull
    private final ActionToolbar actionToolbar;
    private boolean isLoading;
    private boolean isCurrentForegroundProcessDebuggable;
    private boolean hasForegroundProcess;

    public DeviceViewPanel(@NotNull LayoutInspector layoutInspector, @NotNull Disposable disposableParent, @NotNull Executor backgroundExecutor) {
        Intrinsics.checkNotNullParameter((Object)layoutInspector, (String)"layoutInspector");
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        Intrinsics.checkNotNullParameter((Object)backgroundExecutor, (String)"backgroundExecutor");
        super(new BorderLayout());
        this.layoutInspector = layoutInspector;
        this.backgroundExecutor = backgroundExecutor;
        this.renderSettings = this.layoutInspector.getRenderLogic().getRenderSettings();
        this.screenScalingFactor = 1.0;
        this.targetSelectedAction = TargetSelectionActionFactory.INSTANCE.getAction(this.layoutInspector);
        InspectorModel inspectorModel = this.layoutInspector.getInspectorModel();
        MouseListener[] mouseListenerArray = this.layoutInspector.getDeviceModel();
        TreeSettings treeSettings2 = this.layoutInspector.getTreeSettings();
        DropDownActionWithButton dropDownActionWithButton = this.targetSelectedAction;
        RenderLogic renderLogic = this.layoutInspector.getRenderLogic();
        RenderModel renderModel = this.layoutInspector.getRenderModel();
        this.contentPanel = new DeviceViewContentPanel(inspectorModel, (DeviceModel)mouseListenerArray, treeSettings2, renderModel, renderLogic, (Function0<? extends InspectorClient>)((Function0)new Function0<InspectorClient>(this){
            final /* synthetic */ DeviceViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final InspectorClient invoke() {
                return this.this$0.getLayoutInspector().getCurrentClient();
            }
        }), this, dropDownActionWithButton, disposableParent, (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ DeviceViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return DeviceViewPanel.access$isLoading$p(this.this$0);
            }
        }), (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ DeviceViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return DeviceViewPanel.access$isCurrentForegroundProcessDebuggable$p(this.this$0);
            }
        }), (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ DeviceViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return DeviceViewPanel.access$getHasForegroundProcess$p(this.this$0);
            }
        }));
        this.panMouseListener = new MouseAdapter(this){
            final /* synthetic */ DeviceViewPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DeviceViewPanel.access$showGrab(this.this$0);
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DeviceViewPanel.access$showGrab(this.this$0);
            }

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DeviceViewPanel.access$getContentPanel$p(this.this$0).requestFocus();
                DeviceViewPanel.access$setMiddleMousePressed$p(this.this$0, SwingUtilities.isMiddleMouseButton(e));
                if (this.this$0.isPanning()) {
                    this.this$0.setCursor(AdtUiCursorsProvider.Companion.getInstance().getCursor(AdtUiCursorType.GRABBING));
                    DeviceViewPanel.access$setLastPanMouseLocation$p(this.this$0, SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.this$0));
                    e.consume();
                }
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point lastLocation = DeviceViewPanel.access$getLastPanMouseLocation$p(this.this$0);
                Point newLocation = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.this$0);
                DeviceViewPanel.access$setLastPanMouseLocation$p(this.this$0, newLocation);
                if (this.this$0.isPanning() && lastLocation != null) {
                    this.this$0.setCursor(AdtUiCursorsProvider.Companion.getInstance().getCursor(AdtUiCursorType.GRABBING));
                    Dimension extent = DeviceViewPanel.access$getScrollPane$p(this.this$0).getViewport().getExtentSize();
                    Dimension view = DeviceViewPanel.access$getScrollPane$p(this.this$0).getViewport().getViewSize();
                    Point p = DeviceViewPanel.access$getScrollPane$p(this.this$0).getViewport().getViewPosition();
                    p.translate(lastLocation.x - newLocation.x, lastLocation.y - newLocation.y);
                    int availableWidth = RangesKt.coerceAtLeast((int)(view.width - extent.width), (int)0);
                    int availableHeight = RangesKt.coerceAtLeast((int)(view.height - extent.height), (int)0);
                    p.x = RangesKt.coerceIn((int)p.x, (int)0, (int)availableWidth);
                    p.y = RangesKt.coerceIn((int)p.y, (int)0, (int)availableHeight);
                    DeviceViewPanel.access$getScrollPane$p(this.this$0).getViewport().setViewPosition(p);
                    e.consume();
                }
            }

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DeviceViewPanel.access$setMiddleMousePressed$p(this.this$0, false);
                if (DeviceViewPanel.access$getLastPanMouseLocation$p(this.this$0) != null) {
                    this.this$0.setCursor(this.this$0.isPanning() ? AdtUiCursorsProvider.Companion.getInstance().getCursor(AdtUiCursorType.GRAB) : Cursor.getDefaultCursor());
                    DeviceViewPanel.access$setLastPanMouseLocation$p(this.this$0, null);
                    e.consume();
                }
            }
        };
        this.scrollPane = new JBScrollPane((Component)((Object)this.contentPanel));
        this.layeredPane = new JLayeredPane();
        this.loadingPane = new JBLoadingPanel((LayoutManager)new BorderLayout(), disposableParent);
        this.floatingToolbarProvider = new FloatingToolbarProvider(this, disposableParent);
        JViewport jViewport = this.scrollPane.getViewport();
        Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"scrollPane.viewport");
        this.viewportLayoutManager = new MyViewportLayoutManager(jViewport, (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return DeviceViewPanel.access$getContentPanel$p(this.this$0).getRenderModel().getLayerSpacing();
            }
        }), (Function0<? extends Point>)((Function0)new Function0<Point>(this){
            final /* synthetic */ DeviceViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Point invoke() {
                return DeviceViewPanel.access$getContentPanel$p(this.this$0).getRootLocation();
            }
        }));
        DropDownActionWithButton dropDownActionWithButton2 = this.targetSelectedAction;
        this.actionToolbar = LayoutInspectorMainToolbarKt.createLayoutInspectorMainToolbar(this, this.layoutInspector, (AnAction)(dropDownActionWithButton2 != null ? dropDownActionWithButton2.getDropDownAction() : null));
        this.layoutInspector.getStopInspectorListeners().add(new Function0<Unit>(){

            public final void invoke() {
                loadingPane.stopLoading();
            }
        });
        Object object = this.layoutInspector.getDeviceModel();
        if (object != null && (object = ((DeviceModel)object).getNewSelectedDeviceListeners()) != null) {
            ((CopyOnWriteArraySet)object).add(new Function1<DeviceDescriptor, Unit>(){

                public final void invoke(@Nullable DeviceDescriptor deviceDescriptor) {
                    hasForegroundProcess = false;
                }
            });
        }
        this.loadingPane.addListener(new JBLoadingPanelListener(){

            public void onLoadingStart() {
                isLoading = true;
            }

            public void onLoadingFinish() {
                isLoading = false;
            }
        });
        this.scrollPane.getViewport().setLayout(this.viewportLayoutManager);
        this.contentPanel.setFocusable(true);
        MouseListener[] mouseListenerArray2 = this.contentPanel.getMouseListeners();
        Intrinsics.checkNotNullExpressionValue((Object)mouseListenerArray2, (String)"contentPanel.mouseListeners");
        mouseListenerArray = mouseListenerArray2;
        List mouseListeners = CollectionsKt.listOf((Object[])Arrays.copyOf(mouseListenerArray, mouseListenerArray.length));
        Iterable $this$forEach$iv = mouseListeners;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            MouseListener it = (MouseListener)element$iv;
            boolean bl = false;
            this.contentPanel.removeMouseListener(it);
        }
        MouseMotionListener[] mouseMotionListenerArray = this.contentPanel.getMouseMotionListeners();
        Intrinsics.checkNotNullExpressionValue((Object)mouseMotionListenerArray, (String)"contentPanel.mouseMotionListeners");
        MouseMotionListener[] $i$f$forEach22 = mouseMotionListenerArray;
        List mouseMotionListeners = CollectionsKt.listOf((Object[])Arrays.copyOf($i$f$forEach22, $i$f$forEach22.length));
        Iterable $this$forEach$iv2 = mouseMotionListeners;
        boolean $i$f$forEach32 = false;
        for (Object element$iv : $this$forEach$iv2) {
            MouseMotionListener it = (MouseMotionListener)element$iv;
            boolean bl = false;
            this.contentPanel.removeMouseMotionListener(it);
        }
        KeyListener[] keyListenerArray = this.contentPanel.getKeyListeners();
        Intrinsics.checkNotNullExpressionValue((Object)keyListenerArray, (String)"contentPanel.keyListeners");
        KeyListener[] $i$f$forEach32 = keyListenerArray;
        List keyboardListeners = CollectionsKt.listOf((Object[])Arrays.copyOf($i$f$forEach32, $i$f$forEach32.length));
        Iterable $this$forEach$iv3 = keyboardListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv3) {
            KeyListener it = (KeyListener)element$iv;
            boolean bl = false;
            this.contentPanel.removeKeyListener(it);
        }
        this.contentPanel.addMouseListener(this.panMouseListener);
        this.contentPanel.addMouseMotionListener(this.panMouseListener);
        this.contentPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 32) {
                    isSpacePressed = true;
                    this.showGrab();
                }
            }

            @Override
            public void keyReleased(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 32) {
                    isSpacePressed = false;
                    this.showGrab();
                }
            }
        });
        $this$forEach$iv3 = mouseListeners;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv3) {
            MouseListener it = (MouseListener)element$iv;
            boolean bl = false;
            this.contentPanel.addMouseListener(it);
        }
        $this$forEach$iv3 = mouseMotionListeners;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv3) {
            MouseMotionListener it = (MouseMotionListener)element$iv;
            boolean bl = false;
            this.contentPanel.addMouseMotionListener(it);
        }
        $this$forEach$iv3 = keyboardListeners;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv3) {
            KeyListener it = (KeyListener)element$iv;
            boolean bl = false;
            this.contentPanel.addKeyListener(it);
        }
        this.scrollPane.setBorder((Border)JBUI.Borders.empty());
        JComponent toolbarComponent = this.createToolbarPanel(this.actionToolbar);
        this.add((Component)toolbarComponent, "North");
        this.loadingPane.add((Component)this.layeredPane, (Object)"Center");
        this.add((Component)this.loadingPane, "Center");
        final InspectorModel model2 = this.layoutInspector.getInspectorModel();
        model2.getAttachStageListeners().add((Object)new Function1<DynamicLayoutInspectorErrorInfo.AttachErrorState, Unit>(){

            public final void invoke(@NotNull DynamicLayoutInspectorErrorInfo.AttachErrorState state2) {
                Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
                String text2 = switch (WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                    case 1 -> "Unknown state";
                    case 2 -> "Starting";
                    case 3 -> "Adb ping success";
                    case 4 -> "Attach success";
                    case 5 -> "Start request sent";
                    case 6 -> "Start request received";
                    case 7 -> "Started";
                    case 8 -> "Roots sent";
                    case 9 -> "Roots received";
                    case 10 -> "Capture started";
                    case 11 -> "Screenshot captured";
                    case 12 -> "Hierarchy captured";
                    case 13 -> "Response sent";
                    case 14 -> "View information received";
                    case 15 -> "Compose information request";
                    case 16 -> "Compose information received";
                    case 17 -> "Legacy window list requested";
                    case 18 -> "Legacy window list received";
                    case 19 -> "Legacy hierarchy requested";
                    case 20 -> "Legacy hierarchy received";
                    case 21 -> "Legacy screenshot requested";
                    case 22 -> "Legacy screenshot received";
                    case 23 -> "Compose tree parsed";
                    case 24 -> "Update complete";
                    default -> throw new NoWhenBranchMatchedException();
                };
                if (((CharSequence)text2).length() > 0) {
                    loadingPane.setLoadingText(text2);
                }
            }

            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[DynamicLayoutInspectorErrorInfo.AttachErrorState.values().length];
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.UNKNOWN_ATTACH_ERROR_STATE.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.NOT_STARTED.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.ADB_PING.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.ATTACH_SUCCESS.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.START_REQUEST_SENT.ordinal()] = 5;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.START_RECEIVED.ordinal()] = 6;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.STARTED.ordinal()] = 7;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.ROOTS_EVENT_SENT.ordinal()] = 8;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.ROOTS_EVENT_RECEIVED.ordinal()] = 9;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.VIEW_INVALIDATION_CALLBACK.ordinal()] = 10;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.SCREENSHOT_CAPTURED.ordinal()] = 11;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.VIEW_HIERARCHY_CAPTURED.ordinal()] = 12;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.RESPONSE_SENT.ordinal()] = 13;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.LAYOUT_EVENT_RECEIVED.ordinal()] = 14;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.COMPOSE_REQUEST_SENT.ordinal()] = 15;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.COMPOSE_RESPONSE_RECEIVED.ordinal()] = 16;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_WINDOW_LIST_REQUESTED.ordinal()] = 17;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_WINDOW_LIST_RECEIVED.ordinal()] = 18;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_HIERARCHY_REQUESTED.ordinal()] = 19;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_HIERARCHY_RECEIVED.ordinal()] = 20;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_SCREENSHOT_REQUESTED.ordinal()] = 21;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_SCREENSHOT_RECEIVED.ordinal()] = 22;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.PARSED_COMPONENT_TREE.ordinal()] = 23;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DynamicLayoutInspectorErrorInfo.AttachErrorState.MODEL_UPDATED.ordinal()] = 24;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        });
        ProcessesModel processesModel = this.layoutInspector.getProcessModel();
        if (processesModel != null) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
            processesModel.addSelectedProcessListeners(executorService, (Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    ProcessDescriptor processDescriptor2 = this.getLayoutInspector().getProcessModel().getSelectedProcess();
                    boolean bl = processDescriptor2 != null ? processDescriptor2.isRunning() : false;
                    if (bl) {
                        loadingPane.startLoading();
                    }
                    if (this.getLayoutInspector().getProcessModel().getSelectedProcess() == null) {
                        loadingPane.stopLoading();
                    }
                }
            }));
        }
        model2.getModificationListeners().add((Object)new Function3<AndroidWindow, AndroidWindow, Boolean, Unit>(){

            public final void invoke(@Nullable AndroidWindow old2, @Nullable AndroidWindow androidWindow, boolean bl) {
                if (old2 == null && androidWindow != null) {
                    loadingPane.stopLoading();
                }
            }
        });
        this.contentPanel.getRenderModel().getModificationListeners().add(new Function0<Unit>(){

            public final void invoke() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        boolean performanceWarningNeeded;
                        actionToolbar.updateActionsImmediately();
                        boolean bl = performanceWarningNeeded = this.getLayoutInspector().getCurrentClient().isCapturing() && (contentPanel.getRenderModel().isRotated() || model2.hasHiddenNodes());
                        if (performanceWarningNeeded != performanceWarningGiven) {
                            if (performanceWarningNeeded) {
                                String string;
                                String string2 = contentPanel.getRenderModel().isRotated() ? LayoutInspectorBundle.INSTANCE.message("performance.warning.3d", new String[0]) : (string = model2.hasHiddenNodes() ? LayoutInspectorBundle.INSTANCE.message("performance.warning.hidden", new String[0]) : null);
                                if (string != null) {
                                    String string3 = string;
                                    InspectorModel inspectorModel = model2;
                                    String it = string3;
                                    boolean bl2 = false;
                                    InspectorBannerService inspectorBannerService = InspectorBannerService.Companion.getInstance(inspectorModel.getProject());
                                    if (inspectorBannerService != null) {
                                        InspectorBannerService.addNotification$default(inspectorBannerService, it, null, 2, null);
                                    }
                                }
                            } else {
                                InspectorBannerService service;
                                InspectorBannerService inspectorBannerService = service = InspectorBannerService.Companion.getInstance(model2.getProject());
                                if (inspectorBannerService != null) {
                                    inspectorBannerService.removeNotification(LayoutInspectorBundle.INSTANCE.message("performance.warning.3d", new String[0]));
                                }
                                InspectorBannerService inspectorBannerService2 = service;
                                if (inspectorBannerService2 != null) {
                                    inspectorBannerService2.removeNotification(LayoutInspectorBundle.INSTANCE.message("performance.warning.hidden", new String[0]));
                                }
                            }
                        }
                        performanceWarningGiven = performanceWarningNeeded;
                    }
                });
            }
        });
        Component component2 = (Component)this.scrollPane;
        Integer n = JLayeredPane.DEFAULT_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"DEFAULT_LAYER");
        this.layeredPane.setLayer(component2, ((Number)n).intValue());
        Component component3 = this.floatingToolbarProvider.getFloatingToolbar();
        Integer n2 = JLayeredPane.PALETTE_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"PALETTE_LAYER");
        this.layeredPane.setLayer(component3, ((Number)n2).intValue());
        this.layeredPane.setLayout(new BorderLayout(){

            @Override
            public void layoutContainer(@Nullable Container parent2) {
                super.layoutContainer(parent2);
                this.updateLayeredPaneSize();
            }
        });
        this.layeredPane.add(this.floatingToolbarProvider.getFloatingToolbar());
        this.layeredPane.add((Component)this.scrollPane, "Center");
        final Ref.BooleanRef shouldZoomToFit = new Ref.BooleanRef();
        shouldZoomToFit.element = true;
        ProcessesModel processesModel2 = this.layoutInspector.getProcessModel();
        if (processesModel2 != null) {
            processesModel2.addSelectedProcessListeners((Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    shouldZoomToFit.element = true;
                }
            }));
        }
        model2.getModificationListeners().add((Object)new Function3<AndroidWindow, AndroidWindow, Boolean, Unit>(){

            public final void invoke(@Nullable AndroidWindow oldWindow, @Nullable AndroidWindow newWindow, boolean bl) {
                if (oldWindow == null && newWindow != null) {
                    this.getLayoutInspector().getCurrentClient().getStats().setRecompositionHighlightColor(renderSettings.getHighlightColor());
                    if (shouldZoomToFit.element) {
                        this.zoom(ZoomType.FIT);
                        shouldZoomToFit.element = false;
                    }
                }
            }
        });
        final Ref.IntRef prevZoom = new Ref.IntRef();
        prevZoom.element = this.renderSettings.getScalePercent();
        this.renderSettings.getModificationListeners().add(new Function0<Unit>(){

            public final void invoke() {
                InspectorClient client2 = this.getLayoutInspector().getCurrentClient();
                if (client2.isCapturing()) {
                    client2.updateScreenshotType(null, (float)renderSettings.getScaleFraction());
                }
                if (prevZoom.element != renderSettings.getScalePercent()) {
                    backgroundExecutor.execute(new Runnable(){

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public final void run() {
                            void $this$forEach$iv;
                            floatingToolbarProvider.zoomChanged((double)prevZoom.element / 100.0, (double)renderSettings.getScalePercent() / 100.0);
                            prevZoom.element = renderSettings.getScalePercent();
                            Collection<AndroidWindow> collection2 = model2.getWindows().values();
                            Intrinsics.checkNotNullExpressionValue(collection2, (String)"model.windows.values");
                            Iterable iterable = collection2;
                            DeviceViewPanel deviceViewPanel = this;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                AndroidWindow it = (AndroidWindow)element$iv;
                                boolean bl = false;
                                it.refreshImages(deviceViewPanel.renderSettings.getScaleFraction());
                            }
                            contentPanel.getRenderModel().refresh();
                        }
                    });
                }
            }
        });
    }

    public /* synthetic */ DeviceViewPanel(LayoutInspector layoutInspector, Disposable disposable2, Executor executor2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            executor2 = AndroidExecutors.Companion.getInstance().getWorkerThreadExecutor();
        }
        this(layoutInspector, disposable2, executor2);
    }

    @NotNull
    public final LayoutInspector getLayoutInspector() {
        return this.layoutInspector;
    }

    public double getScale() {
        return this.renderSettings.getScaleFraction();
    }

    public double getScreenScalingFactor() {
        return this.screenScalingFactor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPanning() {
        if (!this.isPanning && !this.isMiddleMousePressed) {
            if (!this.isSpacePressed) return false;
        }
        if (this.layoutInspector.isSnapshot()) return true;
        ProcessesModel processesModel = this.layoutInspector.getProcessModel();
        if (processesModel == null) return false;
        ProcessDescriptor processDescriptor2 = processesModel.getSelectedProcess();
        if (processDescriptor2 == null) return false;
        return true;
    }

    public void setPanning(boolean bl) {
        this.isPanning = bl;
    }

    private final void showGrab() {
        this.setCursor(this.isPanning() ? AdtUiCursorsProvider.Companion.getInstance().getCursor(AdtUiCursorType.GRAB) : Cursor.getDefaultCursor());
    }

    public final void onNewForegroundProcess(@NotNull ForegroundProcess foregroundProcess) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)foregroundProcess, (String)"foregroundProcess");
        if (this.layoutInspector.getProcessModel() == null) {
            bl = false;
        } else {
            this.hasForegroundProcess = true;
            ProcessDescriptor processDescriptor2 = ForegroundProcessDetectionKt.matchToProcessDescriptor(foregroundProcess, this.layoutInspector.getProcessModel());
            bl = processDescriptor2 != null;
        }
        this.isCurrentForegroundProcessDebuggable = bl;
    }

    private final void updateLayeredPaneSize() {
        this.scrollPane.setSize(this.layeredPane.getSize());
        JComponent floatingToolbar = this.floatingToolbarProvider.getFloatingToolbar();
        floatingToolbar.setSize(floatingToolbar.getPreferredSize());
        floatingToolbar.setLocation(new Point(this.layeredPane.getWidth() - floatingToolbar.getWidth() - 14, this.layeredPane.getHeight() - floatingToolbar.getHeight() - 14));
    }

    public boolean zoom(@NotNull ZoomType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        int newZoom = this.renderSettings.getScalePercent();
        this.viewportLayoutManager.setCurrentZoomOperation(type);
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                newZoom = this.getFitZoom();
                break;
            }
            case 2: {
                newZoom = 100;
                break;
            }
            case 3: {
                newZoom += 10;
                break;
            }
            case 4: {
                newZoom -= 10;
            }
        }
        newZoom = RangesKt.coerceIn((int)newZoom, (int)10, (int)300);
        if (newZoom != this.renderSettings.getScalePercent()) {
            this.renderSettings.setScalePercent(newZoom);
            this.contentPanel.revalidate();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final int getFitZoom() {
        Dimension size = this.getScreenSize();
        int availableWidth = this.scrollPane.getWidth() - this.scrollPane.getVerticalScrollBar().getWidth();
        int availableHeight = this.scrollPane.getHeight() - this.scrollPane.getHorizontalScrollBar().getHeight();
        double desiredWidth = size.width;
        double desiredHeight = size.height;
        return desiredHeight == 0.0 || desiredWidth == 0.0 ? 100 : (int)((double)90 * Math.min((double)availableHeight / desiredHeight, (double)availableWidth / desiredWidth));
    }

    private final Dimension getScreenSize() {
        Dimension size = this.layoutInspector.getInspectorModel().getResourceLookup().getScreenDimension();
        if (size != null) {
            return size;
        }
        ViewNode root = this.layoutInspector.getInspectorModel().getRoot();
        return new Dimension(root.getLayoutBounds().width, root.getLayoutBounds().height);
    }

    public boolean canZoomIn() {
        return this.renderSettings.getScalePercent() < 300 && !this.layoutInspector.getInspectorModel().isEmpty();
    }

    public boolean canZoomOut() {
        return this.renderSettings.getScalePercent() > 10 && !this.layoutInspector.getInspectorModel().isEmpty();
    }

    public boolean canZoomToFit() {
        return !this.layoutInspector.getInspectorModel().isEmpty() && this.getFitZoom() != this.renderSettings.getScalePercent();
    }

    public boolean canZoomToActual() {
        return this.renderSettings.getScalePercent() < 100 && this.canZoomIn() || this.renderSettings.getScalePercent() > 100 && this.canZoomOut();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (ZoomableKt.ZOOMABLE_KEY.is(dataId) || PannableKt.PANNABLE_KEY.is(dataId)) {
            return this;
        }
        if (RenderModelKt.getDEVICE_VIEW_MODEL_KEY().is(dataId)) {
            return this.contentPanel.getRenderModel();
        }
        if (RenderSettingsKt.getDEVICE_VIEW_SETTINGS_KEY().is(dataId)) {
            return this.renderSettings;
        }
        if (DeviceViewPanelKt.getTOGGLE_3D_ACTION_BUTTON_KEY().is(dataId)) {
            return this.floatingToolbarProvider.getToggle3dActionButton();
        }
        return null;
    }

    public boolean isPannable() {
        return this.contentPanel.getWidth() > this.scrollPane.getViewport().getWidth() || this.contentPanel.getHeight() > this.scrollPane.getViewport().getHeight();
    }

    @NotNull
    public Point getScrollPosition() {
        Point point = this.scrollPane.getViewport().getViewPosition();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"scrollPane.viewport.viewPosition");
        return point;
    }

    public void setScrollPosition(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"<anonymous parameter 0>");
    }

    private final JComponent createToolbarPanel(ActionToolbar actionToolbar) {
        AdtPrimaryPanel panel2 = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        panel2.setBorder((Border)BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)StudioColorsKt.getBorder()));
        AdtPrimaryPanel leftPanel = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        leftPanel.add((Component)actionToolbar.getComponent(), (Object)"Center");
        panel2.add((Component)leftPanel, (Object)"Center");
        return (JComponent)panel2;
    }

    public static final /* synthetic */ boolean access$isLoading$p(DeviceViewPanel $this) {
        return $this.isLoading;
    }

    public static final /* synthetic */ boolean access$isCurrentForegroundProcessDebuggable$p(DeviceViewPanel $this) {
        return $this.isCurrentForegroundProcessDebuggable;
    }

    public static final /* synthetic */ boolean access$getHasForegroundProcess$p(DeviceViewPanel $this) {
        return $this.hasForegroundProcess;
    }

    public static final /* synthetic */ void access$setMiddleMousePressed$p(DeviceViewPanel $this, boolean bl) {
        $this.isMiddleMousePressed = bl;
    }

    public static final /* synthetic */ void access$setLastPanMouseLocation$p(DeviceViewPanel $this, Point point) {
        $this.lastPanMouseLocation = point;
    }

    public static final /* synthetic */ Point access$getLastPanMouseLocation$p(DeviceViewPanel $this) {
        return $this.lastPanMouseLocation;
    }

    public static final /* synthetic */ JBScrollPane access$getScrollPane$p(DeviceViewPanel $this) {
        return $this.scrollPane;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ZoomType.values().length];
            try {
                nArray[ZoomType.FIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.ACTUAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.IN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.OUT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

