/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.skia;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.io.grpc.netty.NettyChannelBuilder;
import com.android.tools.idea.io.grpc.stub.AbstractStub;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.layoutinspector.proto.SkiaParser;
import com.android.tools.idea.layoutinspector.proto.SkiaParserServiceGrpc;
import com.android.tools.idea.layoutinspector.skia.ParsingFailedException;
import com.android.tools.idea.layoutinspector.skia.UnsupportedPictureVersionException;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.protobuf.Empty;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.net.NetUtils;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0007J>\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J>\u0010\u001d\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007J\u0006\u0010 \u001a\u00020\u001fJ\b\u0010!\u001a\u00020\u001fH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/layoutinspector/skia/SkiaParserServerConnection;", "", "serverPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "channel", "Lcom/android/tools/idea/io/grpc/ManagedChannel;", "client", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParserServiceGrpc$SkiaParserServiceStub;", "getClient", "()Lcom/android/tools/idea/layoutinspector/proto/SkiaParserServiceGrpc$SkiaParserServiceStub;", "setClient", "(Lcom/android/tools/idea/layoutinspector/proto/SkiaParserServiceGrpc$SkiaParserServiceStub;)V", "handler", "Lcom/intellij/execution/process/OSProcessHandler;", "createGrpcClient", "", "getViewTree", "Lkotlin/Pair;", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParser$InspectorView;", "", "Lcom/android/tools/idea/protobuf/ByteString;", "data", "", "requestedNodes", "", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParser$RequestedNodeInfo;", "scale", "", "getViewTreeImpl", "ping", "", "runServer", "shutdown", "intellij.android.layout-inspector"})
public final class SkiaParserServerConnection {
    @NotNull
    private final Path serverPath;
    public SkiaParserServiceGrpc.SkiaParserServiceStub client;
    private ManagedChannel channel;
    @Nullable
    private OSProcessHandler handler;

    public SkiaParserServerConnection(@NotNull Path serverPath) {
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        this.serverPath = serverPath;
    }

    @NotNull
    public final SkiaParserServiceGrpc.SkiaParserServiceStub getClient() {
        SkiaParserServiceGrpc.SkiaParserServiceStub skiaParserServiceStub = this.client;
        if (skiaParserServiceStub != null) {
            return skiaParserServiceStub;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        return null;
    }

    public final void setClient(@NotNull SkiaParserServiceGrpc.SkiaParserServiceStub skiaParserServiceStub) {
        Intrinsics.checkNotNullParameter((Object)skiaParserServiceStub, (String)"<set-?>");
        this.client = skiaParserServiceStub;
    }

    /*
     * WARNING - void declaration
     */
    public final void runServer() {
        void $this$runServer_u24lambda_u240;
        int localPort = this.createGrpcClient();
        String[] stringArray = new String[]{((Object)this.serverPath.toAbsolutePath()).toString(), String.valueOf(localPort)};
        String[] stringArray2 = stringArray = new OSProcessHandler.Silent(new GeneralCommandLine(stringArray));
        SkiaParserServerConnection skiaParserServerConnection = this;
        boolean bl = false;
        $this$runServer_u24lambda_u240.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                if (event2.getExitCode() == 0) {
                    Logger.getInstance(SkiaParserServerConnection.class).info("SkiaServer terminated successfully");
                } else {
                    Logger.getInstance(SkiaParserServerConnection.class).warn("SkiaServer terminated exitCode: " + event2.getExitCode() + "  text: " + event2.getText());
                }
            }

            public void processWillTerminate(@NotNull ProcessEvent event2, boolean willBeDestroyed) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                Logger.getInstance(SkiaParserServerConnection.class).debug("SkiaServer willTerminate");
            }

            public void onTextAvailable(@NotNull ProcessEvent event2, @NotNull Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                Logger.getInstance(SkiaParserServerConnection.class).info("SkiaServer Message: " + event2.getText());
            }
        });
        $this$runServer_u24lambda_u240.startNotify();
        skiaParserServerConnection.handler = (OSProcessHandler)stringArray;
    }

    @VisibleForTesting
    @WorkerThread
    public final int createGrpcClient() {
        int localPort = NetUtils.findAvailableSocketPort();
        if (localPort < 0) {
            throw new Exception("Unable to find available socket port");
        }
        ManagedChannel managedChannel = NettyChannelBuilder.forAddress((String)"localhost", (int)localPort).usePlaintext().maxInboundMessageSize(0x1FFFFFFF).build();
        Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"forAddress(\"localhost\", \u2026 1024 - 1)\n      .build()");
        this.channel = managedChannel;
        ManagedChannel managedChannel2 = this.channel;
        if (managedChannel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
            managedChannel2 = null;
        }
        AbstractStub abstractStub = SkiaParserServiceGrpc.newStub((Channel)((Channel)managedChannel2)).withWaitForReady();
        Intrinsics.checkNotNullExpressionValue((Object)abstractStub, (String)"newStub(channel).withWaitForReady()");
        this.setClient((SkiaParserServiceGrpc.SkiaParserServiceStub)abstractStub);
        return localPort;
    }

    @Slow
    public final void shutdown() {
        block3: {
            ManagedChannel managedChannel;
            CountDownLatch lock = new CountDownLatch(1);
            this.getClient().shutdown(Empty.getDefaultInstance(), (StreamObserver)new StreamObserver<Empty>(lock){
                final /* synthetic */ CountDownLatch $lock;
                {
                    this.$lock = $lock;
                }

                public void onNext(@Nullable Empty ignore) {
                    this.$lock.countDown();
                }

                public void onError(@Nullable Throwable error) {
                }

                public void onCompleted() {
                }
            });
            if (!lock.await(10L, TimeUnit.SECONDS)) {
                Logger.getInstance(SkiaParserServerConnection.class).warn("Timed out waiting for skia parser shutdown. A skia-grpc-server process could have been orphaned.");
            }
            if ((managedChannel = this.channel) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
                managedChannel = null;
            }
            managedChannel.shutdownNow();
            ManagedChannel managedChannel2 = this.channel;
            if (managedChannel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
                managedChannel2 = null;
            }
            managedChannel2.awaitTermination(1L, TimeUnit.SECONDS);
            OSProcessHandler oSProcessHandler = this.handler;
            if (oSProcessHandler == null) break block3;
            oSProcessHandler.destroyProcess();
        }
    }

    @Slow
    @NotNull
    public final Pair<SkiaParser.InspectorView, Map<Integer, ByteString>> getViewTree(@NotNull byte[] data, @NotNull Iterable<SkiaParser.RequestedNodeInfo> requestedNodes, double scale) throws ParsingFailedException, UnsupportedPictureVersionException {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(requestedNodes, (String)"requestedNodes");
        this.ping();
        return this.getViewTreeImpl(data, requestedNodes, scale);
    }

    @Slow
    public final void ping() {
        long delay = 10L;
        Ref.ObjectRef lastException = new Ref.ObjectRef();
        for (int tries = 0; tries < 10; ++tries) {
            try {
                CountDownLatch lock = new CountDownLatch(1);
                this.getClient().ping(Empty.getDefaultInstance(), (StreamObserver)new StreamObserver<Empty>(lock, (Ref.ObjectRef<Throwable>)lastException){
                    final /* synthetic */ CountDownLatch $lock;
                    final /* synthetic */ Ref.ObjectRef<Throwable> $lastException;
                    {
                        this.$lock = $lock;
                        this.$lastException = $lastException;
                    }

                    public void onNext(@Nullable Empty ignore) {
                        this.$lock.countDown();
                    }

                    public void onError(@Nullable Throwable error) {
                        Throwable throwable = error;
                        if (throwable != null) {
                            throwable.printStackTrace();
                        }
                        this.$lastException.element = error;
                    }

                    public void onCompleted() {
                    }
                });
                if (lock.await(1L, TimeUnit.SECONDS)) {
                    return;
                }
            }
            catch (TimeoutException ignore) {
                lastException.element = ignore;
            }
            catch (StatusRuntimeException ex) {
                if (ex.getStatus().getCode() != Status.Code.UNAVAILABLE) {
                    throw ex;
                }
                lastException.element = ex;
            }
            Thread.sleep(delay);
            delay = Math.min((long)2 * delay, 1000L);
        }
        Object object = lastException.element;
        Intrinsics.checkNotNull((Object)object);
        throw (Throwable)object;
    }

    private final Pair<SkiaParser.InspectorView, Map<Integer, ByteString>> getViewTreeImpl(byte[] data, Iterable<SkiaParser.RequestedNodeInfo> requestedNodes, double scale) {
        SkiaParser.InspectorView inspectorView;
        CompletableFuture<SkiaParser.InspectorView> responseFuture = new CompletableFuture<SkiaParser.InspectorView>();
        Map images = new LinkedHashMap();
        StreamObserver streamObserver = this.getClient().getViewTree2((StreamObserver)new StreamObserver<SkiaParser.GetViewTreeResponse>((Map<Integer, ByteString>)images, responseFuture){
            @Nullable
            private SkiaParser.GetViewTreeResponse lastResponse;
            final /* synthetic */ Map<Integer, ByteString> $images;
            final /* synthetic */ CompletableFuture<SkiaParser.InspectorView> $responseFuture;
            {
                this.$images = $images;
                this.$responseFuture = $responseFuture;
            }

            public void onNext(@NotNull SkiaParser.GetViewTreeResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.lastResponse = response2;
                if (response2.getImageId() > 0) {
                    Map<Integer, ByteString> map2 = this.$images;
                    Integer n = response2.getImageId();
                    ByteString byteString = response2.getImage();
                    Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"response.image");
                    ByteString byteString2 = byteString;
                    map2.put(n, byteString2);
                }
            }

            public void onError(@Nullable Throwable error) {
                Throwable throwable = error;
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                this.$responseFuture.completeExceptionally(error);
            }

            public void onCompleted() {
                SkiaParser.InspectorView root;
                SkiaParser.GetViewTreeResponse getViewTreeResponse = this.lastResponse;
                Object object = root = getViewTreeResponse != null ? getViewTreeResponse.getRoot() : null;
                if (root != null) {
                    this.$responseFuture.complete(root);
                } else {
                    this.$responseFuture.completeExceptionally(new ParsingFailedException());
                }
            }
        });
        Intrinsics.checkNotNull((Object)streamObserver);
        StreamObserver requestObserver2 = streamObserver;
        int n = data.length + -1;
        int offset = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)0x100000);
        if (offset <= n2) {
            while (true) {
                int size = Math.min(0x100000, data.length - offset);
                SkiaParser.GetViewTreeRequest.Builder requestBuilder = SkiaParser.GetViewTreeRequest.newBuilder().setVersion(2).setTotalSize(data.length).setSkp(ByteString.copyFrom((byte[])data, (int)offset, (int)size));
                if (offset + size == data.length) {
                    requestBuilder.addAllRequestedNodes(requestedNodes).setScale((float)scale);
                    requestObserver2.onNext((Object)requestBuilder.build());
                    requestObserver2.onCompleted();
                } else {
                    requestObserver2.onNext((Object)requestBuilder.build());
                }
                if (offset == n2) break;
                offset += 0x100000;
            }
        }
        try {
            inspectorView = responseFuture.get();
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable == null) {
                throwable = executionException;
            }
            throw throwable;
        }
        SkiaParser.InspectorView root = inspectorView;
        return new Pair((Object)root, (Object)images);
    }
}

