/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.runningdevices;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.layoutinspector.runningdevices.LayoutInspectorManager;
import com.android.tools.idea.layoutinspector.runningdevices.RunningDevicesStateObserver;
import com.android.tools.idea.layoutinspector.runningdevices.TabId;
import com.android.tools.idea.streaming.RunningDevicesConstants;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/layoutinspector/runningdevices/ToggleLayoutInspectorAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.android.layout-inspector"})
public final class ToggleLayoutInspectorAction
extends ToggleAction {
    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        String string = (String)RunningDevicesConstants.SERIAL_NUMBER_KEY.getData(e.getDataContext());
        if (string == null) {
            return false;
        }
        String deviceSerialNumber = string;
        return LayoutInspectorManager.Companion.getInstance(project2).isEnabled(new TabId(deviceSerialNumber));
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String string = (String)RunningDevicesConstants.SERIAL_NUMBER_KEY.getData(e.getDataContext());
        if (string == null) {
            return;
        }
        String deviceSerialNumber = string;
        LayoutInspectorManager.Companion.getInstance(project2).enableLayoutInspector(new TabId(deviceSerialNumber), state2);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Boolean isEnabled2 = (Boolean)StudioFlags.DYNAMIC_LAYOUT_INSPECTOR_IN_RUNNING_DEVICES_ENABLED.get();
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)isEnabled2, (String)"isEnabled");
        presentation.setVisible(isEnabled2.booleanValue());
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        RunningDevicesStateObserver.Companion.getInstance(project2).update(isEnabled2);
    }
}

