/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.runningdevices;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.layoutinspector.model.DrawViewNode;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.runningdevices.LayoutInspectorRendererKt;
import com.android.tools.idea.layoutinspector.ui.RenderLogic;
import com.android.tools.idea.layoutinspector.ui.RenderModel;
import com.android.tools.idea.layoutinspector.ui.ViewDrawInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\nJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorRenderer;", "", "renderLogic", "Lcom/android/tools/idea/layoutinspector/ui/RenderLogic;", "renderModel", "Lcom/android/tools/idea/layoutinspector/ui/RenderModel;", "component", "Ljava/awt/Component;", "displayRectangleProvider", "Lkotlin/Function0;", "Ljava/awt/Rectangle;", "screenScaleProvider", "", "(Lcom/android/tools/idea/layoutinspector/ui/RenderLogic;Lcom/android/tools/idea/layoutinspector/ui/RenderModel;Ljava/awt/Component;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getTransform", "Ljava/awt/geom/AffineTransform;", "displayRectangle", "paint", "", "g", "Ljava/awt/Graphics;", "toModelCoordinates", "Ljava/awt/geom/Point2D;", "originalCoordinates", "LayoutInspectorMouseListener", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nLayoutInspectorRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutInspectorRenderer.kt\ncom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class LayoutInspectorRenderer {
    @NotNull
    private final RenderLogic renderLogic;
    @NotNull
    private final RenderModel renderModel;
    @NotNull
    private final Component component;
    @NotNull
    private final Function0<Rectangle> displayRectangleProvider;
    @NotNull
    private final Function0<Double> screenScaleProvider;

    public LayoutInspectorRenderer(@NotNull RenderLogic renderLogic, @NotNull RenderModel renderModel, @NotNull Component component2, @NotNull Function0<? extends Rectangle> displayRectangleProvider, @NotNull Function0<Double> screenScaleProvider) {
        Intrinsics.checkNotNullParameter((Object)renderLogic, (String)"renderLogic");
        Intrinsics.checkNotNullParameter((Object)renderModel, (String)"renderModel");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter(displayRectangleProvider, (String)"displayRectangleProvider");
        Intrinsics.checkNotNullParameter(screenScaleProvider, (String)"screenScaleProvider");
        this.renderLogic = renderLogic;
        this.renderModel = renderModel;
        this.component = component2;
        this.displayRectangleProvider = displayRectangleProvider;
        this.screenScaleProvider = screenScaleProvider;
        this.renderLogic.getRenderSettings().setScalePercent(30);
        LayoutInspectorMouseListener layoutInspectorMouseListener = new LayoutInspectorMouseListener(this.renderModel);
        this.component.addMouseListener(layoutInspectorMouseListener);
        this.component.addMouseMotionListener(layoutInspectorMouseListener);
    }

    private final AffineTransform getTransform(Rectangle displayRectangle) {
        AffineTransform affineTransform;
        ViewNode rootView2 = this.renderModel.getModel().getRoot();
        double scale = (double)displayRectangle.width / (double)rootView2.getLayoutBounds().getBounds().width;
        AffineTransform $this$getTransform_u24lambda_u240 = affineTransform = new AffineTransform();
        boolean bl = false;
        $this$getTransform_u24lambda_u240.translate((double)displayRectangle.x + (double)displayRectangle.width / 2.0, (double)displayRectangle.y + (double)displayRectangle.height / 2.0);
        $this$getTransform_u24lambda_u240.scale(scale, scale);
        return affineTransform;
    }

    /*
     * WARNING - void declaration
     */
    public final void paint(@NotNull Graphics g, @NotNull Rectangle displayRectangle) {
        void $this$paint_u24lambda_u241;
        AffineTransform affineTransform;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)displayRectangle, (String)"displayRectangle");
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor((Color)StudioColorsKt.getPrimaryPanelBackground());
        AffineTransform transform2 = this.getTransform(displayRectangle);
        AffineTransform affineTransform2 = affineTransform = g2d.getTransform();
        Graphics2D graphics2D = g2d;
        boolean bl = false;
        $this$paint_u24lambda_u241.concatenate(transform2);
        graphics2D.setTransform(affineTransform);
        Color color = this.component.getForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"component.foreground");
        this.renderLogic.renderBorders(g2d, this.component, color);
        this.renderLogic.renderOverlay(g2d);
    }

    private final Point2D toModelCoordinates(Point2D originalCoordinates) {
        Point2D.Double scaledCoordinates = LayoutInspectorRendererKt.access$scale(originalCoordinates, ((Number)this.screenScaleProvider.invoke()).doubleValue());
        Point2D.Double transformedPoint2D = new Point2D.Double();
        Rectangle rectangle = (Rectangle)this.displayRectangleProvider.invoke();
        if (rectangle == null) {
            return null;
        }
        Rectangle displayRectangle = rectangle;
        AffineTransform transform2 = this.getTransform(displayRectangle);
        transform2.inverseTransform(scaledCoordinates, transformedPoint2D);
        return transformedPoint2D;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorRenderer$LayoutInspectorMouseListener;", "Ljava/awt/event/MouseAdapter;", "renderModel", "Lcom/android/tools/idea/layoutinspector/ui/RenderModel;", "(Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorRenderer;Lcom/android/tools/idea/layoutinspector/ui/RenderModel;)V", "mouseMoved", "", "e", "Ljava/awt/event/MouseEvent;", "intellij.android.layout-inspector"})
    private final class LayoutInspectorMouseListener
    extends MouseAdapter {
        @NotNull
        private final RenderModel renderModel;

        public LayoutInspectorMouseListener(RenderModel renderModel) {
            Intrinsics.checkNotNullParameter((Object)renderModel, (String)"renderModel");
            this.renderModel = renderModel;
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.isConsumed()) {
                return;
            }
            Point2D point2D = LayoutInspectorRenderer.this.toModelCoordinates(LayoutInspectorRendererKt.access$coordinates(e));
            if (point2D == null) {
                return;
            }
            Point2D modelCoordinates = point2D;
            ViewDrawInfo hoveredNodeDrawInfo = (ViewDrawInfo)SequencesKt.firstOrNull(this.renderModel.findDrawInfoAt(modelCoordinates.getX(), modelCoordinates.getY()));
            this.renderModel.getModel().setHoveredNode((object = hoveredNodeDrawInfo) != null && (object = ((ViewDrawInfo)object).getNode()) != null ? ((DrawViewNode)object).findFilteredOwner(this.renderModel.getTreeSettings()) : null);
            LayoutInspectorRenderer.this.component.invalidate();
            LayoutInspectorRenderer.this.component.repaint();
        }
    }
}

