/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.runningdevices;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.appinspection.inspector.api.process.DeviceDescriptor;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.DeviceModel;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetection;
import com.android.tools.idea.layoutinspector.runningdevices.DisplayViewManager;
import com.android.tools.idea.layoutinspector.runningdevices.LayoutInspectorManager;
import com.android.tools.idea.layoutinspector.runningdevices.LayoutInspectorManagerKt;
import com.android.tools.idea.layoutinspector.runningdevices.RunningDevicesStateObserver;
import com.android.tools.idea.layoutinspector.runningdevices.RunningDevicesStateObserverKt;
import com.android.tools.idea.layoutinspector.runningdevices.TabId;
import com.android.tools.idea.layoutinspector.runningdevices.WrapLogic;
import com.android.tools.idea.layoutinspector.ui.toolbar.LayoutInspectorMainToolbarKt;
import com.android.tools.idea.streaming.AbstractDisplayView;
import com.android.tools.idea.streaming.StreamingConstants;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0018\u0010\u001b\u001a\u00020\u00132\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u000e0\r@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManagerImpl;", "Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "value", "Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManagerImpl$SelectedTabState;", "selectedTab", "setSelectedTab", "(Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManagerImpl$SelectedTabState;)V", "stateListeners", "", "Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManager$StateListener;", "", "Lcom/android/tools/idea/layoutinspector/runningdevices/TabId;", "tabsWithLayoutInspector", "setTabsWithLayoutInspector", "(Ljava/util/Set;)V", "addStateListener", "", "listener", "createTabState", "tabId", "enableLayoutInspector", "enable", "", "isEnabled", "updateListeners", "listenersToUpdate", "", "SelectedTabState", "TabComponents", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nLayoutInspectorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutInspectorManager.kt\ncom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1#2:286\n1851#3,2:287\n*S KotlinDebug\n*F\n+ 1 LayoutInspectorManager.kt\ncom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManagerImpl\n*L\n199#1:287,2\n*E\n"})
final class LayoutInspectorManagerImpl
implements LayoutInspectorManager {
    @NotNull
    private final Project project;
    @NotNull
    private Set<TabId> tabsWithLayoutInspector;
    @Nullable
    private SelectedTabState selectedTab;
    @NotNull
    private final List<LayoutInspectorManager.StateListener> stateListeners;

    public LayoutInspectorManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.tabsWithLayoutInspector = SetsKt.emptySet();
        this.stateListeners = new ArrayList();
        RunningDevicesStateObserver.Companion.getInstance(this.project).addListener(new RunningDevicesStateObserver.Listener(){

            @Override
            public void onSelectedTabChanged(@Nullable TabId tabId) {
                this.setSelectedTab(tabId != null && tabsWithLayoutInspector.contains(tabId) ? this.createTabState(tabId) : null);
            }

            @Override
            public void onExistingTabsChanged(@NotNull List<TabId> existingTabs) {
                Intrinsics.checkNotNullParameter(existingTabs, (String)"existingTabs");
            }
        });
    }

    private final void setTabsWithLayoutInspector(Set<TabId> value2) {
        if (Intrinsics.areEqual(value2, this.tabsWithLayoutInspector)) {
            return;
        }
        Set removedTabs = SetsKt.minus(this.tabsWithLayoutInspector, (Iterable)value2);
        SelectedTabState selectedTabState = this.selectedTab;
        if (CollectionsKt.contains((Iterable)removedTabs, (Object)(selectedTabState != null ? selectedTabState.getTabId() : null))) {
            this.setSelectedTab(null);
        }
        this.tabsWithLayoutInspector = value2;
        LayoutInspectorManagerImpl.updateListeners$default(this, null, 1, null);
    }

    private final void setSelectedTab(SelectedTabState value2) {
        block9: {
            DeviceDescriptor selectedDevice;
            Object object;
            if (Intrinsics.areEqual((Object)this.selectedTab, (Object)value2)) {
                return;
            }
            SelectedTabState selectedTabState = this.selectedTab;
            if (selectedTabState != null) {
                selectedTabState.disableLayoutInspector();
            }
            if ((object = this.selectedTab) != null && (object = ((SelectedTabState)object).getLayoutInspector()) != null) {
                ((LayoutInspector)object).stopInspector();
            }
            this.selectedTab = value2;
            Object object2 = value2;
            if (object2 != null && (object2 = ((SelectedTabState)object2).getLayoutInspector()) != null && (object2 = ((LayoutInspector)object2).getDeviceModel()) != null && (object2 = ((DeviceModel)object2).getDevices()) != null) {
                Object v3;
                block8: {
                    Iterable iterable = (Iterable)object2;
                    for (Object t : iterable) {
                        DeviceDescriptor it = (DeviceDescriptor)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getSerial(), (Object)value2.getTabId().getDeviceSerialNumber())) continue;
                        v3 = t;
                        break block8;
                    }
                    v3 = null;
                }
                v4 = v3;
            } else {
                v4 = selectedDevice = null;
            }
            if (selectedDevice != null) {
                ForegroundProcessDetection foregroundProcessDetection = value2.getLayoutInspector().getForegroundProcessDetection();
                if (foregroundProcessDetection != null) {
                    foregroundProcessDetection.startPollingDevice(selectedDevice);
                }
            }
            SelectedTabState selectedTabState2 = value2;
            if (selectedTabState2 == null) break block9;
            selectedTabState2.enableLayoutInspector();
        }
    }

    private final SelectedTabState createTabState(TabId tabId) {
        AbstractDisplayView displayView;
        DataProvider selectedTabDataProvider;
        Content selectedTabContent;
        Content content2;
        Object object;
        block6: {
            Content[] runningDevicesContentManager;
            Content[] contentArray = runningDevicesContentManager = RunningDevicesStateObserverKt.getRunningDevicesContentManager(this.project);
            if (runningDevicesContentManager != null && (contentArray = contentArray.getContents()) != null) {
                object = contentArray;
                int n = ((Content[])object).length;
                for (int i = 0; i < n; ++i) {
                    Content content3;
                    Content it = content3 = object[i];
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!Intrinsics.areEqual((Object)LayoutInspectorManagerKt.access$getTabId(it), (Object)tabId)) continue;
                    content2 = content3;
                    break block6;
                }
                content2 = null;
            } else {
                content2 = null;
            }
        }
        Content content4 = selectedTabContent = content2;
        JComponent jComponent = content4 != null ? content4.getComponent() : null;
        DataProvider dataProvider = selectedTabDataProvider = jComponent instanceof DataProvider ? (DataProvider)jComponent : null;
        object = dataProvider != null ? dataProvider.getData(StreamingConstants.STREAMING_CONTENT_PANEL_KEY.getName()) : null;
        JComponent streamingContentPanel = object instanceof JComponent ? (JComponent)object : null;
        DataProvider dataProvider2 = selectedTabDataProvider;
        Object object2 = dataProvider2 != null ? dataProvider2.getData(StreamingConstants.DISPLAY_VIEW_KEY.getName()) : null;
        AbstractDisplayView abstractDisplayView = displayView = object2 instanceof AbstractDisplayView ? (AbstractDisplayView)((Object)object2) : null;
        if (selectedTabContent == null) {
            object2 = "Required value was null.";
            throw new IllegalStateException(object2.toString());
        }
        if (streamingContentPanel == null) {
            object2 = "Required value was null.";
            throw new IllegalStateException(object2.toString());
        }
        if (displayView == null) {
            object2 = "Required value was null.";
            throw new IllegalStateException(object2.toString());
        }
        Disposable disposable2 = (Disposable)selectedTabContent;
        Container container = streamingContentPanel.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"streamingContentPanel.parent");
        TabComponents tabComponents = new TabComponents(disposable2, streamingContentPanel, container, displayView);
        return new SelectedTabState(this.project, tabId, tabComponents, LayoutInspectorManagerKt.access$getLayoutInspector(this.project), null, null, 48, null);
    }

    @Override
    public void addStateListener(@NotNull LayoutInspectorManager.StateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateListeners(CollectionsKt.listOf((Object)listener2));
        this.stateListeners.add(listener2);
    }

    @Override
    public void enableLayoutInspector(@NotNull TabId tabId, boolean enable) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (enable) {
            if (this.tabsWithLayoutInspector.contains(tabId)) {
                return;
            }
            this.setTabsWithLayoutInspector(SetsKt.plus(this.tabsWithLayoutInspector, (Object)tabId));
            this.setSelectedTab(this.createTabState(tabId));
        } else {
            if (!this.tabsWithLayoutInspector.contains(tabId)) {
                return;
            }
            this.setTabsWithLayoutInspector(SetsKt.minus(this.tabsWithLayoutInspector, (Object)tabId));
            SelectedTabState selectedTabState = this.selectedTab;
            if (Intrinsics.areEqual((Object)(selectedTabState != null ? selectedTabState.getTabId() : null), (Object)tabId)) {
                this.setSelectedTab(null);
            }
        }
    }

    @Override
    public boolean isEnabled(@NotNull TabId tabId) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.tabsWithLayoutInspector.contains(tabId);
    }

    private final void updateListeners(List<? extends LayoutInspectorManager.StateListener> listenersToUpdate) {
        Iterable $this$forEach$iv = listenersToUpdate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LayoutInspectorManager.StateListener listener2 = (LayoutInspectorManager.StateListener)element$iv;
            boolean bl = false;
            listener2.onStateUpdate(this.tabsWithLayoutInspector);
        }
    }

    static /* synthetic */ void updateListeners$default(LayoutInspectorManagerImpl layoutInspectorManagerImpl, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = layoutInspectorManagerImpl.stateListeners;
        }
        layoutInspectorManagerImpl.updateListeners(list2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000bH\u00c6\u0003J\t\u0010 \u001a\u00020\rH\u00c6\u0003JE\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManagerImpl$SelectedTabState;", "", "project", "Lcom/intellij/openapi/project/Project;", "tabId", "Lcom/android/tools/idea/layoutinspector/runningdevices/TabId;", "tabComponents", "Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManagerImpl$TabComponents;", "layoutInspector", "Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "wrapLogic", "Lcom/android/tools/idea/layoutinspector/runningdevices/WrapLogic;", "displayViewManager", "Lcom/android/tools/idea/layoutinspector/runningdevices/DisplayViewManager;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/layoutinspector/runningdevices/TabId;Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManagerImpl$TabComponents;Lcom/android/tools/idea/layoutinspector/LayoutInspector;Lcom/android/tools/idea/layoutinspector/runningdevices/WrapLogic;Lcom/android/tools/idea/layoutinspector/runningdevices/DisplayViewManager;)V", "getDisplayViewManager", "()Lcom/android/tools/idea/layoutinspector/runningdevices/DisplayViewManager;", "getLayoutInspector", "()Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTabComponents", "()Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManagerImpl$TabComponents;", "getTabId", "()Lcom/android/tools/idea/layoutinspector/runningdevices/TabId;", "getWrapLogic", "()Lcom/android/tools/idea/layoutinspector/runningdevices/WrapLogic;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "disableLayoutInspector", "", "enableLayoutInspector", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.layout-inspector"})
    private static final class SelectedTabState {
        @NotNull
        private final Project project;
        @NotNull
        private final TabId tabId;
        @NotNull
        private final TabComponents tabComponents;
        @NotNull
        private final LayoutInspector layoutInspector;
        @NotNull
        private final WrapLogic wrapLogic;
        @NotNull
        private final DisplayViewManager displayViewManager;

        public SelectedTabState(@NotNull Project project, @NotNull TabId tabId, @NotNull TabComponents tabComponents, @NotNull LayoutInspector layoutInspector, @NotNull WrapLogic wrapLogic, @NotNull DisplayViewManager displayViewManager) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
            Intrinsics.checkNotNullParameter((Object)tabComponents, (String)"tabComponents");
            Intrinsics.checkNotNullParameter((Object)layoutInspector, (String)"layoutInspector");
            Intrinsics.checkNotNullParameter((Object)wrapLogic, (String)"wrapLogic");
            Intrinsics.checkNotNullParameter((Object)displayViewManager, (String)"displayViewManager");
            this.project = project;
            this.tabId = tabId;
            this.tabComponents = tabComponents;
            this.layoutInspector = layoutInspector;
            this.wrapLogic = wrapLogic;
            this.displayViewManager = displayViewManager;
        }

        public /* synthetic */ SelectedTabState(Project project, TabId tabId, TabComponents tabComponents, LayoutInspector layoutInspector, WrapLogic wrapLogic, DisplayViewManager displayViewManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                wrapLogic = new WrapLogic(tabComponents.getTabContentPanel(), tabComponents.getTabContentPanelContainer());
            }
            if ((n & 0x20) != 0) {
                displayViewManager = new DisplayViewManager(layoutInspector.getRenderModel(), layoutInspector.getRenderLogic(), tabComponents.getDisplayView());
            }
            this(project, tabId, tabComponents, layoutInspector, wrapLogic, displayViewManager);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final TabId getTabId() {
            return this.tabId;
        }

        @NotNull
        public final TabComponents getTabComponents() {
            return this.tabComponents;
        }

        @NotNull
        public final LayoutInspector getLayoutInspector() {
            return this.layoutInspector;
        }

        @NotNull
        public final WrapLogic getWrapLogic() {
            return this.wrapLogic;
        }

        @NotNull
        public final DisplayViewManager getDisplayViewManager() {
            return this.displayViewManager;
        }

        public final void enableLayoutInspector() {
            this.wrapLogic.wrapComponent((Function1<? super JComponent, ? extends JComponent>)((Function1)new Function1<JComponent, JComponent>(this){
                final /* synthetic */ SelectedTabState this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final JComponent invoke(@NotNull JComponent centerPanel2) {
                    Intrinsics.checkNotNullParameter((Object)centerPanel2, (String)"centerPanel");
                    BorderLayoutPanel mainPanel2 = new BorderLayoutPanel();
                    ActionToolbar toolbar2 = LayoutInspectorMainToolbarKt.createLayoutInspectorMainToolbar((JComponent)mainPanel2, this.this$0.getLayoutInspector(), null);
                    mainPanel2.add((Component)toolbar2.getComponent(), (Object)"North");
                    mainPanel2.add((Component)centerPanel2, (Object)"Center");
                    return (JComponent)LayoutInspectorManagerKt.access$createLayoutInspectorWorkbench(this.this$0.getProject(), this.this$0.getLayoutInspector(), (JComponent)mainPanel2);
                }
            }));
            this.displayViewManager.startRendering();
        }

        public final void disableLayoutInspector() {
            this.wrapLogic.unwrapComponent();
            this.displayViewManager.stopRendering();
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final TabId component2() {
            return this.tabId;
        }

        @NotNull
        public final TabComponents component3() {
            return this.tabComponents;
        }

        @NotNull
        public final LayoutInspector component4() {
            return this.layoutInspector;
        }

        @NotNull
        public final WrapLogic component5() {
            return this.wrapLogic;
        }

        @NotNull
        public final DisplayViewManager component6() {
            return this.displayViewManager;
        }

        @NotNull
        public final SelectedTabState copy(@NotNull Project project, @NotNull TabId tabId, @NotNull TabComponents tabComponents, @NotNull LayoutInspector layoutInspector, @NotNull WrapLogic wrapLogic, @NotNull DisplayViewManager displayViewManager) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
            Intrinsics.checkNotNullParameter((Object)tabComponents, (String)"tabComponents");
            Intrinsics.checkNotNullParameter((Object)layoutInspector, (String)"layoutInspector");
            Intrinsics.checkNotNullParameter((Object)wrapLogic, (String)"wrapLogic");
            Intrinsics.checkNotNullParameter((Object)displayViewManager, (String)"displayViewManager");
            return new SelectedTabState(project, tabId, tabComponents, layoutInspector, wrapLogic, displayViewManager);
        }

        public static /* synthetic */ SelectedTabState copy$default(SelectedTabState selectedTabState, Project project, TabId tabId, TabComponents tabComponents, LayoutInspector layoutInspector, WrapLogic wrapLogic, DisplayViewManager displayViewManager, int n, Object object) {
            if ((n & 1) != 0) {
                project = selectedTabState.project;
            }
            if ((n & 2) != 0) {
                tabId = selectedTabState.tabId;
            }
            if ((n & 4) != 0) {
                tabComponents = selectedTabState.tabComponents;
            }
            if ((n & 8) != 0) {
                layoutInspector = selectedTabState.layoutInspector;
            }
            if ((n & 0x10) != 0) {
                wrapLogic = selectedTabState.wrapLogic;
            }
            if ((n & 0x20) != 0) {
                displayViewManager = selectedTabState.displayViewManager;
            }
            return selectedTabState.copy(project, tabId, tabComponents, layoutInspector, wrapLogic, displayViewManager);
        }

        @NotNull
        public String toString() {
            return "SelectedTabState(project=" + this.project + ", tabId=" + this.tabId + ", tabComponents=" + this.tabComponents + ", layoutInspector=" + this.layoutInspector + ", wrapLogic=" + this.wrapLogic + ", displayViewManager=" + this.displayViewManager + ")";
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + this.tabId.hashCode();
            result2 = result2 * 31 + this.tabComponents.hashCode();
            result2 = result2 * 31 + this.layoutInspector.hashCode();
            result2 = result2 * 31 + this.wrapLogic.hashCode();
            result2 = result2 * 31 + this.displayViewManager.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SelectedTabState)) {
                return false;
            }
            SelectedTabState selectedTabState = (SelectedTabState)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)selectedTabState.project)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tabId, (Object)selectedTabState.tabId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tabComponents, (Object)selectedTabState.tabComponents)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.layoutInspector, (Object)selectedTabState.layoutInspector)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.wrapLogic, (Object)selectedTabState.wrapLogic)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.displayViewManager, (Object)selectedTabState.displayViewManager);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManagerImpl$TabComponents;", "Lcom/intellij/openapi/Disposable;", "disposable", "tabContentPanel", "Ljavax/swing/JComponent;", "tabContentPanelContainer", "Ljava/awt/Container;", "displayView", "Lcom/android/tools/idea/streaming/AbstractDisplayView;", "(Lcom/intellij/openapi/Disposable;Ljavax/swing/JComponent;Ljava/awt/Container;Lcom/android/tools/idea/streaming/AbstractDisplayView;)V", "getDisplayView", "()Lcom/android/tools/idea/streaming/AbstractDisplayView;", "getTabContentPanel", "()Ljavax/swing/JComponent;", "getTabContentPanelContainer", "()Ljava/awt/Container;", "dispose", "", "intellij.android.layout-inspector"})
    private static final class TabComponents
    implements Disposable {
        @NotNull
        private final JComponent tabContentPanel;
        @NotNull
        private final Container tabContentPanelContainer;
        @NotNull
        private final AbstractDisplayView displayView;

        public TabComponents(@NotNull Disposable disposable2, @NotNull JComponent tabContentPanel, @NotNull Container tabContentPanelContainer, @NotNull AbstractDisplayView displayView) {
            Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
            Intrinsics.checkNotNullParameter((Object)tabContentPanel, (String)"tabContentPanel");
            Intrinsics.checkNotNullParameter((Object)tabContentPanelContainer, (String)"tabContentPanelContainer");
            Intrinsics.checkNotNullParameter((Object)((Object)displayView), (String)"displayView");
            this.tabContentPanel = tabContentPanel;
            this.tabContentPanelContainer = tabContentPanelContainer;
            this.displayView = displayView;
            Disposer.register((Disposable)disposable2, (Disposable)this);
        }

        @NotNull
        public final JComponent getTabContentPanel() {
            return this.tabContentPanel;
        }

        @NotNull
        public final Container getTabContentPanelContainer() {
            return this.tabContentPanelContainer;
        }

        @NotNull
        public final AbstractDisplayView getDisplayView() {
            return this.displayView;
        }

        public void dispose() {
        }
    }
}

