/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.properties;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.properties.DimensionUnits;
import com.android.tools.idea.layoutinspector.properties.PropertiesSettings;
import com.android.tools.idea.layoutinspector.properties.PropertySection;
import com.android.tools.idea.layoutinspector.properties.PropertyType;
import com.android.tools.idea.layoutinspector.properties.ViewNodeAndResourceLookup;
import com.android.tools.idea.layoutinspector.resource.ResourceLookup;
import com.android.tools.idea.layoutinspector.resource.SourceLocation;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.property.panel.api.ActionIconButton;
import com.android.tools.property.panel.api.HelpSupport;
import com.android.tools.property.panel.api.PropertyItem;
import com.android.utils.HashCodes;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.pom.Navigatable;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBScalableIcon;
import java.awt.Color;
import java.text.DecimalFormat;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001VBK\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0006\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0014\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010B\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\n\u0010C\u001a\u0004\u0018\u00010\u0019H\u0002J\u0013\u0010D\u001a\u00020-2\b\u0010E\u001a\u0004\u0018\u00010FH\u0096\u0002J\u0012\u0010G\u001a\u0004\u0018\u00010\u00032\u0006\u0010H\u001a\u00020\u001fH\u0002J\u0012\u0010I\u001a\u0004\u0018\u00010\u00032\u0006\u0010H\u001a\u000201H\u0002J\u0012\u0010J\u001a\u0004\u0018\u00010\u00032\u0006\u0010K\u001a\u000201H\u0002J\u0012\u0010L\u001a\u0004\u0018\u00010\u00032\u0006\u0010M\u001a\u000201H\u0002J\u0012\u0010N\u001a\u0004\u0018\u00010\u00032\u0006\u0010O\u001a\u000201H\u0002J\u0010\u0010P\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u000201H\u0002J\b\u0010Q\u001a\u00020\u001fH\u0016J\u0010\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0017R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010\u0011\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0017R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0016\u00100\u001a\u0004\u0018\u0001018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R(\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\u0010<\u001a\u0004\u0018\u00010\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010\u0017\"\u0004\b>\u0010?R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010A\u00a8\u0006W"}, d2={"Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "Lcom/android/tools/property/panel/api/PropertyItem;", "namespace", "", "attrName", "type", "Lcom/android/tools/idea/layoutinspector/properties/PropertyType;", "value", "group", "Lcom/android/tools/idea/layoutinspector/properties/PropertySection;", "source", "Lcom/android/ide/common/rendering/api/ResourceReference;", "viewId", "", "lookup", "Lcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;", "(Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/idea/layoutinspector/properties/PropertyType;Ljava/lang/String;Lcom/android/tools/idea/layoutinspector/properties/PropertySection;Lcom/android/ide/common/rendering/api/ResourceReference;JLcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;)V", "name", "initialType", "initialValue", "section", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/idea/layoutinspector/properties/PropertyType;Ljava/lang/String;Lcom/android/tools/idea/layoutinspector/properties/PropertySection;Lcom/android/ide/common/rendering/api/ResourceReference;JLcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;)V", "getAttrName", "()Ljava/lang/String;", "colorButton", "Lcom/android/tools/property/panel/api/ActionIconButton;", "getColorButton", "()Lcom/android/tools/property/panel/api/ActionIconButton;", "setColorButton", "(Lcom/android/tools/property/panel/api/ActionIconButton;)V", "<set-?>", "", "dimensionValue", "getDimensionValue", "()I", "helpSupport", "Lcom/android/tools/property/panel/api/HelpSupport;", "getHelpSupport", "()Lcom/android/tools/property/panel/api/HelpSupport;", "getInitialValue", "getLookup", "()Lcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;", "getName", "getNamespace", "needsResolutionEditor", "", "getNeedsResolutionEditor", "()Z", "pixelsToSpFactor", "", "getPixelsToSpFactor", "()Ljava/lang/Float;", "getSection", "()Lcom/android/tools/idea/layoutinspector/properties/PropertySection;", "getSource", "()Lcom/android/ide/common/rendering/api/ResourceReference;", "getType", "()Lcom/android/tools/idea/layoutinspector/properties/PropertyType;", "setType", "(Lcom/android/tools/idea/layoutinspector/properties/PropertyType;)V", "<anonymous parameter 0>", "getValue", "setValue", "(Ljava/lang/String;)V", "getViewId", "()J", "computeDimensionValue", "createColorButton", "equals", "other", "", "formatDimension", "pixels", "formatDimensionFloat", "formatDimensionFloatAsEm", "em", "formatDimensionFloatAsSp", "sp", "formatDimensionFloatDp", "dp", "formatFloat", "hashCode", "resolveDimensionType", "", "view", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "ColorActionIconButton", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nInspectorPropertyItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectorPropertyItem.kt\ncom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
public class InspectorPropertyItem
implements PropertyItem {
    @NotNull
    private final String namespace;
    @NotNull
    private final String attrName;
    @NotNull
    private final String name;
    @Nullable
    private final String initialValue;
    @NotNull
    private final PropertySection section;
    @Nullable
    private final ResourceReference source;
    private final long viewId;
    @NotNull
    private final ViewNodeAndResourceLookup lookup;
    @NotNull
    private PropertyType type;
    private int dimensionValue;
    @NotNull
    private final HelpSupport helpSupport;
    @Nullable
    private ActionIconButton colorButton;

    public InspectorPropertyItem(@NotNull String namespace, @NotNull String attrName, @NotNull String name2, @NotNull PropertyType initialType, @Nullable String initialValue, @NotNull PropertySection section, @Nullable ResourceReference source, long viewId, @NotNull ViewNodeAndResourceLookup lookup) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)initialType), (String)"initialType");
        Intrinsics.checkNotNullParameter((Object)((Object)section), (String)"section");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        this.namespace = namespace;
        this.attrName = attrName;
        this.name = name2;
        this.initialValue = initialValue;
        this.section = section;
        this.source = source;
        this.viewId = viewId;
        this.lookup = lookup;
        this.type = initialType;
        this.dimensionValue = this.computeDimensionValue(initialType);
        this.helpSupport = new HelpSupport(this){
            final /* synthetic */ InspectorPropertyItem this$0;
            {
                this.this$0 = $receiver;
            }

            public void browse() {
                block2: {
                    ViewNode viewNode = this.this$0.getLookup().get(this.this$0.getViewId());
                    if (viewNode == null) {
                        return;
                    }
                    ViewNode view = viewNode;
                    SourceLocation sourceLocation2 = (SourceLocation)CollectionsKt.singleOrNull(this.this$0.getLookup().getResourceLookup().findFileLocations(this.this$0, view, 1));
                    if (sourceLocation2 == null) {
                        return;
                    }
                    SourceLocation location = sourceLocation2;
                    Navigatable navigatable = location.getNavigatable();
                    if (navigatable == null) break block2;
                    navigatable.navigate(true);
                }
            }
        };
        this.colorButton = this.createColorButton();
    }

    @Override
    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final String getAttrName() {
        return this.attrName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public final String getInitialValue() {
        return this.initialValue;
    }

    @NotNull
    public final PropertySection getSection() {
        return this.section;
    }

    @Nullable
    public final ResourceReference getSource() {
        return this.source;
    }

    public final long getViewId() {
        return this.viewId;
    }

    @NotNull
    public final ViewNodeAndResourceLookup getLookup() {
        return this.lookup;
    }

    public InspectorPropertyItem(@NotNull String namespace, @NotNull String attrName, @NotNull PropertyType type, @Nullable String value2, @NotNull PropertySection group2, @Nullable ResourceReference source, long viewId, @NotNull ViewNodeAndResourceLookup lookup) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)group2), (String)"group");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        this(namespace, attrName, attrName, type, value2, group2, source, viewId, lookup);
    }

    @NotNull
    public final PropertyType getType() {
        return this.type;
    }

    private final void setType(PropertyType value2) {
        this.type = value2;
        this.dimensionValue = this.computeDimensionValue(value2);
    }

    public boolean getNeedsResolutionEditor() {
        return false;
    }

    public final int getDimensionValue() {
        return this.dimensionValue;
    }

    private final int computeDimensionValue(PropertyType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> {
                Object v0 = this.initialValue;
                if (v0 != null && (v0 = StringsKt.toIntOrNull((String)v0)) != null) {
                    yield ((Integer)v0).intValue();
                }
                yield -1;
            }
            case 2, 3, 4, 5 -> {
                Object v2 = this.initialValue;
                yield Float.floatToRawIntBits(v2 != null && (v2 = StringsKt.toFloatOrNull((String)v2)) != null ? ((Float)v2).floatValue() : Float.NaN);
            }
            default -> -1;
        };
    }

    @Override
    @Nullable
    public String getValue() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> this.formatDimension(this.dimensionValue);
            case 3 -> this.formatDimensionFloatDp(Float.intBitsToFloat(this.dimensionValue));
            case 2 -> this.formatDimensionFloatAsEm(Float.intBitsToFloat(this.dimensionValue));
            case 4 -> this.formatDimensionFloat(Float.intBitsToFloat(this.dimensionValue));
            case 5 -> this.formatDimensionFloatAsSp(Float.intBitsToFloat(this.dimensionValue));
            default -> this.initialValue;
        };
    }

    @Override
    public void setValue(@Nullable String string) {
    }

    public int hashCode() {
        ResourceReference resourceReference = this.source;
        return HashCodes.mix((int)this.getNamespace().hashCode(), (int)this.attrName.hashCode(), (int)(resourceReference != null ? resourceReference.hashCode() : 0));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof InspectorPropertyItem && Intrinsics.areEqual((Object)this.getNamespace(), (Object)((InspectorPropertyItem)other).getNamespace()) && Intrinsics.areEqual((Object)this.attrName, (Object)((InspectorPropertyItem)other).attrName) && Intrinsics.areEqual((Object)this.source, (Object)((InspectorPropertyItem)other).source) && Intrinsics.areEqual(this.getClass(), other.getClass());
    }

    @Override
    @NotNull
    public HelpSupport getHelpSupport() {
        return this.helpSupport;
    }

    @Override
    @Nullable
    public ActionIconButton getColorButton() {
        return this.colorButton;
    }

    public void setColorButton(@Nullable ActionIconButton actionIconButton) {
        this.colorButton = actionIconButton;
    }

    private final String formatDimension(int pixels) {
        switch (pixels) {
            case -2147483648: 
            case -1: 
            case 0x7FFFFFFF: {
                return this.initialValue;
            }
        }
        ResourceLookup resourceLookup = this.lookup.getResourceLookup();
        Integer n = resourceLookup.getDpi();
        if (n == null) {
            return pixels + "px";
        }
        int dpi = n;
        return switch (WhenMappings.$EnumSwitchMapping$1[PropertiesSettings.INSTANCE.getDimensionUnits().ordinal()]) {
            case 1 -> pixels + "px";
            case 2 -> pixels * 160 / dpi + "dp";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String formatDimensionFloat(float pixels) {
        Float spFactor;
        if (Float.isNaN(pixels)) {
            return this.initialValue;
        }
        ResourceLookup resourceLookup = this.lookup.getResourceLookup();
        Integer n = resourceLookup.getDpi();
        if (n == null) {
            return this.formatFloat(pixels) + "px";
        }
        int dpi = n;
        if (Intrinsics.areEqual((Object)this.getName(), (Object)"textSize") && !Intrinsics.areEqual((Float)resourceLookup.getFontScale(), (float)0.0f) && PropertiesSettings.INSTANCE.getDimensionUnits() == DimensionUnits.DP && (spFactor = this.getPixelsToSpFactor()) != null) {
            return new DecimalFormat("0.0").format(Float.valueOf(pixels * spFactor.floatValue())) + "sp";
        }
        return switch (WhenMappings.$EnumSwitchMapping$1[PropertiesSettings.INSTANCE.getDimensionUnits().ordinal()]) {
            case 1 -> this.formatFloat(pixels) + "px";
            case 2 -> this.formatFloat(pixels * 160.0f / (float)dpi) + "dp";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String formatDimensionFloatDp(float dp) {
        if (Float.isNaN(dp)) {
            return this.initialValue;
        }
        ResourceLookup resourceLookup = this.lookup.getResourceLookup();
        Integer n = resourceLookup.getDpi();
        if (n == null) {
            return this.formatFloat(dp) + "dp";
        }
        int dpi = n;
        return switch (WhenMappings.$EnumSwitchMapping$1[PropertiesSettings.INSTANCE.getDimensionUnits().ordinal()]) {
            case 2 -> this.formatFloat(dp) + "dp";
            case 1 -> this.formatFloat(dp / 160.0f * (float)dpi) + "px";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String formatDimensionFloatAsSp(float sp) {
        if (Float.isNaN(sp)) {
            return this.initialValue;
        }
        Float f = this.getPixelsToSpFactor();
        if (f == null) {
            return this.formatFloat(sp) + "sp";
        }
        float spFactor = f.floatValue();
        return switch (WhenMappings.$EnumSwitchMapping$1[PropertiesSettings.INSTANCE.getDimensionUnits().ordinal()]) {
            case 1 -> this.formatFloat(sp / spFactor) + "px";
            case 2 -> this.formatFloat(sp) + "sp";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String formatDimensionFloatAsEm(float em) {
        if (Float.isNaN(em)) {
            return this.initialValue;
        }
        return this.formatFloat(em) + "em";
    }

    private final Float getPixelsToSpFactor() {
        Integer n = this.lookup.getResourceLookup().getDpi();
        if (n == null) {
            return null;
        }
        int dpi = n;
        Float f = this.lookup.getResourceLookup().getFontScale();
        if (f == null) {
            return null;
        }
        float fontScale = f.floatValue();
        return Float.valueOf(160.0f / fontScale / (float)dpi);
    }

    private final String formatFloat(float value2) {
        String string;
        if (value2 == 0.0f) {
            string = "0";
        } else {
            String string2 = new DecimalFormat("0.0##").format(Float.valueOf(value2));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DecimalFormat(\"0.0##\").format(value)");
        }
        return string;
    }

    private final ActionIconButton createColorButton() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 6, 7 -> {
                ColorActionIconButton v1;
                String v0 = this.getValue();
                if (v0 != null) {
                    String it = v0;
                    boolean $i$a$-let-InspectorPropertyItem$createColorButton$1 = false;
                    v1 = new ColorActionIconButton(this);
                } else {
                    v1 = null;
                }
                yield v1;
            }
            default -> null;
        };
    }

    @Slow
    public final void resolveDimensionType(@NotNull ViewNode view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if ((this.type == PropertyType.INT32 || this.type == PropertyType.FLOAT) && this.lookup.getResourceLookup().isDimension(view, this.getName())) {
            this.setType(this.type == PropertyType.INT32 ? PropertyType.DIMENSION : PropertyType.DIMENSION_FLOAT);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem$ColorActionIconButton;", "Lcom/android/tools/property/panel/api/ActionIconButton;", "property", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "(Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;)V", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "getAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "actionButtonFocusable", "", "getActionButtonFocusable", "()Z", "actionIcon", "Ljavax/swing/Icon;", "getActionIcon", "()Ljavax/swing/Icon;", "intellij.android.layout-inspector"})
    @SourceDebugExtension(value={"SMAP\nInspectorPropertyItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectorPropertyItem.kt\ncom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem$ColorActionIconButton\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
    private static final class ColorActionIconButton
    implements ActionIconButton {
        @NotNull
        private final InspectorPropertyItem property;
        private final boolean actionButtonFocusable;
        @Nullable
        private final AnAction action;

        public ColorActionIconButton(@NotNull InspectorPropertyItem property2) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            this.property = property2;
        }

        @Override
        public boolean getActionButtonFocusable() {
            return this.actionButtonFocusable;
        }

        @Override
        @Nullable
        public AnAction getAction() {
            return this.action;
        }

        @Override
        @Nullable
        public Icon getActionIcon() {
            Object object;
            block6: {
                block5: {
                    ViewNode viewNode = this.property.getLookup().get(this.property.getViewId());
                    if (viewNode == null) {
                        return null;
                    }
                    ViewNode view = viewNode;
                    Icon icon2 = this.property.getLookup().getResourceLookup().resolveAsIcon(this.property, view);
                    if (icon2 != null) {
                        Icon it = icon2;
                        boolean bl = false;
                        return it;
                    }
                    String value2 = this.property.getValue();
                    object = value2;
                    if (object == null) break block5;
                    String it = object;
                    boolean bl = false;
                    Color color = IdeResourcesUtil.parseColor(value2);
                    object = color;
                    if (color != null) break block6;
                }
                return null;
            }
            Object color = object;
            return (Icon)JBUIScale.scaleIcon((JBScalableIcon)((JBScalableIcon)new ColorIcon(16, (Color)color, false)));
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PropertyType.values().length];
            try {
                nArray[PropertyType.DIMENSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.DIMENSION_EM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.DIMENSION_DP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.DIMENSION_FLOAT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.DIMENSION_SP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.COLOR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.DRAWABLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DimensionUnits.values().length];
            try {
                nArray[DimensionUnits.PIXELS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionUnits.DP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

