/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.properties;

import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.properties.DimensionBuilder;
import com.android.tools.idea.layoutinspector.properties.InlineNotificationBuilder;
import com.android.tools.idea.layoutinspector.properties.InspectorPropertiesModel;
import com.android.tools.idea.layoutinspector.properties.InspectorPropertiesView;
import com.android.tools.idea.layoutinspector.properties.InspectorPropertiesViewKt;
import com.android.tools.idea.layoutinspector.properties.InspectorPropertyItem;
import com.android.tools.idea.layoutinspector.properties.InspectorTableBuilder;
import com.android.tools.idea.layoutinspector.properties.PropertySection;
import com.android.tools.idea.layoutinspector.properties.SelectedViewBuilder;
import com.android.tools.property.panel.api.ControlType;
import com.android.tools.property.panel.api.ControlTypeProvider;
import com.android.tools.property.panel.api.EnumSupport;
import com.android.tools.property.panel.api.EnumSupportProvider;
import com.android.tools.property.panel.api.PropertiesView;
import com.android.tools.property.panel.api.PropertiesViewTab;
import com.android.tools.property.panel.api.Watermark;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002*\u0002\u0007\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertiesView;", "Lcom/android/tools/property/panel/api/PropertiesView;", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "model", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertiesModel;", "(Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertiesModel;)V", "controlTypeProvider", "com/android/tools/idea/layoutinspector/properties/InspectorPropertiesView$controlTypeProvider$1", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertiesView$controlTypeProvider$1;", "enumSupportProvider", "com/android/tools/idea/layoutinspector/properties/InspectorPropertiesView$enumSupportProvider$1", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertiesView$enumSupportProvider$1;", "showRecompositions", "", "propertiesModel", "intellij.android.layout-inspector"})
public final class InspectorPropertiesView
extends PropertiesView<InspectorPropertyItem> {
    @NotNull
    private final enumSupportProvider.1 enumSupportProvider;
    @NotNull
    private final controlTypeProvider.1 controlTypeProvider;

    public InspectorPropertiesView(final @NotNull InspectorPropertiesModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super("LayoutInspectorPropertyEditor", model2);
        this.enumSupportProvider = new EnumSupportProvider<InspectorPropertyItem>(){

            @Nullable
            public EnumSupport invoke(@NotNull InspectorPropertyItem property2) {
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                return null;
            }
        };
        this.controlTypeProvider = new ControlTypeProvider<InspectorPropertyItem>(){

            @NotNull
            public ControlType invoke(@NotNull InspectorPropertyItem property2) {
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                return switch (controlTypeProvider.WhenMappings.$EnumSwitchMapping$0[property2.getType().ordinal()]) {
                    case 1, 2 -> {
                        if (property2.getNeedsResolutionEditor()) {
                            yield InspectorPropertiesViewKt.getCOLOR_RESOURCE_EDITOR();
                        }
                        yield ControlType.COLOR_EDITOR;
                    }
                    case 3, 4, 5 -> ControlType.LINK_EDITOR;
                    default -> property2.getNeedsResolutionEditor() ? InspectorPropertiesViewKt.getTEXT_RESOURCE_EDITOR() : ControlType.TEXT_EDITOR;
                };
            }
        };
        this.setWatermark(new Watermark("No view selected.", "Select a view in the Component Tree.", ""));
        this.getMain().getBuilders().add(SelectedViewBuilder.INSTANCE);
        PropertySection[] propertySectionArray = new PropertySection[]{PropertySection.DEFAULT, PropertySection.DECLARED, PropertySection.LAYOUT};
        final Set attributeSections = SetsKt.setOf((Object[])propertySectionArray);
        PropertiesViewTab tab = this.addTab("");
        tab.getBuilders().add(DimensionBuilder.INSTANCE);
        tab.getBuilders().add(new InlineNotificationBuilder(model2));
        tab.getBuilders().add(new InspectorTableBuilder("Declared Attributes", 1.INSTANCE, model2, this.enumSupportProvider, this.controlTypeProvider, null, false, 96, null));
        tab.getBuilders().add(new InspectorTableBuilder("Layout", 2.INSTANCE, model2, this.enumSupportProvider, this.controlTypeProvider, InspectorPropertiesViewKt.getAndroidSortOrder(), false, 64, null));
        tab.getBuilders().add(new InspectorTableBuilder("All Attributes", (Function1)new Function1<InspectorPropertyItem, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull InspectorPropertyItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return attributeSections.contains((Object)it.getSection());
            }
        }, model2, this.enumSupportProvider, this.controlTypeProvider, null, true, 32, null));
        tab.getBuilders().add(new InspectorTableBuilder("Parameters", 4.INSTANCE, model2, this.enumSupportProvider, this.controlTypeProvider, null, true, 32, null));
        tab.getBuilders().add(new InspectorTableBuilder("Merged Semantics", 5.INSTANCE, model2, this.enumSupportProvider, this.controlTypeProvider, null, true, 32, null));
        tab.getBuilders().add(new InspectorTableBuilder("Declared Semantics", 6.INSTANCE, model2, this.enumSupportProvider, this.controlTypeProvider, null, true, 32, null));
        tab.getBuilders().add(new InspectorTableBuilder("Recomposition", (Function1)new Function1<InspectorPropertyItem, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull InspectorPropertyItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getSection() == PropertySection.RECOMPOSITIONS && this.showRecompositions(model2);
            }
        }, model2, this.enumSupportProvider, this.controlTypeProvider, null, true, 32, null));
    }

    private final boolean showRecompositions(InspectorPropertiesModel propertiesModel) {
        Object object = propertiesModel.getLayoutInspector();
        if (object == null || (object = ((LayoutInspector)object).getTreeSettings()) == null) {
            return false;
        }
        Object treeSettings2 = object;
        Object object2 = propertiesModel.getLayoutInspector();
        if (object2 == null || (object2 = ((LayoutInspector)object2).getInspectorModel()) == null) {
            return false;
        }
        Object model2 = object2;
        return treeSettings2.getShowRecompositions() && !((InspectorModel)model2).getMaxRecomposition().isEmpty();
    }
}

