/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.legacy;

import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyPropertiesProvider;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyTreeParser;
import com.google.common.base.Charsets;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyTreeParser;", "", "()V", "createViewNode", "Lkotlin/Pair;", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "", "parent", "data", "propertyLoader", "Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyPropertiesProvider$Updater;", "parseLiveViewNode", "bytes", "", "propertyUpdater", "MergeNewLineCollector", "intellij.android.layout-inspector"})
public final class LegacyTreeParser {
    @NotNull
    public static final LegacyTreeParser INSTANCE = new LegacyTreeParser();

    private LegacyTreeParser() {
    }

    @Nullable
    public final Pair<ViewNode, String> parseLiveViewNode(@NotNull byte[] bytes2, @NotNull LegacyPropertiesProvider.Updater propertyUpdater) {
        String line2;
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)propertyUpdater, (String)"propertyUpdater");
        Pair<ViewNode, String> rootNodeAndHash = null;
        Pair<ViewNode, String> lastNodeAndHash = null;
        int lastWhitespaceCount = Integer.MIN_VALUE;
        Stack<ViewNode> stack = new Stack<ViewNode>();
        BufferedReader input2 = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes2), Charsets.UTF_8));
        Iterator iterator2 = ((List)input2.lines().collect(MergeNewLineCollector.INSTANCE)).iterator();
        while (iterator2.hasNext() && !StringsKt.equals((String)"DONE.", (String)(line2 = (String)iterator2.next()), (boolean)true)) {
            int whitespaceCount;
            for (whitespaceCount = 0; line2.length() > whitespaceCount && line2.charAt(whitespaceCount) == ' '; ++whitespaceCount) {
            }
            if (lastWhitespaceCount < whitespaceCount) {
                Pair<ViewNode, String> pair = lastNodeAndHash;
                stack.push(pair != null ? (ViewNode)pair.getFirst() : null);
            } else if (!stack.isEmpty()) {
                int count2 = lastWhitespaceCount - whitespaceCount;
                for (int i = 0; i < count2; ++i) {
                    stack.pop();
                }
            }
            lastWhitespaceCount = whitespaceCount;
            ViewNode parent2 = null;
            if (!stack.isEmpty()) {
                parent2 = (ViewNode)stack.peek();
            }
            lastNodeAndHash = this.createViewNode(parent2, ((Object)StringsKt.trim((CharSequence)line2)).toString(), propertyUpdater);
            if (rootNodeAndHash != null) continue;
            rootNodeAndHash = lastNodeAndHash;
        }
        return rootNodeAndHash;
    }

    private final Pair<ViewNode, String> createViewNode(ViewNode parent2, String data, LegacyPropertiesProvider.Updater propertyLoader) {
        char[] cArray = new char[]{'@'};
        List list2 = StringsKt.split$default((CharSequence)data, (char[])cArray, (boolean)false, (int)2, (int)2, null);
        String name2 = (String)list2.get(0);
        String dataWithoutName = (String)list2.get(1);
        char[] cArray2 = new char[]{' '};
        List list3 = StringsKt.split$default((CharSequence)dataWithoutName, (char[])cArray2, (boolean)false, (int)2, (int)2, null);
        String hash2 = (String)list3.get(0);
        String properties2 = (String)list3.get(1);
        Long l = StringsKt.toLongOrNull((String)hash2, (int)16);
        long hashId = l != null ? l : 0L;
        ViewNode view = new ViewNode(hashId, name2, null, new Rectangle(), new Rectangle(), null, "", 0);
        ViewNode.Companion.writeAccess((Function1)new Function1<ViewNode.WriteAccess, Boolean>(view, parent2){
            final /* synthetic */ ViewNode $view;
            final /* synthetic */ ViewNode $parent;
            {
                this.$view = $view;
                this.$parent = $parent;
                super(1);
            }

            @Nullable
            public final Boolean invoke(@NotNull ViewNode.WriteAccess $this$writeAccess) {
                Intrinsics.checkNotNullParameter((Object)$this$writeAccess, (String)"$this$writeAccess");
                $this$writeAccess.setParent(this.$view, this.$parent);
                Object object = this.$parent;
                return object != null && (object = $this$writeAccess.getChildren((ViewNode)object)) != null ? Boolean.valueOf(object.add(this.$view)) : null;
            }
        });
        propertyLoader.parseProperties(view, properties2);
        return new Pair((Object)view, (Object)(name2 + "@" + hash2));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\fH\u0016J \u0010\r\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u000eH\u0016J\u0014\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyTreeParser$MergeNewLineCollector;", "Ljava/util/stream/Collector;", "", "", "", "()V", "accumulator", "Ljava/util/function/BiConsumer;", "characteristics", "", "Ljava/util/stream/Collector$Characteristics;", "combiner", "Ljava/util/function/BinaryOperator;", "finisher", "Ljava/util/function/Function;", "supplier", "Ljava/util/function/Supplier;", "intellij.android.layout-inspector"})
    private static final class MergeNewLineCollector
    implements Collector<String, List<String>, List<? extends String>> {
        @NotNull
        public static final MergeNewLineCollector INSTANCE = new MergeNewLineCollector();

        private MergeNewLineCollector() {
        }

        @Override
        @NotNull
        public Set<Collector.Characteristics> characteristics() {
            return SetsKt.setOf((Object)((Object)Collector.Characteristics.CONCURRENT));
        }

        @Override
        @NotNull
        public Supplier<List<String>> supplier() {
            return supplier.1.INSTANCE;
        }

        @Override
        @NotNull
        public Function<List<String>, List<String>> finisher() {
            return finisher.1.INSTANCE;
        }

        @Override
        @NotNull
        public BinaryOperator<List<String>> combiner() {
            return combiner.1.INSTANCE;
        }

        @Override
        @NotNull
        public BiConsumer<List<String>, String> accumulator() {
            return accumulator.1.INSTANCE;
        }
    }
}

