/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.appinspection.view;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenRoundQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.resources.ScreenRound;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.ComponentImageLoader;
import com.android.tools.idea.layoutinspector.model.DrawViewChild;
import com.android.tools.idea.layoutinspector.model.DrawViewImage;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.view.FromProtoConversionsKt;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.view.ViewAndroidWindow;
import com.android.tools.idea.layoutinspector.proto.SkiaParser;
import com.android.tools.idea.layoutinspector.skia.ParsingFailedException;
import com.android.tools.idea.layoutinspector.skia.SkiaParser;
import com.android.tools.idea.layoutinspector.skia.UnsupportedPictureVersionException;
import com.android.tools.idea.layoutinspector.ui.InspectorBannerService;
import com.android.tools.idea.layoutinspector.view.inspection.LayoutInspectorViewProtocol;
import com.android.tools.layoutinspector.BitmapType;
import com.android.tools.layoutinspector.InvalidPictureException;
import com.android.tools.layoutinspector.LayoutInspectorUtils;
import com.android.tools.layoutinspector.LayoutInspectorUtilsKt;
import com.android.tools.layoutinspector.SkiaViewNode;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0001H\u0016J\u0012\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J>\u0010\u001f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0006\u0012\u0004\u0018\u00010\"0 2\u0006\u0010#\u001a\u00020\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0019H\u0002J(\u0010*\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0017R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/appinspection/view/ViewAndroidWindow;", "Lcom/android/tools/idea/layoutinspector/model/AndroidWindow;", "project", "Lcom/intellij/openapi/project/Project;", "skiaParser", "Lcom/android/tools/idea/layoutinspector/skia/SkiaParser;", "root", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "event", "Lcom/android/tools/idea/layoutinspector/view/inspection/LayoutInspectorViewProtocol$LayoutEvent;", "folderConfiguration", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "isInterrupted", "Lkotlin/Function0;", "", "logEvent", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorEvent$DynamicLayoutInspectorEventType;", "", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/layoutinspector/skia/SkiaParser;Lcom/android/tools/idea/layoutinspector/model/ViewNode;Lcom/android/tools/idea/layoutinspector/view/inspection/LayoutInspectorViewProtocol$LayoutEvent;Lcom/android/ide/common/resources/configuration/FolderConfiguration;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "deviceClip", "Ljava/awt/geom/Ellipse2D$Float;", "getDeviceClip", "()Ljava/awt/geom/Ellipse2D$Float;", "screenshotBytes", "", "copyFrom", "other", "createDrawChildren", "image", "Ljava/awt/image/BufferedImage;", "getViewTree", "Lkotlin/Pair;", "Lcom/android/tools/layoutinspector/SkiaViewNode;", "", "bytes", "requestedNodes", "", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParser$RequestedNodeInfo;", "scale", "", "processBitmap", "processSkp", "refreshImages", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nViewAndroidWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewAndroidWindow.kt\ncom/android/tools/idea/layoutinspector/pipeline/appinspection/view/ViewAndroidWindow\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1#2:217\n*E\n"})
public final class ViewAndroidWindow
extends AndroidWindow {
    @NotNull
    private final Project project;
    @NotNull
    private final SkiaParser skiaParser;
    @NotNull
    private final LayoutInspectorViewProtocol.LayoutEvent event;
    @NotNull
    private final Function0<Boolean> isInterrupted;
    @NotNull
    private final Function1<DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType, Unit> logEvent;
    @Nullable
    private byte[] screenshotBytes;
    @Nullable
    private final Ellipse2D.Float deviceClip;

    public ViewAndroidWindow(@NotNull Project project, @NotNull SkiaParser skiaParser2, @NotNull ViewNode root, @NotNull LayoutInspectorViewProtocol.LayoutEvent event2, @NotNull FolderConfiguration folderConfiguration, @NotNull Function0<Boolean> isInterrupted, @NotNull Function1<? super DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType, Unit> logEvent2) {
        Ellipse2D.Float float_;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)skiaParser2, (String)"skiaParser");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Intrinsics.checkNotNullParameter((Object)folderConfiguration, (String)"folderConfiguration");
        Intrinsics.checkNotNullParameter(isInterrupted, (String)"isInterrupted");
        Intrinsics.checkNotNullParameter(logEvent2, (String)"logEvent");
        Long l = root.getDrawId();
        LayoutInspectorViewProtocol.Screenshot.Type type = event2.getScreenshot().getType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"event.screenshot.type");
        super(root, l, FromProtoConversionsKt.toImageType(type));
        this.project = project;
        this.skiaParser = skiaParser2;
        this.event = event2;
        this.isInterrupted = isInterrupted;
        this.logEvent = logEvent2;
        this.screenshotBytes = this.event.hasScreenshot() ? this.event.getScreenshot().getBytes().toByteArray() : null;
        ScreenRoundQualifier screenRoundQualifier = folderConfiguration.getScreenRoundQualifier();
        if ((screenRoundQualifier != null ? screenRoundQualifier.getValue() : null) == ScreenRound.ROUND) {
            Integer dpi;
            ScreenWidthQualifier screenWidthQualifier = folderConfiguration.getScreenWidthQualifier();
            Integer width = screenWidthQualifier != null ? Integer.valueOf(screenWidthQualifier.getValue()) : null;
            ScreenHeightQualifier screenHeightQualifier = folderConfiguration.getScreenHeightQualifier();
            Integer height = screenHeightQualifier != null ? Integer.valueOf(screenHeightQualifier.getValue()) : null;
            DensityQualifier densityQualifier = folderConfiguration.getDensityQualifier();
            Integer n = densityQualifier != null && (densityQualifier = densityQualifier.getValue()) != null ? Integer.valueOf(densityQualifier.getDpiValue()) : (dpi = null);
            float_ = width != null && height != null && dpi != null ? new Ellipse2D.Float(0.0f, 0.0f, (float)(width * dpi) / 160.0f, (float)(height * dpi) / 160.0f) : null;
        } else {
            float_ = null;
        }
        this.deviceClip = float_;
    }

    @Override
    @Nullable
    public Ellipse2D.Float getDeviceClip() {
        return this.deviceClip;
    }

    @Override
    public void copyFrom(@NotNull AndroidWindow other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        super.copyFrom(other);
        if (other instanceof ViewAndroidWindow) {
            this.screenshotBytes = ((ViewAndroidWindow)other).screenshotBytes;
        }
    }

    @Override
    @Slow
    public void refreshImages(double scale) {
        try {
            byte[] immutableScreenshotBytes = this.screenshotBytes;
            if (immutableScreenshotBytes == null) {
                this.createDrawChildren(null);
            } else if (!(immutableScreenshotBytes.length == 0)) {
                switch (WhenMappings.$EnumSwitchMapping$0[this.getImageType().ordinal()]) {
                    case 1: {
                        BufferedImage bufferedImage = this.processBitmap(immutableScreenshotBytes);
                        this.createDrawChildren(bufferedImage);
                        this.logEvent.invoke((Object)DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.INITIAL_RENDER_BITMAPS);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.processSkp(immutableScreenshotBytes, this.skiaParser, this.project, scale);
                        break;
                    }
                    default: {
                        this.logEvent.invoke((Object)DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.INITIAL_RENDER_NO_PICTURE);
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            Logger.getInstance(LayoutInspector.class).warn((Throwable)ex);
        }
    }

    private final void processSkp(byte[] bytes2, SkiaParser skiaParser2, Project project, double scale) {
        Pair pair = (Pair)ViewNode.Companion.readAccess((Function1)new Function1<ViewNode.ReadAccess, Pair<? extends Map<Long, ? extends ViewNode>, ? extends List<? extends SkiaParser.RequestedNodeInfo>>>(this){
            final /* synthetic */ ViewAndroidWindow this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Pair<Map<Long, ViewNode>, List<SkiaParser.RequestedNodeInfo>> invoke(@NotNull ViewNode.ReadAccess $this$readAccess) {
                void $this$associateByTo$iv$iv;
                Sequence allNodes2;
                Intrinsics.checkNotNullParameter((Object)$this$readAccess, (String)"$this$readAccess");
                Sequence $this$associateBy$iv = allNodes2 = SequencesKt.filter($this$readAccess.flatten(this.this$0.getRoot()), (Function1)processSkp.allNodes.1.INSTANCE);
                boolean $i$f$associateBy = false;
                Sequence sequence = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$associateByTo = false;
                for (E element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    ViewNode viewNode = (ViewNode)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    map2.put(it.getDrawId(), element$iv$iv);
                }
                Map nodeMap = destination$iv$iv;
                int surfaceOriginX = this.this$0.getRoot().getLayoutBounds().x - ViewAndroidWindow.access$getEvent$p(this.this$0).getRootOffset().getX();
                int surfaceOriginY = this.this$0.getRoot().getLayoutBounds().y - ViewAndroidWindow.access$getEvent$p(this.this$0).getRootOffset().getY();
                List requests2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)allNodes2, (Function1)((Function1)new Function1<ViewNode, SkiaParser.RequestedNodeInfo>(surfaceOriginX, surfaceOriginY){
                    final /* synthetic */ int $surfaceOriginX;
                    final /* synthetic */ int $surfaceOriginY;
                    {
                        this.$surfaceOriginX = $surfaceOriginX;
                        this.$surfaceOriginY = $surfaceOriginY;
                        super(1);
                    }

                    @Nullable
                    public final SkiaParser.RequestedNodeInfo invoke(@NotNull ViewNode it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Rectangle bounds = it.getRenderBounds().getBounds().intersection(new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
                        return bounds.isEmpty() ? null : LayoutInspectorUtils.INSTANCE.makeRequestedNodeInfo(it.getDrawId(), bounds.x - this.$surfaceOriginX, bounds.y - this.$surfaceOriginY, bounds.width, bounds.height);
                    }
                })));
                return new Pair((Object)nodeMap, (Object)requests2);
            }
        });
        Map nodeMap = (Map)pair.component1();
        List requestedNodeInfo = (List)pair.component2();
        if (requestedNodeInfo.isEmpty()) {
            return;
        }
        Pair<SkiaViewNode, String> pair2 = this.getViewTree(bytes2, requestedNodeInfo, skiaParser2, scale);
        SkiaViewNode rootViewFromSkiaImage = (SkiaViewNode)pair2.component1();
        String errorMessage = (String)pair2.component2();
        if (errorMessage != null) {
            InspectorBannerService inspectorBannerService = InspectorBannerService.Companion.getInstance(project);
            if (inspectorBannerService != null) {
                InspectorBannerService.addNotification$default(inspectorBannerService, errorMessage, null, 2, null);
            }
        }
        if (rootViewFromSkiaImage != null && rootViewFromSkiaImage.getId() != 0L) {
            this.logEvent.invoke((Object)DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.INITIAL_RENDER);
            new ComponentImageLoader(nodeMap, rootViewFromSkiaImage).loadImages(this);
        }
    }

    private final BufferedImage processBitmap(byte[] bytes2) {
        int count2;
        Inflater inflater;
        Inflater it = inflater = new Inflater();
        boolean bl = false;
        it.setInput(bytes2);
        Inflater inf = inflater;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while (!inf.finished() && (count2 = inf.inflate(buffer)) > 0) {
            baos.write(buffer, 0, count2);
        }
        byte[] inflatedBytes = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)inflatedBytes, (String)"inflatedBytes");
        int width = LayoutInspectorUtilsKt.toInt(inflatedBytes);
        int height = LayoutInspectorUtilsKt.toInt(ArraysKt.sliceArray((byte[])inflatedBytes, (IntRange)new IntRange(4, 7)));
        BitmapType bitmapType = BitmapType.Companion.fromByteVal(inflatedBytes[8]);
        ByteBuffer byteBuffer = ByteBuffer.wrap(inflatedBytes, 9, inflatedBytes.length - 9);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(inflatedBytes, BITM\u2026ize - BITMAP_HEADER_SIZE)");
        return bitmapType.createImage(byteBuffer, width, height);
    }

    private final void createDrawChildren(BufferedImage image) {
        ViewNode.Companion.writeAccess((Function1)new Function1<ViewNode.WriteAccess, Unit>(this, image){
            final /* synthetic */ ViewAndroidWindow this$0;
            final /* synthetic */ BufferedImage $image;
            {
                this.this$0 = $receiver;
                this.$image = $image;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ViewNode.WriteAccess $this$writeAccess) {
                ViewNode it;
                Intrinsics.checkNotNullParameter((Object)$this$writeAccess, (String)"$this$writeAccess");
                Sequence<ViewNode> $this$forEach$iv = $this$writeAccess.flatten(this.this$0.getRoot());
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    it = (ViewNode)element$iv;
                    boolean bl = false;
                    $this$writeAccess.getDrawChildren(it).clear();
                }
                if (this.$image != null) {
                    $this$writeAccess.getDrawChildren(this.this$0.getRoot()).add(new DrawViewImage(this.$image, this.this$0.getRoot(), this.this$0.getDeviceClip()));
                }
                $this$forEach$iv = $this$writeAccess.flatten(this.this$0.getRoot());
                $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    void $this$mapTo$iv;
                    it = (ViewNode)element$iv;
                    boolean bl = false;
                    Iterable iterable = $this$writeAccess.getChildren(it);
                    Collection destination$iv = $this$writeAccess.getDrawChildren(it);
                    boolean $i$f$mapTo = false;
                    for (T item$iv : $this$mapTo$iv) {
                        void child;
                        ViewNode viewNode = (ViewNode)item$iv;
                        Collection collection2 = destination$iv;
                        boolean bl2 = false;
                        collection2.add(new DrawViewChild((ViewNode)child));
                    }
                }
            }
        });
    }

    private final Pair<SkiaViewNode, String> getViewTree(byte[] bytes2, Iterable<SkiaParser.RequestedNodeInfo> requestedNodes, SkiaParser skiaParser2, double scale) {
        SkiaViewNode skiaViewNode;
        Object errorMessage = null;
        try {
            skiaViewNode = skiaParser2.getViewTree(bytes2, requestedNodes, scale, this.isInterrupted);
        }
        catch (InvalidPictureException ex) {
            errorMessage = "Invalid picture data received from device. Rotation disabled.";
            skiaViewNode = null;
        }
        catch (ParsingFailedException ex) {
            errorMessage = "Invalid picture data received from device. Rotation disabled.";
            skiaViewNode = null;
        }
        catch (UnsupportedPictureVersionException ex) {
            errorMessage = "No renderer supporting SKP version " + ex.getVersion() + " found. Rotation disabled.";
            skiaViewNode = null;
        }
        catch (Exception ex) {
            errorMessage = "Problem launching renderer. Rotation disabled.";
            Logger.getInstance(ViewAndroidWindow.class).warn((Throwable)ex);
            skiaViewNode = null;
        }
        SkiaViewNode inspectorView = skiaViewNode;
        return new Pair((Object)inspectorView, errorMessage);
    }

    public static final /* synthetic */ LayoutInspectorViewProtocol.LayoutEvent access$getEvent$p(ViewAndroidWindow $this) {
        return $this.event;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidWindow.ImageType.values().length];
            try {
                nArray[AndroidWindow.ImageType.BITMAP_AS_REQUESTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidWindow.ImageType.SKP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidWindow.ImageType.SKP_PENDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

