/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline;

import com.android.tools.idea.appinspection.internal.process.TransportDeviceDescriptorKt;
import com.android.tools.idea.layoutinspector.LayoutInspectorBundle;
import com.android.tools.idea.layoutinspector.metrics.LayoutInspectorMetrics;
import com.android.tools.idea.layoutinspector.ui.InspectorBannerService;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.transport.FailedToStartServerException;
import com.android.tools.idea.transport.TransportDeviceManager;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.profiler.proto.Agent;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorTransportError;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020&H\u0016J\u001c\u0010'\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\n\u0010#\u001a\u00060&j\u0002`(H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/TransportErrorListener;", "Lcom/android/tools/idea/transport/TransportDeviceManager$TransportDeviceManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "layoutInspectorMetrics", "Lcom/android/tools/idea/layoutinspector/metrics/LayoutInspectorMetrics;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/layoutinspector/metrics/LayoutInspectorMetrics;Lcom/intellij/openapi/Disposable;)V", "errorMessage", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "getErrorMessage", "()Ljava/lang/String;", "value", "", "hasStartServerFailed", "setHasStartServerFailed", "(Z)V", "customizeAgentConfig", "", "configBuilder", "Lcom/android/tools/profiler/proto/Agent$AgentConfig$Builder;", "runConfig", "Lcom/android/tools/idea/run/AndroidRunConfigurationBase;", "customizeDaemonConfig", "Lcom/android/tools/profiler/proto/Transport$DaemonConfig$Builder;", "customizeProxyService", "proxy", "Lcom/android/tools/idea/transport/TransportProxy;", "onPreTransportDaemonStart", "device", "Lcom/android/tools/profiler/proto/Common$Device;", "onStartTransportDaemonServerFail", "exception", "Lcom/android/tools/idea/transport/FailedToStartServerException;", "onTransportDaemonException", "Ljava/lang/Exception;", "onTransportProxyCreationFail", "Lkotlin/Exception;", "intellij.android.layout-inspector"})
public final class TransportErrorListener
implements TransportDeviceManager.TransportDeviceManagerListener {
    @NotNull
    private final Project project;
    @NotNull
    private final LayoutInspectorMetrics layoutInspectorMetrics;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final String errorMessage;
    private boolean hasStartServerFailed;

    public TransportErrorListener(@NotNull Project project, @NotNull LayoutInspectorMetrics layoutInspectorMetrics, @NotNull Disposable disposable2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)layoutInspectorMetrics, (String)"layoutInspectorMetrics");
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        this.project = project;
        this.layoutInspectorMetrics = layoutInspectorMetrics;
        this.disposable = disposable2;
        this.errorMessage = LayoutInspectorBundle.INSTANCE.message("two.versions.of.studio.running", new String[0]);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(this.disposable);
        Topic<TransportDeviceManager.TransportDeviceManagerListener> topic = TransportDeviceManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
    }

    @NotNull
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    private final void setHasStartServerFailed(boolean value2) {
        block1: {
            InspectorBannerService bannerService;
            block0: {
                this.hasStartServerFailed = value2;
                bannerService = InspectorBannerService.Companion.getInstance(this.project);
                if (!this.hasStartServerFailed) break block0;
                InspectorBannerService inspectorBannerService = bannerService;
                if (inspectorBannerService == null) break block1;
                inspectorBannerService.addNotification(this.errorMessage, CollectionsKt.emptyList());
                break block1;
            }
            InspectorBannerService inspectorBannerService = bannerService;
            if (inspectorBannerService == null) break block1;
            inspectorBannerService.removeNotification(this.errorMessage);
        }
    }

    @Override
    public void onPreTransportDaemonStart(@NotNull Common.Device device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.setHasStartServerFailed(false);
    }

    @Override
    public void onTransportDaemonException(@NotNull Common.Device device2, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
    }

    @Override
    public void onTransportProxyCreationFail(@NotNull Common.Device device2, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
    }

    @Override
    public void onStartTransportDaemonServerFail(@NotNull Common.Device device2, @NotNull FailedToStartServerException exception) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.setHasStartServerFailed(true);
        this.layoutInspectorMetrics.logTransportError(DynamicLayoutInspectorTransportError.Type.TRANSPORT_FAILED_TO_START_DAEMON, TransportDeviceDescriptorKt.toDeviceDescriptor(device2));
    }

    @Override
    public void customizeProxyService(@NotNull TransportProxy proxy) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
    }

    @Override
    public void customizeDaemonConfig(@NotNull Transport.DaemonConfig.Builder configBuilder) {
        Intrinsics.checkNotNullParameter((Object)configBuilder, (String)"configBuilder");
    }

    @Override
    public void customizeAgentConfig(@NotNull Agent.AgentConfig.Builder configBuilder, @Nullable AndroidRunConfigurationBase runConfig) {
        Intrinsics.checkNotNullParameter((Object)configBuilder, (String)"configBuilder");
    }
}

