/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline;

import com.android.tools.idea.appinspection.api.process.ProcessesModel;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.concurrency.AndroidExecutors;
import com.android.tools.idea.layoutinspector.metrics.LayoutInspectorSessionMetrics;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.StatusNotification;
import com.android.tools.idea.layoutinspector.pipeline.AbstractInspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.DisconnectedClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClientLauncher;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClientSettings;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.AppInspectionInspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyClient;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.android.tools.idea.layoutinspector.ui.InspectorBannerService;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.rd.util.PlatformDependentKt;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 82\u00020\u0001:\u000289BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0003\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010*\u001a\u00020\u001c2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001c0\u0006J\b\u0010,\u001a\u00020\u001cH\u0002J\u001c\u0010-\u001a\u00020\u001c2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u000201H\u0007J\u001a\u00102\u001a\u00020\u001c2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00020\u001dH\u0002J$\u00106\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u00103\u001a\u0004\u0018\u0001042\u0006\u00107\u001a\u00020\u001dH\u0002R$\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001c0\u00060\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0004\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u001d@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u0012\u0012\u0004\u0012\u00020$0'j\b\u0012\u0004\u0012\u00020$`(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher;", "", "processes", "Lcom/android/tools/idea/appinspection/api/process/ProcessesModel;", "clientCreators", "", "Lkotlin/Function1;", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher$Params;", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "metrics", "Lcom/android/tools/idea/layoutinspector/metrics/LayoutInspectorSessionMetrics;", "executor", "Ljava/util/concurrent/Executor;", "(Lcom/android/tools/idea/appinspection/api/process/ProcessesModel;Ljava/util/List;Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/layoutinspector/metrics/LayoutInspectorSessionMetrics;Ljava/util/concurrent/Executor;)V", "value", "activeClient", "getActiveClient", "()Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "setActiveClient", "(Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;)V", "clientChangedCallbacks", "", "", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "sequenceNumber", "", "sequenceNumberLock", "threadSequenceNumber", "Ljava/lang/ThreadLocal;", "Lcom/jetbrains/rd/util/ThreadLocal;", "workerExecutor", "addClientChangedListener", "callback", "checkCancelled", "disconnectActiveClient", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "handleProcess", "process", "Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "isInstantlyAutoConnected", "handleProcessInWorkerThread", "isAutoConnected", "Companion", "Params", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nInspectorClientLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectorClientLauncher.kt\ncom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1851#2,2:325\n1851#2,2:327\n288#2,2:330\n1#3:329\n*S KotlinDebug\n*F\n+ 1 InspectorClientLauncher.kt\ncom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher\n*L\n244#1:325,2\n267#1:327,2\n290#1:330,2\n*E\n"})
public final class InspectorClientLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProcessesModel processes;
    @NotNull
    private final List<Function1<Params, InspectorClient>> clientCreators;
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Disposable parentDisposable;
    @Nullable
    private final LayoutInspectorSessionMetrics metrics;
    @NotNull
    private final Object sequenceNumberLock;
    private int sequenceNumber;
    @NotNull
    private final ThreadLocal<Integer> threadSequenceNumber;
    @NotNull
    private final Executor workerExecutor;
    @NotNull
    private InspectorClient activeClient;
    private boolean enabled;
    @NotNull
    private final List<Function1<InspectorClient, Unit>> clientChangedCallbacks;

    public InspectorClientLauncher(@NotNull ProcessesModel processes, @NotNull List<? extends Function1<? super Params, ? extends InspectorClient>> clientCreators, @NotNull Project project, @NotNull CoroutineScope scope2, @NotNull Disposable parentDisposable, @Nullable LayoutInspectorSessionMetrics metrics, final @VisibleForTesting @Nullable Executor executor2) {
        Intrinsics.checkNotNullParameter((Object)processes, (String)"processes");
        Intrinsics.checkNotNullParameter(clientCreators, (String)"clientCreators");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.processes = processes;
        this.clientCreators = clientCreators;
        this.project = project;
        this.scope = scope2;
        this.parentDisposable = parentDisposable;
        this.metrics = metrics;
        this.sequenceNumberLock = new Object();
        this.threadSequenceNumber = PlatformDependentKt.threadLocalWithInitial((Function0)threadSequenceNumber.1.INSTANCE);
        this.workerExecutor = AndroidExecutors.Companion.getInstance().getWorkerThreadExecutor();
        Executor executor3 = executor2;
        if (executor3 == null) {
            executor3 = new Executor(this){
                private final ExecutorService singleThreadExecutor;
                final /* synthetic */ InspectorClientLauncher this$0;
                {
                    this.this$0 = $receiver;
                    this.singleThreadExecutor = Executors.newSingleThreadExecutor();
                }

                public void execute(@NotNull Runnable command) {
                    Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                    T t = InspectorClientLauncher.access$getThreadSequenceNumber$p(this.this$0).get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"threadSequenceNumber.get()");
                    if (((Number)t).intValue() > 0) {
                        command.run();
                    } else {
                        this.singleThreadExecutor.execute(command);
                    }
                }
            };
        }
        Executor realExecutor2 = executor3;
        this.processes.addSelectedProcessListeners(realExecutor2, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.handleProcessInWorkerThread(executor2, processes.getSelectedProcess(), processes.isAutoConnected());
            }
        }));
        Disposer.register((Disposable)this.parentDisposable, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void dispose() {
                ThreadLocal threadLocal = threadSequenceNumber;
                InspectorClientLauncher inspectorClientLauncher = this;
                inspectorClientLauncher.sequenceNumber = inspectorClientLauncher.sequenceNumber + 1;
                threadLocal.set(inspectorClientLauncher.sequenceNumber);
                try {
                    this.setActiveClient(DisconnectedClient.INSTANCE);
                }
                finally {
                    threadSequenceNumber.set(-1);
                }
            }
        });
        this.activeClient = DisconnectedClient.INSTANCE;
        this.enabled = true;
        this.clientChangedCallbacks = new ArrayList();
    }

    public /* synthetic */ InspectorClientLauncher(ProcessesModel processesModel, List list2, Project project, CoroutineScope coroutineScope, Disposable disposable2, LayoutInspectorSessionMetrics layoutInspectorSessionMetrics, Executor executor2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            layoutInspectorSessionMetrics = null;
        }
        if ((n & 0x40) != 0) {
            executor2 = null;
        }
        this(processesModel, list2, project, coroutineScope, disposable2, layoutInspectorSessionMetrics, executor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleProcessInWorkerThread(Executor executor2, ProcessDescriptor process2, boolean isAutoConnected) {
        if (!this.project.isDisposed()) {
            Function0 processHandler2 = (Function0)new Function0<Unit>(this, process2, isAutoConnected){
                final /* synthetic */ InspectorClientLauncher this$0;
                final /* synthetic */ ProcessDescriptor $process;
                final /* synthetic */ boolean $isAutoConnected;
                {
                    this.this$0 = $receiver;
                    this.$process = $process;
                    this.$isAutoConnected = $isAutoConnected;
                    super(0);
                }

                public final void invoke() {
                    try {
                        InspectorClientLauncher.access$handleProcess(this.this$0, this.$process, this.$isAutoConnected);
                    }
                    catch (CancellationException cancellationException) {
                        // empty catch block
                    }
                }
            };
            Integer n = this.threadSequenceNumber.get();
            int n2 = this.sequenceNumber;
            if (n != null && n == n2) {
                processHandler2.invoke();
            } else {
                Integer n3 = this.threadSequenceNumber.get();
                Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"threadSequenceNumber.get()");
                if (((Number)n3).intValue() < 0) {
                    Object object = this.sequenceNumberLock;
                    synchronized (object) {
                        boolean bl = false;
                        CountDownLatch threadStartedLatch = new CountDownLatch(1);
                        Executor executor3 = executor2;
                        if (executor3 == null) {
                            executor3 = this.workerExecutor;
                        }
                        executor3.execute(new Runnable(this, threadStartedLatch, (Function0<Unit>)processHandler2){
                            final /* synthetic */ InspectorClientLauncher this$0;
                            final /* synthetic */ CountDownLatch $threadStartedLatch;
                            final /* synthetic */ Function0<Unit> $processHandler;
                            {
                                this.this$0 = $receiver;
                                this.$threadStartedLatch = $threadStartedLatch;
                                this.$processHandler = $processHandler;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void run() {
                                ThreadLocal threadLocal = InspectorClientLauncher.access$getThreadSequenceNumber$p(this.this$0);
                                InspectorClientLauncher inspectorClientLauncher = this.this$0;
                                InspectorClientLauncher.access$setSequenceNumber$p(inspectorClientLauncher, InspectorClientLauncher.access$getSequenceNumber$p(inspectorClientLauncher) + 1);
                                threadLocal.set(InspectorClientLauncher.access$getSequenceNumber$p(inspectorClientLauncher));
                                try {
                                    this.$threadStartedLatch.countDown();
                                    this.$processHandler.invoke();
                                }
                                finally {
                                    InspectorClientLauncher.access$getThreadSequenceNumber$p(this.this$0).set(-1);
                                }
                            }
                        });
                        threadStartedLatch.await();
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        }
    }

    private final void handleProcess(ProcessDescriptor process2, boolean isInstantlyAutoConnected) {
        Ref.BooleanRef validClientConnected;
        block14: {
            validClientConnected = new Ref.BooleanRef();
            if (process2 == null || !process2.isRunning() || !this.enabled) break block14;
            Params params2 = new Params(process2, isInstantlyAutoConnected, this){
                @NotNull
                private final ProcessDescriptor process;
                private final boolean isInstantlyAutoConnected;
                @NotNull
                private final Disposable disposable;
                {
                    this.process = $process;
                    this.isInstantlyAutoConnected = $isInstantlyAutoConnected;
                    this.disposable = InspectorClientLauncher.access$getParentDisposable$p($receiver);
                }

                @NotNull
                public ProcessDescriptor getProcess() {
                    return this.process;
                }

                public boolean isInstantlyAutoConnected() {
                    return this.isInstantlyAutoConnected;
                }

                @NotNull
                public Disposable getDisposable() {
                    return this.disposable;
                }
            };
            LayoutInspectorSessionMetrics layoutInspectorSessionMetrics = this.metrics;
            if (layoutInspectorSessionMetrics != null) {
                layoutInspectorSessionMetrics.setProcess(process2);
            }
            for (Function1<Params, InspectorClient> createClient : this.clientCreators) {
                this.checkCancelled();
                InspectorClient client2 = (InspectorClient)createClient.invoke((Object)params2);
                if (client2 == null) continue;
                try {
                    block16: {
                        block15: {
                            CountDownLatch latch = new CountDownLatch(1);
                            client2.registerStateCallback((Function1<? super InspectorClient.State, Unit>)((Function1)new Function1<InspectorClient.State, Unit>(validClientConnected, latch){
                                final /* synthetic */ Ref.BooleanRef $validClientConnected;
                                final /* synthetic */ CountDownLatch $latch;
                                {
                                    this.$validClientConnected = $validClientConnected;
                                    this.$latch = $latch;
                                    super(1);
                                }

                                public final void invoke(@NotNull InspectorClient.State state2) {
                                    Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
                                    if (state2 == InspectorClient.State.CONNECTED || state2 == InspectorClient.State.DISCONNECTED) {
                                        this.$validClientConnected.element = state2 == InspectorClient.State.CONNECTED;
                                        this.$latch.countDown();
                                    }
                                }
                            }));
                            this.setActiveClient(client2);
                            latch.await();
                            ProcessDescriptor processDescriptor2 = this.processes.getSelectedProcess();
                            boolean bl = processDescriptor2 != null ? processDescriptor2.isRunning() : false;
                            if (!bl) break block15;
                            ProcessDescriptor processDescriptor3 = this.processes.getSelectedProcess();
                            if (processDescriptor3 != null ? processDescriptor3.getPid() == process2.getPid() : false) break block16;
                        }
                        LayoutInspectorSessionMetrics layoutInspectorSessionMetrics2 = this.metrics;
                        if (layoutInspectorSessionMetrics2 != null) {
                            LayoutInspectorSessionMetrics.logEvent$default(layoutInspectorSessionMetrics2, DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.ATTACH_CANCELLED, client2.getStats(), null, null, 12, null);
                        }
                        return;
                    }
                    if (validClientConnected.element) break;
                    client2.disconnect();
                }
                catch (CancellationException cancellationException) {
                    client2.disconnect();
                    LayoutInspectorSessionMetrics layoutInspectorSessionMetrics3 = this.metrics;
                    if (layoutInspectorSessionMetrics3 != null) {
                        LayoutInspectorSessionMetrics.logEvent$default(layoutInspectorSessionMetrics3, DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.ATTACH_CANCELLED, client2.getStats(), null, null, 12, null);
                    }
                    throw cancellationException;
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
        }
        if (!validClientConnected.element) {
            InspectorBannerService inspectorBannerService = InspectorBannerService.Companion.getInstance(this.project);
            if (inspectorBannerService == null) {
                return;
            }
            InspectorBannerService bannerService = inspectorBannerService;
            List<StatusNotification> notifications = bannerService.getNotifications();
            this.setActiveClient(DisconnectedClient.INSTANCE);
            if (this.enabled) {
                this.processes.setSelectedProcess(null);
            }
            Iterable $this$forEach$iv = notifications;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StatusNotification it = (StatusNotification)element$iv;
                boolean bl = false;
                bannerService.addNotification(it.getMessage(), it.getActions());
            }
        }
    }

    private final void checkCancelled() {
        Integer n = this.threadSequenceNumber.get();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"threadSequenceNumber.get()");
        if (((Number)n).intValue() < this.sequenceNumber) {
            throw new CancellationException("Launch thread preempted");
        }
    }

    @NotNull
    public final InspectorClient getActiveClient() {
        return this.activeClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setActiveClient(InspectorClient value2) {
        if (!Intrinsics.areEqual((Object)this.activeClient, (Object)value2)) {
            InspectorClient $i$a$-synchronized-InspectorClientLauncher$activeClient$oldClient$22;
            Object object = this.sequenceNumberLock;
            synchronized (object) {
                boolean $i$a$-synchronized-InspectorClientLauncher$activeClient$oldClient$22 = false;
                this.checkCancelled();
                $i$a$-synchronized-InspectorClientLauncher$activeClient$oldClient$22 = this.activeClient;
            }
            InspectorClient oldClient = $i$a$-synchronized-InspectorClientLauncher$activeClient$oldClient$22;
            oldClient.disconnect();
            Disposer.dispose((Disposable)oldClient);
            object = this.sequenceNumberLock;
            synchronized (object) {
                boolean bl = false;
                this.checkCancelled();
                this.activeClient = value2;
                Unit unit = Unit.INSTANCE;
            }
            Iterable $this$forEach$iv = this.clientChangedCallbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 callback2 = (Function1)element$iv;
                boolean bl = false;
                callback2.invoke((Object)value2);
            }
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(value2, this, null){
                int label;
                final /* synthetic */ InspectorClient $value;
                final /* synthetic */ InspectorClientLauncher this$0;
                {
                    this.$value = $value;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$value.connect(InspectorClientLauncher.access$getProject$p(this.this$0), (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean value2) {
        block6: {
            if (this.enabled == value2) break block6;
            this.enabled = value2;
            if (!this.activeClient.isConnected() && value2) {
                ProcessDescriptor processDescriptor2 = this.processes.getSelectedProcess();
                if (processDescriptor2 != null) {
                    ProcessDescriptor runningProcess;
                    ProcessDescriptor processDescriptor3;
                    ProcessDescriptor process2 = processDescriptor2;
                    boolean bl = false;
                    ProcessDescriptor it = processDescriptor3 = process2;
                    boolean bl2 = false;
                    ProcessDescriptor processDescriptor4 = it.isRunning() ? processDescriptor3 : null;
                    if (processDescriptor4 == null) {
                        Object v2;
                        block5: {
                            Iterable $this$firstOrNull$iv = this.processes.getProcesses();
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                ProcessDescriptor it2 = (ProcessDescriptor)element$iv;
                                boolean bl3 = false;
                                if (!(it2.getPid() == process2.getPid() && it2.isRunning())) continue;
                                v2 = element$iv;
                                break block5;
                            }
                            v2 = null;
                        }
                        processDescriptor4 = v2;
                    }
                    if ((runningProcess = processDescriptor4) != null) {
                        this.processes.setSelectedProcess(null);
                        this.processes.setSelectedProcess(runningProcess);
                    }
                }
            }
        }
    }

    public final void addClientChangedListener(@NotNull Function1<? super InspectorClient, Unit> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this.clientChangedCallbacks.add(callback2);
    }

    @TestOnly
    public final void disconnectActiveClient(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (this.activeClient.isConnected()) {
            CountDownLatch latch = new CountDownLatch(1);
            this.activeClient.registerStateCallback((Function1<? super InspectorClient.State, Unit>)((Function1)new Function1<InspectorClient.State, Unit>(latch){
                final /* synthetic */ CountDownLatch $latch;
                {
                    this.$latch = $latch;
                    super(1);
                }

                public final void invoke(@NotNull InspectorClient.State state2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
                    if (state2 == InspectorClient.State.DISCONNECTED) {
                        this.$latch.countDown();
                    }
                }
            }));
            this.activeClient.disconnect();
            latch.await(timeout, unit);
        }
    }

    public static /* synthetic */ void disconnectActiveClient$default(InspectorClientLauncher inspectorClientLauncher, long l, TimeUnit timeUnit, int n, Object object) {
        if ((n & 1) != 0) {
            l = Long.MAX_VALUE;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        inspectorClientLauncher.disconnectActiveClient(l, timeUnit);
    }

    public static final /* synthetic */ void access$handleProcess(InspectorClientLauncher $this, ProcessDescriptor process2, boolean isInstantlyAutoConnected) {
        $this.handleProcess(process2, isInstantlyAutoConnected);
    }

    public static final /* synthetic */ Disposable access$getParentDisposable$p(InspectorClientLauncher $this) {
        return $this.parentDisposable;
    }

    public static final /* synthetic */ Project access$getProject$p(InspectorClientLauncher $this) {
        return $this.project;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher$Companion;", "", "()V", "createDefaultLauncher", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher;", "processes", "Lcom/android/tools/idea/appinspection/api/process/ProcessesModel;", "model", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "metrics", "Lcom/android/tools/idea/layoutinspector/metrics/LayoutInspectorSessionMetrics;", "treeSettings", "Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "inspectorClientSettings", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientSettings;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.android.layout-inspector"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InspectorClientLauncher createDefaultLauncher(@NotNull ProcessesModel processes, @NotNull InspectorModel model2, @NotNull LayoutInspectorSessionMetrics metrics, @NotNull TreeSettings treeSettings2, @NotNull InspectorClientSettings inspectorClientSettings, @NotNull CoroutineScope coroutineScope, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)processes, (String)"processes");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
            Intrinsics.checkNotNullParameter((Object)treeSettings2, (String)"treeSettings");
            Intrinsics.checkNotNullParameter((Object)inspectorClientSettings, (String)"inspectorClientSettings");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Object[] objectArray = new Function1[]{new Function1<Params, AbstractInspectorClient>(model2, metrics, treeSettings2, inspectorClientSettings, coroutineScope, parentDisposable){
                final /* synthetic */ InspectorModel $model;
                final /* synthetic */ LayoutInspectorSessionMetrics $metrics;
                final /* synthetic */ TreeSettings $treeSettings;
                final /* synthetic */ InspectorClientSettings $inspectorClientSettings;
                final /* synthetic */ CoroutineScope $coroutineScope;
                final /* synthetic */ Disposable $parentDisposable;
                {
                    this.$model = $model;
                    this.$metrics = $metrics;
                    this.$treeSettings = $treeSettings;
                    this.$inspectorClientSettings = $inspectorClientSettings;
                    this.$coroutineScope = $coroutineScope;
                    this.$parentDisposable = $parentDisposable;
                    super(1);
                }

                @Nullable
                public final AbstractInspectorClient invoke(@NotNull Params params2) {
                    Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
                    return params2.getProcess().getDevice().getApiLevel() >= 29 ? new AppInspectionInspectorClient(params2.getProcess(), params2.isInstantlyAutoConnected(), this.$model, this.$metrics, this.$treeSettings, this.$inspectorClientSettings, this.$coroutineScope, this.$parentDisposable, null, null, 768, null) : null;
                }
            }, new Function1<Params, AbstractInspectorClient>(model2, metrics, coroutineScope, parentDisposable){
                final /* synthetic */ InspectorModel $model;
                final /* synthetic */ LayoutInspectorSessionMetrics $metrics;
                final /* synthetic */ CoroutineScope $coroutineScope;
                final /* synthetic */ Disposable $parentDisposable;
                {
                    this.$model = $model;
                    this.$metrics = $metrics;
                    this.$coroutineScope = $coroutineScope;
                    this.$parentDisposable = $parentDisposable;
                    super(1);
                }

                @Nullable
                public final AbstractInspectorClient invoke(@NotNull Params params2) {
                    Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
                    return new LegacyClient(params2.getProcess(), params2.isInstantlyAutoConnected(), this.$model, this.$metrics, this.$coroutineScope, this.$parentDisposable, null, 64, null);
                }
            }};
            return new InspectorClientLauncher(processes, CollectionsKt.listOf((Object[])objectArray), model2.getProject(), coroutineScope, parentDisposable, metrics, null, 64, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher$Params;", "", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "isInstantlyAutoConnected", "", "()Z", "process", "Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "getProcess", "()Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "intellij.android.layout-inspector"})
    public static interface Params {
        @NotNull
        public ProcessDescriptor getProcess();

        public boolean isInstantlyAutoConnected();

        @NotNull
        public Disposable getDisposable();
    }
}

