/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.layoutinspector.LayoutInspectorBundle;
import com.android.tools.idea.layoutinspector.metrics.LayoutInspectorSessionMetrics;
import com.android.tools.idea.layoutinspector.metrics.statistics.SessionStatistics;
import com.android.tools.idea.layoutinspector.pipeline.DisconnectedClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClientLaunchMonitorKt;
import com.android.tools.idea.layoutinspector.pipeline.adb.AdbUtils;
import com.android.tools.idea.layoutinspector.pipeline.adb.AdbUtilsKt;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.ConnectionFailedExceptionKt;
import com.android.tools.idea.layoutinspector.pipeline.debugger.DebuggerDetectionKt;
import com.android.tools.idea.layoutinspector.ui.InspectorBannerService;
import com.android.tools.idea.util.ListenerCollection;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorAttachToProcess;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorErrorInfo;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorEvent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001fH\u0002J\b\u0010%\u001a\u00020\bH\u0002J\b\u0010&\u001a\u00020\bH\u0002J\u0010\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010.\u001a\u00020\bJ\u000e\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\u0007R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f8G\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00061"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLaunchMonitor;", "", "project", "Lcom/intellij/openapi/project/Project;", "attachErrorStateListeners", "Lcom/android/tools/idea/util/ListenerCollection;", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorErrorInfo$AttachErrorState;", "", "stats", "Lcom/android/tools/idea/layoutinspector/metrics/statistics/SessionStatistics;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/util/ListenerCollection;Lcom/android/tools/idea/layoutinspector/metrics/statistics/SessionStatistics;Ljava/util/concurrent/ScheduledExecutorService;)V", "adbClient", "Lcom/android/ddmlib/Client;", "getAdbClient", "()Lcom/android/ddmlib/Client;", "client", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "clientLock", "<set-?>", "currentProgress", "getCurrentProgress", "()Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorErrorInfo$AttachErrorState;", "debuggerFuture", "Ljava/util/concurrent/ScheduledFuture;", "lastUpdate", "", "timeoutFuture", "timeoutHandlerScheduled", "", "getTimeoutHandlerScheduled", "()Z", "createDisconnectAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "attemptDumpViews", "handleDebuggerCheck", "handleTimeout", "logAttachError", "errorCode", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorErrorInfo$AttachErrorCode;", "onFailure", "t", "", "start", "stop", "updateProgress", "progress", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nInspectorClientLaunchMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectorClientLaunchMonitor.kt\ncom/android/tools/idea/layoutinspector/pipeline/InspectorClientLaunchMonitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
public final class InspectorClientLaunchMonitor {
    @NotNull
    private final Project project;
    @NotNull
    private final ListenerCollection<Function1<DynamicLayoutInspectorErrorInfo.AttachErrorState, Unit>> attachErrorStateListeners;
    @NotNull
    private final SessionStatistics stats;
    @TestOnly
    @NotNull
    private final ScheduledExecutorService executorService;
    private long lastUpdate;
    @Nullable
    private ScheduledFuture<?> timeoutFuture;
    @Nullable
    private ScheduledFuture<?> debuggerFuture;
    @NotNull
    private final Object clientLock;
    @NotNull
    private DynamicLayoutInspectorErrorInfo.AttachErrorState currentProgress;
    @Nullable
    private InspectorClient client;

    public InspectorClientLaunchMonitor(@NotNull Project project, @NotNull ListenerCollection<Function1<DynamicLayoutInspectorErrorInfo.AttachErrorState, Unit>> attachErrorStateListeners, @NotNull SessionStatistics stats, @NotNull ScheduledExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(attachErrorStateListeners, (String)"attachErrorStateListeners");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.project = project;
        this.attachErrorStateListeners = attachErrorStateListeners;
        this.stats = stats;
        this.executorService = executorService;
        this.clientLock = new Object();
        this.currentProgress = DynamicLayoutInspectorErrorInfo.AttachErrorState.UNKNOWN_ATTACH_ERROR_STATE;
    }

    public /* synthetic */ InspectorClientLaunchMonitor(Project project, ListenerCollection listenerCollection, SessionStatistics sessionStatistics, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = AppExecutorUtil.getAppScheduledExecutorService();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"getAppScheduledExecutorService()");
            scheduledExecutorService = scheduledExecutorService2;
        }
        this(project, (ListenerCollection<Function1<DynamicLayoutInspectorErrorInfo.AttachErrorState, Unit>>)listenerCollection, sessionStatistics, scheduledExecutorService);
    }

    @NotNull
    public final DynamicLayoutInspectorErrorInfo.AttachErrorState getCurrentProgress() {
        return this.currentProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(@NotNull InspectorClient client2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        boolean bl2 = bl = this.client == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Object object = this.clientLock;
        synchronized (object) {
            boolean bl3 = false;
            this.client = client2;
            Unit unit = Unit.INSTANCE;
        }
        this.updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.NOT_STARTED);
    }

    @TestOnly
    public final boolean getTimeoutHandlerScheduled() {
        return this.timeoutFuture != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateProgress(@NotNull DynamicLayoutInspectorErrorInfo.AttachErrorState progress2) {
        block9: {
            InspectorBannerService banner;
            Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
            this.attachErrorStateListeners.forEach(new Consumer(progress2){
                final /* synthetic */ DynamicLayoutInspectorErrorInfo.AttachErrorState $progress;
                {
                    this.$progress = $progress;
                }

                public final void accept(@NotNull Function1<? super DynamicLayoutInspectorErrorInfo.AttachErrorState, Unit> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    it.invoke((Object)this.$progress);
                }
            });
            if (progress2.compareTo((Enum)this.currentProgress) <= 0) {
                return;
            }
            ScheduledFuture<?> scheduledFuture2 = this.timeoutFuture;
            if (scheduledFuture2 != null) {
                scheduledFuture2.cancel(true);
            }
            ScheduledFuture<?> scheduledFuture3 = this.debuggerFuture;
            if (scheduledFuture3 != null) {
                scheduledFuture3.cancel(true);
            }
            this.currentProgress = progress2;
            this.stats.setCurrentProgress(progress2);
            if (this.currentProgress.compareTo((Enum)InspectorClientLaunchMonitorKt.getCONNECTED_STATE()) < 0) {
                this.lastUpdate = System.currentTimeMillis();
                Object object = this.clientLock;
                synchronized (object) {
                    boolean bl = false;
                    if (this.client != null) {
                        this.timeoutFuture = this.executorService.schedule(new Runnable(this){
                            final /* synthetic */ InspectorClientLaunchMonitor $tmp0;
                            {
                                this.$tmp0 = $tmp0;
                            }

                            public final void run() {
                                InspectorClientLaunchMonitor.access$handleTimeout(this.$tmp0);
                            }
                        }, 30L, TimeUnit.SECONDS);
                        this.debuggerFuture = this.executorService.schedule(new Runnable(this){
                            final /* synthetic */ InspectorClientLaunchMonitor $tmp0;
                            {
                                this.$tmp0 = $tmp0;
                            }

                            public final void run() {
                                InspectorClientLaunchMonitor.access$handleDebuggerCheck(this.$tmp0);
                            }
                        }, 2L, TimeUnit.SECONDS);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            InspectorBannerService inspectorBannerService = banner = InspectorBannerService.Companion.getInstance(this.project);
            if (inspectorBannerService != null) {
                inspectorBannerService.removeNotification(LayoutInspectorBundle.INSTANCE.message("connect.timeout", new String[0]));
            }
            InspectorBannerService inspectorBannerService2 = banner;
            if (inspectorBannerService2 == null) break block9;
            inspectorBannerService2.removeNotification(LayoutInspectorBundle.INSTANCE.message("debugger.paused", new String[0]));
        }
    }

    public final void onFailure(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (!(t instanceof CancellationException)) {
            this.logAttachError(ConnectionFailedExceptionKt.getErrorCode(t).getCode());
        }
        this.stop();
    }

    private final void handleDebuggerCheck() {
        block6: {
            InspectorBannerService banner = InspectorBannerService.Companion.getInstance(this.project);
            Client currentClient = this.getAdbClient();
            if (currentClient == null || !DebuggerDetectionKt.isPausedInDebugger(currentClient)) {
                Object object;
                Client client2 = currentClient;
                boolean bl = client2 != null ? client2.isDebuggerAttached() : false;
                if (bl && (object = this.client) != null && (object = object.getStats()) != null) {
                    object.debuggerInUse(false);
                }
                InspectorBannerService inspectorBannerService = banner;
                if (inspectorBannerService != null) {
                    inspectorBannerService.removeNotification(LayoutInspectorBundle.INSTANCE.message("debugger.paused", new String[0]));
                }
                this.debuggerFuture = this.executorService.schedule(new Runnable(this){
                    final /* synthetic */ InspectorClientLaunchMonitor $tmp0;
                    {
                        this.$tmp0 = $tmp0;
                    }

                    public final void run() {
                        InspectorClientLaunchMonitor.access$handleDebuggerCheck(this.$tmp0);
                    }
                }, 2L, TimeUnit.SECONDS);
                return;
            }
            Object object = this.client;
            if (object != null && (object = object.getStats()) != null) {
                object.debuggerInUse(true);
            }
            ScheduledFuture<?> scheduledFuture2 = this.timeoutFuture;
            if (scheduledFuture2 != null) {
                scheduledFuture2.cancel(true);
            }
            AnAction resumeDebugger2 = new AnAction(banner, this){
                final /* synthetic */ InspectorBannerService $banner;
                final /* synthetic */ InspectorClientLaunchMonitor this$0;
                {
                    this.$banner = $banner;
                    this.this$0 = $receiver;
                    super("Resume Debugger");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(@NotNull AnActionEvent event2) {
                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                    InspectorBannerService inspectorBannerService = this.$banner;
                    if (inspectorBannerService != null) {
                        inspectorBannerService.removeNotification(LayoutInspectorBundle.INSTANCE.message("debugger.paused", new String[0]));
                    }
                    Object object = InspectorClientLaunchMonitor.access$getClientLock$p(this.this$0);
                    InspectorClientLaunchMonitor inspectorClientLaunchMonitor = this.this$0;
                    Object object2 = object;
                    synchronized (object2) {
                        boolean bl = false;
                        if (InspectorClientLaunchMonitor.access$getClient$p(inspectorClientLaunchMonitor) != null) {
                            Client client2 = InspectorClientLaunchMonitor.access$getAdbClient(inspectorClientLaunchMonitor);
                            if (client2 != null) {
                                Client it = client2;
                                boolean bl2 = false;
                                DebuggerDetectionKt.resumeDebugger(it);
                            }
                            InspectorClientLaunchMonitor.access$setDebuggerFuture$p(inspectorClientLaunchMonitor, InspectorClientLaunchMonitor.access$getExecutorService$p(inspectorClientLaunchMonitor).schedule(new Runnable(inspectorClientLaunchMonitor){
                                final /* synthetic */ InspectorClientLaunchMonitor $tmp0;
                                {
                                    this.$tmp0 = $tmp0;
                                }

                                public final void run() {
                                    InspectorClientLaunchMonitor.access$handleDebuggerCheck(this.$tmp0);
                                }
                            }, 2L, TimeUnit.SECONDS));
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
            };
            AnAction disconnect2 = this.createDisconnectAction(false);
            InspectorBannerService inspectorBannerService = banner;
            if (inspectorBannerService != null) {
                Object[] objectArray = new AnAction[]{resumeDebugger2, disconnect2};
                inspectorBannerService.addNotification(LayoutInspectorBundle.INSTANCE.message("debugger.paused", new String[0]), CollectionsKt.listOf((Object[])objectArray));
            }
            InspectorBannerService inspectorBannerService2 = banner;
            if (inspectorBannerService2 == null) break block6;
            inspectorBannerService2.removeNotification(LayoutInspectorBundle.INSTANCE.message("connect.timeout", new String[0]));
        }
    }

    private final void handleTimeout() {
        block3: {
            boolean bl;
            Client client2 = this.getAdbClient();
            if (client2 != null) {
                Client it = client2;
                boolean bl2 = false;
                bl = DebuggerDetectionKt.isPausedInDebugger(it);
            } else {
                bl = false;
            }
            if (bl) {
                return;
            }
            InspectorBannerService banner = InspectorBannerService.Companion.getInstance(this.project);
            AnAction continueWaiting2 = new AnAction(banner, this){
                final /* synthetic */ InspectorBannerService $banner;
                final /* synthetic */ InspectorClientLaunchMonitor this$0;
                {
                    this.$banner = $banner;
                    this.this$0 = $receiver;
                    super("Continue Waiting");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(@NotNull AnActionEvent event2) {
                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                    InspectorBannerService inspectorBannerService = this.$banner;
                    if (inspectorBannerService != null) {
                        inspectorBannerService.removeNotification(LayoutInspectorBundle.INSTANCE.message("connect.timeout", new String[0]));
                    }
                    Object object = InspectorClientLaunchMonitor.access$getClientLock$p(this.this$0);
                    InspectorClientLaunchMonitor inspectorClientLaunchMonitor = this.this$0;
                    Object object2 = object;
                    synchronized (object2) {
                        boolean bl = false;
                        if (InspectorClientLaunchMonitor.access$getClient$p(inspectorClientLaunchMonitor) != null) {
                            InspectorClientLaunchMonitor.access$setTimeoutFuture$p(inspectorClientLaunchMonitor, InspectorClientLaunchMonitor.access$getExecutorService$p(inspectorClientLaunchMonitor).schedule(new Runnable(inspectorClientLaunchMonitor){
                                final /* synthetic */ InspectorClientLaunchMonitor $tmp0;
                                {
                                    this.$tmp0 = $tmp0;
                                }

                                public final void run() {
                                    InspectorClientLaunchMonitor.access$handleTimeout(this.$tmp0);
                                }
                            }, 30L, TimeUnit.SECONDS));
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
            };
            AnAction disconnect2 = this.createDisconnectAction(true);
            InspectorBannerService inspectorBannerService = banner;
            if (inspectorBannerService == null) break block3;
            Object[] objectArray = new AnAction[]{continueWaiting2, disconnect2};
            inspectorBannerService.addNotification(LayoutInspectorBundle.INSTANCE.message("connect.timeout", new String[0]), CollectionsKt.listOf((Object[])objectArray));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final AnAction createDisconnectAction(boolean attemptDumpViews) {
        if (!attemptDumpViews) ** GOTO lbl-1000
        v0 = this.client;
        if ((v0 != null ? v0.getClientType() : null) == DynamicLayoutInspectorAttachToProcess.ClientType.APP_INSPECTION_CLIENT) {
            v1 = "Dump Views";
        } else lbl-1000:
        // 2 sources

        {
            v1 = "Disconnect";
        }
        disconnectText = v1;
        return new AnAction(disconnectText, this){
            final /* synthetic */ InspectorClientLaunchMonitor this$0;
            {
                this.this$0 = $receiver;
                super($disconnectText);
            }

            public void actionPerformed(@NotNull AnActionEvent event2) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                    InspectorBannerService inspectorBannerService = InspectorBannerService.Companion.getInstance(InspectorClientLaunchMonitor.access$getProject$p(this.this$0));
                    if (inspectorBannerService != null) {
                        inspectorBannerService.removeNotification(LayoutInspectorBundle.INSTANCE.message("connect.timeout", new String[0]));
                    }
                    Logger.getInstance(InspectorClientLaunchMonitor.class).warn("Client " + InspectorClientLaunchMonitor.access$getClient$p(this.this$0) + " timed out during attach at step " + this.this$0.getCurrentProgress() + " on the users request");
                    InspectorClientLaunchMonitor.access$logAttachError(this.this$0, DynamicLayoutInspectorErrorInfo.AttachErrorCode.CONNECT_TIMEOUT);
                    InspectorClient inspectorClient = InspectorClientLaunchMonitor.access$getClient$p(this.this$0);
                    if (inspectorClient == null) break block1;
                    inspectorClient.disconnect();
                }
            }
        };
    }

    private final Client getAdbClient() {
        Object object;
        Object object2 = this.client;
        if (object2 != null && (object2 = object2.getProcess()) != null) {
            Object it = object2;
            boolean bl = false;
            AndroidDebugBridge androidDebugBridge = (AndroidDebugBridge)AdbUtils.INSTANCE.getAdbFuture(this.project).get();
            object = androidDebugBridge != null ? AdbUtilsKt.findClient(androidDebugBridge, (ProcessDescriptor)it) : null;
        } else {
            object = null;
        }
        return object;
    }

    private final void logAttachError(DynamicLayoutInspectorErrorInfo.AttachErrorCode errorCode) {
        Object object = this.client;
        if (object == null || (object = object.getStats()) == null) {
            object = DisconnectedClient.INSTANCE.getStats();
        }
        Object stats = object;
        InspectorClient inspectorClient = this.client;
        new LayoutInspectorSessionMetrics(null, inspectorClient != null ? inspectorClient.getProcess() : null, null).logEvent(DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.ATTACH_ERROR, (SessionStatistics)stats, this.currentProgress, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.clientLock;
        synchronized (object) {
            boolean bl = false;
            this.client = null;
            Unit unit = Unit.INSTANCE;
        }
        ScheduledFuture<?> scheduledFuture2 = this.timeoutFuture;
        if (scheduledFuture2 != null) {
            scheduledFuture2.cancel(true);
        }
        this.timeoutFuture = null;
        ScheduledFuture<?> scheduledFuture3 = this.debuggerFuture;
        if (scheduledFuture3 != null) {
            scheduledFuture3.cancel(true);
        }
        this.debuggerFuture = null;
    }

    public static final /* synthetic */ void access$handleDebuggerCheck(InspectorClientLaunchMonitor $this) {
        $this.handleDebuggerCheck();
    }

    public static final /* synthetic */ Object access$getClientLock$p(InspectorClientLaunchMonitor $this) {
        return $this.clientLock;
    }

    public static final /* synthetic */ InspectorClient access$getClient$p(InspectorClientLaunchMonitor $this) {
        return $this.client;
    }

    public static final /* synthetic */ Client access$getAdbClient(InspectorClientLaunchMonitor $this) {
        return $this.getAdbClient();
    }

    public static final /* synthetic */ void access$setDebuggerFuture$p(InspectorClientLaunchMonitor $this, ScheduledFuture scheduledFuture2) {
        $this.debuggerFuture = scheduledFuture2;
    }

    public static final /* synthetic */ ScheduledExecutorService access$getExecutorService$p(InspectorClientLaunchMonitor $this) {
        return $this.executorService;
    }

    public static final /* synthetic */ void access$setTimeoutFuture$p(InspectorClientLaunchMonitor $this, ScheduledFuture scheduledFuture2) {
        $this.timeoutFuture = scheduledFuture2;
    }

    public static final /* synthetic */ void access$handleTimeout(InspectorClientLaunchMonitor $this) {
        $this.handleTimeout();
    }

    public static final /* synthetic */ Project access$getProject$p(InspectorClientLaunchMonitor $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$logAttachError(InspectorClientLaunchMonitor $this, DynamicLayoutInspectorErrorInfo.AttachErrorCode errorCode) {
        $this.logAttachError(errorCode);
    }
}

