/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.appinspection.api.process.ProcessesModel;
import com.android.tools.idea.appinspection.ide.AppInspectionDiscoveryService;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.LayoutInspectorOpenProjectsTracker;
import com.android.tools.idea.layoutinspector.LayoutInspectorProjectService;
import com.android.tools.idea.layoutinspector.LayoutInspectorProjectServiceKt;
import com.android.tools.idea.layoutinspector.metrics.ForegroundProcessDetectionMetrics;
import com.android.tools.idea.layoutinspector.metrics.LayoutInspectorMetrics;
import com.android.tools.idea.layoutinspector.metrics.LayoutInspectorSessionMetrics;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClientLauncher;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClientSettings;
import com.android.tools.idea.layoutinspector.pipeline.TransportErrorListener;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.DeviceModel;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetection;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetectionInitializer;
import com.android.tools.idea.layoutinspector.settings.LayoutInspectorSettings;
import com.android.tools.idea.layoutinspector.tree.InspectorTreeSettings;
import com.android.tools.idea.layoutinspector.ui.InspectorBannerService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0001H\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0001H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0007R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/layoutinspector/LayoutInspectorProjectService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "layoutInspector", "Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "createForegroundProcessDetection", "Lcom/android/tools/idea/layoutinspector/pipeline/foregroundprocessdetection/ForegroundProcessDetection;", "processesModel", "Lcom/android/tools/idea/appinspection/api/process/ProcessesModel;", "deviceModel", "Lcom/android/tools/idea/layoutinspector/pipeline/foregroundprocessdetection/DeviceModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "createLayoutInspector", "disposable", "createScheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "dispose", "", "getLayoutInspector", "Companion", "intellij.android.layout-inspector"})
public final class LayoutInspectorProjectService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private LayoutInspector layoutInspector;

    public LayoutInspectorProjectService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @UiThread
    @NotNull
    public final LayoutInspector getLayoutInspector() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.layoutInspector == null) {
            this.layoutInspector = this.createLayoutInspector(this.project, this);
        }
        LayoutInspector layoutInspector = this.layoutInspector;
        Intrinsics.checkNotNull((Object)layoutInspector);
        return layoutInspector;
    }

    @UiThread
    private final LayoutInspector createLayoutInspector(Project project, Disposable disposable2) {
        InspectorClientLauncher inspectorClientLauncher;
        ApplicationManager.getApplication().assertIsDispatchThread();
        CoroutineScope layoutInspectorCoroutineScope = CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)disposable2, null, (int)2, null);
        LayoutInspectorOpenProjectsTracker layoutInspectorOpenProjectsTracker = LayoutInspectorOpenProjectsTracker.INSTANCE;
        layoutInspectorOpenProjectsTracker.setOpenProjects$intellij_android_layout_inspector(layoutInspectorOpenProjectsTracker.getOpenProjects$intellij_android_layout_inspector() + 1);
        Disposer.register((Disposable)disposable2, (Disposable)createLayoutInspector.1.INSTANCE);
        InspectorClientSettings inspectorClientSettings = new InspectorClientSettings(project);
        EdtExecutorService edtExecutorService = EdtExecutorService.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)edtExecutorService, (String)"getInstance()");
        EdtExecutorService edtExecutor = edtExecutorService;
        new TransportErrorListener(project, LayoutInspectorMetrics.INSTANCE, disposable2);
        ProcessesModel processesModel = LayoutInspectorProjectServiceKt.createProcessesModel(project, disposable2, AppInspectionDiscoveryService.Companion.getInstance().getApiServices().getProcessDiscovery(), (Executor)edtExecutor);
        ScheduledExecutorService scheduledExecutor = this.createScheduledExecutor(disposable2);
        InspectorModel model2 = new InspectorModel(project, scheduledExecutor);
        processesModel.addSelectedProcessListeners((Function0<Unit>)((Function0)new Function0<Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                block0: {
                    InspectorBannerService inspectorBannerService = InspectorBannerService.Companion.getInstance(this.$project);
                    if (inspectorBannerService == null) break block0;
                    inspectorBannerService.clear();
                }
            }
        }));
        Ref.ObjectRef launcher = new Ref.ObjectRef();
        InspectorTreeSettings treeSettings2 = new InspectorTreeSettings((Function0<? extends InspectorClient>)((Function0)new Function0<InspectorClient>((Ref.ObjectRef<InspectorClientLauncher>)launcher){
            final /* synthetic */ Ref.ObjectRef<InspectorClientLauncher> $launcher;
            {
                this.$launcher = $launcher;
                super(0);
            }

            @NotNull
            public final InspectorClient invoke() {
                InspectorClientLauncher inspectorClientLauncher;
                if (this.$launcher.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"launcher");
                    inspectorClientLauncher = null;
                } else {
                    inspectorClientLauncher = (InspectorClientLauncher)this.$launcher.element;
                }
                return inspectorClientLauncher.getActiveClient();
            }
        }));
        LayoutInspectorSessionMetrics metrics = new LayoutInspectorSessionMetrics(project, null, null, 4, null);
        launcher.element = InspectorClientLauncher.Companion.createDefaultLauncher(processesModel, model2, metrics, treeSettings2, inspectorClientSettings, layoutInspectorCoroutineScope, disposable2);
        DeviceModel deviceModel = new DeviceModel(disposable2, processesModel);
        ForegroundProcessDetection foregroundProcessDetection = this.createForegroundProcessDetection(project, processesModel, deviceModel, layoutInspectorCoroutineScope);
        if (launcher.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"launcher");
            inspectorClientLauncher = null;
        } else {
            inspectorClientLauncher = (InspectorClientLauncher)launcher.element;
        }
        return new LayoutInspector(layoutInspectorCoroutineScope, processesModel, deviceModel, foregroundProcessDetection, inspectorClientSettings, inspectorClientLauncher, model2, treeSettings2, null, null, null, 1792, null);
    }

    private final ScheduledExecutorService createScheduledExecutor(Disposable disposable2) {
        ScheduledExecutorService scheduledExecutorService;
        ScheduledExecutorService $this$createScheduledExecutor_u24lambda_u240 = scheduledExecutorService = Executors.newScheduledThreadPool(1);
        boolean bl = false;
        Disposer.register((Disposable)disposable2, (Disposable)new Disposable($this$createScheduledExecutor_u24lambda_u240){
            final /* synthetic */ ScheduledExecutorService $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public final void dispose() {
                this.$this_apply.shutdown();
                this.$this_apply.awaitTermination(3L, TimeUnit.SECONDS);
            }
        });
        ScheduledExecutorService scheduledExecutorService2 = scheduledExecutorService;
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"newScheduledThreadPool(1\u2026it.SECONDS)\n      }\n    }");
        return scheduledExecutorService2;
    }

    private final ForegroundProcessDetection createForegroundProcessDetection(Project project, ProcessesModel processesModel, DeviceModel deviceModel, CoroutineScope coroutineScope) {
        return LayoutInspectorSettings.Companion.getInstance().getAutoConnectEnabled() ? ForegroundProcessDetectionInitializer.initialize$default(ForegroundProcessDetectionInitializer.INSTANCE, project, processesModel, deviceModel, coroutineScope, null, null, ForegroundProcessDetectionMetrics.INSTANCE, null, 176, null) : null;
    }

    public void dispose() {
    }

    @JvmStatic
    @NotNull
    public static final LayoutInspectorProjectService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/layoutinspector/LayoutInspectorProjectService$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/layoutinspector/LayoutInspectorProjectService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.layout-inspector"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LayoutInspectorProjectService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LayoutInspectorProjectService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Layou\u2026ojectService::class.java)");
            return (LayoutInspectorProjectService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

