/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.appinspection.inspector.api.process.DeviceDescriptor;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.layoutinspector.LayoutInspectorExecutionListener;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.DebugViewAttributes;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.DeviceFutures;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J \u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/layoutinspector/LayoutInspectorExecutionListener;", "Lcom/intellij/execution/ExecutionListener;", "()V", "model", "", "Lcom/android/ddmlib/IDevice;", "getModel", "(Lcom/android/ddmlib/IDevice;)Ljava/lang/String;", "enableDebugViewAttributes", "", "project", "Lcom/intellij/openapi/project/Project;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "packageName", "device", "processStarted", "executorId", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nLayoutInspectorExecutionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutInspectorExecutionListener.kt\ncom/android/tools/idea/layoutinspector/LayoutInspectorExecutionListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1851#2,2:98\n1#3:100\n*S KotlinDebug\n*F\n+ 1 LayoutInspectorExecutionListener.kt\ncom/android/tools/idea/layoutinspector/LayoutInspectorExecutionListener\n*L\n51#1:98,2\n*E\n"})
public final class LayoutInspectorExecutionListener
implements ExecutionListener {
    public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Project project = env.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"env.project");
        Project project2 = project;
        RunProfile runProfile = env.getRunProfile();
        AndroidRunConfiguration androidRunConfiguration = runProfile instanceof AndroidRunConfiguration ? (AndroidRunConfiguration)runProfile : null;
        if (androidRunConfiguration == null) {
            return;
        }
        AndroidRunConfiguration configuration = androidRunConfiguration;
        if (!configuration.INSPECTION_WITHOUT_ACTIVITY_RESTART) {
            return;
        }
        String string = configuration.getAppId();
        if (string == null) {
            throw new RuntimeException("No packageName for started AndroidRunConfiguration configuration");
        }
        String appId = string;
        DeviceFutures deviceFutures = (DeviceFutures)env.getCopyableUserData(DeviceFutures.KEY);
        Object object = deviceFutures;
        if (object == null || (object = ((DeviceFutures)object).getIfReady()) == null) {
            return;
        }
        Object targetDevices = object;
        Iterable $this$forEach$iv = (Iterable)targetDevices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IDevice device2 = (IDevice)element$iv;
            boolean bl = false;
            if (device2.getVersion().getApiLevel() < 29) continue;
            Intrinsics.checkNotNullExpressionValue((Object)device2, (String)"device");
            this.enableDebugViewAttributes(project2, handler2, appId, device2);
        }
    }

    private final void enableDebugViewAttributes(Project project, ProcessHandler handler2, String packageName2, IDevice device2) {
        DeviceDescriptor descriptor2 = new DeviceDescriptor(this, device2){
            @NotNull
            private final String manufacturer;
            @NotNull
            private final String model;
            @NotNull
            private final String serial;
            private final boolean isEmulator;
            private final int apiLevel;
            @NotNull
            private final String version;
            @NotNull
            private final String codename;
            {
                this.manufacturer = "";
                this.model = LayoutInspectorExecutionListener.access$getModel($receiver, $device);
                String string = $device.getSerialNumber();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.serialNumber");
                this.serial = string;
                this.isEmulator = $device.isEmulator();
                this.apiLevel = $device.getVersion().getApiLevel();
                this.version = "";
                this.codename = "";
            }

            @NotNull
            public String getManufacturer() {
                return this.manufacturer;
            }

            @NotNull
            public String getModel() {
                return this.model;
            }

            @NotNull
            public String getSerial() {
                return this.serial;
            }

            public boolean isEmulator() {
                return this.isEmulator;
            }

            public int getApiLevel() {
                return this.apiLevel;
            }

            @NotNull
            public String getVersion() {
                return this.version;
            }

            @NotNull
            public String getCodename() {
                return this.codename;
            }
        };
        ProcessDescriptor process2 = new ProcessDescriptor(descriptor2, packageName2){
            @NotNull
            private final DeviceDescriptor device;
            @NotNull
            private final String abiCpuArch;
            @NotNull
            private final String name;
            @NotNull
            private final String packageName;
            private final boolean isRunning;
            private final int pid;
            private final long streamId;
            {
                this.device = $descriptor;
                this.abiCpuArch = "";
                this.name = $packageName;
                this.packageName = $packageName;
                this.isRunning = true;
            }

            @NotNull
            public DeviceDescriptor getDevice() {
                return this.device;
            }

            @NotNull
            public String getAbiCpuArch() {
                return this.abiCpuArch;
            }

            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public String getPackageName() {
                return this.packageName;
            }

            public boolean isRunning() {
                return this.isRunning;
            }

            public int getPid() {
                return this.pid;
            }

            public long getStreamId() {
                return this.streamId;
            }
        };
        DebugViewAttributes debugViewAttributes = DebugViewAttributes.Companion.getInstance();
        if (debugViewAttributes.set(project, process2)) {
            handler2.addProcessListener((ProcessListener)new ProcessAdapter(debugViewAttributes, project, process2){
                final /* synthetic */ DebugViewAttributes $debugViewAttributes;
                final /* synthetic */ Project $project;
                final /* synthetic */ enableDebugViewAttributes.process.1 $process;
                {
                    this.$debugViewAttributes = $debugViewAttributes;
                    this.$project = $project;
                    this.$process = $process;
                }

                public void processWillTerminate(@NotNull ProcessEvent event2, boolean willBeDestroyed) {
                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                    if (!((Boolean)this.$debugViewAttributes.getUsePerDeviceSettings().invoke()).booleanValue()) {
                        this.$debugViewAttributes.clear(this.$project, this.$process);
                    }
                }
            });
        }
    }

    private final String getModel(IDevice $this$model) {
        String string;
        String string2;
        if ($this$model.isEmulator()) {
            String string3;
            String it = string3 = $this$model.getAvdName();
            boolean bl = false;
            CharSequence charSequence = it;
            string2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string3 : null;
        } else {
            String string4 = $this$model.getProperty("ro.product.model");
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                string2 = StringUtil.capitalizeWords((String)it, (boolean)true);
            } else {
                string2 = string = null;
            }
        }
        if (string2 == null) {
            string = "Unknown";
        }
        return string;
    }

    public static final /* synthetic */ String access$getModel(LayoutInspectorExecutionListener $this, IDevice $receiver) {
        return $this.getModel($receiver);
    }
}

