/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.reference;

import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.util.LayoutBindingTypeUtil;
import com.android.tools.idea.lang.databinding.model.PsiModelClass;
import com.android.tools.idea.lang.databinding.reference.DbExprReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/lang/databinding/reference/PsiResourceReference;", "Lcom/android/tools/idea/lang/databinding/reference/DbExprReference;", "element", "Lcom/intellij/psi/PsiElement;", "resolveTo", "resourceValue", "Lorg/jetbrains/android/dom/resources/ResourceValue;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/android/dom/resources/ResourceValue;)V", "memberAccess", "Lcom/android/tools/idea/lang/databinding/model/PsiModelClass$MemberAccess;", "getMemberAccess", "()Lcom/android/tools/idea/lang/databinding/model/PsiModelClass$MemberAccess;", "resolvedType", "Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "getResolvedType", "()Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "handleElementRename", "newElementName", "", "parseType", "Lcom/intellij/psi/PsiType;", "name", "intellij.android.lang-databinding"})
public final class PsiResourceReference
extends DbExprReference {
    @NotNull
    private final ResourceValue resourceValue;
    @NotNull
    private final PsiModelClass.MemberAccess memberAccess;

    public PsiResourceReference(@NotNull PsiElement element2, @NotNull PsiElement resolveTo, @NotNull ResourceValue resourceValue) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)resolveTo, (String)"resolveTo");
        Intrinsics.checkNotNullParameter((Object)resourceValue, (String)"resourceValue");
        super(element2, resolveTo, null, 4, null);
        this.resourceValue = resourceValue;
        this.memberAccess = PsiModelClass.MemberAccess.ALL_MEMBERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public PsiModelClass getResolvedType() {
        PsiType psiType;
        String string = this.resourceValue.getResourceType();
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case -826507106: {
                if (string.equals("drawable")) {
                    n = 1;
                }
                break;
            }
            case 95588145: {
                if (string.equals("dimen")) {
                    n = 2;
                }
                break;
            }
            case -475309713: {
                if (string.equals("plurals")) {
                    n = 3;
                }
                break;
            }
            case 3029738: {
                if (string.equals("bool")) {
                    n = 4;
                }
                break;
            }
            case 94842723: {
                if (string.equals("color")) {
                    n = 5;
                }
                break;
            }
            case -891985903: {
                if (string.equals("string")) {
                    n = 6;
                }
                break;
            }
            case -983114737: {
                if (string.equals("typedArray")) {
                    n = 7;
                }
                break;
            }
            case 1958052158: {
                if (string.equals("integer")) {
                    n = 5;
                }
                break;
            }
            case 196774102: {
                if (string.equals("stateListAnimator")) {
                    n = 8;
                }
                break;
            }
            case -1724158635: {
                if (string.equals("transition")) {
                    n = 9;
                }
                break;
            }
            case 537167786: {
                if (string.equals("intArray")) {
                    n = 10;
                }
                break;
            }
            case -1653751294: {
                if (string.equals("fraction")) {
                    n = 2;
                }
                break;
            }
            case -1109722326: {
                if (string.equals("layout")) {
                    n = 5;
                }
                break;
            }
            case 1434372268: {
                if (string.equals("colorStateList")) {
                    n = 11;
                }
                break;
            }
            case 2096253127: {
                if (string.equals("interpolator")) {
                    n = 12;
                }
                break;
            }
            case -1538095928: {
                if (string.equals("stringArray")) {
                    n = 13;
                }
                break;
            }
            case 3355: {
                if (string.equals("id")) {
                    n = 5;
                }
                break;
            }
            case 3556653: {
                if (string.equals("text")) {
                    n = 14;
                }
                break;
            }
            case 2998801: {
                if (string.equals("anim")) {
                    n = 15;
                }
                break;
            }
            case -1074202844: {
                if (string.equals("dimenOffset")) {
                    n = 5;
                }
                break;
            }
            case -795202841: {
                if (string.equals("animator")) {
                    n = 16;
                }
                break;
            }
            case -1095965998: {
                if (string.equals("dimenSize")) {
                    n = 5;
                }
                break;
            }
        }
        switch (n) {
            case 3: {
                PsiElement[] psiElementArray = this.getElement().getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"element.children");
                if (((Object[])psiElementArray).length == 0) {
                    psiType = (PsiType)PsiType.INT;
                    break;
                }
                psiType = this.parseType("java.lang.String");
                break;
            }
            case 15: {
                psiType = this.parseType("android.view.animation.Animation");
                break;
            }
            case 16: {
                psiType = this.parseType("android.animation.Animator");
                break;
            }
            case 11: {
                psiType = this.parseType("android.content.res.ColorStateList");
                break;
            }
            case 1: {
                psiType = this.parseType("android.graphics.drawable.Drawable");
                break;
            }
            case 8: {
                psiType = this.parseType("android.animation.StateListAnimator");
                break;
            }
            case 9: {
                psiType = this.parseType("android.transition.Transition");
                break;
            }
            case 7: {
                psiType = this.parseType("android.content.res.TypedArray");
                break;
            }
            case 12: {
                psiType = this.parseType("android.view.animation.Interpolator");
                break;
            }
            case 4: {
                psiType = (PsiType)PsiType.BOOLEAN;
                break;
            }
            case 5: {
                psiType = (PsiType)PsiType.INT;
                break;
            }
            case 2: {
                psiType = (PsiType)PsiType.FLOAT;
                break;
            }
            case 10: {
                psiType = (PsiType)PsiType.INT.createArrayType();
                break;
            }
            case 6: {
                psiType = this.parseType("java.lang.String");
                break;
            }
            case 13: {
                PsiType psiType2 = this.parseType("java.lang.String");
                psiType = (PsiType)(psiType2 != null ? psiType2.createArrayType() : null);
                break;
            }
            case 14: {
                psiType = this.parseType("java.lang.CharSequence");
                break;
            }
            default: {
                return null;
            }
        }
        if (psiType == null) {
            return null;
        }
        PsiType psiType3 = psiType;
        return new PsiModelClass(psiType3, DataBindingMode.Companion.fromPsiElement(this.getElement()));
    }

    @Override
    @NotNull
    public PsiModelClass.MemberAccess getMemberAccess() {
        return this.memberAccess;
    }

    private final PsiType parseType(String name2) {
        return LayoutBindingTypeUtil.parsePsiType(name2, this.getElement());
    }

    @Override
    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        PsiElement psiElement = this.getElement().findElementAt(this.getRangeInElement().getStartOffset());
        LeafPsiElement leafPsiElement = psiElement instanceof LeafPsiElement ? (LeafPsiElement)psiElement : null;
        if (leafPsiElement == null) {
            return null;
        }
        LeafPsiElement identifier = leafPsiElement;
        ResourceValue newResourceValue = ResourceValue.referenceTo(this.resourceValue.getPrefix(), this.resourceValue.getPackage(), this.resourceValue.getResourceType(), newElementName);
        identifier.rawReplaceWithText(newResourceValue.toString());
        return this.getElement();
    }
}

