/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.highlight;

import com.android.tools.idea.lang.databinding.config.DbLanguage;
import com.android.tools.idea.lang.databinding.psi.DbTokenTypes;
import com.android.tools.idea.lang.databinding.psi.PsiDbCallExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbCastExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbParenExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbResourceParameters;
import com.android.tools.idea.lang.databinding.psi.PsiDbResourcesExpr;
import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbPairedBraceMatcher
extends PairedBraceMatcherAdapter {
    private static final BracePair[] BRACE_PAIRS = new BracePair[]{new BracePair(DbTokenTypes.LPARENTH, DbTokenTypes.RPARENTH, false), new BracePair(DbTokenTypes.LBRACKET, DbTokenTypes.RBRACKET, false)};

    public DbPairedBraceMatcher() {
        super(new PairedBraceMatcher(){

            @NotNull
            public BracePair[] getPairs() {
                return BRACE_PAIRS;
            }

            public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
                return true;
            }

            public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
                PsiElement element2 = file2.findElementAt(openingBraceOffset);
                if (element2 == null || element2 instanceof PsiFile) {
                    return openingBraceOffset;
                }
                PsiElement parent2 = element2.getParent();
                if (parent2 instanceof PsiDbCastExpr || parent2 instanceof PsiDbParenExpr) {
                    return openingBraceOffset;
                }
                if (parent2 instanceof PsiDbCallExpr) {
                    return parent2.getTextRange().getStartOffset();
                }
                if (parent2 instanceof PsiDbResourceParameters && (parent2 = parent2.getParent()) instanceof PsiDbResourcesExpr) {
                    return parent2.getTextRange().getStartOffset();
                }
                return openingBraceOffset;
            }
        }, (Language)DbLanguage.INSTANCE);
    }
}

