/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instrumentation.threading;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.instrumentation.threading.ThreadingCheckerHookImpl;
import com.android.tools.idea.instrumentation.threading.ThreadingViolationNotifier;
import com.android.tools.idea.instrumentation.threading.ThreadingViolationNotifierImpl;
import com.android.tools.instrumentation.threading.agent.callback.ThreadingCheckerHook;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ThreadingAgentUsageEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/instrumentation/threading/ThreadingCheckerHookImpl;", "Lcom/android/tools/instrumentation/threading/agent/callback/ThreadingCheckerHook;", "threadingViolationNotifier", "Lcom/android/tools/idea/instrumentation/threading/ThreadingViolationNotifier;", "(Lcom/android/tools/idea/instrumentation/threading/ThreadingViolationNotifier;)V", "lastReportedUsageTimeMs", "", "lock", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "threadingViolations", "Ljava/util/concurrent/ConcurrentMap;", "", "Ljava/util/concurrent/atomic/AtomicLong;", "getThreadingViolations$annotations", "()V", "getThreadingViolations", "()Ljava/util/concurrent/ConcurrentMap;", "uiThreadCheckCount", "workerThreadCheckCount", "maybeReportUsageStats", "", "recordViolation", "warningMessage", "shouldLogErrors", "", "shouldSuppressNotifications", "verifyOnUiThread", "verifyOnWorkerThread", "intellij.android.threading-checker"})
@SourceDebugExtension(value={"SMAP\nThreadingCheckerHookImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadingCheckerHookImpl.kt\ncom/android/tools/idea/instrumentation/threading/ThreadingCheckerHookImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,132:1\n8#2:133\n*S KotlinDebug\n*F\n+ 1 ThreadingCheckerHookImpl.kt\ncom/android/tools/idea/instrumentation/threading/ThreadingCheckerHookImpl\n*L\n40#1:133\n*E\n"})
public final class ThreadingCheckerHookImpl
implements ThreadingCheckerHook {
    @NotNull
    private final ThreadingViolationNotifier threadingViolationNotifier;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Object lock;
    private volatile long lastReportedUsageTimeMs;
    private long uiThreadCheckCount;
    private long workerThreadCheckCount;
    @NotNull
    private final ConcurrentMap<String, AtomicLong> threadingViolations;

    public ThreadingCheckerHookImpl(@NotNull ThreadingViolationNotifier threadingViolationNotifier) {
        Intrinsics.checkNotNullParameter((Object)threadingViolationNotifier, (String)"threadingViolationNotifier");
        this.threadingViolationNotifier = threadingViolationNotifier;
        ThreadingCheckerHookImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(ThreadingCheckerHookImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        this.logger = logger2;
        this.lock = new Object();
        this.threadingViolations = new ConcurrentHashMap();
    }

    public /* synthetic */ ThreadingCheckerHookImpl(ThreadingViolationNotifier threadingViolationNotifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            threadingViolationNotifier = new ThreadingViolationNotifierImpl();
        }
        this(threadingViolationNotifier);
    }

    @NotNull
    public final ConcurrentMap<String, AtomicLong> getThreadingViolations() {
        return this.threadingViolations;
    }

    @VisibleForTesting
    public static /* synthetic */ void getThreadingViolations$annotations() {
    }

    public void verifyOnUiThread() {
        ++this.uiThreadCheckCount;
        this.maybeReportUsageStats();
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        this.recordViolation("Threading violation: methods annotated with @UiThread should be called on the UI thread");
    }

    public void verifyOnWorkerThread() {
        ++this.workerThreadCheckCount;
        this.maybeReportUsageStats();
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        this.recordViolation("Threading violation: methods annotated with @WorkerThread should not be called on the UI thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void maybeReportUsageStats() {
        long currentTimeMs = System.currentTimeMillis();
        if (currentTimeMs - this.lastReportedUsageTimeMs < 60000L) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (currentTimeMs - this.lastReportedUsageTimeMs < 60000L) {
                return;
            }
            this.lastReportedUsageTimeMs = currentTimeMs;
            Unit unit = Unit.INSTANCE;
        }
        AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.THREADING_AGENT_STATS).setThreadingAgentUsageEvent(ThreadingAgentUsageEvent.newBuilder().setVerifyUiThreadCount(this.uiThreadCheckCount).setVerifyWorkerThreadCount(this.workerThreadCheckCount));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n        .se\u2026(workerThreadCheckCount))");
        UsageTracker.log((AndroidStudioEvent.Builder)builder2);
        this.uiThreadCheckCount = 0L;
        this.workerThreadCheckCount = 0L;
    }

    private final void recordViolation(String warningMessage) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int annotatedMethodIndex = 4;
        String methodSignature = stackTrace[annotatedMethodIndex].getClassName() + "#" + stackTrace[annotatedMethodIndex].getMethodName();
        long violationCount2 = this.threadingViolations.computeIfAbsent(methodSignature, recordViolation.violationCount.1.INSTANCE).incrementAndGet();
        String loggedStackTrace2 = Stream.of(Arrays.copyOf(stackTrace, stackTrace.length)).skip(annotatedMethodIndex).map(recordViolation.loggedStackTrace.1.INSTANCE).collect(Collectors.joining("\n  "));
        String message2 = warningMessage + "\nViolating method: " + methodSignature + "\nStack trace:\n" + loggedStackTrace2;
        if (this.shouldLogErrors()) {
            this.logger.error(message2);
        } else {
            this.logger.warn(message2);
        }
        if (violationCount2 == 1L && !this.shouldSuppressNotifications()) {
            this.threadingViolationNotifier.notify(warningMessage, methodSignature);
        }
    }

    private final boolean shouldLogErrors() {
        return StringsKt.equals((String)System.getProperty("android.studio.instrumentation.threading.log-errors", "true"), (String)"true", (boolean)true);
    }

    private final boolean shouldSuppressNotifications() {
        return StringsKt.equals((String)System.getProperty("android.studio.instrumentation.threading.suppress-notifications", "true"), (String)"true", (boolean)true);
    }

    public ThreadingCheckerHookImpl() {
        this(null, 1, null);
    }
}

