/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instrumentation.threading;

import com.android.tools.idea.instrumentation.threading.ThreadingCheckerHookImpl;
import com.android.tools.idea.util.StudioPathManager;
import com.android.tools.instrumentation.threading.agent.callback.ThreadingCheckerHook;
import com.android.tools.instrumentation.threading.agent.callback.ThreadingCheckerTrampoline;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.tools.attach.VirtualMachine;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\b\u001a\u00020\u0004H\u0002\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/instrumentation/threading/ThreadingChecker;", "Lcom/intellij/ide/ApplicationInitializedListener;", "()V", "attachThreadingAgent", "", "componentsInitialized", "getThreadingAgentJarLocation", "Ljava/nio/file/Path;", "maybeAttachThreadingAgent", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nThreadingChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadingChecker.kt\ncom/android/tools/idea/instrumentation/threading/ThreadingChecker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,102:1\n8#2:103\n8#2:104\n8#2:105\n8#2:106\n*S KotlinDebug\n*F\n+ 1 ThreadingChecker.kt\ncom/android/tools/idea/instrumentation/threading/ThreadingChecker\n*L\n45#1:103\n77#1:104\n83#1:105\n86#1:106\n*E\n"})
public final class ThreadingChecker
implements ApplicationInitializedListener {
    public void componentsInitialized() {
        boolean bl;
        try {
            Class.forName("com.android.tools.instrumentation.threading.agent.Agent", false, null);
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        boolean agentLoadedAtStartup = bl;
        if (agentLoadedAtStartup) {
            ThreadingCheckerTrampoline.installHook((ThreadingCheckerHook)new ThreadingCheckerHookImpl(null, 1, null));
            ThreadingChecker $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(ThreadingChecker.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
            logger2.debug("ThreadingChecker listener has been installed.");
        } else {
            this.maybeAttachThreadingAgent();
        }
    }

    private final void maybeAttachThreadingAgent() {
        if (!ApplicationManager.getApplication().isEAP()) {
            return;
        }
        if (StudioPathManager.isRunningFromSources()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
            final /* synthetic */ ThreadingChecker this$0;
            {
                this.this$0 = $receiver;
            }

            public final void run() {
                ThreadingChecker.access$attachThreadingAgent(this.this$0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void attachThreadingAgent() {
        VirtualMachine vm = null;
        try {
            Path threadingAgentJarPath = this.getThreadingAgentJarLocation();
            if (threadingAgentJarPath == null) {
                ThreadingChecker $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(ThreadingChecker.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                logger2.warn("Couldn't locate threading_agent.jar.");
                return;
            }
            vm = VirtualMachine.attach(OSProcessUtil.getApplicationPid());
            vm.loadAgent(((Object)threadingAgentJarPath).toString());
            ThreadingCheckerTrampoline.installHook((ThreadingCheckerHook)new ThreadingCheckerHookImpl(null, 1, null));
            ThreadingChecker $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger3 = Logger.getInstance(ThreadingChecker.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(T::class.java)");
            logger3.debug("ThreadingChecker listener has been installed (after threading agent was dynamically loaded).");
        }
        catch (Exception e) {
            ThreadingChecker $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger4 = Logger.getInstance(ThreadingChecker.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(T::class.java)");
            logger4.error((Throwable)e);
        }
        finally {
            VirtualMachine virtualMachine = vm;
            if (virtualMachine != null) {
                virtualMachine.detach();
            }
        }
    }

    private final Path getThreadingAgentJarLocation() {
        Path path2 = Paths.get(PathManager.getHomePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(PathManager.getHomePath())");
        Path homePath = path2;
        Path path3 = homePath.resolve("plugins/android/resources/threading_agent.jar");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"homePath.resolve(\"plugin\u2026ces/threading_agent.jar\")");
        Path jarFile = path3;
        if (!Files.exists(jarFile, new LinkOption[0])) {
            return null;
        }
        return jarFile;
    }

    public static final /* synthetic */ void access$attachThreadingAgent(ThreadingChecker $this) {
        $this.attachThreadingAgent();
    }
}

