/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.analysis;

import com.android.tools.idea.insights.Frame;
import com.android.tools.idea.insights.analysis.Cause;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\"\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\"\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0011"}, d2={"candidateFileNames", "", "", "Lcom/intellij/psi/PsiFile;", "getCandidateFileNames", "(Lcom/intellij/psi/PsiFile;)Ljava/util/Set;", "findMatchingCause", "Lorg/jetbrains/uast/UElement;", "element", "cause", "Lcom/android/tools/idea/insights/analysis/Cause;", "range", "Lcom/intellij/openapi/util/TextRange;", "findMatchingMethodCall", "Lcom/android/tools/idea/insights/analysis/Cause$Frame;", "findMatchingThrow", "Lcom/android/tools/idea/insights/analysis/Cause$Throwable;", "intellij.android.app-quality-insights.api"})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\ncom/android/tools/idea/insights/analysis/UtilKt\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,123:1\n15#2:124\n15#2:125\n*S KotlinDebug\n*F\n+ 1 Util.kt\ncom/android/tools/idea/insights/analysis/UtilKt\n*L\n77#1:124\n112#1:125\n*E\n"})
public final class UtilKt {
    @Nullable
    public static final UElement findMatchingCause(@NotNull UElement element2, @NotNull Cause cause, @NotNull TextRange range) {
        UElement uElement;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Cause cause2 = cause;
        if (cause2 instanceof Cause.Frame) {
            uElement = UtilKt.findMatchingMethodCall(element2, (Cause.Frame)cause, range);
        } else if (cause2 instanceof Cause.Throwable) {
            uElement = UtilKt.findMatchingThrow(element2, (Cause.Throwable)cause, range);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return uElement;
    }

    private static final UElement findMatchingThrow(UElement element2, Cause.Throwable cause, TextRange range) {
        ProgressManager.checkCanceled();
        AtomicReference<UElement> foundChild = new AtomicReference<UElement>();
        element2.accept(new UastVisitor(range, cause, foundChild){
            final /* synthetic */ TextRange $range;
            final /* synthetic */ Cause.Throwable $cause;
            final /* synthetic */ AtomicReference<UElement> $foundChild;
            {
                this.$range = $range;
                this.$cause = $cause;
                this.$foundChild = $foundChild;
            }

            public boolean visitElement(@NotNull UElement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return false;
            }

            public boolean visitThrowExpression(@NotNull UThrowExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.getSourcePsi();
                if (!(psiElement != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.intersects(this.$range) : false)) {
                    return false;
                }
                UExpression exception = node.getThrownExpression();
                if (!(exception instanceof UCallExpression)) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)((UCallExpression)exception).getKind(), (Object)UastCallKind.CONSTRUCTOR_CALL)) {
                    UReferenceExpression uReferenceExpression = ((UCallExpression)exception).getClassReference();
                    PsiElement psiElement2 = uReferenceExpression != null ? uReferenceExpression.resolve() : null;
                    PsiClass psiClass = psiElement2 instanceof PsiClass ? (PsiClass)psiElement2 : null;
                    if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)this.$cause.getExceptionType())) {
                        this.$foundChild.set((UElement)node);
                        return true;
                    }
                }
                PsiMethod psiMethod = ((UCallExpression)exception).resolve();
                PsiClass psiClass = InferenceProcessUtilKt.resolve((PsiType)(psiMethod != null ? psiMethod.getReturnType() : null));
                if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)this.$cause.getExceptionType())) {
                    this.$foundChild.set((UElement)node);
                    return true;
                }
                return false;
            }
        });
        UElement uElement = foundChild.get();
        if (uElement != null) {
            UElement it = uElement;
            boolean bl = false;
            return it;
        }
        UElement $this$getParentOfType_u24default$iv = element2;
        boolean strict$iv = true;
        UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
        boolean $i$f$getParentOfType = false;
        UThrowExpression uThrowExpression = (UThrowExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, UThrowExpression.class, (boolean)strict$iv);
        if (uThrowExpression == null) {
            return null;
        }
        return UtilKt.findMatchingThrow((UElement)uThrowExpression, cause, range);
    }

    private static final UElement findMatchingMethodCall(UElement element2, Cause.Frame cause, TextRange range) {
        ProgressManager.checkCanceled();
        AtomicReference<UElement> foundChild = new AtomicReference<UElement>();
        element2.accept(new UastVisitor(range, cause, foundChild){
            final /* synthetic */ TextRange $range;
            final /* synthetic */ Cause.Frame $cause;
            final /* synthetic */ AtomicReference<UElement> $foundChild;
            {
                this.$range = $range;
                this.$cause = $cause;
                this.$foundChild = $foundChild;
            }

            public boolean visitElement(@NotNull UElement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return false;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.getSourcePsi();
                if (!(psiElement != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.intersects(this.$range) : false)) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)node.getKind(), (Object)UastCallKind.METHOD_CALL) || Intrinsics.areEqual((Object)node.getKind(), (Object)UastCallKind.CONSTRUCTOR_CALL)) {
                    PsiMethod psiMethod = node.resolve();
                    if (psiMethod == null) {
                        return false;
                    }
                    PsiMethod psiMethod2 = psiMethod;
                    Cause.Frame frame = this.$cause;
                    AtomicReference<UElement> atomicReference = this.$foundChild;
                    PsiMethod $this$visitCallExpression_u24lambda_u240 = psiMethod2;
                    boolean bl = false;
                    Frame frame2 = frame.getFrame();
                    Object object = $this$visitCallExpression_u24lambda_u240.getContainingClass();
                    if (object == null || (object = object.getQualifiedName()) == null) {
                        object = "";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"containingClass?.qualifiedName ?: \"\"");
                    String string = $this$visitCallExpression_u24lambda_u240.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    if (frame2.matches((String)object, string)) {
                        atomicReference.set((UElement)node);
                        return true;
                    }
                }
                return false;
            }
        });
        UElement uElement = foundChild.get();
        if (uElement != null) {
            UElement it = uElement;
            boolean bl = false;
            return it;
        }
        UElement $this$getParentOfType_u24default$iv = element2;
        boolean strict$iv = true;
        UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
        boolean $i$f$getParentOfType = false;
        UThrowExpression uThrowExpression = (UThrowExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, UThrowExpression.class, (boolean)strict$iv);
        if (uThrowExpression == null) {
            return null;
        }
        return UtilKt.findMatchingMethodCall((UElement)uThrowExpression, cause, range);
    }

    @NotNull
    public static final Set<String> getCandidateFileNames(@NotNull PsiFile $this$candidateFileNames) {
        Intrinsics.checkNotNullParameter((Object)$this$candidateFileNames, (String)"<this>");
        String string = $this$candidateFileNames.getVirtualFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualFile.name");
        String baseName = StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null);
        boolean bl = false;
        Object[] objectArray = new String[]{baseName + ".java", baseName + ".kt"};
        return SetsKt.setOf((Object[])objectArray);
    }
}

