/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.analysis;

import com.android.tools.idea.insights.analysis.Confidence;
import com.android.tools.idea.insights.analysis.CrashFrame;
import com.android.tools.idea.insights.analysis.CrashMatcher;
import com.android.tools.idea.insights.analysis.Match;
import com.android.tools.idea.insights.analysis.UtilKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/insights/analysis/MethodMatcher;", "Lcom/android/tools/idea/insights/analysis/CrashMatcher;", "()V", "findMatch", "Lcom/android/tools/idea/insights/analysis/Match;", "cls", "Lorg/jetbrains/uast/UClass;", "crash", "Lcom/android/tools/idea/insights/analysis/CrashFrame;", "match", "file", "Lcom/intellij/psi/PsiFile;", "intellij.android.app-quality-insights.api"})
@SourceDebugExtension(value={"SMAP\nMethodMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodMatcher.kt\ncom/android/tools/idea/insights/analysis/MethodMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,106:1\n1603#2,9:107\n1851#2:116\n1852#2:118\n1612#2:119\n1959#2,14:120\n1#3:117\n1411#4,14:134\n*S KotlinDebug\n*F\n+ 1 MethodMatcher.kt\ncom/android/tools/idea/insights/analysis/MethodMatcher\n*L\n63#1:107,9\n63#1:116\n63#1:118\n63#1:119\n63#1:120,14\n63#1:117\n102#1:134,14\n*E\n"})
public final class MethodMatcher
implements CrashMatcher {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Match match(@NotNull PsiFile file2, @NotNull CrashFrame crash) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)crash, (String)"crash");
        if (!(file2 instanceof PsiClassOwner)) {
            return null;
        }
        String string = crash.getFrame().getSymbol();
        String string2 = ((PsiClassOwner)file2).getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.packageName");
        if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
            return null;
        }
        PsiClass[] psiClassArray = ((PsiClassOwner)file2).getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"file.classes");
        PsiClass[] psiClassArray2 = psiClassArray;
        int n = 0;
        int n2 = psiClassArray2.length;
        if (n < n2) {
            Object v3;
            void $this$maxByOrNull$iv;
            void $this$mapNotNullTo$iv$iv;
            PsiClass cls = psiClassArray2[n];
            ArrayList<UClass> innerClasses = new ArrayList<UClass>();
            UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)((PsiElement)cls), UClass.class);
            if (uClass != null) {
                uClass.accept(new UastVisitor(innerClasses){
                    final /* synthetic */ ArrayList<UClass> $innerClasses;
                    {
                        this.$innerClasses = $innerClasses;
                    }

                    public boolean visitClass(@NotNull UClass node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.$innerClasses.add(node);
                        return false;
                    }

                    public boolean visitElement(@NotNull UElement node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        return false;
                    }
                });
            }
            Iterable $this$mapNotNull$iv = innerClasses;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Match it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                UClass it = (UClass)element$iv$iv;
                boolean bl2 = false;
                if (this.findMatch(it, crash) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = maxElem$iv;
                } else {
                    Match it = (Match)maxElem$iv;
                    boolean bl = false;
                    Comparable maxValue$iv = (Comparable)((Object)it.getConfidence());
                    do {
                        Object e$iv = iterator$iv.next();
                        Match it2 = (Match)e$iv;
                        $i$a$-maxByOrNull-MethodMatcher$match$3 = false;
                        Comparable v$iv = (Comparable)((Object)it2.getConfidence());
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = maxElem$iv;
                }
            }
            return v3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Match findMatch(UClass cls, CrashFrame crash) {
        Object v0;
        void $this$maxByOrNull$iv;
        Sequence sequence = SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])cls.getMethods()), (Function1)((Function1)new Function1<UMethod, Match>(cls, crash, this){
            final /* synthetic */ UClass $cls;
            final /* synthetic */ CrashFrame $crash;
            final /* synthetic */ MethodMatcher this$0;
            {
                this.$cls = $cls;
                this.$crash = $crash;
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Match invoke(@NotNull UMethod method2) {
                Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
                ProgressManager.checkCanceled();
                String string = this.$cls.getQualifiedName();
                if (string == null) {
                    UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)this.$cls));
                    string = uClass != null ? uClass.getQualifiedName() : null;
                    if (string == null) {
                        return null;
                    }
                }
                String className = string;
                if (this.$crash.getFrame().matches(className, method2.getName())) {
                    PsiElement psiElement;
                    PsiElement psiElement2;
                    PsiElement psiElement3 = method2.getSourcePsi();
                    Object object = psiElement3 != null ? psiElement3.getTextRange() : null;
                    if (object == null) {
                        return null;
                    }
                    UElement result2 = UtilKt.findMatchingCause((UElement)method2, this.$crash.getCause(), object);
                    if (result2 != null && (psiElement2 = result2.getSourcePsi()) != null && (psiElement = psiElement2.getNavigationElement()) != null) {
                        PsiElement psiElement4 = psiElement;
                        MethodMatcher methodMatcher = this.this$0;
                        PsiElement it = psiElement4;
                        boolean bl = false;
                        String string2 = Reflection.getOrCreateKotlinClass(methodMatcher.getClass()).getSimpleName();
                        Intrinsics.checkNotNull((Object)string2);
                        return new Match(it, Confidence.MEDIUM, string2);
                    }
                    int line2 = RangesKt.coerceAtLeast((int)((int)this.$crash.getFrame().getLine() - 1), (int)0);
                    UFile uFile = UastUtils.getContainingUFile((UElement)((UElement)this.$cls));
                    if (uFile == null || (uFile = uFile.getSourcePsi()) == null) {
                        return null;
                    }
                    UFile psiFile = uFile;
                    Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)psiFile, (int)line2);
                    if (n == null) {
                        return null;
                    }
                    int startOffset = n;
                    Integer n2 = PsiLinesUtilsKt.getLineEndOffset((PsiFile)psiFile, (int)line2);
                    if (n2 == null) {
                        return null;
                    }
                    int endOffset = n2;
                    endOffset = RangesKt.coerceAtLeast((int)endOffset, (int)(startOffset + 1));
                    TextRange lineRange = new TextRange(startOffset, endOffset);
                    PsiElement psiElement5 = method2.getSourcePsi();
                    boolean bl = psiElement5 != null && (psiElement5 = psiElement5.getTextRange()) != null ? psiElement5.intersects(lineRange) : false;
                    if (bl) {
                        List $this$invoke_u24lambda_u241 = PsiUtilsKt.elementsInRange((PsiFile)psiFile, (TextRange)lineRange);
                        boolean bl2 = false;
                        if (!((Collection)$this$invoke_u24lambda_u241).isEmpty()) {
                            PsiElement psiElement6 = (PsiElement)$this$invoke_u24lambda_u241.get(0);
                            String string3 = Reflection.getOrCreateKotlinClass($this$invoke_u24lambda_u241.getClass()).getSimpleName();
                            Intrinsics.checkNotNull((Object)string3);
                            return new Match(psiElement6, Confidence.LOW, string3);
                        }
                    }
                }
                return null;
            }
        }));
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Match it = (Match)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)((Object)it.getConfidence());
                do {
                    Object e$iv = iterator$iv.next();
                    Match it2 = (Match)e$iv;
                    $i$a$-maxByOrNull-MethodMatcher$findMatch$match$2 = false;
                    Comparable v$iv = (Comparable)((Object)it2.getConfidence());
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Match match2 = v0;
        return match2;
    }
}

